/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.heuristic.rules;

import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;

public class ClusRuleHeuristicMEstimate
extends ClusHeuristic {
    double m_MValue;
    double m_Prior;

    public ClusRuleHeuristicMEstimate(double m_value, Settings sett) {
        super(sett);
        this.m_MValue = m_value;
    }

    @Override
    public double calcHeuristic(ClusStatistic c_tstat, ClusStatistic c_pstat, ClusStatistic missing) {
        double n_pos = c_pstat.getTotalWeight();
        if (n_pos - SettingsTree.MINIMAL_WEIGHT < 1.0E-6) {
            return Double.NEGATIVE_INFINITY;
        }
        double correct = n_pos - c_pstat.getError();
        double m_estimate = (correct + this.m_MValue * this.m_Prior) / (n_pos + this.m_MValue);
        return m_estimate;
    }

    @Override
    public void setRootStatistic(ClusStatistic stat) {
        this.m_Prior = (stat.getTotalWeight() - stat.getError()) / stat.getTotalWeight();
        ClusLogger.info("Setting prior: " + this.m_Prior);
    }

    @Override
    public String getName() {
        return "Rule Heuristic (M-Estimate, M = " + this.m_MValue + ")";
    }
}

