/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.heuristic;

import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.FTest;

public class VarianceReductionHeuristicInclMissingValues
extends ClusHeuristic {
    private ClusAttrType[] m_Attrs;
    protected ClusStatistic m_Pos;
    protected ClusStatistic m_Neg;
    protected ClusStatistic m_Tot;

    public VarianceReductionHeuristicInclMissingValues(ClusAttributeWeights prod, ClusAttrType[] attrs, ClusStatistic stat, Settings sett) {
        super(sett);
        this.m_ClusteringWeights = prod;
        this.m_Attrs = attrs;
        this.m_Pos = stat.cloneStat();
        this.m_Neg = stat.cloneStat();
        this.m_Tot = stat.cloneStat();
    }

    @Override
    public double calcHeuristic(ClusStatistic tstat, ClusStatistic pstat, ClusStatistic missing) {
        double n_tot = tstat.getTotalWeight();
        double n_pos = pstat.getTotalWeight();
        double n_neg = n_tot - n_pos;
        if (n_pos < SettingsTree.MINIMAL_WEIGHT || n_neg < SettingsTree.MINIMAL_WEIGHT) {
            return Double.NEGATIVE_INFINITY;
        }
        double pos_freq = n_pos / n_tot;
        this.m_Pos.copy(pstat);
        this.m_Neg.copy(tstat);
        this.m_Tot.copy(tstat);
        this.m_Tot.add(missing);
        this.m_Neg.subtractFromThis(pstat);
        this.m_Pos.addScaled(pos_freq, missing);
        this.m_Neg.addScaled(1.0 - pos_freq, missing);
        double s_ss_pos = this.m_Pos.getSVarS(this.m_ClusteringWeights);
        double s_ss_neg = this.m_Neg.getSVarS(this.m_ClusteringWeights);
        double s_ss_tot = this.m_Tot.getSVarS(this.m_ClusteringWeights);
        return FTest.calcVarianceReductionHeuristic(n_tot, s_ss_tot, s_ss_pos + s_ss_neg);
    }

    @Override
    public String getName() {
        return "Variance Reduction Including Missing Values (ftest: " + SettingsTree.FTEST_VALUE + ", " + this.m_ClusteringWeights.getName(this.m_Attrs) + ")";
    }
}

