/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.heuristic;

import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.FTest;
import si.ijs.kt.clus.util.exception.ClusException;

public class VarianceReductionHeuristic
extends ClusHeuristic {
    protected RowData m_Data;
    protected String m_BasicDist;
    protected ClusStatistic m_NegStat;

    public VarianceReductionHeuristic(String basicdist, ClusStatistic negstat, ClusAttributeWeights targetweights, Settings sett) {
        super(sett);
        this.m_BasicDist = basicdist;
        this.m_NegStat = negstat;
        this.m_ClusteringWeights = targetweights;
    }

    public VarianceReductionHeuristic(ClusStatistic negstat, ClusAttributeWeights targetweights, Settings sett) {
        this(negstat.getDistanceName(), negstat, targetweights, sett);
    }

    @Override
    public void setData(RowData data) {
        this.m_Data = data;
    }

    @Override
    public double calcHeuristic(ClusStatistic tstat, ClusStatistic pstat, ClusStatistic missing) throws ClusException {
        if (this.stopCriterion(tstat, pstat, missing)) {
            return Double.NEGATIVE_INFINITY;
        }
        double ss_tot = tstat.getSVarS(this.m_ClusteringWeights, this.m_Data);
        double ss_pos = pstat.getSVarS(this.m_ClusteringWeights, this.m_Data);
        this.m_NegStat.copy(tstat);
        this.m_NegStat.subtractFromThis(pstat);
        double ss_neg = this.m_NegStat.getSVarS(this.m_ClusteringWeights, this.m_Data);
        double value = FTest.calcVarianceReductionHeuristic(tstat.getTotalWeight(), ss_tot, ss_pos + ss_neg);
        if (this.getSettings().getGeneral().getVerbose() >= 10) {
            ClusLogger.info("TOT: " + tstat.getDebugString());
            ClusLogger.info("POS: " + pstat.getDebugString());
            ClusLogger.info("NEG: " + this.m_NegStat.getDebugString());
            ClusLogger.info("-> (" + ss_tot + ", " + ss_pos + ", " + ss_neg + ") " + value);
        }
        return value;
    }

    @Override
    public String getName() {
        return "Variance Reduction with Distance '" + this.m_BasicDist + "', (" + this.m_ClusteringWeights.getName() + ") (FTest = " + FTest.getSettingSig() + ")";
    }
}

