/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.heuristic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.heuristic.GeneticDistanceHeuristic;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.GeneticDistanceStat;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.jeans.list.BitList;
import si.ijs.kt.clus.util.jeans.math.matrix.MSymMatrix;

public class GeneticDistanceHeuristicMatrix
extends GeneticDistanceHeuristic {
    protected MSymMatrix m_DistMatrix;
    protected double m_SumAllDistances;
    protected double m_AvgAllDistances;
    protected double m_SumEntropyWithin;
    protected HashMap m_HeurComputed = new HashMap();
    protected double[] m_SumDistWithCompl;
    protected int m_SampleSize = 20;
    protected boolean m_Sampling = false;
    protected String[][] m_Sequences;
    public long m_SetDataTimer = 0L;
    public long m_HeurTimer = 0L;
    protected double m_RootSumAllDistances;
    protected double m_RootAvgAllDistances;
    protected double m_RootSumEntropyWithin;

    public GeneticDistanceHeuristicMatrix(Settings sett) {
        super(sett);
    }

    @Override
    public void setInitialData(ClusStatistic stat, RowData data) {
        this.m_RootData = data;
        this.m_RootData.addIndices();
        this.constructMatrix(stat);
    }

    public void constructMatrix(ClusStatistic stat) {
        try {
            this.m_DistMatrix = this.read(this.m_RootData.getSchema().getSettings(), stat);
        }
        catch (IOException e) {
            this.m_DistMatrix = new MSymMatrix(this.m_RootData.getNbRows());
            ClusLogger.info("  Calculating Distance Matrix (Size: " + this.m_RootData.getNbRows() + ")");
            GeneticDistanceStat gstat = (GeneticDistanceStat)stat;
            this.m_Sequences = new String[this.m_RootData.getNbRows()][gstat.m_NbTarget];
            for (int i = 0; i < this.m_RootData.getNbRows(); ++i) {
                DataTuple tuple1 = this.m_RootData.getTuple(i);
                int row = tuple1.getIndex();
                String[] str1 = new String[gstat.m_NbTarget];
                for (int t = 0; t < gstat.m_NbTarget; ++t) {
                    int nomvalue1 = gstat.m_Attrs[t].getNominal(tuple1);
                    str1[t] = gstat.m_Attrs[t].getValueOrMissing(nomvalue1);
                    this.m_Sequences[i][t] = str1[t];
                }
                for (int j = i + 1; j < this.m_RootData.getNbRows(); ++j) {
                    DataTuple tuple2 = this.m_RootData.getTuple(j);
                    int col = tuple2.getIndex();
                    String[] str2 = new String[gstat.m_NbTarget];
                    for (int t = 0; t < gstat.m_NbTarget; ++t) {
                        int nomvalue2 = gstat.m_Attrs[t].getNominal(tuple2);
                        str2[t] = gstat.m_Attrs[t].getValueOrMissing(nomvalue2);
                    }
                    double distance = this.getDistance(str1, str2);
                    this.m_DistMatrix.set_sym(row, col, distance);
                }
            }
        }
    }

    public MSymMatrix read(Settings sett, ClusStatistic stat) throws IOException {
        String filename = sett.getPhylogeny().getPhylogenyDistanceMatrix();
        ClusReader reader = new ClusReader(filename, sett);
        int nb = (int)reader.readFloat();
        ClusLogger.info("  Loading Distance Matrix: " + filename + " (Size: " + nb + ")");
        MSymMatrix matrix = new MSymMatrix(nb);
        for (int i = 0; i < nb; ++i) {
            reader.readName();
            for (int j = 0; j < nb; ++j) {
                double value = reader.readFloat();
                if (i > j) continue;
                matrix.set_sym(i, j, value);
            }
            reader.readTillEol();
        }
        reader.close();
        ClusLogger.info("  Matrix loaded");
        if (this.m_RootData.getSchema().getSettings().getPhylogeny().getPhylogenyEntropyVsRootStop() > 0.0 || this.m_RootData.getSchema().getSettings().getPhylogeny().getPhylogenyEntropyVsParentStop() > 0.0) {
            GeneticDistanceStat gstat = (GeneticDistanceStat)stat;
            this.m_Sequences = new String[this.m_RootData.getNbRows()][gstat.m_NbTarget];
            for (int i = 0; i < this.m_RootData.getNbRows(); ++i) {
                DataTuple tuple1 = this.m_RootData.getTuple(i);
                String[] str1 = new String[gstat.m_NbTarget];
                for (int t = 0; t < gstat.m_NbTarget; ++t) {
                    int nomvalue1 = gstat.m_Attrs[t].getNominal(tuple1);
                    str1[t] = gstat.m_Attrs[t].getValueOrMissing(nomvalue1);
                    this.m_Sequences[i][t] = str1[t];
                }
            }
        }
        return matrix;
    }

    @Override
    public void setData(RowData data) {
        this.m_Data = data;
        this.m_HeurComputed.clear();
        this.m_DataIndices = this.constructIndexVector(this.m_Data);
        this.m_SumAllDistances = this.getSumPWDistancesWithin(this.m_DataIndices);
        if (this.m_RootData.getSchema().getSettings().getPhylogeny().getPhylogenyDistancesVsRootStop() > 0.0 || this.m_RootData.getSchema().getSettings().getPhylogeny().getPhylogenyDistancesVsParentStop() > 0.0) {
            this.m_AvgAllDistances = this.getAvgPWDistancesWithin(this.m_DataIndices);
        }
        if (this.m_RootData.getSchema().getSettings().getPhylogeny().getPhylogenyEntropyVsRootStop() > 0.0 || this.m_RootData.getSchema().getSettings().getPhylogeny().getPhylogenyEntropyVsParentStop() > 0.0) {
            this.m_SumEntropyWithin = this.getSumOfEntropyWithin(this.m_DataIndices);
        }
        this.m_ComplDataIndices = this.constructComplIndexVector(this.m_RootData, this.m_DataIndices);
        this.m_SumDistWithCompl = this.constructComplDistVector(this.m_DataIndices, this.m_ComplDataIndices);
        if (this.m_Data.getNbRows() == this.m_RootData.getNbRows()) {
            this.m_RootSumAllDistances = this.m_SumAllDistances;
            this.m_RootAvgAllDistances = this.m_AvgAllDistances;
            this.m_RootSumEntropyWithin = this.m_SumEntropyWithin;
        }
    }

    public double[] constructComplDistVector(int[] indices, int[] complIndices) {
        int nbindices = indices.length;
        int nbcomplindices = complIndices.length;
        double[] resultvector = new double[nbindices];
        for (int i = 0; i < nbindices; ++i) {
            double sumdist = 0.0;
            int matrixrow = indices[i];
            for (int j = 0; j < nbcomplindices; ++j) {
                int matrixcol = complIndices[j];
                sumdist += this.m_DistMatrix.get(matrixrow, matrixcol);
            }
            resultvector[i] = sumdist;
        }
        return resultvector;
    }

    public double getMinPWDistanceBetween(int[] posindices, int[] negindices) {
        double mindist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < posindices.length; ++i) {
            int row = posindices[i];
            for (int j = 0; j < negindices.length; ++j) {
                int col = negindices[j];
                double dist = this.m_DistMatrix.get(row, col);
                if (!(dist < mindist)) continue;
                mindist = dist;
            }
        }
        return mindist;
    }

    public double getSumPWDistanceBetween(int[] posindices, int[] negindices) {
        double dist = 0.0;
        for (int i = 0; i < posindices.length; ++i) {
            int row = posindices[i];
            for (int j = 0; j < negindices.length; ++j) {
                int col = negindices[j];
                dist += this.m_DistMatrix.get(row, col);
            }
        }
        return dist;
    }

    public double getAvgPWDistanceBetween(int[] posindices, int[] negindices) {
        double dist = this.getSumPWDistanceBetween(posindices, negindices);
        double nbpairs = posindices.length * negindices.length;
        return dist / nbpairs;
    }

    public double getSumPWDistancesWithin(int[] indices) {
        int nb_ex = indices.length;
        double sum = 0.0;
        for (int i = 0; i < nb_ex; ++i) {
            int row = indices[i];
            for (int j = i + 1; j < nb_ex; ++j) {
                int col = indices[j];
                sum += this.m_DistMatrix.get(row, col);
            }
        }
        return sum;
    }

    public double getAvgPWDistancesWithin(int[] indices) {
        if (indices.length <= 1) {
            return 0.0;
        }
        double dist = this.getSumPWDistancesWithin(indices);
        int nb_ex = indices.length;
        double nb_pairs = nb_ex * (nb_ex - 1) / 2;
        return dist / nb_pairs;
    }

    public double getSumOfEntropyWithin(int[] indices) {
        double entropy = 0.0;
        for (int t = 0; t < this.m_Sequences[0].length; ++t) {
            int i;
            int[] counters = new int[95];
            int nbnongaps = 0;
            double columnentropy = 0.0;
            for (i = 0; i < indices.length; ++i) {
                int code;
                int row = indices[i];
                int n = code = this.m_Sequences[row][t].hashCode();
                counters[n] = counters[n] + 1;
                ++nbnongaps;
            }
            for (i = 0; i < 95; ++i) {
                if (counters[i] == 0) continue;
                double p = (double)counters[i] / (double)nbnongaps;
                double log = GeneticDistanceHeuristicMatrix.log2(p);
                double product = p * log;
                columnentropy -= product;
            }
            entropy += columnentropy;
        }
        return entropy;
    }

    private static double log2(double x) {
        return Math.log(x) / Math.log(2.0);
    }

    @Override
    public double calcHeuristic(ClusStatistic c_tstat, ClusStatistic c_pstat, ClusStatistic missing) {
        switch (this.getSettings().getPhylogeny().getPhylogenyCriterion()) {
            case MinTotBranchLength: {
                return this.calcHeuristicBranchLengths(c_tstat, c_pstat, null);
            }
            case MaxAvgPWDistance: {
                return this.calcHeuristicArslan(c_tstat, c_pstat, null);
            }
            case MaxMinPWDistance: {
                return this.calcHeuristicMaxMinDistance(c_tstat, c_pstat, null);
            }
        }
        return 0.0;
    }

    @Override
    public double calcHeuristic(ClusStatistic c_tstat, ClusStatistic[] array_stat, int nbsplit) {
        ClusStatistic p_stat = array_stat[0];
        ClusStatistic part_stat = array_stat[1];
        switch (this.getSettings().getPhylogeny().getPhylogenyCriterion()) {
            case MinTotBranchLength: {
                return this.calcHeuristicBranchLengths(c_tstat, p_stat, part_stat);
            }
            case MaxAvgPWDistance: {
                return this.calcHeuristicArslan(c_tstat, p_stat, null);
            }
            case MaxMinPWDistance: {
                return this.calcHeuristicMaxMinDistance(c_tstat, p_stat, null);
            }
        }
        return 0.0;
    }

    public double calcHeuristicArslan(ClusStatistic c_tstat, ClusStatistic c_pstat, ClusStatistic missing) {
        GeneticDistanceStat tstat = (GeneticDistanceStat)c_tstat;
        GeneticDistanceStat pstat = (GeneticDistanceStat)c_pstat;
        GeneticDistanceStat nstat = tstat.cloneStat();
        nstat.copy(tstat);
        nstat.subtractFromThis(pstat);
        double stop = this.checkStopCriterion(tstat, pstat, nstat);
        if (stop != 0.0) {
            return stop;
        }
        int[] posindices = this.constructIndexVector(this.m_Data, pstat);
        int[] negindices = this.constructIndexVector(this.m_Data, nstat);
        double result = this.getAvgPWDistanceBetween(posindices, negindices);
        return result;
    }

    public double calcHeuristicMaxMinDistance(ClusStatistic c_tstat, ClusStatistic c_pstat, ClusStatistic missing) {
        GeneticDistanceStat tstat = (GeneticDistanceStat)c_tstat;
        GeneticDistanceStat pstat = (GeneticDistanceStat)c_pstat;
        GeneticDistanceStat nstat = tstat.cloneStat();
        nstat.copy(tstat);
        nstat.subtractFromThis(pstat);
        double stop = this.checkStopCriterion(tstat, pstat, nstat);
        if (stop != 0.0) {
            return stop;
        }
        int[] posindices = this.constructIndexVector(this.m_Data, pstat);
        int[] negindices = this.constructIndexVector(this.m_Data, nstat);
        double result = this.getMinPWDistanceBetween(posindices, negindices);
        return result;
    }

    public double[] effcalculate(GeneticDistanceStat pstat, GeneticDistanceStat partition, int[] negindices) {
        String part1bits = partition.getBits().toString();
        double part1poswithin = -100000.0;
        double part1negwithin = -100000.0;
        ArrayList ResAl = (ArrayList)this.m_HeurComputed.get(part1bits);
        if (ResAl != null) {
            part1poswithin = (Double)ResAl.get(1);
            part1negwithin = (Double)ResAl.get(2);
        } else {
            ClusLogger.info("------- Partition not found ------");
        }
        int[] part1posindices = this.constructIndexVector(this.m_Data, partition);
        GeneticDistanceStat p2stat = pstat.cloneStat();
        p2stat.copy(pstat);
        p2stat.subtractFromThis(partition);
        BitList part2bitl = p2stat.getBits();
        double part2poswithin = -100000.0;
        ArrayList ResAl2 = (ArrayList)this.m_HeurComputed.get(part2bitl.toString());
        if (ResAl2 != null) {
            part2poswithin = (Double)ResAl2.get(1);
        } else {
            ClusLogger.info("------- Partition2 not found ------");
        }
        int[] part2posindices = this.constructIndexVector(this.m_Data, p2stat);
        double poswithin = part1poswithin + part2poswithin + this.getSumPWDistanceBetween(part1posindices, part2posindices);
        double negwithin = part1negwithin - part2poswithin - this.getSumPWDistanceBetween(part2posindices, negindices);
        double[] result = new double[]{poswithin, negwithin};
        return result;
    }

    public double calcHeuristicBranchLengths(ClusStatistic c_tstat, ClusStatistic c_pstat, ClusStatistic partition) {
        double result;
        GeneticDistanceStat tstat = (GeneticDistanceStat)c_tstat;
        GeneticDistanceStat pstat = (GeneticDistanceStat)c_pstat;
        GeneticDistanceStat nstat = tstat.cloneStat();
        nstat.copy(tstat);
        nstat.subtractFromThis(pstat);
        double stop = this.checkStopCriterion(tstat, pstat, nstat);
        if (stop != 0.0) {
            return stop;
        }
        String key = pstat.getBits().toString();
        ArrayList ResAl = (ArrayList)this.m_HeurComputed.get(key);
        if (ResAl != null) {
            Double value = (Double)ResAl.get(0);
            return value;
        }
        key = pstat.getBits().toString();
        ResAl = (ArrayList)this.m_HeurComputed.get(key);
        if (ResAl != null) {
            Double value = (Double)ResAl.get(0);
            return value;
        }
        int[] posindices = this.constructIndexVector(this.m_Data, pstat);
        int[] negindices = this.constructIndexVector(this.m_Data, nstat);
        double poswithin = 0.0;
        double negwithin = 0.0;
        if (partition != null) {
            GeneticDistanceStat part = (GeneticDistanceStat)partition;
            double[] withins = this.effcalculate(pstat, part, negindices);
            poswithin = withins[0];
            negwithin = withins[1];
        } else {
            poswithin = this.getSumPWDistancesWithin(posindices);
            negwithin = this.getSumPWDistancesWithin(negindices);
        }
        double n_pos = pstat.getTotalWeight();
        double n_neg = tstat.getTotalWeight() - pstat.getTotalWeight();
        if (this.m_Data.getNbRows() == this.m_RootData.getNbRows()) {
            result = (this.m_SumAllDistances + (n_neg - 1.0) * poswithin + (n_pos - 1.0) * negwithin) / (n_pos * n_neg);
        } else {
            double sumDistPosToCompl = 0.0;
            double sumDistNegToCompl = 0.0;
            int i = 0;
            while ((double)i < tstat.getTotalWeight()) {
                if (pstat.getBits().getBit(i)) {
                    sumDistPosToCompl += this.m_SumDistWithCompl[i];
                } else {
                    sumDistNegToCompl += this.m_SumDistWithCompl[i];
                }
                ++i;
            }
            double n_compl = this.m_ComplDataIndices.length;
            result = sumDistNegToCompl / (n_neg * n_compl) + sumDistPosToCompl / (n_pos * n_compl) + this.m_SumAllDistances / (n_pos * n_neg) + poswithin * (2.0 * n_neg - 1.0) / (n_pos * n_neg) + negwithin * (2.0 * n_pos - 1.0) / (n_pos * n_neg);
        }
        double finalresult = -1.0 * result;
        key = pstat.getBits().toString();
        ArrayList<Double> al = new ArrayList<Double>(3);
        al.add(new Double(finalresult));
        al.add(new Double(poswithin));
        al.add(new Double(negwithin));
        this.m_HeurComputed.put(key, al);
        key = nstat.getBits().toString();
        ArrayList<Double> al2 = new ArrayList<Double>(3);
        al2.add(new Double(finalresult));
        al2.add(new Double(negwithin));
        al2.add(new Double(poswithin));
        this.m_HeurComputed.put(key, al2);
        return finalresult;
    }

    public double checkStopCriterion(GeneticDistanceStat tstat, GeneticDistanceStat pstat, GeneticDistanceStat nstat) {
        double n_pos = pstat.getTotalWeight();
        double n_neg = tstat.getTotalWeight() - pstat.getTotalWeight();
        if (n_pos < SettingsTree.MINIMAL_WEIGHT || n_neg < SettingsTree.MINIMAL_WEIGHT) {
            return Double.NEGATIVE_INFINITY;
        }
        if (n_pos + n_neg != (double)this.m_Data.getNbRows()) {
            return Double.NEGATIVE_INFINITY;
        }
        if ((double)Math.round(n_pos) != n_pos || (double)Math.round(n_neg) != n_neg) {
            return Double.NEGATIVE_INFINITY;
        }
        if (n_pos + n_neg == 2.0 * SettingsTree.MINIMAL_WEIGHT) {
            return Double.POSITIVE_INFINITY;
        }
        return 0.0;
    }

    @Override
    public boolean isAcceptable(ClusStatistic c_tstat, ClusStatistic c_pstat, ClusStatistic missing) {
        double negwithin;
        double poswithin;
        int[] negindices;
        int[] posindices;
        GeneticDistanceStat tstat = (GeneticDistanceStat)c_tstat;
        GeneticDistanceStat pstat = (GeneticDistanceStat)c_pstat;
        GeneticDistanceStat nstat = tstat.cloneStat();
        nstat.copy(tstat);
        nstat.subtractFromThis(pstat);
        double n_pos = pstat.getTotalWeight();
        double n_neg = tstat.getTotalWeight() - pstat.getTotalWeight();
        if (this.m_RootData.getSchema().getSettings().getPhylogeny().getPhylogenyEntropyVsRootStop() > 0.0 && this.m_SumEntropyWithin / this.m_RootSumEntropyWithin < this.m_RootData.getSchema().getSettings().getPhylogeny().getPhylogenyEntropyVsRootStop()) {
            if (this.m_RootData.getSchema().getSettings().getGeneral().getVerbose() > 2) {
                ClusLogger.info("STOP: entropy at current node = " + this.m_SumEntropyWithin + ", at root = " + this.m_RootSumEntropyWithin);
            }
            return false;
        }
        if (this.m_RootData.getSchema().getSettings().getPhylogeny().getPhylogenyDistancesVsRootStop() > 0.0 && this.m_AvgAllDistances / this.m_RootAvgAllDistances < this.m_RootData.getSchema().getSettings().getPhylogeny().getPhylogenyDistancesVsRootStop()) {
            if (this.m_RootData.getSchema().getSettings().getGeneral().getVerbose() > 2) {
                ClusLogger.info("STOP: AvgPWDistance at current node = " + this.m_AvgAllDistances + ", at root = " + this.m_RootAvgAllDistances);
            }
            return false;
        }
        if (this.m_RootData.getSchema().getSettings().getPhylogeny().getPhylogenyDistancesVsParentStop() > 0.0) {
            posindices = this.constructIndexVector(this.m_Data, pstat);
            negindices = this.constructIndexVector(this.m_Data, nstat);
            poswithin = this.getAvgPWDistancesWithin(posindices);
            if ((n_pos * poswithin + n_neg * (negwithin = this.getAvgPWDistancesWithin(negindices))) / (n_pos + n_neg) / this.m_AvgAllDistances > this.m_RootData.getSchema().getSettings().getPhylogeny().getPhylogenyDistancesVsParentStop()) {
                if (this.m_RootData.getSchema().getSettings().getGeneral().getVerbose() > 2) {
                    ClusLogger.info("STOP: weighted sum of AvgPWDistances in children = " + (n_pos * poswithin + n_neg * negwithin) / (n_pos + n_neg) + ", AvgPWDistance at node = " + this.m_AvgAllDistances);
                }
                return false;
            }
        }
        if (this.m_RootData.getSchema().getSettings().getPhylogeny().getPhylogenyEntropyVsParentStop() > 0.0) {
            posindices = this.constructIndexVector(this.m_Data, pstat);
            negindices = this.constructIndexVector(this.m_Data, nstat);
            poswithin = this.getSumOfEntropyWithin(posindices);
            if ((n_pos * poswithin + n_neg * (negwithin = this.getSumOfEntropyWithin(negindices))) / (n_pos + n_neg) / this.m_SumEntropyWithin > this.m_RootData.getSchema().getSettings().getPhylogeny().getPhylogenyEntropyVsParentStop()) {
                if (this.m_RootData.getSchema().getSettings().getGeneral().getVerbose() > 2) {
                    ClusLogger.info("STOP: weighted sum of SumEntropies in children = " + (n_pos * poswithin + n_neg * negwithin) / (n_pos + n_neg) + ", SumEntropies at node = " + this.m_SumEntropyWithin);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public String getName() {
        switch (this.getSettings().getPhylogeny().getPhylogenyCriterion()) {
            case MinTotBranchLength: {
                return "GeneticDistanceHeuristicMatrix -> Minimize total branch length";
            }
            case MaxAvgPWDistance: {
                return "GeneticDistanceHeuristicMatrix -> Maximize avg pairwise distance";
            }
        }
        return "GeneticDistanceHeuristicMatrix";
    }
}

