/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.heuristic;

import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.jeans.math.MathUtil;

public class GainHeuristic
extends ClusHeuristic {
    protected boolean m_GainRatio;

    public GainHeuristic(boolean gainratio, ClusAttributeWeights prod, Settings sett) {
        super(sett);
        this.m_GainRatio = gainratio;
        this.m_ClusteringWeights = prod;
    }

    public final boolean isGainRatio() {
        return this.m_GainRatio;
    }

    @Override
    public double calcHeuristic(ClusStatistic c_tstat, ClusStatistic c_pstat, ClusStatistic missing) {
        if (this.stopCriterion(c_tstat, c_pstat, missing)) {
            return Double.NEGATIVE_INFINITY;
        }
        ClassificationStat tstat = (ClassificationStat)c_tstat;
        ClassificationStat pstat = (ClassificationStat)c_pstat;
        double n_tot = tstat.getTotalWeight();
        double n_pos = pstat.getTotalWeight();
        double n_neg = n_tot - n_pos;
        double tot_ent = tstat.entropy(this.m_ClusteringWeights);
        double pos_ent = pstat.entropy(this.m_ClusteringWeights);
        double neg_ent = tstat.entropyDifference(pstat, this.m_ClusteringWeights);
        double value = 0.0;
        if (!tstat.getAttribute(0).getSchema().getSettings().getTree().considerUnlableInstancesInIGCalc()) {
            value = tot_ent - (n_pos * pos_ent + n_neg * neg_ent) / n_tot;
        } else {
            double n_tot_label = tstat.getSumWeights(0);
            double n_pos_label = pstat.getSumWeights(0);
            double n_neg_label = n_tot_label - n_pos_label;
            value = tot_ent - ((n_pos - n_pos_label) * pos_ent + (n_neg - n_neg_label) * neg_ent) / (n_tot - n_tot_label);
        }
        if (value < 1.0E-6) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.m_GainRatio) {
            double si = ClassificationStat.computeSplitInfo(n_tot, n_pos, n_neg);
            if (si < 1.0E-6) {
                return Double.NEGATIVE_INFINITY;
            }
            return value / si;
        }
        return value;
    }

    @Override
    public double calcHeuristic(ClusStatistic c_tstat, ClusStatistic[] c_pstat, int nbsplit) {
        if (this.stopCriterion(c_tstat, c_pstat, nbsplit)) {
            return Double.NEGATIVE_INFINITY;
        }
        ClassificationStat tstat = (ClassificationStat)c_tstat;
        double n_tot = tstat.getTotalWeight();
        double value = tstat.entropy(this.m_ClusteringWeights);
        for (int i = 0; i < nbsplit; ++i) {
            ClassificationStat pstat = (ClassificationStat)c_pstat[i];
            double n_set = pstat.getTotalWeight();
            value -= n_set / n_tot * pstat.entropy(this.m_ClusteringWeights);
        }
        if (value < 1.0E-6) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.m_GainRatio) {
            double si = 0.0;
            for (int i = 0; i < nbsplit; ++i) {
                double n_set = c_pstat[i].getTotalWeight();
                if (!(n_set >= 1.0E-6)) continue;
                double div = n_set / n_tot;
                si -= div * Math.log(div);
            }
            if ((si /= MathUtil.M_LN2) < 1.0E-6) {
                return Double.NEGATIVE_INFINITY;
            }
            return value / si;
        }
        return value;
    }

    @Override
    public String getName() {
        return this.m_GainRatio ? "Gainratio" : "Gain";
    }
}

