/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.heuristic;

import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.heuristic.stopCriterion.ClusStopCriterion;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public abstract class ClusHeuristic {
    public static final double DELTA = 1.0E-6;
    protected RowData m_TrainData;
    protected double m_TrainDataHeurValue;
    protected ClusAttributeWeights m_ClusteringWeights;
    protected ClusStopCriterion m_StopCrit;
    protected double m_NumericSplitTotStatSVarS;
    private Settings m_Settings;

    public ClusHeuristic(Settings sett) {
        this.m_Settings = sett;
    }

    public final Settings getSettings() {
        return this.m_Settings;
    }

    public void setSplitStatSVarS(double value) {
        this.m_NumericSplitTotStatSVarS = value;
    }

    public boolean isEfficient() {
        return false;
    }

    public double calcHeuristic(ClusStatistic tstat, ClusStatistic pstat, ClusStatistic missing, double ss_tot) throws ClusException {
        return this.calcHeuristic(tstat, pstat, missing);
    }

    public void setData(RowData data) {
    }

    public ClusAttributeWeights getClusteringAttributeWeights() {
        return this.m_ClusteringWeights;
    }

    public void setInitialData(ClusStatistic stat, RowData data) {
    }

    public void setRootStatistic(ClusStatistic stat) {
    }

    public abstract double calcHeuristic(ClusStatistic var1, ClusStatistic var2, ClusStatistic var3) throws ClusException;

    public abstract String getName();

    public double calcHeuristic(ClusStatistic c_tstat, ClusStatistic[] c_pstat, int nbsplit) {
        return Double.NEGATIVE_INFINITY;
    }

    public boolean stopCriterion(ClusStatistic tstat, ClusStatistic pstat, ClusStatistic missing) {
        return this.m_StopCrit.stopCriterion(tstat, pstat, missing);
    }

    public boolean stopCriterion(ClusStatistic tstat, ClusStatistic[] pstat, int nbsplit) {
        return this.m_StopCrit.stopCriterion(tstat, pstat, nbsplit);
    }

    public static double nonZero(double val) {
        if (val < 1.0E-6) {
            return Double.NEGATIVE_INFINITY;
        }
        return val;
    }

    public RowData getTrainData() {
        return this.m_TrainData;
    }

    public void setTrainData(RowData data) {
        this.m_TrainData = data;
    }

    public double getTrainDataHeurValue() {
        return this.m_TrainDataHeurValue;
    }

    public void setTrainDataHeurValue(double value) {
        this.m_TrainDataHeurValue = value;
    }

    public void setStopCriterion(ClusStopCriterion stop) {
        this.m_StopCrit = stop;
    }

    public boolean isAcceptable(ClusStatistic c_tstat, ClusStatistic c_pstat, ClusStatistic missing) {
        return true;
    }
}

