/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.timeseries;

import java.util.ArrayList;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.data.type.primitive.TimeSeriesAttrType;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.distance.primitive.timeseries.TimeSeriesDist;
import si.ijs.kt.clus.ext.timeseries.TimeSeries;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTimeSeries;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.statistic.SumPairwiseDistancesStat;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusUtil;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class TimeSeriesStat
extends SumPairwiseDistancesStat {
    public static final long serialVersionUID = 1L;
    protected TimeSeriesAttrType m_Attr;
    private ArrayList<TimeSeries> m_TimeSeriesStack = new ArrayList();
    public TimeSeries m_RepresentativeMean = new TimeSeries("[]");
    public TimeSeries m_RepresentativeMedoid = new TimeSeries("[]");
    protected double m_AvgDistances;

    public TimeSeriesStat(Settings sett, TimeSeriesAttrType attr, ClusDistance dist, SettingsTimeSeries.TimeSeriesPrototypeComplexity efflvl) {
        super(sett, dist, efflvl);
        this.m_Attr = attr;
    }

    @Override
    public ClusStatistic cloneStat() {
        TimeSeriesStat stat = new TimeSeriesStat(this.m_Settings, this.m_Attr, this.m_Distance, this.m_Efficiency);
        stat.cloneFrom(this);
        return stat;
    }

    @Override
    public ClusStatistic cloneSimple() {
        TimeSeriesStat stat = new TimeSeriesStat(this.m_Settings, this.m_Attr, this.m_Distance, this.m_Efficiency);
        stat.m_RepresentativeMean = new TimeSeries(this.m_RepresentativeMean.length());
        stat.m_RepresentativeMedoid = new TimeSeries(this.m_RepresentativeMedoid.length());
        return stat;
    }

    @Override
    public void copy(ClusStatistic other) {
        TimeSeriesStat or = (TimeSeriesStat)other;
        super.copy(or);
        this.m_TimeSeriesStack.clear();
        this.m_TimeSeriesStack.addAll(or.m_TimeSeriesStack);
    }

    @Override
    public TimeSeriesStat normalizedCopy() {
        TimeSeriesStat copy = (TimeSeriesStat)this.cloneSimple();
        copy.m_NbExamples = 0;
        copy.m_SumWeight = 1.0;
        copy.m_TimeSeriesStack.add(this.getTimeSeriesPred());
        copy.m_RepresentativeMean.setValues(this.m_RepresentativeMean.getValues());
        copy.m_RepresentativeMedoid.setValues(this.m_RepresentativeMedoid.getValues());
        return copy;
    }

    @Override
    public void addPrediction(ClusStatistic other, double weight) {
        TimeSeriesStat or = (TimeSeriesStat)other;
        this.m_SumWeight += weight;
        TimeSeries pred = new TimeSeries(or.getTimeSeriesPred());
        pred.setTSWeight(weight);
        this.m_TimeSeriesStack.add(pred);
    }

    @Override
    public void updateWeighted(DataTuple tuple, int idx) {
        super.updateWeighted(tuple, idx);
        TimeSeries newTimeSeries = new TimeSeries((TimeSeries)tuple.getObjVal(this.m_Attr.getArrayIndex()));
        newTimeSeries.setTSWeight(tuple.getWeight());
        this.m_TimeSeriesStack.add(newTimeSeries);
    }

    public double calcDistance(TimeSeries ts1, TimeSeries ts2) throws ClusException {
        TimeSeriesDist dist = (TimeSeriesDist)this.getDistance();
        return dist.calcDistance(ts1, ts2);
    }

    @Override
    public double getDispersion(ClusAttributeWeights scale, RowData data) throws ClusException {
        return this.getSVarS(scale, data);
    }

    @Override
    public double getAbsoluteDistance(DataTuple tuple, ClusAttributeWeights weights) throws ClusException {
        int idx = this.m_Attr.getIndex();
        TimeSeries actual = (TimeSeries)tuple.getObjVal(0);
        return this.calcDistance(this.m_RepresentativeMean, actual) * weights.getWeight(idx);
    }

    public void initNormalizationWeights(ClusAttributeWeights weights, boolean[] shouldNormalize) {
        int idx = this.m_Attr.getIndex();
        if (shouldNormalize[idx]) {
            double var = this.m_SVarS / this.getTotalWeight();
            double norm = var > 0.0 ? 1.0 / var : 1.0;
            weights.setWeight(this.m_Attr, norm);
        }
    }

    public void calcSumAndSumSqDistances(TimeSeries prototype) throws ClusException {
        this.m_AvgDistances = 0.0;
        int count = this.m_TimeSeriesStack.size();
        for (int i = 0; i < count; ++i) {
            double dist = this.calcDistance(prototype, this.m_TimeSeriesStack.get(i));
            this.m_AvgDistances += dist;
        }
        this.m_AvgDistances /= (double)count;
    }

    private TimeSeries calcMedoidTS() throws ClusException {
        TimeSeries medoid = null;
        double minDistance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.m_TimeSeriesStack.size(); ++i) {
            double crDistance = 0.0;
            TimeSeries t1 = this.m_TimeSeriesStack.get(i);
            for (int j = 0; j < this.m_TimeSeriesStack.size(); ++j) {
                TimeSeries t2 = this.m_TimeSeriesStack.get(j);
                double dist = this.calcDistance(t1, t2);
                crDistance += dist * t2.geTSWeight();
            }
            if (!(crDistance < minDistance)) continue;
            medoid = this.m_TimeSeriesStack.get(i);
            minDistance = crDistance;
        }
        return medoid;
    }

    private TimeSeries calcMeanTS() {
        TimeSeries mean = new TimeSeries("[]");
        if (this.m_TimeSeriesStack.size() == 0) {
            return null;
        }
        mean.setSize(this.m_TimeSeriesStack.get(0).length());
        for (int j = 0; j < this.m_TimeSeriesStack.size(); ++j) {
            if (this.m_TimeSeriesStack.get(j).length() == mean.length()) continue;
            if (this.m_Settings.getGeneral().getVerbose() > 1) {
                ClusLogger.info("TSs should be of the same length, returning null as the mean value.");
            }
            return null;
        }
        for (int i = 0; i < mean.length(); ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.m_TimeSeriesStack.size(); ++j) {
                TimeSeries t1 = this.m_TimeSeriesStack.get(j);
                sum += t1.getValue(i) * t1.geTSWeight();
            }
            mean.setValue(i, sum / this.m_SumWeight);
        }
        return mean;
    }

    @Override
    public void calcMean() throws ClusException {
        this.m_RepresentativeMedoid = this.calcMedoidTS();
        this.calcSumAndSumSqDistances(this.m_RepresentativeMedoid);
        if (this.m_Attr.isEqualLength()) {
            this.m_RepresentativeMean = this.calcMeanTS();
        }
        double sumwi = 0.0;
        for (int j = 0; j < this.m_TimeSeriesStack.size(); ++j) {
            TimeSeries t1 = this.m_TimeSeriesStack.get(j);
            sumwi += t1.geTSWeight();
        }
        double diff = Math.abs(this.m_SumWeight - sumwi);
        if (diff > 1.0E-6) {
            System.err.println("Error: Sanity check failed! - " + diff);
        }
    }

    @Override
    public boolean samePrediction(ClusStatistic other) {
        TimeSeries otherMean;
        TimeSeriesStat otherTS = (TimeSeriesStat)other;
        TimeSeries thisMean = this.calcMeanTS();
        if (!TimeSeries.areEqual(thisMean, otherMean = otherTS.calcMeanTS())) {
            return false;
        }
        try {
            TimeSeries thisMedoid = this.calcMedoidTS();
            TimeSeries otherMedoid = otherTS.calcMedoidTS();
            return TimeSeries.areEqual(thisMedoid, otherMedoid);
        }
        catch (ClusException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.m_TimeSeriesStack.clear();
    }

    @Override
    public String getString(StatisticPrintInfo info) {
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        StringBuffer buf = new StringBuffer();
        buf.append("Mean: ");
        buf.append(this.m_RepresentativeMean.toString());
        if (info.SHOW_EXAMPLE_COUNT) {
            buf.append(": ");
            buf.append(fr.format(this.m_SumWeight));
        }
        buf.append("; ");
        buf.append("Medoid: ");
        buf.append(this.m_RepresentativeMedoid.toString());
        if (info.SHOW_EXAMPLE_COUNT) {
            buf.append(": ");
            buf.append(fr.format(this.m_SumWeight));
            buf.append(", ");
            buf.append(fr.format(this.m_AvgDistances));
        }
        buf.append("; ");
        return buf.toString();
    }

    @Override
    public void addPredictWriterSchema(String prefix, ClusSchema schema) {
        schema.addAttrType(new TimeSeriesAttrType(prefix + "-p-TimeSeries"));
        schema.addAttrType(new NumericAttrType(prefix + "-p-Distance"));
        schema.addAttrType(new NumericAttrType(prefix + "-p-Size"));
        schema.addAttrType(new NumericAttrType(prefix + "-p-AvgDist"));
    }

    @Override
    public String getPredictWriterString(DataTuple tuple) throws ClusException {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_RepresentativeMedoid.toString());
        double dist = this.calcDistanceToCentroid(tuple);
        buf.append(",");
        buf.append(dist);
        buf.append(",");
        buf.append(this.getTotalWeight());
        buf.append(",");
        buf.append(this.m_AvgDistances);
        return buf.toString();
    }

    public TimeSeries getRepresentativeMean() {
        return this.m_RepresentativeMean;
    }

    public TimeSeries getRepresentativeMedoid() {
        return this.m_RepresentativeMedoid;
    }

    @Override
    public TimeSeries getTimeSeriesPred() {
        return this.m_RepresentativeMedoid;
    }

    public TimeSeriesAttrType getAttribute() {
        return this.m_Attr;
    }

    public double stackWeight() {
        double sum = 0.0;
        for (TimeSeries ts : this.m_TimeSeriesStack) {
            sum += ts.geTSWeight();
        }
        return sum;
    }

    @Override
    public void add(ClusStatistic other) {
        super.add(other);
        this.m_TimeSeriesStack.addAll(((TimeSeriesStat)other).m_TimeSeriesStack);
    }

    @Override
    public void subtractFromThis(ClusStatistic other) {
        super.subtractFromThis(other);
        ArrayList<TimeSeries> newStack = new ArrayList<TimeSeries>();
        boolean[] shouldRemove = new boolean[this.m_TimeSeriesStack.size()];
        TimeSeriesStat otherTS = (TimeSeriesStat)other;
        int found = 0;
        block0: for (TimeSeries ts1 : otherTS.m_TimeSeriesStack) {
            for (int i = 0; i < this.m_TimeSeriesStack.size(); ++i) {
                if (shouldRemove[i] || !TimeSeries.areEqual(ts1, this.m_TimeSeriesStack.get(i))) continue;
                shouldRemove[i] = true;
                ++found;
                continue block0;
            }
        }
        if (found != otherTS.m_TimeSeriesStack.size()) {
            System.err.println("Removal candidates: " + otherTS.m_TimeSeriesStack.size() + " found: " + found);
        }
        for (int i = 0; i < shouldRemove.length; ++i) {
            if (shouldRemove[i]) continue;
            newStack.add(this.m_TimeSeriesStack.get(i));
        }
        this.m_TimeSeriesStack = newStack;
    }

    public boolean checkInvariant() {
        return ClusUtil.eq(this.stackWeight(), this.m_SumWeight, 1.0E-6);
    }
}

