/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.timeseries;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import si.ijs.kt.clus.algo.rules.ClusRule;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.primitive.TimeSeriesAttrType;
import si.ijs.kt.clus.distance.primitive.timeseries.TimeSeriesDist;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.ext.timeseries.TimeSeries;
import si.ijs.kt.clus.ext.timeseries.TimeSeriesStat;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.selection.XValRandomSelection;
import si.ijs.kt.clus.selection.XValSelection;
import si.ijs.kt.clus.util.exception.ClusException;

public class TimeSeriesSignificantChangeTesterXVAL
extends ClusError {
    public static final long serialVersionUID = 1L;
    protected TimeSeriesStat m_Stat;
    protected ArrayList m_FoldsMean;
    protected ArrayList m_FoldsMedoid;

    public TimeSeriesSignificantChangeTesterXVAL(ClusErrorList par, TimeSeriesStat stat) {
        super(par);
        this.m_Stat = stat;
    }

    @Override
    public boolean isComputeForModel(String name) {
        return false;
    }

    public double computeMeanValue(TimeSeriesAttrType attr, RowData data) {
        int nb = 0;
        double sum = 0.0;
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            double[] series = attr.getTimeSeries(tuple).getValues();
            for (int j = 0; j < series.length; ++j) {
                sum += series[j];
                ++nb;
            }
        }
        return sum / (double)nb;
    }

    public int getTimeSeriesLength(TimeSeriesAttrType attr, RowData data) {
        int len = 0;
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            double[] series = attr.getTimeSeries(tuple).getValues();
            len = Math.max(len, series.length);
        }
        return len;
    }

    public double computeError(RowData data, TimeSeries ts) throws ClusException {
        double sum = 0.0;
        TimeSeriesDist dist = (TimeSeriesDist)this.m_Stat.getDistance();
        TimeSeriesAttrType attr = this.m_Stat.getAttribute();
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            TimeSeries series = attr.getTimeSeries(tuple);
            sum += dist.calcDistance(series, ts);
        }
        return sum / (double)data.getNbRows();
    }

    public void doOneFold(RowData train, RowData test) throws ClusException {
        TimeSeriesAttrType attr = this.m_Stat.getAttribute();
        double mean = this.computeMeanValue(attr, train);
        double[] mean_series = new double[this.getTimeSeriesLength(attr, train)];
        Arrays.fill(mean_series, mean);
        TimeSeries mean_ts = new TimeSeries(mean_series);
        TimeSeriesStat stat = (TimeSeriesStat)this.m_Stat.cloneStat();
        train.calcTotalStatBitVector(stat);
        stat.calcMean();
        TimeSeries medoid_ts = stat.getRepresentativeMedoid();
        double mean_err = this.computeError(test, mean_ts);
        double medoid_err = this.computeError(test, medoid_ts);
        this.m_FoldsMean.add(new Double(mean_err));
        this.m_FoldsMedoid.add(new Double(medoid_err));
    }

    public void computeSignificantChangePValueXVAL(RowData data) throws ClusException {
        this.m_FoldsMean = new ArrayList();
        this.m_FoldsMedoid = new ArrayList();
        Random random = new Random(0L);
        int nbfolds = 10;
        XValRandomSelection sel = new XValRandomSelection(data.getNbRows(), nbfolds, random);
        for (int i = 0; i < nbfolds; ++i) {
            XValSelection msel = new XValSelection(sel, i);
            RowData train = (RowData)data.cloneData();
            RowData test = (RowData)train.select(msel);
            this.doOneFold(train, test);
        }
    }

    public void computeForRule(ClusRule rule, ClusSchema schema) throws ClusException {
        RowData covered = new RowData(rule.getData(), schema);
        this.computeSignificantChangePValueXVAL(covered);
    }

    @Override
    public void compute(RowData data, ClusModel model) throws ClusException {
        if (model instanceof ClusRule) {
            this.computeForRule((ClusRule)model, data.getSchema());
        }
    }

    public void printArray(ArrayList arr, StringBuffer res) {
        res.append("[");
        for (int i = 0; i < arr.size(); ++i) {
            double v = (Double)arr.get(i);
            if (i != 0) {
                res.append(",");
            }
            res.append(String.valueOf(v));
        }
        res.append("]");
    }

    @Override
    public void showModelError(PrintWriter wrt, int detail) {
        StringBuffer res = new StringBuffer();
        res.append("\n");
        res.append("   Medoid: ");
        this.printArray(this.m_FoldsMedoid, res);
        res.append("\n");
        res.append("   Mean: ");
        this.printArray(this.m_FoldsMean, res);
        wrt.println(res.toString());
    }

    @Override
    public ClusError getErrorClone(ClusErrorList par) {
        return new TimeSeriesSignificantChangeTesterXVAL(this.getParent(), this.m_Stat);
    }

    @Override
    public String getName() {
        return "Significant Time Change XVAL";
    }

    @Override
    public boolean shouldBeLow() {
        return true;
    }
}

