/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.structuredTypes;

import java.util.ArrayList;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.complex.TupleAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.distance.complex.TupleDistance;
import si.ijs.kt.clus.ext.structuredTypes.Tuple;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTimeSeries;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.statistic.SumPairwiseDistancesStat;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class TupleStatistic
extends SumPairwiseDistancesStat {
    public static final long serialVersionUID = 1L;
    protected TupleAttrType m_Attr;
    private ArrayList<Tuple> m_TupleStack = new ArrayList();
    public Tuple m_RepresentativeMean = new Tuple("[]");
    public Tuple m_RepresentativeMedoid = new Tuple("[]");
    protected double m_AvgDistances;

    public TupleStatistic(Settings sett, TupleAttrType attr, ClusDistance dist, SettingsTimeSeries.TimeSeriesPrototypeComplexity efflvl) {
        super(sett, dist, efflvl);
        this.m_Attr = attr;
    }

    @Override
    public ClusStatistic cloneStat() {
        TupleStatistic stat = new TupleStatistic(this.getSettings(), this.m_Attr, this.m_Distance, this.m_Efficiency);
        stat.cloneFrom(this);
        return stat;
    }

    @Override
    public ClusStatistic cloneSimple() {
        TupleStatistic stat = new TupleStatistic(this.getSettings(), this.m_Attr, this.m_Distance, this.m_Efficiency);
        stat.m_RepresentativeMean = new Tuple(this.m_RepresentativeMean.length());
        stat.m_RepresentativeMedoid = new Tuple(this.m_RepresentativeMedoid.length());
        return stat;
    }

    @Override
    public void copy(ClusStatistic other) {
        TupleStatistic or = (TupleStatistic)other;
        super.copy(or);
        this.m_TupleStack.clear();
        this.m_TupleStack.addAll(or.m_TupleStack);
    }

    @Override
    public TupleStatistic normalizedCopy() {
        TupleStatistic copy = (TupleStatistic)this.cloneSimple();
        copy.m_NbExamples = 0;
        copy.m_SumWeight = 1.0;
        copy.m_TupleStack.add(this.getTuplePred());
        copy.m_RepresentativeMean.setValues(this.m_RepresentativeMean.getValues());
        copy.m_RepresentativeMedoid.setValues(this.m_RepresentativeMedoid.getValues());
        return copy;
    }

    @Override
    public void addPrediction(ClusStatistic other, double weight) {
        TupleStatistic or = (TupleStatistic)other;
        this.m_SumWeight += weight * or.m_SumWeight;
        Tuple pred = new Tuple(or.getTuplePred());
        pred.setTSWeight(weight);
        this.m_TupleStack.add(pred);
    }

    @Override
    public void updateWeighted(DataTuple tuple, int idx) {
        super.updateWeighted(tuple, idx);
        Tuple newTuple = new Tuple((Tuple)tuple.getObjVal(this.getAttribute().getArrayIndex()));
        newTuple.setTSWeight(tuple.getWeight());
        this.m_TupleStack.add(newTuple);
    }

    public double calcDistance(Tuple t1, Tuple t2) throws ClusException {
        TupleDistance dist = (TupleDistance)this.getDistance();
        return dist.calcDistance(t1, t2);
    }

    @Override
    public double calcDistance(DataTuple t1, DataTuple t2) throws ClusException {
        return ((TupleDistance)this.m_Distance).calcDistance(t1, t2);
    }

    @Override
    public double getDispersion(ClusAttributeWeights scale, RowData data) throws ClusException {
        return this.getSVarS(scale, data);
    }

    @Override
    public double getAbsoluteDistance(DataTuple tuple, ClusAttributeWeights weights) throws ClusException {
        int idx = this.m_Attr.getIndex();
        Tuple actual = (Tuple)tuple.getObjVal(0);
        return this.calcDistance(this.m_RepresentativeMean, actual) * weights.getWeight(idx);
    }

    public void initNormalizationWeights(ClusAttributeWeights weights, boolean[] shouldNormalize) {
        int idx = this.m_Attr.getIndex();
        if (shouldNormalize[idx]) {
            double var = this.m_SVarS / this.getTotalWeight();
            double norm = var > 0.0 ? 1.0 / var : 1.0;
            weights.setWeight(this.m_Attr, norm);
        }
    }

    public void calcSumAndSumSqDistances(Tuple prototype) throws ClusException {
        this.m_AvgDistances = 0.0;
        int count = this.m_TupleStack.size();
        for (int i = 0; i < count; ++i) {
            double dist = this.calcDistance(prototype, this.m_TupleStack.get(i));
            this.m_AvgDistances += dist;
        }
        this.m_AvgDistances /= (double)count;
    }

    @Override
    public void calcMean() throws ClusException {
        Tuple t1;
        this.m_RepresentativeMedoid = null;
        double minDistance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.m_TupleStack.size(); ++i) {
            double crDistance = 0.0;
            t1 = this.m_TupleStack.get(i);
            for (int j = 0; j < this.m_TupleStack.size(); ++j) {
                Tuple t2 = this.m_TupleStack.get(j);
                double dist = this.calcDistance(t1, t2);
                crDistance += dist * t2.geTSWeight();
                if (!Double.isNaN(dist)) continue;
                System.err.println("ooops!!!");
            }
            if (!(crDistance < minDistance)) continue;
            this.m_RepresentativeMedoid = this.m_TupleStack.get(i);
            minDistance = crDistance;
        }
        this.calcSumAndSumSqDistances(this.m_RepresentativeMedoid);
        double sumwi = 0.0;
        for (int j = 0; j < this.m_TupleStack.size(); ++j) {
            t1 = this.m_TupleStack.get(j);
            sumwi += t1.geTSWeight();
        }
        double diff = Math.abs(this.m_SumWeight - sumwi);
        if (diff > 1.0E-6) {
            System.err.println("Error: Sanity check failed! - " + diff);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.m_TupleStack.clear();
    }

    @Override
    public String getString(StatisticPrintInfo info) {
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        StringBuffer buf = new StringBuffer();
        buf.append("Mean: ");
        buf.append(this.m_RepresentativeMean.toString());
        if (info.SHOW_EXAMPLE_COUNT) {
            buf.append(": ");
            buf.append(fr.format(this.m_SumWeight));
        }
        buf.append("; ");
        buf.append("Medoid: ");
        buf.append(this.m_RepresentativeMedoid.toString());
        if (info.SHOW_EXAMPLE_COUNT) {
            buf.append(": ");
            buf.append(fr.format(this.m_SumWeight));
            buf.append(", ");
            buf.append(fr.format(this.m_AvgDistances));
        }
        buf.append("; ");
        return buf.toString();
    }

    @Override
    public void addPredictWriterSchema(String prefix, ClusSchema schema) {
        schema.addAttrType(new TupleAttrType(prefix + "-p-Tuple"));
        schema.addAttrType(new NumericAttrType(prefix + "-p-Distance"));
        schema.addAttrType(new NumericAttrType(prefix + "-p-Size"));
        schema.addAttrType(new NumericAttrType(prefix + "-p-AvgDist"));
    }

    @Override
    public String getPredictWriterString(DataTuple tuple) throws ClusException {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_RepresentativeMedoid.toString());
        double dist = this.calcDistanceToCentroid(tuple);
        buf.append(",");
        buf.append(dist);
        buf.append(",");
        buf.append(this.getTotalWeight());
        buf.append(",");
        buf.append(this.m_AvgDistances);
        return buf.toString();
    }

    public Tuple getRepresentativeMean() {
        return this.m_RepresentativeMean;
    }

    public Tuple getRepresentativeMedoid() {
        return this.m_RepresentativeMedoid;
    }

    public Tuple getTuplePred() {
        return this.m_RepresentativeMedoid;
    }

    public TupleAttrType getAttribute() {
        return this.m_Attr;
    }

    @Override
    public double getError(ClusAttributeWeights scale) {
        return this.getSVarS(scale);
    }
}

