/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.structuredTypes;

import java.io.Serializable;
import java.util.StringTokenizer;

public class Tuple
implements Serializable {
    public static final long serialVersionUID = 1L;
    private Object[] m_Values;
    private double m_TSWeight;

    public Tuple(String values) {
        values = values.trim();
        values = values.replace("[", "");
        values = values.replace("]", "");
        StringTokenizer st = new StringTokenizer(values, ",");
        this.m_Values = new Object[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            this.m_Values[i++] = Double.parseDouble(st.nextToken());
        }
    }

    public Tuple(Object[] values) {
        this.m_Values = new Object[values.length];
        System.arraycopy(values, 0, this.m_Values, 0, values.length);
    }

    public Tuple(int size) {
        this.m_Values = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.m_Values[i] = 0.0;
        }
    }

    public Tuple(Tuple series) {
        this(series.getValues());
    }

    public int length() {
        if (this.m_Values == null) {
            return 0;
        }
        return this.m_Values.length;
    }

    public Object[] getValues() {
        Object[] result = new Object[this.m_Values.length];
        System.arraycopy(this.m_Values, 0, result, 0, this.m_Values.length);
        return result;
    }

    public Object[] getValuesNoCopy() {
        return this.m_Values;
    }

    public Object getValue(int index) {
        return this.m_Values[index];
    }

    public void setValues(Object[] values) {
        System.arraycopy(values, 0, this.m_Values, 0, values.length);
    }

    public void setValue(int index, Object value) {
        this.m_Values[index] = value;
    }

    public String toString() {
        StringBuffer a = new StringBuffer("[");
        for (int i = 0; i < this.length() - 1; ++i) {
            if (this.m_Values[i] != null) {
                a.append(this.m_Values[i]);
            } else {
                a.append("?");
            }
            a.append(',');
        }
        if (this.length() > 0) {
            a.append(this.m_Values[this.length() - 1]);
        }
        a.append(']');
        return a.toString();
    }

    public double geTSWeight() {
        return this.m_TSWeight;
    }

    public void setTSWeight(double weight) {
        this.m_TSWeight = weight;
    }
}

