/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.structuredTypes;

import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;
import si.ijs.kt.clus.ext.timeseries.TimeSeries;

public class Set
implements Serializable {
    public static final long serialVersionUID = 1L;
    private Object[] m_Values;
    private double m_SetWeight;

    public Set(String values) throws IOException {
        this(values, "");
    }

    public Set(String values, String typeDefinition) throws IOException {
        block4: {
            String subType;
            block3: {
                values = values.trim();
                if (values.charAt(0) != '{' || values.charAt(values.length() - 1) != '}') {
                    throw new IOException("This is not a well defined set! Please use {,} brackets to define a set!");
                }
                values = values.substring(1);
                values = values.substring(0, values.length() - 1);
                subType = typeDefinition.trim().substring(4);
                if (!(subType = subType.substring(0, subType.length() - 1)).equalsIgnoreCase("numeric")) break block3;
                StringTokenizer st = new StringTokenizer(values, ",");
                this.m_Values = new Object[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    this.m_Values[i++] = Double.parseDouble(st.nextToken());
                }
                break block4;
            }
            if (!subType.equalsIgnoreCase("timeseries")) break block4;
            StringTokenizer st = new StringTokenizer(values, "]");
            this.m_Values = new Object[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String ts = st.nextToken();
                ts = ts.replace(",[", "");
                ts = ts.replace("[", "");
                this.m_Values[i++] = new TimeSeries(ts);
            }
        }
    }

    public Set(Object[] values) {
        this.m_Values = new Object[values.length];
        System.arraycopy(values, 0, this.m_Values, 0, values.length);
    }

    public Set(int size) {
        this.m_Values = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.m_Values[i] = 0.0;
        }
    }

    public Set(Set set) {
        this(set.getValues());
    }

    public int size() {
        if (this.m_Values == null) {
            return 0;
        }
        return this.m_Values.length;
    }

    public Object[] getValues() {
        Object[] result = new Object[this.m_Values.length];
        System.arraycopy(this.m_Values, 0, result, 0, this.m_Values.length);
        return result;
    }

    public Object[] getValuesNoCopy() {
        return this.m_Values;
    }

    public void setValues(Object[] values) {
        System.arraycopy(values, 0, this.m_Values, 0, values.length);
    }

    public String toString() {
        StringBuffer a = new StringBuffer("{");
        for (int i = 0; i < this.size() - 1; ++i) {
            a.append(String.valueOf(this.m_Values[i]));
            a.append(',');
        }
        if (this.size() > 0) {
            a.append(String.valueOf(this.m_Values[this.size() - 1]));
        }
        a.append('}');
        return a.toString();
    }

    public double getSetWeight() {
        return this.m_SetWeight;
    }

    public void setSetWeight(double weight) {
        this.m_SetWeight = weight;
    }
}

