/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.semisupervised.confidence.normalization;

import java.util.Arrays;
import java.util.Map;
import si.ijs.kt.clus.ext.semisupervised.confidence.normalization.Normalization;

public class Standardization
implements Normalization {
    int nbTargetAttributes;
    boolean lessIsBetter = true;

    public Standardization(int nbTargetAttributes) {
        this.nbTargetAttributes = nbTargetAttributes;
    }

    @Override
    public void normalize(Map<Integer, double[]> perTargetScores) {
        double[] instancePerTargetScores;
        double[] means = new double[this.nbTargetAttributes];
        double[] stdDevs = new double[this.nbTargetAttributes];
        Arrays.fill(means, 0.0);
        Arrays.fill(stdDevs, 0.0);
        double nbExamples = 0.0;
        for (Integer key : perTargetScores.keySet()) {
            instancePerTargetScores = perTargetScores.get(key);
            nbExamples += 1.0;
            for (int i = 0; i < instancePerTargetScores.length; ++i) {
                if (nbExamples > 1.0) {
                    stdDevs[i] = (nbExamples - 2.0) / (nbExamples - 1.0) * stdDevs[i] + 1.0 / nbExamples * Math.pow(instancePerTargetScores[i] - means[i], 2.0);
                }
                means[i] = (instancePerTargetScores[i] + (nbExamples - 1.0) * means[i]) / nbExamples;
            }
        }
        for (int i = 0; i < this.nbTargetAttributes; ++i) {
            stdDevs[i] = Math.sqrt(stdDevs[i]);
        }
        for (Integer key : perTargetScores.keySet()) {
            instancePerTargetScores = perTargetScores.get(key);
            for (int i = 0; i < this.nbTargetAttributes; ++i) {
                double standardizedValue = stdDevs[i] == 0.0 ? 0.0 : (instancePerTargetScores[i] - means[i]) / stdDevs[i] * 0.125 + 0.5;
                perTargetScores.get((Object)key)[i] = standardizedValue > 1.0 ? 1.0 : (standardizedValue < 0.0 ? 0.0 : (this.lessIsBetter ? 1.0 - standardizedValue : standardizedValue));
            }
        }
    }

    @Override
    public void setIsLessBetter(boolean lessIsBetter) {
        this.lessIsBetter = lessIsBetter;
    }
}

