/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.semisupervised.confidence.classification;

import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.ext.ensemble.ClusForest;
import si.ijs.kt.clus.ext.semisupervised.Helper;
import si.ijs.kt.clus.ext.semisupervised.confidence.PredictionConfidence;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.section.SettingsSSL;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public class ClassesProbabilities
extends PredictionConfidence {
    public ClassesProbabilities(ClusStatManager statManager, SettingsSSL.SSLNormalization normalizationType, SettingsSSL.SSLAggregation aggregationType) throws ClusException {
        super(statManager, normalizationType, aggregationType);
    }

    @Override
    public int getNbTargetAttributes() {
        return this.m_StatManager.getSchema().getNbTargetAttributes();
    }

    @Override
    public double[] calculatePerTargetScores(ClusModel model, DataTuple tuple) throws ClusException, InterruptedException {
        ClusStatistic stat = new ClassificationStat(this.m_StatManager.getSettings(), this.m_StatManager.getSchema().getNominalAttrUse(ClusAttrType.AttributeUseType.Target));
        stat = model.predictWeighted(tuple);
        double[][] classCounts = ((ClassificationStat)stat).getClassCounts();
        double[] confidence = new double[classCounts.length];
        for (int j = 0; j < classCounts.length; ++j) {
            confidence[j] = Helper.max(classCounts[j]) / Helper.sum(classCounts[j]);
        }
        return confidence;
    }

    @Override
    public double[] calculatePerTargetOOBScores(ClusForest model, DataTuple tuple) throws ClusException, InterruptedException {
        ClusStatistic stat = new ClassificationStat(this.m_StatManager.getSettings(), this.m_StatManager.getSchema().getNominalAttrUse(ClusAttrType.AttributeUseType.Target));
        stat = model.predictWeightedOOB(tuple);
        double[][] classCounts = ((ClassificationStat)stat).getClassCounts();
        double[] confidence = new double[classCounts.length];
        for (int j = 0; j < classCounts.length; ++j) {
            confidence[j] = Helper.max(classCounts[j]);
        }
        return confidence;
    }
}

