/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.semisupervised.confidence;

import java.util.Random;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.ext.ensemble.ClusForest;
import si.ijs.kt.clus.ext.semisupervised.confidence.PredictionConfidence;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.section.SettingsSSL;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.util.exception.ClusException;

public class RandomScore
extends PredictionConfidence {
    public static int RANDOM_UNIFORM = 1;
    public static int RANDOM_GAUSSIAN = 2;
    public int type;

    public RandomScore(ClusStatManager statManager, int type) {
        super(statManager, SettingsSSL.SSLNormalization.MinMaxNormalization, SettingsSSL.SSLAggregation.Average);
        this.type = type;
    }

    @Override
    public void calculateConfidenceScores(ClusModel model, RowData unlabeledData) throws ClusException {
        int nb_unlabeled = unlabeledData.getNbRows();
        if (this.m_ConfidenceScores == null) {
            this.m_ConfidenceScores = new double[nb_unlabeled];
        }
        Random rnd = new Random();
        for (int i = 0; i < nb_unlabeled; ++i) {
            DataTuple tuple = unlabeledData.getTuple(i);
            if (tuple != null && tuple.getWeight() > 0.0) {
                if (this.type == RANDOM_UNIFORM) {
                    this.m_ConfidenceScores[i] = rnd.nextDouble();
                }
                if (this.type != RANDOM_GAUSSIAN) continue;
                this.m_ConfidenceScores[i] = rnd.nextGaussian() * 0.125 + 0.5;
                if (this.m_ConfidenceScores[i] > 1.0) {
                    this.m_ConfidenceScores[i] = 1.0;
                }
                if (!(this.m_ConfidenceScores[i] < 0.0)) continue;
                this.m_ConfidenceScores[i] = 0.0;
                continue;
            }
            this.m_ConfidenceScores[i] = Double.NaN;
        }
    }

    @Override
    public double[] calculatePerTargetScores(ClusModel model, DataTuple tuple) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double[] calculatePerTargetOOBScores(ClusForest model, DataTuple tuple) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

