/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.semisupervised.confidence;

import java.util.HashMap;
import java.util.Map;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.ext.ensemble.ClusForest;
import si.ijs.kt.clus.ext.semisupervised.confidence.aggregation.Aggregation;
import si.ijs.kt.clus.ext.semisupervised.confidence.aggregation.Average;
import si.ijs.kt.clus.ext.semisupervised.confidence.aggregation.AverageHMC;
import si.ijs.kt.clus.ext.semisupervised.confidence.aggregation.Maximum;
import si.ijs.kt.clus.ext.semisupervised.confidence.aggregation.Minimum;
import si.ijs.kt.clus.ext.semisupervised.confidence.normalization.MinMaxNormalization;
import si.ijs.kt.clus.ext.semisupervised.confidence.normalization.NoNormalization;
import si.ijs.kt.clus.ext.semisupervised.confidence.normalization.Normalization;
import si.ijs.kt.clus.ext.semisupervised.confidence.normalization.Ranking;
import si.ijs.kt.clus.ext.semisupervised.confidence.normalization.Standardization;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.section.SettingsSSL;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;

public abstract class PredictionConfidence {
    protected double[] m_ConfidenceScores;
    protected Map<Integer, double[]> m_perTargetScores;
    protected int m_counter;
    protected int m_NbTargets;
    protected Normalization m_Normalization;
    protected Aggregation m_Aggregation;
    protected ClusStatManager m_StatManager;

    public PredictionConfidence(ClusStatManager statManager, SettingsSSL.SSLNormalization normalizationType, SettingsSSL.SSLAggregation aggregationType) {
        this.m_StatManager = statManager;
        switch (this.m_StatManager.getTargetMode()) {
            case REGRESSION: {
                this.m_NbTargets = statManager.getSchema().getNbTargetAttributes();
                break;
            }
            case CLASSIFY: {
                this.m_NbTargets = statManager.getSchema().getNbTargetAttributes();
                break;
            }
            case HIERARCHICAL: {
                this.m_NbTargets = statManager.getHier().getTotal();
            }
        }
        switch (normalizationType) {
            case MinMaxNormalization: {
                this.m_Normalization = new MinMaxNormalization(this.m_NbTargets);
                break;
            }
            case Ranking: {
                this.m_Normalization = new Ranking(this.m_NbTargets);
                break;
            }
            case Standardization: {
                this.m_Normalization = new Standardization(this.m_NbTargets);
                break;
            }
            case NoNormalization: {
                this.m_Normalization = new NoNormalization();
                break;
            }
            default: {
                this.m_Normalization = new MinMaxNormalization(this.m_NbTargets);
            }
        }
        switch (aggregationType) {
            case Average: {
                this.m_Aggregation = new Average();
                break;
            }
            case Minimum: {
                this.m_Aggregation = new Minimum();
                break;
            }
            case Maximum: {
                this.m_Aggregation = new Maximum();
                break;
            }
            case AverageIgnoreZeros: {
                this.m_Aggregation = new AverageHMC();
            }
            default: {
                this.m_Aggregation = new Average();
            }
        }
        if (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.CLASSIFY && this.m_StatManager.getSettings().getSSL().getConfidenceMeasure().equals((Object)SettingsSSL.SSLConfidenceMeasure.Variance)) {
            this.m_Normalization.setIsLessBetter(false);
        }
    }

    public void calculateConfidenceScores(ClusModel model, RowData data, boolean OOB) throws ClusException, InterruptedException {
        int nb_unlabeled = data.getNbRows();
        this.m_ConfidenceScores = new double[nb_unlabeled];
        this.m_counter = 0;
        this.m_perTargetScores = new HashMap<Integer, double[]>();
        for (int i = 0; i < nb_unlabeled; ++i) {
            DataTuple tuple = data.getTuple(i);
            double[] instancePerTargetScores = null;
            if (tuple != null && tuple.getWeight() > 0.0) {
                if (OOB) {
                    if (((ClusForest)model).containsOOBForTuple(tuple)) {
                        instancePerTargetScores = this.calculatePerTargetOOBScores((ClusForest)model, tuple);
                        this.m_perTargetScores.put(i, instancePerTargetScores);
                        ++this.m_counter;
                        continue;
                    }
                    this.m_ConfidenceScores[i] = Double.NaN;
                    continue;
                }
                instancePerTargetScores = this.calculatePerTargetScores(model, tuple);
                this.m_perTargetScores.put(i, instancePerTargetScores);
                ++this.m_counter;
                continue;
            }
            this.m_ConfidenceScores[i] = Double.NaN;
        }
        this.m_Normalization.normalize(this.m_perTargetScores);
        for (Integer key : this.m_perTargetScores.keySet()) {
            this.m_ConfidenceScores[key.intValue()] = this.m_Aggregation.aggregate(this.m_perTargetScores.get(key));
        }
        ClusLogger.info();
    }

    public void calculateConfidenceScores(ClusModel model, RowData unlabeledData) throws ClusException, InterruptedException {
        this.calculateConfidenceScores(model, unlabeledData, false);
    }

    public void calculateOOBConfidenceScores(ClusForest model, RowData data) throws ClusException, InterruptedException {
        this.calculateConfidenceScores(model, data, true);
    }

    public abstract double[] calculatePerTargetScores(ClusModel var1, DataTuple var2) throws ClusException, InterruptedException;

    public abstract double[] calculatePerTargetOOBScores(ClusForest var1, DataTuple var2) throws ClusException, InterruptedException;

    public double getConfidence(int i) {
        return this.m_ConfidenceScores[i];
    }

    public double[] getConfidenceScores() {
        return this.m_ConfidenceScores;
    }

    public double[] getPerTargetConfidenceScores(int i) {
        return this.m_perTargetScores.get(i);
    }

    public int getCounter() {
        return this.m_counter;
    }

    public int getNbTargetAttributes() {
        return this.m_NbTargets;
    }

    public Normalization getNormalization() {
        return this.m_Normalization;
    }
}

