/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.semisupervised;

import si.ijs.kt.clus.heuristic.ClusHeuristicImpl;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;

public class ModifiedGainHeuristic
extends ClusHeuristicImpl {
    public ModifiedGainHeuristic(ClusStatistic stat, Settings sett) {
        super(stat, sett);
    }

    @Override
    public double calcHeuristic(ClusStatistic c_tstat, ClusStatistic c_pstat, ClusStatistic c_nstat, ClusStatistic missing) {
        ClassificationStat tstat = (ClassificationStat)c_tstat;
        ClassificationStat pstat = (ClassificationStat)c_pstat;
        ClassificationStat nstat = (ClassificationStat)c_nstat;
        int nb = tstat.m_NbTarget;
        double n_tot = tstat.getTotalWeight();
        double n_pos = pstat.getTotalWeight();
        double n_neg = nstat.getTotalWeight();
        if (n_pos < SettingsTree.MINIMAL_WEIGHT || n_neg < SettingsTree.MINIMAL_WEIGHT) {
            return Double.NEGATIVE_INFINITY;
        }
        double pos_ent = 0.0;
        double neg_ent = 0.0;
        double tot_ent = 0.0;
        for (int i = 0; i < nb; ++i) {
            pos_ent += pstat.entropy(i);
            neg_ent += nstat.entropy(i);
            tot_ent += tstat.entropy(i);
        }
        double gain = tot_ent - (n_pos * pos_ent + n_neg * neg_ent) / n_tot;
        if (gain < 1.0E-6) {
            return Double.NEGATIVE_INFINITY;
        }
        return gain;
    }

    @Override
    public String getName() {
        return "Gain modified for semi-supervised learning";
    }
}

