/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.semisupervised;

import com.google.common.primitives.Doubles;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.math3.stat.inference.TTest;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataPreprocs;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.error.Accuracy;
import si.ijs.kt.clus.error.RMSError;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.hmlc.HierErrorMeasures;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduce;
import si.ijs.kt.clus.ext.ensemble.ClusForest;
import si.ijs.kt.clus.ext.hierarchical.ClassesTuple;
import si.ijs.kt.clus.ext.hierarchical.thresholdcalibration.calibrateByLabelCardinality;
import si.ijs.kt.clus.ext.semisupervised.ClusSemiSupervisedInduce;
import si.ijs.kt.clus.ext.semisupervised.Helper;
import si.ijs.kt.clus.ext.semisupervised.confidence.OracleScore;
import si.ijs.kt.clus.ext.semisupervised.confidence.PredictionConfidence;
import si.ijs.kt.clus.ext.semisupervised.confidence.RandomScore;
import si.ijs.kt.clus.ext.semisupervised.confidence.classification.ClassesProbabilities;
import si.ijs.kt.clus.ext.semisupervised.confidence.regression.RForestProximities;
import si.ijs.kt.clus.ext.semisupervised.confidence.regression.VarianceScore;
import si.ijs.kt.clus.ext.semisupervised.utils.DoublesPair;
import si.ijs.kt.clus.ext.semisupervised.utils.IndiceValuePair;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsHMLC;
import si.ijs.kt.clus.main.settings.section.SettingsSSL;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.WHTDStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;

public class ClusSelfTrainingInduce
extends ClusSemiSupervisedInduce {
    ClusInductionAlgorithm m_Induce;
    PredictionConfidence m_PredConfidence;
    double m_Threshold;
    SettingsSSL.SSLStoppingCriteria m_StoppingCriteria;
    int m_K;
    int m_Iterations;
    int m_maxAirbagTrials;
    SettingsSSL.SSLAggregation m_Aggregation;
    SettingsSSL.SSLNormalization m_Normalization;
    SettingsSSL.SSLOOBErrorCalculation m_OOBErrorCalculation;
    SettingsSSL.SSLUnlabeledCriteria m_UnlabeledCriteria;
    boolean m_UseWeights;
    double[] m_ExhaustiveSearchThresholds;
    double HMCthreshold = 0.0;

    public ClusSelfTrainingInduce(ClusSchema schema, Settings sett, ClusInductionAlgorithm clss_induce) throws ClusException, IOException {
        super(schema, sett);
        this.m_Induce = clss_induce;
        this.initialize(this.getSchema(), this.getSettings());
        block0 : switch (this.m_StatManager.getTargetMode()) {
            case REGRESSION: {
                switch (sett.getSSL().getConfidenceMeasure()) {
                    case RandomUniform: {
                        this.m_PredConfidence = new RandomScore(this.m_StatManager, RandomScore.RANDOM_UNIFORM);
                        break block0;
                    }
                    case RandomGaussian: {
                        this.m_PredConfidence = new RandomScore(this.m_StatManager, RandomScore.RANDOM_GAUSSIAN);
                        break block0;
                    }
                    case Oracle: {
                        this.m_PredConfidence = new OracleScore(this.m_StatManager, this.m_Normalization, this.m_Aggregation);
                        break block0;
                    }
                    case Variance: {
                        this.m_PredConfidence = new VarianceScore(this.m_StatManager, this.m_Normalization, this.m_Aggregation);
                        break block0;
                    }
                    case RForestProximities: {
                        this.m_PredConfidence = new RForestProximities(this.m_StatManager, this.m_Normalization, this.m_Aggregation);
                        break block0;
                    }
                }
                this.m_PredConfidence = new VarianceScore(this.m_StatManager, this.m_Normalization, this.m_Aggregation);
                break;
            }
            case HIERARCHICAL: {
                switch (sett.getSSL().getConfidenceMeasure()) {
                    case ClassesProbabilities: {
                        if (this.m_Aggregation.equals((Object)SettingsSSL.SSLAggregation.Average)) {
                            this.m_Aggregation = SettingsSSL.SSLAggregation.AverageIgnoreZeros;
                        }
                        this.m_PredConfidence = new VarianceScore(this.m_StatManager, this.m_Normalization, this.m_Aggregation);
                        break block0;
                    }
                    case Oracle: {
                        this.m_PredConfidence = new OracleScore(this.m_StatManager, this.m_Normalization, this.m_Aggregation);
                        break block0;
                    }
                    case RandomUniform: {
                        this.m_PredConfidence = new RandomScore(this.m_StatManager, RandomScore.RANDOM_UNIFORM);
                        break block0;
                    }
                    case RandomGaussian: {
                        this.m_PredConfidence = new RandomScore(this.m_StatManager, RandomScore.RANDOM_GAUSSIAN);
                        break block0;
                    }
                }
                this.m_PredConfidence = new VarianceScore(this.m_StatManager, this.m_Normalization, SettingsSSL.SSLAggregation.AverageIgnoreZeros);
                break;
            }
            case CLASSIFY: {
                switch (sett.getSSL().getConfidenceMeasure()) {
                    case ClassesProbabilities: {
                        this.m_PredConfidence = new ClassesProbabilities(this.m_StatManager, this.m_Normalization, this.m_Aggregation);
                        break block0;
                    }
                    case Oracle: {
                        this.m_PredConfidence = new OracleScore(this.m_StatManager, this.m_Normalization, this.m_Aggregation);
                        break block0;
                    }
                    case RandomUniform: {
                        this.m_PredConfidence = new RandomScore(this.m_StatManager, RandomScore.RANDOM_UNIFORM);
                        break block0;
                    }
                    case RandomGaussian: {
                        this.m_PredConfidence = new RandomScore(this.m_StatManager, RandomScore.RANDOM_GAUSSIAN);
                        break block0;
                    }
                }
                this.m_PredConfidence = new ClassesProbabilities(this.m_StatManager, this.m_Normalization, this.m_Aggregation);
                break;
            }
            default: {
                throw new ClusException("Mode not yet supported, for now you can do SSL for multi-target regression, classification and HMC");
            }
        }
    }

    public void initialize(ClusSchema schema, Settings settx) {
        SettingsSSL sett = settx.getSSL();
        this.m_UnlabeledCriteria = sett.getUnlabeledCriteria();
        this.m_StoppingCriteria = sett.getStoppingCriteria();
        this.m_Threshold = sett.getConfidenceThreshold();
        this.m_K = sett.getK();
        this.m_Iterations = sett.getIterations();
        this.m_PercentageLabeled = (double)sett.getPercentageLabeled() / 100.0;
        this.m_UseWeights = sett.getUseWeights();
        this.m_maxAirbagTrials = sett.getAirbagTrails();
        this.m_ExhaustiveSearchThresholds = sett.getExhaustiveSearchThresholds();
        this.m_OOBErrorCalculation = sett.getOOBErrorCalculation();
        this.m_Normalization = sett.getSSLNormalization();
        this.m_Aggregation = sett.getSSLAggregation();
    }

    @Override
    public ClusModel induceSingleUnpruned(ClusRun cr) throws Exception {
        this.partitionData(cr);
        int origLabeledMax = this.m_TrainingSet.getNbRows();
        int nb_unlabeled = this.m_UnlabeledData.getNbRows();
        int unlabeledAdded = 1;
        int unlabeledAddeddTotal = 0;
        int iterations = 0;
        int airBagTrials = 0;
        boolean first = true;
        double OOBError = Double.MAX_VALUE;
        double originalError = 0.0;
        double labelCardinalityTrainHMC = 0.0;
        PrintWriter writer = null;
        String errorType = "";
        switch (this.m_StatManager.getTargetMode()) {
            case HIERARCHICAL: {
                errorType = "AUPRC";
                break;
            }
            case REGRESSION: {
                errorType = "RMSE";
                break;
            }
            case CLASSIFY: {
                errorType = "Accuracy";
                break;
            }
            default: {
                errorType = "RMSE";
            }
        }
        ClusRun myClusRun = new ClusRun(cr);
        ClusModel oldModel = null;
        if (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.HIERARCHICAL || this.m_StatManager.getTargetMode() == ClusStatManager.Mode.CLASSIFY) {
            OOBError = Double.MIN_VALUE;
        }
        if (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.HIERARCHICAL) {
            for (int i = 0; i < this.m_TrainingSet.getNbRows(); ++i) {
                DataTuple t = this.m_TrainingSet.getTuple(i);
                labelCardinalityTrainHMC += (double)((ClassesTuple)t.getObjVal(0)).getNbClasses();
            }
            labelCardinalityTrainHMC /= (double)this.m_TrainingSet.getNbRows();
        }
        if (cr.getStatManager().getSettings().getSSL().getConfidenceMeasure().equals((Object)SettingsSSL.SSLConfidenceMeasure.RForestProximities)) {
            ((RForestProximities)this.m_PredConfidence).setTrainingSet(this.m_TrainingSet, origLabeledMax);
        }
        while (!(unlabeledAdded <= 0 || this.m_StoppingCriteria.equals((Object)SettingsSSL.SSLStoppingCriteria.Iterations) && iterations >= this.m_Iterations)) {
            int i;
            unlabeledAdded = 0;
            ClusLogger.info();
            ClusLogger.info("SelfTraining iteration: " + ++iterations);
            ClusLogger.info();
            if (this.getSettings().getEnsemble().shouldEstimateOOB()) {
                ((ClusEnsembleInduce)this.m_Induce).resetClusOOBErrorEstimate();
            }
            if (!this.m_UnlabeledCriteria.equals((Object)SettingsSSL.SSLUnlabeledCriteria.ExhaustiveSearch) || first) {
                this.m_Model = this.m_Induce.induceSingleUnpruned(myClusRun);
            }
            if (first) {
                first = false;
                ClusModelInfo defInfo = cr.addModelInfo(0);
                defInfo.setModel(this.m_Model);
                originalError = this.calculateError(cr.getTestSet()).getModelError();
                writer = new PrintWriter(cr.getStatManager().getSettings().getGeneric().getAppName() + "_SelfTrainingErrors.csv", "UTF-8");
                writer.println("Iteration,Threshold,examplesAdded,examplesAddedTotal," + errorType + "SSL," + errorType + "Supervised," + errorType + "OOBLabeled," + errorType + "OOBTrainingSet," + errorType + "TrainingSet");
            }
            if (this.m_StoppingCriteria.equals((Object)SettingsSSL.SSLStoppingCriteria.Airbag)) {
                double newOOBError = this.getOOBError(this.m_TrainingSet, origLabeledMax).getModelError();
                if (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.CLASSIFY && newOOBError < OOBError || this.m_StatManager.getTargetMode() == ClusStatManager.Mode.HIERARCHICAL && newOOBError < OOBError || this.m_StatManager.getTargetMode() == ClusStatManager.Mode.REGRESSION && newOOBError > OOBError) {
                    if (++airBagTrials > this.m_maxAirbagTrials) {
                        this.m_Model = oldModel;
                        ClusLogger.info("Stopping because of airbag.");
                        break;
                    }
                } else {
                    OOBError = newOOBError;
                    oldModel = this.m_Model;
                    airBagTrials = 0;
                }
            }
            if (this.m_UnlabeledCriteria.equals((Object)SettingsSSL.SSLUnlabeledCriteria.AutomaticOOB) || this.m_UnlabeledCriteria.equals((Object)SettingsSSL.SSLUnlabeledCriteria.AutomaticOOBInitial)) {
                double[] OOBErrors;
                Object[] confidencesOOBErrors;
                int maxInd;
                this.m_PredConfidence.calculateOOBConfidenceScores((ClusForest)this.m_Model, this.m_TrainingSet);
                switch (this.m_OOBErrorCalculation) {
                    case LabeledOnly: {
                        maxInd = origLabeledMax;
                        confidencesOOBErrors = new DoublesPair[origLabeledMax];
                        OOBErrors = new double[origLabeledMax];
                        break;
                    }
                    case AllData: {
                        maxInd = this.m_TrainingSet.getNbRows();
                        confidencesOOBErrors = new DoublesPair[this.m_PredConfidence.getCounter()];
                        OOBErrors = new double[this.m_PredConfidence.getCounter()];
                        break;
                    }
                    default: {
                        maxInd = origLabeledMax;
                        confidencesOOBErrors = new DoublesPair[origLabeledMax];
                        OOBErrors = new double[origLabeledMax];
                    }
                }
                int j = 0;
                for (int i2 = 0; i2 < maxInd; ++i2) {
                    ClusErrorList errListOOB = new ClusErrorList();
                    ClusError error = null;
                    if (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.HIERARCHICAL) {
                        error = new HierErrorMeasures(errListOOB, this.m_StatManager.getHier(), this.m_StatManager.getSettings().getHMLC().getRecallValues().getDoubleVector(), SettingsHMLC.HierarchyMeasures.PooledAUPRC, this.m_StatManager.getSettings().getOutput().isWriteCurves(), this.m_StatManager.getSettings().getOutput().isGzipOutput());
                    }
                    if (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.REGRESSION) {
                        error = new RMSError(errListOOB, this.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.Target));
                    }
                    if (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.CLASSIFY) {
                        error = new Accuracy(errListOOB, this.getSchema().getNominalAttrUse(ClusAttrType.AttributeUseType.Target));
                    }
                    errListOOB.addError(error);
                    if (Double.isNaN(this.m_PredConfidence.getConfidence(i2))) continue;
                    errListOOB.addExample(this.m_TrainingSet.getTuple(i2), ((ClusForest)this.m_Model).predictWeightedOOB(this.m_TrainingSet.getTuple(i2)));
                    DoublesPair dPair = new DoublesPair(this.m_PredConfidence.getConfidence(i2), error.getModelError());
                    confidencesOOBErrors[j] = dPair;
                    ++j;
                }
                ClusLogger.info(this.m_PredConfidence.getCounter());
                Arrays.sort(confidencesOOBErrors);
                OOBErrors = Helper.getArrayOfSecond((DoublesPair[])confidencesOOBErrors);
                TTest tTest = new TTest();
                boolean thresholdFound = false;
                double confidenceLevel = 0.05;
                for (int i3 = OOBErrors.length - 1; i3 > 1; --i3) {
                    while (i3 > 2 && ((DoublesPair)confidencesOOBErrors[i3]).getFirst() == ((DoublesPair)confidencesOOBErrors[i3 - 1]).getFirst()) {
                        --i3;
                    }
                    double pValue = tTest.tTest(OOBErrors, Arrays.copyOfRange(OOBErrors, 0, i3));
                    if (!(pValue < confidenceLevel)) continue;
                    ClusLogger.info("AutomaticOOB: found threshold: " + ((DoublesPair)confidencesOOBErrors[i3]).getFirst() + " (p-value = " + pValue + ")");
                    this.m_Threshold = ((DoublesPair)confidencesOOBErrors[i3]).getFirst();
                    thresholdFound = true;
                    break;
                }
                if (!thresholdFound) {
                    ClusLogger.info("AutomaticOOB: threshold not found, using 0.0");
                    this.m_Threshold = 0.0;
                }
                if (this.m_UnlabeledCriteria.equals((Object)SettingsSSL.SSLUnlabeledCriteria.AutomaticOOBInitial)) {
                    this.m_UnlabeledCriteria = SettingsSSL.SSLUnlabeledCriteria.Threshold;
                }
            }
            if (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.HIERARCHICAL) {
                if (cr.getStatManager().getSettings().getSSL().shouldCalibrateHmcThreshold()) {
                    calibrateByLabelCardinality thCalib = new calibrateByLabelCardinality(5.0, labelCardinalityTrainHMC);
                    for (int i4 = 0; i4 < nb_unlabeled; ++i4) {
                        DataTuple tuple = this.m_UnlabeledData.getTuple(i4);
                        if (tuple == null || !(tuple.getWeight() > 0.0)) continue;
                        thCalib.addExample((WHTDStatistic)this.m_Model.predictWeighted(this.m_UnlabeledData.getTuple(i4)));
                    }
                    this.HMCthreshold = thCalib.getThreshold();
                } else {
                    this.HMCthreshold = 50.0;
                }
                if (this.m_StatManager.getSettings().getSSL().getConfidenceMeasure().equals((Object)SettingsSSL.SSLConfidenceMeasure.Oracle)) {
                    ((OracleScore)this.m_PredConfidence).setHmcThreshold(this.HMCthreshold);
                }
            }
            this.m_PredConfidence.calculateConfidenceScores(this.m_Model, this.m_UnlabeledData);
            ArrayList<DataTuple> unlabeledForTrain = new ArrayList<DataTuple>();
            if (this.m_UnlabeledCriteria.equals((Object)SettingsSSL.SSLUnlabeledCriteria.KPercentageMostAverage)) {
                IndiceValuePair[] topK = Helper.greatestKelements(this.m_PredConfidence.getConfidenceScores(), (int)((double)(nb_unlabeled - unlabeledAddeddTotal) * ((double)this.m_K / 100.0)));
                double threshold = 0.0;
                for (int i5 = 0; i5 < topK.length; ++i5) {
                    threshold += topK[i5].getValue();
                }
                this.m_Threshold = threshold / (double)topK.length;
                this.m_UnlabeledCriteria = SettingsSSL.SSLUnlabeledCriteria.Threshold;
                ClusLogger.info("Threshold selected: " + this.m_Threshold);
            }
            if (this.m_UnlabeledCriteria.equals((Object)SettingsSSL.SSLUnlabeledCriteria.Threshold) || this.m_UnlabeledCriteria.equals((Object)SettingsSSL.SSLUnlabeledCriteria.AutomaticOOB)) {
                for (int i6 = 0; i6 < nb_unlabeled; ++i6) {
                    if (!(this.m_PredConfidence.getConfidence(i6) >= this.m_Threshold)) continue;
                    DataTuple t = this.m_UnlabeledData.getTuple(i6).deepCloneTuple();
                    this.processUnlabeledExample(t, i6);
                    unlabeledForTrain.add(t);
                    ++unlabeledAdded;
                }
            }
            if (this.m_UnlabeledCriteria.equals((Object)SettingsSSL.SSLUnlabeledCriteria.KMostConfident)) {
                IndiceValuePair[] topK = Helper.greatestKelements(this.m_PredConfidence.getConfidenceScores(), this.m_K);
                for (i = 0; i < topK.length; ++i) {
                    int index = topK[i].getIndice();
                    DataTuple t = this.m_UnlabeledData.getTuple(index).deepCloneTuple();
                    this.processUnlabeledExample(t, index);
                    unlabeledForTrain.add(t);
                    ++unlabeledAdded;
                }
            }
            if (this.m_UnlabeledCriteria.equals((Object)SettingsSSL.SSLUnlabeledCriteria.KPercentageMostConfident)) {
                IndiceValuePair[] topK = Helper.greatestKelements(this.m_PredConfidence.getConfidenceScores(), (int)((double)nb_unlabeled * ((double)this.m_K / 100.0)));
                for (i = 0; i < topK.length; ++i) {
                    int index = topK[i].getIndice();
                    DataTuple t = this.m_UnlabeledData.getTuple(index).deepCloneTuple();
                    this.processUnlabeledExample(t, index);
                    unlabeledForTrain.add(t);
                    ++unlabeledAdded;
                }
            }
            if (this.m_UnlabeledCriteria.equals((Object)SettingsSSL.SSLUnlabeledCriteria.ExhaustiveSearch)) {
                Boolean betterFound;
                Boolean firstIteration = true;
                ClusModel bestModel = this.m_Model;
                double bestOOB = Double.NaN;
                Arrays.sort(this.m_ExhaustiveSearchThresholds);
                Collections.reverse(Doubles.asList(this.m_ExhaustiveSearchThresholds));
                do {
                    betterFound = false;
                    RowData bestTrainingSet = this.m_TrainingSet.shallowCloneData();
                    double bestThreshold = 0.0;
                    if (firstIteration.booleanValue()) {
                        bestOOB = this.getOOBError(this.m_TrainingSet, origLabeledMax).getModelError();
                        firstIteration = false;
                    }
                    int bestUnlabeledAdded = 0;
                    int i7 = 0;
                    int best_i = 0;
                    IndiceValuePair[] confidenceScoresSorted = new IndiceValuePair[nb_unlabeled];
                    for (int j = 0; j < nb_unlabeled; ++j) {
                        confidenceScoresSorted[j] = new IndiceValuePair(j, this.m_PredConfidence.getConfidence(j));
                    }
                    Arrays.sort(confidenceScoresSorted, Collections.reverseOrder());
                    unlabeledAdded = 0;
                    double conf = confidenceScoresSorted[0].getValue();
                    ClusLogger.info("Started exhaustive search (current OOBError = " + bestOOB + ")");
                    ClusLogger.info();
                    for (double threshold : this.m_ExhaustiveSearchThresholds) {
                        ClusError errOOB;
                        int examplesAddedPerThreshold = 0;
                        while (conf >= threshold && i7 < nb_unlabeled) {
                            DataTuple t = this.m_UnlabeledData.getTuple(confidenceScoresSorted[i7].getIndice());
                            ClusStatistic stat = this.m_Model.predictWeighted(t);
                            stat.computePrediction();
                            stat.predictTuple(t);
                            this.m_TrainingSet.add(t);
                            ++examplesAddedPerThreshold;
                            if (++i7 >= nb_unlabeled) continue;
                            conf = confidenceScoresSorted[i7].getValue();
                        }
                        if (examplesAddedPerThreshold <= 0) continue;
                        ((ClusEnsembleInduce)this.m_Induce).resetClusOOBErrorEstimate();
                        this.m_Model = this.m_Induce.induceSingleUnpruned(myClusRun);
                        unlabeledAdded += examplesAddedPerThreshold;
                        switch (this.m_OOBErrorCalculation) {
                            case LabeledOnly: {
                                errOOB = this.getOOBError(this.m_TrainingSet, origLabeledMax);
                                break;
                            }
                            case AllData: {
                                errOOB = this.getOOBError(this.m_TrainingSet, this.m_TrainingSet.getNbRows());
                                break;
                            }
                            default: {
                                errOOB = this.getOOBError(this.m_TrainingSet, origLabeledMax);
                            }
                        }
                        OOBError = errOOB.getModelError();
                        ClusLogger.info("Trying threshold: " + threshold);
                        ClusLogger.info("OOBError: " + OOBError);
                        ClusLogger.info("Examples added: " + unlabeledAdded);
                        ClusLogger.info("Training set size: " + this.m_TrainingSet.getNbRows());
                        ClusLogger.info();
                        if (OOBError < bestOOB) {
                            bestOOB = OOBError;
                            bestModel = this.m_Model;
                            betterFound = true;
                            best_i = i7;
                            bestThreshold = threshold;
                            bestUnlabeledAdded = unlabeledAdded;
                            bestTrainingSet = this.m_TrainingSet.shallowCloneData();
                        }
                        ClusLogger.info("Th: " + threshold + " BtSize: " + bestTrainingSet.getNbRows());
                    }
                    this.m_TrainingSet = bestTrainingSet;
                    myClusRun.setTrainingSet(this.m_TrainingSet);
                    unlabeledAdded = bestUnlabeledAdded;
                    if (betterFound.booleanValue()) {
                        ClusLogger.info("Found threshold: " + bestThreshold + " (new OOBError = " + bestOOB + ")");
                        this.m_Model = bestModel;
                        for (int j = 0; j < best_i; ++j) {
                            this.m_UnlabeledData.setTuple(null, confidenceScoresSorted[j].getIndice());
                        }
                        this.m_PredConfidence.calculateConfidenceScores(this.m_Model, this.m_UnlabeledData);
                        writer.println(++iterations + "," + bestThreshold + "," + unlabeledAdded + "," + (unlabeledAddeddTotal += unlabeledAdded) + "," + this.calculateError(cr.getTestSet()).getModelError() + "," + originalError + "," + this.getOOBError(this.m_TrainingSet, origLabeledMax).getModelError() + "," + this.getOOBError(this.m_TrainingSet, this.m_TrainingSet.getNbRows()).getModelError() + "," + this.calculateError(this.m_TrainingSet).getModelError());
                        writer.flush();
                        continue;
                    }
                    ClusLogger.info("Threshold not found");
                } while (betterFound.booleanValue());
            }
            unlabeledAddeddTotal += unlabeledAdded;
            for (DataTuple dataTuple : unlabeledForTrain) {
                this.m_TrainingSet.add(dataTuple);
            }
            ClusLogger.info("Unlabeled added: " + unlabeledAdded);
            writer.println(iterations + "," + this.m_Threshold + "," + unlabeledAdded + "," + unlabeledAddeddTotal + "," + this.calculateError(cr.getTestSet()).getModelError() + "," + originalError + "," + this.getOOBError(this.m_TrainingSet, origLabeledMax).getModelError() + "," + this.getOOBError(this.m_TrainingSet, this.m_TrainingSet.getNbRows()).getModelError() + "," + this.calculateError(this.m_TrainingSet).getModelError());
            writer.flush();
        }
        writer.close();
        ClusLogger.info();
        ClusLogger.info("Total self-training iterations performed: " + iterations);
        ClusLogger.info("Unlabeled examples added: " + unlabeledAddeddTotal);
        ClusLogger.info();
        ClusModelInfo origInfo = cr.addModelInfo(1);
        String additionalInfo = "Semi-supervised Self-training\n\t Iterations performed = " + iterations + "\n\t Unlabeled examples added: " + unlabeledAddeddTotal + "\n\t Base model: ";
        ((ClusForest)this.m_Model).setModelInfo(additionalInfo);
        origInfo.setModel(this.m_Model);
        return this.m_Model;
    }

    private void processUnlabeledExample(DataTuple t, int index) throws ClusException, InterruptedException {
        ClusStatistic stat = this.m_Model.predictWeighted(t);
        if (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.HIERARCHICAL) {
            ((WHTDStatistic)stat).setThreshold(this.HMCthreshold);
        }
        stat.computePrediction();
        stat.predictTuple(t);
        this.m_UnlabeledData.setTuple(null, index);
        if (this.m_UseWeights) {
            t.setWeight(t.getWeight() * this.m_PredConfidence.getConfidence(index));
        }
    }

    @Override
    public void initialize() throws ClusException, IOException {
        this.m_Induce.initialize();
    }

    @Override
    public ClusSchema getSchema() {
        return this.m_Induce.getSchema();
    }

    @Override
    public ClusStatManager getStatManager() {
        return this.m_Induce.getStatManager();
    }

    @Override
    public Settings getSettings() {
        return this.getStatManager().getSettings();
    }

    @Override
    public void getPreprocs(DataPreprocs pps) {
        this.getStatManager().getPreprocs(pps);
    }

    @Override
    public void initializeHeuristic() {
        this.m_Induce.initializeHeuristic();
    }
}

