/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.optxval;

import java.io.IOException;
import si.ijs.kt.clus.Clus;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.algo.split.NArySplit;
import si.ijs.kt.clus.algo.split.NominalSplit;
import si.ijs.kt.clus.algo.split.SubsetSplit;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.algo.tdidt.DepthFirstInduce;
import si.ijs.kt.clus.data.ClusData;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.error.common.multiscore.MultiScore;
import si.ijs.kt.clus.ext.optxval.OptXValGroup;
import si.ijs.kt.clus.ext.optxval.OptXValNode;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStat;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public abstract class OptXValInduce
extends ClusInductionAlgorithm {
    protected ClusHeuristic m_Heuristic;
    protected DepthFirstInduce m_DFirst;
    protected NominalSplit m_Split;
    protected ClusStatistic[] m_PosStat;
    protected ClusStatistic[][] m_TestStat;
    protected ClusStatistic m_Scratch;
    protected int m_NbFolds;
    protected int[] m_PrevCl;
    protected double[] m_PrevVl;
    protected CurrentBestTestAndHeuristic[] m_Selector;
    protected int m_MaxStats;

    public OptXValInduce(ClusSchema schema, Settings sett) throws ClusException, IOException {
        super(schema, sett);
    }

    public final void findNominal(NominalAttrType at, OptXValGroup grp) throws ClusException {
        int nbvalues = at.getNbValues();
        int statsize = nbvalues + at.intHasMissing();
        this.reset(statsize);
        if (Clus.isDebug()) {
            ClusStat.deltaSplit();
        }
        RowData data = grp.getData();
        int nb_rows = data.getNbRows();
        for (int i = 0; i < nb_rows; ++i) {
            DataTuple tuple = data.getTuple(i);
            int value = at.getNominal(tuple);
            if (Clus.isDebug()) {
                ClusStat.deltaTest();
            }
            this.m_TestStat[tuple.m_Index][value].updateWeighted(tuple, i);
            if (!Clus.isDebug()) continue;
            ClusStat.deltaStat();
        }
        this.sumStats(statsize);
        if (Clus.isDebug()) {
            ClusStat.deltaStat();
        }
        int nb = grp.getNbFolds();
        for (int i = 0; i < nb; ++i) {
            int foldnr = grp.getFold(i);
            if (foldnr != 0) {
                ClusStatistic[] zero_stat = this.m_TestStat[0];
                ClusStatistic[] cr_stat = this.m_TestStat[foldnr];
                for (int j = 0; j < statsize; ++j) {
                    cr_stat[j].subtractFromOther(zero_stat[j]);
                }
            }
            if (Clus.isDebug()) {
                ClusStat.deltaStat();
            }
            this.m_Split.findSplit(this.m_Selector[i], at);
            if (!Clus.isDebug()) continue;
            ClusStat.deltaHeur();
        }
    }

    public final void findNumeric(NumericAttrType at, OptXValGroup grp) throws ClusException {
        DataTuple tuple;
        RowData data = grp.getData();
        int idx = at.getArrayIndex();
        if (Clus.isDebug()) {
            ClusStat.deltaSplit();
        }
        data.sort(at);
        if (Clus.isDebug()) {
            ClusStat.deltaSort();
        }
        this.reset(2);
        int nb_rows = data.getNbRows();
        if (at.hasMissing()) {
            for (int first = 0; first < nb_rows && (tuple = data.getTuple(first)).hasNumMissing(idx); ++first) {
                this.m_TestStat[tuple.m_Index][1].updateWeighted(tuple, first);
            }
            this.subtractMissing(grp);
        } else {
            this.copyTotal(grp);
        }
        if (Clus.isDebug()) {
            ClusStat.deltaStat();
        }
        int[] folds = grp.getFolds();
        for (int i = 0; i < folds.length; ++i) {
            this.m_PrevCl[i] = -1;
            this.m_PrevVl[i] = Double.NaN;
        }
        ClusStatistic sum = this.m_PosStat[0];
        this.getSettings().getTree();
        if (SettingsTree.ONE_NOMINAL) {
            for (int i = first; i < nb_rows; ++i) {
                tuple = data.getTuple(i);
                boolean no_sum_calc = true;
                int foldnr = tuple.getIndex();
                int crcl = tuple.getClassification();
                double value = tuple.getDoubleVal(idx);
                for (int j = 0; j < folds.length; ++j) {
                    int cr_fold = folds[j];
                    if (foldnr == cr_fold) continue;
                    if (this.m_PrevCl[j] == -1 && value != this.m_PrevVl[j] && !Double.isNaN(this.m_PrevVl[j])) {
                        if (no_sum_calc) {
                            if (Clus.isDebug()) {
                                ClusStat.deltaTest();
                            }
                            sum.reset();
                            for (int k = 1; k <= this.m_NbFolds; ++k) {
                                sum.add(this.m_PosStat[k]);
                            }
                            no_sum_calc = false;
                            if (Clus.isDebug()) {
                                ClusStat.deltaStat();
                            }
                        }
                        if (cr_fold != 0) {
                            if (Clus.isDebug()) {
                                ClusStat.deltaTest();
                            }
                            this.m_Scratch.copy(sum);
                            this.m_Scratch.subtractFromThis(this.m_PosStat[cr_fold]);
                            if (Clus.isDebug()) {
                                ClusStat.deltaStat();
                            }
                            this.m_Selector[j].updateNumeric(value, this.m_Scratch, at);
                            if (Clus.isDebug()) {
                                ClusStat.deltaHeur();
                            }
                        } else {
                            if (Clus.isDebug()) {
                                ClusStat.deltaTest();
                            }
                            this.m_Selector[j].updateNumeric(value, sum, at);
                            if (Clus.isDebug()) {
                                ClusStat.deltaHeur();
                            }
                        }
                        this.m_PrevCl[j] = crcl;
                    } else if (this.m_PrevCl[j] != crcl) {
                        this.m_PrevCl[j] = -1;
                    }
                    this.m_PrevVl[j] = value;
                }
                if (Clus.isDebug()) {
                    ClusStat.deltaTest();
                }
                this.m_PosStat[foldnr].updateWeighted(tuple, i);
                if (!Clus.isDebug()) continue;
                ClusStat.deltaStat();
            }
        } else {
            for (int i = first; i < nb_rows; ++i) {
                tuple = data.getTuple(i);
                boolean no_sum_calc = true;
                int foldnr = tuple.getIndex();
                double value = tuple.getDoubleVal(idx);
                for (int j = 0; j < folds.length; ++j) {
                    int cr_fold = folds[j];
                    if (foldnr == cr_fold) continue;
                    if (value != this.m_PrevVl[j] && !Double.isNaN(this.m_PrevVl[j])) {
                        if (no_sum_calc) {
                            if (Clus.isDebug()) {
                                ClusStat.deltaTest();
                            }
                            sum.reset();
                            for (int k = 1; k <= this.m_NbFolds; ++k) {
                                sum.add(this.m_PosStat[k]);
                            }
                            no_sum_calc = false;
                            if (Clus.isDebug()) {
                                ClusStat.deltaStat();
                            }
                        }
                        if (cr_fold != 0) {
                            if (Clus.isDebug()) {
                                ClusStat.deltaTest();
                            }
                            this.m_Scratch.copy(sum);
                            this.m_Scratch.subtractFromThis(this.m_PosStat[cr_fold]);
                            if (Clus.isDebug()) {
                                ClusStat.deltaStat();
                            }
                            this.m_Selector[j].updateNumeric(value, this.m_Scratch, at);
                            if (Clus.isDebug()) {
                                ClusStat.deltaHeur();
                            }
                        } else {
                            if (Clus.isDebug()) {
                                ClusStat.deltaTest();
                            }
                            this.m_Selector[j].updateNumeric(value, sum, at);
                            if (Clus.isDebug()) {
                                ClusStat.deltaHeur();
                            }
                        }
                    }
                    this.m_PrevVl[j] = value;
                }
                if (Clus.isDebug()) {
                    ClusStat.deltaTest();
                }
                this.m_PosStat[foldnr].updateWeighted(tuple, i);
                if (!Clus.isDebug()) continue;
                ClusStat.deltaStat();
            }
        }
    }

    public abstract OptXValNode xvalInduce(OptXValGroup var1) throws ClusException, Exception;

    @Override
    public ClusData createData() {
        return new RowData(this.m_Schema);
    }

    public final void reset(int nb) {
        for (int i = 0; i <= this.m_NbFolds; ++i) {
            for (int j = 0; j < nb; ++j) {
                this.m_TestStat[i][j].reset();
            }
        }
    }

    public final void sumStats(int nb) {
        for (int j = 0; j < nb; ++j) {
            ClusStatistic sum = this.m_TestStat[0][j];
            for (int i = 1; i <= this.m_NbFolds; ++i) {
                sum.add(this.m_TestStat[i][j]);
            }
        }
    }

    public final void subtractMissing(OptXValGroup grp) {
        ClusStatistic sum = this.m_TestStat[0][1];
        for (int i = 1; i <= this.m_NbFolds; ++i) {
            sum.add(this.m_TestStat[i][1]);
        }
        ClusStatistic[] stot = grp.m_TotStat;
        for (int i = 0; i <= this.m_NbFolds; ++i) {
            this.m_TestStat[i][1].subtractFromOther(stot[i]);
        }
    }

    public final void copyTotal(OptXValGroup grp) {
        ClusStatistic[] stot = grp.m_TotStat;
        for (int i = 0; i <= this.m_NbFolds; ++i) {
            this.m_TestStat[i][1].copy(stot[i]);
        }
    }

    public final void findBestTest(OptXValGroup mgrp) throws ClusException {
        mgrp.makeNodes();
        RowData data = mgrp.getData();
        ClusSchema schema = data.getSchema();
        for (ClusAttrType at : schema.getDescriptiveAttributes()) {
            if (at instanceof NominalAttrType) {
                this.findNominal((NominalAttrType)at, mgrp);
                continue;
            }
            this.findNumeric((NumericAttrType)at, mgrp);
        }
    }

    public final CurrentBestTestAndHeuristic getSelector(int i) {
        return this.m_Selector[i];
    }

    public final void cleanSplit() {
        this.m_Split = null;
    }

    public final void createStats() {
        int mfolds = this.m_NbFolds + 1;
        this.m_Heuristic = this.m_StatManager.getHeuristic();
        this.m_PosStat = new ClusStatistic[mfolds];
        this.m_TestStat = new ClusStatistic[mfolds][this.m_MaxStats];
        this.m_Selector = new CurrentBestTestAndHeuristic[mfolds];
        for (int i = 0; i < mfolds; ++i) {
            for (int j = 0; j < this.m_MaxStats; ++j) {
                this.m_TestStat[i][j] = this.m_StatManager.createClusteringStat();
            }
            this.m_PosStat[i] = this.m_TestStat[i][0];
            CurrentBestTestAndHeuristic sel = this.m_Selector[i] = new CurrentBestTestAndHeuristic(this.getSettings());
            sel.m_Heuristic = this.m_Heuristic;
        }
        CurrentBestTestAndHeuristic sel = this.m_DFirst.getBestTest();
        sel.m_Heuristic = this.m_Heuristic;
        sel.m_TestStat = this.m_TestStat[0];
        sel.m_PosStat = this.m_PosStat[0];
    }

    public final void initTestSelectors(OptXValGroup grp) {
        int nb = grp.getNbFolds();
        for (int i = 0; i < nb; ++i) {
            int fold = grp.getFold(i);
            CurrentBestTestAndHeuristic sel = this.m_Selector[i];
            sel.m_TestStat = this.m_TestStat[fold];
            sel.m_PosStat = this.m_PosStat[fold];
            sel.initTestSelector(grp.getTotStat(fold));
        }
    }

    public final void setNbFolds(int folds) {
        this.m_NbFolds = folds;
        this.m_PrevCl = new int[folds + 1];
        this.m_PrevVl = new double[folds + 1];
    }

    public final void initialize(int folds) {
        this.m_Split = this.getSettings().getTree().isBinarySplit() ? new SubsetSplit() : new NArySplit();
        this.m_DFirst = new DepthFirstInduce((ClusInductionAlgorithm)this, this.m_Split);
        this.setNbFolds(folds);
        if (this.m_Schema.getNbNumericDescriptiveAttributes() > 0) {
            this.m_MaxStats = Math.max(this.m_MaxStats, 3);
        }
    }

    public final OptXValNode optXVal(RowData data) throws Exception {
        if (Clus.isDebug()) {
            ClusStat.initTime();
        }
        this.createStats();
        this.m_Split.initialize(this.m_StatManager);
        this.m_Scratch = this.m_StatManager.createClusteringStat();
        OptXValGroup grp = new OptXValGroup(data, this.m_NbFolds + 1);
        grp.initializeFolds();
        grp.create(this.m_StatManager, this.m_NbFolds);
        grp.calcTotalStats();
        return this.xvalInduce(grp);
    }

    public ClusNode induce(ClusRun cr, MultiScore score) {
        return null;
    }

    @Override
    public ClusModel induceSingleUnpruned(ClusRun cr) {
        return null;
    }
}

