/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.optxval;

import java.io.IOException;
import si.ijs.kt.clus.Clus;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.ext.optxval.OptXValGroup;
import si.ijs.kt.clus.ext.optxval.OptXValInduce;
import si.ijs.kt.clus.ext.optxval.OptXValNode;
import si.ijs.kt.clus.ext.optxval.OptXValSplit;
import si.ijs.kt.clus.main.ClusStat;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.util.ResourceInfo;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.list.MyListIter;

public class OptXValIndNO
extends OptXValInduce {
    public OptXValIndNO(ClusSchema schema, Settings sett) throws ClusException, IOException {
        super(schema, sett);
    }

    public final int mkNewGroups(OptXValGroup mgrp, MyListIter ngrps) {
        int nb_groups = 0;
        int nb = mgrp.getNbFolds();
        for (int i = 0; i < nb; ++i) {
            ClusNode fnode = mgrp.getNode(i);
            if (fnode == null) continue;
            NodeTest mtest = fnode.m_Test;
            int gsize = 0;
            for (int j = i + 1; j < nb; ++j) {
                ClusNode onode = mgrp.getNode(j);
                if (onode == null || !mtest.equals(onode.m_Test)) continue;
                ++gsize;
            }
            int gidx = 1;
            OptXValGroup ngrp = new OptXValGroup(mgrp.getData(), gsize + 1);
            ngrp.setTest(mtest);
            ngrp.setFold(0, mgrp.getFold(i));
            if (gsize > 0) {
                for (int j = i + 1; j < nb; ++j) {
                    ClusNode onode = mgrp.getNode(j);
                    if (onode == null || !mtest.equals(onode.m_Test)) continue;
                    ngrp.setFold(gidx++, mgrp.getFold(j));
                    mgrp.cleanNode(j);
                }
            }
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ngrp.println();
            }
            ngrps.insertBefore(ngrp);
            ++nb_groups;
        }
        return nb_groups;
    }

    public final void xvalInduce(OptXValNode node, OptXValGroup mgrp) throws Exception {
        Long t0 = null;
        if (Clus.isDebug()) {
            t0 = ResourceInfo.getCPUTime();
        }
        if (Clus.isDebug()) {
            ClusStat.updateMaxMemory();
        }
        node.init(mgrp.getFolds());
        mgrp.stopCrit(node);
        if (mgrp.cleanFolds()) {
            return;
        }
        if (mgrp.getNbFolds() == 1) {
            int fold = mgrp.getFold();
            ClusNode onode = new ClusNode();
            onode.m_ClusteringStat = mgrp.getTotStat(fold);
            node.setNode(fold, onode);
            this.m_DFirst.induce(onode, mgrp.getData().getFoldData(fold), null);
            return;
        }
        this.initTestSelectors(mgrp);
        if (Clus.isDebug()) {
            ClusStat.deltaSplit();
        }
        this.findBestTest(mgrp);
        if (Clus.isDebug()) {
            ClusStat.deltaTest();
        }
        mgrp.preprocNodes(node, this);
        MyListIter ngrps = new MyListIter();
        int nb_groups = this.mkNewGroups(mgrp, ngrps);
        if (Clus.isDebug()) {
            ClusStat.deltaSplit();
        }
        if (Clus.isDebug()) {
            node.m_Time = ResourceInfo.getCPUTime() - t0;
        }
        if (nb_groups > 0) {
            int idx = 0;
            node.setNbChildren(nb_groups);
            OptXValGroup grp = (OptXValGroup)ngrps.getFirst();
            while (grp != null) {
                NodeTest test = grp.getTest();
                OptXValSplit split = new OptXValSplit();
                int arity = split.init(grp.getFolds(), test);
                node.setChild(split, idx++);
                RowData gdata = grp.getData();
                Long t01 = null;
                if (Clus.isDebug()) {
                    t01 = ResourceInfo.getCPUTime();
                }
                for (int i = 0; i < arity; ++i) {
                    OptXValNode child = new OptXValNode();
                    split.setChild(child, i);
                    OptXValGroup cgrp = grp.cloneGroup();
                    cgrp.setData(gdata.apply(test, i));
                    cgrp.create(this.m_StatManager, this.m_NbFolds);
                    cgrp.calcTotalStats();
                    if (Clus.isDebug()) {
                        node.m_Time += ResourceInfo.getCPUTime() - t01;
                    }
                    if (Clus.isDebug()) {
                        ClusStat.deltaSplit();
                    }
                    this.xvalInduce(child, cgrp);
                    if (!Clus.isDebug()) continue;
                    t01 = ResourceInfo.getCPUTime();
                }
                grp = (OptXValGroup)ngrps.getNext();
            }
        }
    }

    @Override
    public OptXValNode xvalInduce(OptXValGroup mgrp) throws Exception {
        OptXValNode root = new OptXValNode();
        this.xvalInduce(root, mgrp);
        return root;
    }
}

