/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.optxval;

import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.ext.optxval.OptXValInduce;
import si.ijs.kt.clus.ext.optxval.OptXValNode;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.jeans.util.list.MyList;

public class OptXValGroup
extends MyList {
    public RowData m_Data;
    public int[] m_Folds;
    public boolean m_IsSoft;
    public NodeTest m_Test;
    public ClusStatistic[] m_TotStat;
    public ClusNode[] m_Nodes;

    public OptXValGroup(RowData data, int size) {
        this.m_Data = data;
        this.m_Folds = new int[size];
    }

    public OptXValGroup(OptXValGroup grp, int size) {
        this.m_Data = grp.m_Data;
        this.m_IsSoft = grp.m_IsSoft;
        this.m_Folds = new int[size];
    }

    public void optimize2() {
        this.m_Data.optimize2(this.m_Folds);
    }

    public final int[] getFolds() {
        return this.m_Folds;
    }

    public final void preprocNodes(OptXValNode node, OptXValInduce induce) {
        int nb = this.getNbFolds();
        for (int i = 0; i < nb; ++i) {
            CurrentBestTestAndHeuristic sel = induce.getSelector(i);
            ClusNode fnode = this.getNode(i);
            if (sel.hasBestTest()) {
                fnode.testToNode(sel);
            } else {
                fnode.makeLeaf();
                this.cleanNode(i);
            }
            node.setNode(this.getFold(i), fnode);
        }
    }

    public final void setSoft() {
        this.m_IsSoft = true;
    }

    public final boolean updateSoft() {
        this.m_IsSoft = this.m_Data.isSoft();
        return this.m_IsSoft;
    }

    public final OptXValGroup cloneGroup() {
        OptXValGroup res = new OptXValGroup(this.m_Data, this.m_Folds.length);
        System.arraycopy(this.m_Folds, 0, res.m_Folds, 0, this.m_Folds.length);
        res.m_IsSoft = this.m_IsSoft;
        return res;
    }

    public final void setFold(int idx, int fold) {
        this.m_Folds[idx] = fold;
    }

    public final void setTest(NodeTest test) {
        this.m_Test = test;
    }

    public final NodeTest getTest() {
        return this.m_Test;
    }

    public final void println() {
        System.out.print("[");
        System.out.print(this.m_Folds[0]);
        for (int i = 1; i < this.m_Folds.length; ++i) {
            System.out.print("," + this.m_Folds[i]);
        }
        System.out.print("] - ");
        ClusLogger.info(this.m_Test.getString());
    }

    public final void initializeFolds() {
        for (int i = 0; i < this.m_Folds.length; ++i) {
            this.m_Folds[i] = i;
        }
    }

    public final ClusNode getNode(int i) {
        return this.m_Nodes[i];
    }

    public final ClusNode[] getNodes() {
        return this.m_Nodes;
    }

    public final void cleanNode(int i) {
        this.m_Nodes[i] = null;
    }

    public final void create(ClusStatManager m_StatManager, int folds) {
        this.m_TotStat = new ClusStatistic[folds + 1];
        for (int i = 0; i <= folds; ++i) {
            this.m_TotStat[i] = m_StatManager.createClusteringStat();
        }
    }

    public final void create2(ClusStatManager m_StatManager, int folds) {
        this.m_TotStat = new ClusStatistic[folds];
        for (int i = 0; i < folds; ++i) {
            this.m_TotStat[i] = m_StatManager.createClusteringStat();
        }
    }

    public final void makeNodes() {
        int nb = this.m_Folds.length;
        this.m_Nodes = new ClusNode[nb];
        for (int i = 0; i < nb; ++i) {
            this.m_Nodes[i] = new ClusNode();
            int foldnr = this.m_Folds[i];
            this.m_Nodes[i].m_ClusteringStat = this.m_TotStat[foldnr];
        }
    }

    public final ClusStatistic getTotStat(int fold) {
        return this.m_TotStat[fold];
    }

    public final RowData getData() {
        return this.m_Data;
    }

    public final void setData(RowData data) {
        this.m_Data = data;
    }

    public final int getFold() {
        return this.m_Folds[0];
    }

    public final int getNbFolds() {
        return this.m_Folds.length;
    }

    public final int getFold(int idx) {
        return this.m_Folds[idx];
    }

    public final void killFold(int idx) {
        this.m_Folds[idx] = -1;
    }

    public final boolean cleanFolds() {
        int nb = 0;
        for (int i = 0; i < this.m_Folds.length; ++i) {
            if (this.m_Folds[i] == -1) continue;
            ++nb;
        }
        int idx = 0;
        int[] old = this.m_Folds;
        this.m_Folds = new int[nb];
        if (nb > 0) {
            for (int i = 0; i < old.length; ++i) {
                if (old[i] == -1) continue;
                this.m_Folds[idx++] = old[i];
            }
        }
        return nb == 0;
    }

    public final ClusNode makeLeaf(int idx) {
        ClusNode leaf = new ClusNode();
        leaf.m_ClusteringStat = this.m_TotStat[idx];
        leaf.makeLeaf();
        return leaf;
    }

    public final boolean stopCrit(int idx) {
        return this.m_TotStat[idx].getTotalWeight() < 2.0 * SettingsTree.MINIMAL_WEIGHT;
    }

    public final void stopCrit(OptXValNode node) {
        int nb = this.getNbFolds();
        for (int i = 0; i < nb; ++i) {
            int fld = this.getFold(i);
            if (!this.stopCrit(fld)) continue;
            node.setNodeIndex(i, this.makeLeaf(fld));
            this.killFold(i);
        }
    }

    public final void calcTotalStats2() {
        int nb = this.m_Data.getNbRows();
        for (int i = 0; i < nb; ++i) {
            DataTuple tuple = this.m_Data.getTuple(i);
            int[] folds = tuple.m_Folds;
            for (int j = 0; j < folds.length; ++j) {
                int times = folds[j];
                if (times == 0) continue;
                this.m_TotStat[j].updateWeighted(tuple, (double)times * tuple.getWeight());
            }
        }
    }

    public final void calcTotalStats() {
        int i;
        this.m_Data.calcXValTotalStat(this.m_TotStat);
        ClusStatistic sum = this.m_TotStat[0];
        for (i = 1; i < this.m_TotStat.length; ++i) {
            sum.add(this.m_TotStat[i]);
        }
        for (i = 1; i < this.m_TotStat.length; ++i) {
            this.m_TotStat[i].subtractFromOther(sum);
        }
    }

    public final void calcTotalStats(ClusStatistic[] extra) {
        int i;
        this.m_Data.calcXValTotalStat(this.m_TotStat, extra);
        ClusStatistic sum = this.m_TotStat[0];
        for (i = 1; i < this.m_TotStat.length; ++i) {
            sum.add(this.m_TotStat[i]);
        }
        for (i = 1; i < this.m_TotStat.length; ++i) {
            this.m_TotStat[i].subtractFromOther(sum);
        }
        for (i = 0; i < this.m_TotStat.length; ++i) {
            this.m_TotStat[i].add(extra[i]);
        }
    }
}

