/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.optxval;

import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.ext.optxval.OptXValNode;
import si.ijs.kt.clus.ext.optxval.OptXValSplit;
import si.ijs.kt.clus.util.jeans.tree.MyNode;
import si.ijs.kt.clus.util.jeans.tree.Node;
import si.ijs.kt.clus.util.jeans.util.MyArray;

public class OptXValBinTree
extends MyNode {
    public static final long serialVersionUID = 1L;
    protected int m_NbTests;
    protected int m_NbFoldTests;
    protected long m_Time;

    public double[] getFIs() {
        double[] arr = new double[this.getMaxLeafDepth()];
        this.getFIs(arr, 0);
        return arr;
    }

    private void getFIs(double[] arr, int depth) {
        if (this.m_NbTests > 0) {
            int n = depth;
            arr[n] = arr[n] + (double)this.m_NbFoldTests / (double)this.m_NbTests;
        }
        for (int j = 0; j < this.getNbChildren(); ++j) {
            OptXValBinTree tree = (OptXValBinTree)this.getChild(j);
            tree.getFIs(arr, depth + 1);
        }
    }

    public double[] getNodes() {
        double[] arr = new double[this.getMaxLeafDepth()];
        this.getNodes(arr, 0);
        return arr;
    }

    private void getNodes(double[] arr, int depth) {
        if (this.m_NbTests > 0) {
            int n = depth;
            arr[n] = arr[n] + 1.0;
        }
        for (int j = 0; j < this.getNbChildren(); ++j) {
            OptXValBinTree tree = (OptXValBinTree)this.getChild(j);
            tree.getNodes(arr, depth + 1);
        }
    }

    public double[] getTimes() {
        double[] arr = new double[this.getMaxLeafDepth()];
        this.getTimes(arr, 0);
        return arr;
    }

    private void getTimes(double[] arr, int depth) {
        int n = depth;
        arr[n] = arr[n] + (double)this.m_Time;
        for (int j = 0; j < this.getNbChildren(); ++j) {
            OptXValBinTree tree = (OptXValBinTree)this.getChild(j);
            tree.getTimes(arr, depth + 1);
        }
    }

    public static void processs(MyArray nodes, MyArray left, MyArray right, OptXValBinTree tree) {
        for (int i = 0; i < nodes.size(); ++i) {
            int j;
            MyNode node;
            Object obj = nodes.elementAt(i);
            if (obj instanceof ClusNode) {
                node = (ClusNode)obj;
                tree.m_Time += ((ClusNode)node).m_Time;
                if (node.getNbChildren() <= 0) continue;
                left.addElement(node.getChild(0));
                right.addElement(node.getChild(1));
                ++tree.m_NbTests;
                ++tree.m_NbFoldTests;
                continue;
            }
            node = (OptXValNode)obj;
            tree.m_Time += ((OptXValNode)node).m_Time;
            ClusNode[] cnodes = ((OptXValNode)node).getNodes();
            for (j = 0; j < cnodes.length; ++j) {
                tree.m_Time += cnodes[j].m_Time;
                if (cnodes[j].getNbChildren() <= 0) continue;
                Node n1 = cnodes[j].getChild(0);
                Node n2 = cnodes[j].getChild(1);
                if (n1 != null) {
                    left.addElement(n1);
                }
                if (n2 == null) continue;
                right.addElement(n2);
            }
            for (j = 0; j < node.getNbChildren(); ++j) {
                OptXValSplit split = (OptXValSplit)node.getChild(j);
                if (split.getNbChildren() <= 0) continue;
                left.addElement(split.getChild(0));
                right.addElement(split.getChild(1));
                ++tree.m_NbTests;
                tree.m_NbFoldTests += split.getFolds().length;
            }
        }
    }

    public static OptXValBinTree convertTree(MyArray crnodes) {
        OptXValBinTree tree = new OptXValBinTree();
        if (crnodes.size() != 0) {
            tree.setNbChildren(2);
            MyArray left = new MyArray();
            MyArray right = new MyArray();
            OptXValBinTree.processs(crnodes, left, right, tree);
            tree.setChild(OptXValBinTree.convertTree(left), 0);
            tree.setChild(OptXValBinTree.convertTree(right), 1);
        }
        return tree;
    }

    public static OptXValBinTree convertTree(Object object) {
        MyArray arr = new MyArray();
        arr.addElement(object);
        return OptXValBinTree.convertTree(arr);
    }
}

