/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.optiontree;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.ext.optiontree.MyNode;
import si.ijs.kt.clus.ext.optiontree.Node;
import si.ijs.kt.clus.ext.optiontree.TestAndHeuristic;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.Global;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.MyArray;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class ClusSplitNode
extends MyNode {
    public static final long serialVersionUID = 1L;
    private static final int YES = 0;
    private static final int NO = 1;
    private static final int UNK = 2;
    private int m_ID;
    private NodeTest m_Test;

    @Override
    public int getID() {
        return this.m_ID;
    }

    @Override
    public final int getMaxLeafDepth() {
        int nb = this.getNbChildren();
        if (nb == 0) {
            return 1;
        }
        int max = 0;
        for (int i = 0; i < nb; ++i) {
            MyNode node = this.getChild(i);
            max = Math.max(max, node.getMaxLeafDepth());
        }
        return max + 1;
    }

    @Override
    public final int getLevel() {
        int depth = 0;
        for (Node node = this.getParent(); node != null; node = node.getParent()) {
            if (!(node instanceof ClusSplitNode)) continue;
            ++depth;
        }
        return depth;
    }

    @Override
    public ClusStatistic predictWeighted(DataTuple tuple) throws ClusException, InterruptedException {
        if (this.atBottomLevel()) {
            this.getTargetStat().calcMean();
            return this.getTargetStat();
        }
        int n_idx = this.m_Test.predictWeighted(tuple);
        if (n_idx != -1) {
            MyNode info = this.getChild(n_idx);
            return info.predictWeighted(tuple);
        }
        int nb_c = this.getNbChildren();
        MyNode ch_0 = this.getChild(0);
        ClusStatistic ch_0s = ch_0.predictWeighted(tuple);
        ClusStatistic stat = ch_0s.cloneSimple();
        stat.addPrediction(ch_0s, this.m_Test.getProportion(0));
        for (int i = 1; i < nb_c; ++i) {
            MyNode ch_i = this.getChild(i);
            ClusStatistic ch_is = ch_i.predictWeighted(tuple);
            stat.addPrediction(ch_is, this.m_Test.getProportion(i));
        }
        stat.computePrediction();
        return stat;
    }

    @Override
    public String getModelInfo() {
        return "Nodes = " + this.getNbNodes() + " (Leaves: " + this.getNbLeaves() + ", OptionNodes: " + this.getNbOptionNodes() + ", Options: " + this.getNbOptions() + ")";
    }

    public final String getTestString() {
        return this.m_Test != null ? this.m_Test.getString() : "None";
    }

    private final boolean hasBestTest() {
        return this.m_Test != null;
    }

    @Override
    public void printModel(PrintWriter wrt) {
        this.printTree(wrt, StatisticPrintInfo.getInstance(), "");
    }

    @Override
    public void printModel(PrintWriter wrt, StatisticPrintInfo info) {
        this.printTree(wrt, info, "");
    }

    @Override
    public void printModelAndExamples(PrintWriter wrt, StatisticPrintInfo info, RowData examples) {
        this.printTree(wrt, info, "", examples);
    }

    @Override
    public void printModelToPythonScript(PrintWriter wrt, HashMap<String, Integer> indices) {
        this.printTreeToPythonScript(wrt, "\t");
    }

    @Override
    public void printModelToPythonScript(PrintWriter wrt, HashMap<String, Integer> indices, String modelIdentifier) {
        this.printModelToPythonScript(wrt, indices);
    }

    @Override
    public void printModelToQuery(PrintWriter wrt, ClusRun cr, int starttree, int startitem, boolean exhaustive) {
        int lastmodel = cr.getNbModels() - 1;
        ClusLogger.info("The number of models to print is:" + lastmodel);
        String[][] tabitem = new String[lastmodel + 1][10000];
        int[][] tabexist = new int[lastmodel + 1][10000];
        Global.set_treecpt(starttree);
        Global.set_itemsetcpt(startitem);
        if (exhaustive) {
            for (int i = 0; i < cr.getNbModels(); ++i) {
                ClusModelInfo mod = cr.getModelInfo(i);
                MyNode tree = (MyNode)cr.getModel(i);
                if (tree.getNbChildren() != 0) {
                    tree.printTreeInDatabase(wrt, tabitem[i], tabexist[i], 0, "all_trees");
                }
                if (tree.getNbNodes() <= 1) {
                    double error_rate = tree.m_ClusteringStat.getErrorRel();
                    wrt.println("#" + tree.m_ClusteringStat.getPredictedClassName(0));
                    wrt.println(mod.getModelSize() + ", " + error_rate + ", " + (1.0 - error_rate));
                } else {
                    wrt.println(mod.getModelSize() + ", " + mod.m_TrainErr.getErrorClassif() + ", " + mod.m_TrainErr.getErrorAccuracy());
                }
                Global.inc_treecpt();
            }
        } else {
            ClusModelInfo mod = cr.getModelInfo(lastmodel);
            MyNode tree = (MyNode)cr.getModel(lastmodel);
            tabitem[lastmodel][0] = "null";
            tabexist[lastmodel][0] = 1;
            wrt.println("INSERT INTO trees_sets VALUES(" + Global.get_itemsetcpt() + ", '" + tabitem[lastmodel][0] + "', " + tabexist[lastmodel][0] + ")");
            wrt.println("INSERT INTO greedy_trees VALUES(" + Global.get_treecpt() + ", " + Global.get_itemsetcpt() + ",1)");
            Global.inc_itemsetcpt();
            if (tree.getNbChildren() != 0) {
                this.printTreeInDatabase(wrt, tabitem[lastmodel], tabexist[lastmodel], 1, "greedy_trees");
            }
            wrt.println("INSERT INTO trees_charac VALUES(" + Global.get_treecpt() + ", " + mod.getModelSize() + ", " + mod.m_TrainErr.getErrorClassif() + ", " + mod.m_TrainErr.getErrorAccuracy() + ", NULL)");
            Global.inc_treecpt();
        }
    }

    private final void writeDistributionForInternalNode(PrintWriter writer, StatisticPrintInfo info) {
        if (info.INTERNAL_DISTR && this.m_TargetStat != null) {
            writer.print(": " + this.m_TargetStat.getString(info));
        }
        writer.println();
    }

    private final void printTree(PrintWriter writer, StatisticPrintInfo info, String prefix) {
        this.printTree(writer, info, prefix, null);
    }

    @Override
    public final void printTree(PrintWriter writer, StatisticPrintInfo info, String prefix, RowData examples) {
        int arity = this.getNbChildren();
        if (arity > 0) {
            int delta;
            int n = delta = this.hasUnknownBranch() ? 1 : 0;
            if (arity - delta == 2) {
                writer.print(this.m_Test.getTestString());
                RowData examples0 = null;
                RowData examples1 = null;
                if (examples != null) {
                    examples0 = examples.apply(this.m_Test, 0);
                    examples1 = examples.apply(this.m_Test, 1);
                }
                this.writeDistributionForInternalNode(writer, info);
                writer.print(prefix + "+--yes: ");
                this.getChild(0).printTree(writer, info, prefix + "|       ", examples0);
                writer.print(prefix + "+--no:  ");
                if (this.hasUnknownBranch()) {
                    this.getChild(1).printTree(writer, info, prefix + "|       ", examples1);
                    writer.print(prefix + "+--unk: ");
                    this.getChild(2).printTree(writer, info, prefix + "        ", examples0);
                } else {
                    this.getChild(1).printTree(writer, info, prefix + "        ", examples1);
                }
            } else {
                writer.println(this.m_Test.getTestString());
                for (int i = 0; i < arity; ++i) {
                    MyNode child = this.getChild(i);
                    String branchlabel = this.m_Test.getBranchLabel(i);
                    RowData examplesi = null;
                    if (examples != null) {
                        examples.apply(this.m_Test, i);
                    }
                    writer.print(prefix + "+--" + branchlabel + ": ");
                    String suffix = StringUtils.makeString(' ', branchlabel.length() + 4);
                    if (i != arity - 1) {
                        child.printTree(writer, info, prefix + "|" + suffix, examplesi);
                        continue;
                    }
                    child.printTree(writer, info, prefix + " " + suffix, examplesi);
                }
            }
        } else {
            if (this.m_TargetStat == null) {
                writer.print("?");
            } else {
                writer.print(this.m_TargetStat.getString(info));
            }
            if (this.getID() != 0 && info.SHOW_INDEX) {
                writer.println(" (" + this.getID() + ")");
            } else {
                writer.println();
            }
            if (examples != null && examples.getNbRows() > 0) {
                writer.println(examples.toString(prefix));
                writer.println(prefix + "Summary:");
                writer.println(examples.getSummary(prefix));
            }
        }
    }

    private final boolean hasUnknownBranch() {
        return this.m_Test.hasUnknownBranch();
    }

    @Override
    public final void printTreeInDatabase(PrintWriter writer, String[] tabitem, int[] tabexist, int cpt, String typetree) {
        int arity = this.getNbChildren();
        if (arity > 0) {
            int delta;
            int n = delta = this.hasUnknownBranch() ? 1 : 0;
            if (arity - delta == 2) {
                tabitem[cpt] = this.m_Test.getTestString();
                tabexist[cpt] = 1;
                this.getChild(0).printTreeInDatabase(writer, tabitem, tabexist, ++cpt, typetree);
                tabitem[--cpt] = this.m_Test.getTestString();
                tabexist[cpt] = 0;
                ++cpt;
                if (this.hasUnknownBranch()) {
                    this.getChild(1).printTreeInDatabase(writer, tabitem, tabexist, cpt, typetree);
                    this.getChild(2).printTreeInDatabase(writer, tabitem, tabexist, cpt, typetree);
                } else {
                    this.getChild(1).printTreeInDatabase(writer, tabitem, tabexist, cpt, typetree);
                }
            } else {
                writer.println("arity-delta different 2");
                for (int i = 0; i < arity; ++i) {
                    MyNode child = this.getChild(i);
                    String branchlabel = this.m_Test.getBranchLabel(i);
                    writer.print("+--" + branchlabel + ": ");
                    if (i != arity - 1) {
                        child.printTreeInDatabase(writer, tabitem, tabexist, cpt, typetree);
                        continue;
                    }
                    child.printTreeInDatabase(writer, tabitem, tabexist, cpt, typetree);
                }
            }
        } else if (this.m_TargetStat == null) {
            writer.print("?");
        } else {
            tabitem[cpt] = this.m_TargetStat.getPredictedClassName(0);
            tabexist[cpt] = 1;
            writer.print("#");
            for (int i = 0; i <= cpt - 1; ++i) {
                writer.print(this.printTestNode(tabitem[i], tabexist[i]) + ", ");
            }
            writer.println(this.printTestNode(tabitem[cpt], tabexist[cpt]));
            ++cpt;
        }
    }

    private String printTestNode(String a, int pres) {
        if (pres == 1) {
            return a;
        }
        return "not(" + a + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void printTreeToPythonScript(PrintWriter writer, String prefix) {
        int arity = this.getNbChildren();
        if (arity > 0) {
            int delta;
            int n = delta = this.hasUnknownBranch() ? 1 : 0;
            if (arity - delta != 2) return;
            writer.println(prefix + "if " + this.m_Test.getTestString() + ":");
            writer.println(prefix + "else: ");
            if (!this.hasUnknownBranch()) return;
        }
        if (this.m_TargetStat == null) return;
        writer.println(prefix + "return " + this.m_TargetStat.getArrayOfStatistic());
        ClusLogger.info(this.m_TargetStat.getClass().toString());
    }

    public String toString() {
        try {
            if (this.hasBestTest()) {
                return this.getTestString();
            }
            return this.m_TargetStat.getSimpleString();
        }
        catch (Exception e) {
            return "null clusnode ";
        }
    }

    @Override
    public void makeLeaf() {
        this.m_Test = null;
        this.cleanup();
        this.removeAllChildren();
    }

    private final void cleanup() {
        if (this.m_ClusteringStat != null) {
            this.m_ClusteringStat.setSDataSize(0);
        }
        if (this.m_TargetStat != null) {
            this.m_TargetStat.setSDataSize(0);
        }
    }

    public final void setTest(NodeTest test) {
        this.m_Test = test;
    }

    @Override
    public MyNode cloneNode() {
        ClusSplitNode clone = new ClusSplitNode();
        clone.m_Test = this.m_Test;
        clone.m_ClusteringStat = this.m_ClusteringStat;
        clone.m_TargetStat = this.m_TargetStat;
        return clone;
    }

    public Node[] getChildren() {
        Node[] temp = new Node[this.m_Children.size()];
        for (int i = 0; i < this.m_Children.size(); ++i) {
            temp[i] = this.getChild(i);
        }
        return temp;
    }

    public final NodeTest getTest() {
        return this.m_Test;
    }

    @Override
    public int getModelSize() {
        return this.getNbNodes();
    }

    public final int updateArity() {
        int arity = this.m_Test.updateArity();
        this.setNbChildren(arity);
        return arity;
    }

    public final void testToNode(TestAndHeuristic tnh) {
        this.setTest(tnh.updateTest());
    }

    @Override
    public JsonObject getModelJSON() {
        return null;
    }

    @Override
    public JsonObject getModelJSON(StatisticPrintInfo info) {
        return null;
    }

    @Override
    public JsonObject getModelJSON(StatisticPrintInfo info, RowData examples) {
        return null;
    }

    @Override
    public void applyModelProcessors(DataTuple tuple, MyArray mproc) throws IOException {
    }

    @Override
    public void attachModel(HashMap table) throws ClusException {
    }

    public void retrieveStatistics(ArrayList list) {
    }

    @Override
    public ClusModel prune(int prunetype) {
        return null;
    }
}

