/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.optiontree;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.ext.optiontree.ClusSplitNode;
import si.ijs.kt.clus.ext.optiontree.MyNode;
import si.ijs.kt.clus.ext.optiontree.Node;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.Global;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.GeneticDistanceStat;
import si.ijs.kt.clus.statistic.HierSingleLabelStat;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.statistic.WHTDStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.MyArray;

public class ClusOptionNode
extends MyNode {
    public static final long serialVersionUID = 1L;
    private int m_ID;
    private double[] m_HeuristicRatios;
    private String m_OptionNodeText = "[option node]";

    public double[] getHeuristicRatios() {
        return this.m_HeuristicRatios;
    }

    public void setHeuristicRatios(double[] m_HeuristicRatios) {
        this.m_HeuristicRatios = m_HeuristicRatios;
    }

    public void setHeuristicRatio(int position, double value) {
        this.m_HeuristicRatios[position] = value;
    }

    @Override
    public MyNode cloneNode() {
        ClusOptionNode clone = new ClusOptionNode();
        clone.m_ClusteringStat = this.m_ClusteringStat;
        clone.m_TargetStat = this.m_TargetStat;
        return clone;
    }

    @Override
    public int getID() {
        return this.m_ID;
    }

    @Override
    public ClusStatistic predictWeighted(DataTuple tuple) throws ClusException, InterruptedException {
        if (this.atBottomLevel()) {
            throw new RuntimeException("clus.ext.optiontree.ClusOptionNode.predictWeighted(DataTuple): This should never happen");
        }
        int nb_c = this.getNbChildren();
        ArrayList<ClusStatistic> votes = new ArrayList<ClusStatistic>();
        for (int i = 0; i < nb_c; ++i) {
            votes.add(this.getChild(i).predictWeighted(tuple));
        }
        ClusStatistic outStat = this.newClusStatistic();
        outStat.vote(votes);
        outStat.computePrediction();
        return outStat;
    }

    protected ClusStatistic newClusStatistic() {
        ClusStatistic outStat = null;
        switch (this.m_StatManager.getTargetMode()) {
            case CLASSIFY: {
                outStat = new ClassificationStat(this.m_StatManager.getSettings(), this.m_StatManager.getSchema().getNominalAttrUse(ClusAttrType.AttributeUseType.Target));
                break;
            }
            case REGRESSION: {
                outStat = new RegressionStat(this.m_StatManager.getSettings(), this.m_StatManager.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.Target));
                break;
            }
            case HIERARCHICAL: {
                if (this.m_StatManager.getSettings().getHMLC().getHierSingleLabel()) {
                    outStat = new HierSingleLabelStat(this.m_StatManager.getSettings(), this.m_StatManager.getHier());
                    break;
                }
                outStat = new WHTDStatistic(this.m_StatManager.getSettings(), this.m_StatManager.getHier());
                break;
            }
            case PHYLO: {
                outStat = new GeneticDistanceStat(this.m_StatManager.getSettings(), this.m_StatManager.getSchema().getNominalAttrUse(ClusAttrType.AttributeUseType.Target));
                break;
            }
            default: {
                throw new RuntimeException(this.getClass().getName() + " newClusStatistic(): Error initializing the statistic " + (Object)((Object)this.m_StatManager.getTargetMode()));
            }
        }
        return outStat;
    }

    @Override
    public void printModel(PrintWriter wrt) {
        this.printTree(wrt, StatisticPrintInfo.getInstance(), "");
    }

    @Override
    public void printModel(PrintWriter wrt, StatisticPrintInfo info) {
        this.printTree(wrt, info, "");
    }

    @Override
    public void printModelAndExamples(PrintWriter wrt, StatisticPrintInfo info, RowData examples) {
        this.printTree(wrt, info, "", examples);
    }

    @Override
    public void printModelToPythonScript(PrintWriter wrt, HashMap<String, Integer> indices) {
        this.printTreeToPythonScript(wrt, "\t");
    }

    @Override
    public void printModelToPythonScript(PrintWriter wrt, HashMap<String, Integer> indices, String modelIdentifier) {
        this.printModelToPythonScript(wrt, indices);
    }

    @Override
    public void printModelToQuery(PrintWriter wrt, ClusRun cr, int starttree, int startitem, boolean exhaustive) {
        int lastmodel = cr.getNbModels() - 1;
        ClusLogger.info("The number of models to print is:" + lastmodel);
        String[][] tabitem = new String[lastmodel + 1][10000];
        int[][] tabexist = new int[lastmodel + 1][10000];
        Global.set_treecpt(starttree);
        Global.set_itemsetcpt(startitem);
        if (exhaustive) {
            for (int i = 0; i < cr.getNbModels(); ++i) {
                ClusModelInfo mod = cr.getModelInfo(i);
                MyNode tree = (MyNode)cr.getModel(i);
                if (tree.getNbChildren() != 0) {
                    tree.printTreeInDatabase(wrt, tabitem[i], tabexist[i], 0, "all_trees");
                }
                if (tree.getNbNodes() <= 1) {
                    double error_rate = tree.m_ClusteringStat.getErrorRel();
                    wrt.println("#" + tree.m_ClusteringStat.getPredictedClassName(0));
                    wrt.println(mod.getModelSize() + ", " + error_rate + ", " + (1.0 - error_rate));
                } else {
                    wrt.println(mod.getModelSize() + ", " + mod.m_TrainErr.getErrorClassif() + ", " + mod.m_TrainErr.getErrorAccuracy());
                }
                Global.inc_treecpt();
            }
        } else {
            ClusModelInfo mod = cr.getModelInfo(lastmodel);
            MyNode tree = (MyNode)cr.getModel(lastmodel);
            tabitem[lastmodel][0] = "null";
            tabexist[lastmodel][0] = 1;
            wrt.println("INSERT INTO trees_sets VALUES(" + Global.get_itemsetcpt() + ", '" + tabitem[lastmodel][0] + "', " + tabexist[lastmodel][0] + ")");
            wrt.println("INSERT INTO greedy_trees VALUES(" + Global.get_treecpt() + ", " + Global.get_itemsetcpt() + ",1)");
            Global.inc_itemsetcpt();
            if (tree.getNbChildren() != 0) {
                this.printTreeInDatabase(wrt, tabitem[lastmodel], tabexist[lastmodel], 1, "greedy_trees");
            }
            wrt.println("INSERT INTO trees_charac VALUES(" + Global.get_treecpt() + ", " + mod.getModelSize() + ", " + mod.m_TrainErr.getErrorClassif() + ", " + mod.m_TrainErr.getErrorAccuracy() + ", NULL)");
            Global.inc_treecpt();
        }
    }

    public final void printTree() {
        PrintWriter wrt = new PrintWriter(new OutputStreamWriter(System.out));
        this.printTree(wrt, StatisticPrintInfo.getInstance(), "");
        wrt.flush();
    }

    public final void writeDistributionForInternalNode(PrintWriter writer, StatisticPrintInfo info) {
        if (info.INTERNAL_DISTR && this.m_TargetStat != null) {
            writer.print(": " + this.m_TargetStat.getString(info));
        }
        writer.println();
    }

    public final void printTree(PrintWriter writer, StatisticPrintInfo info, String prefix) {
        this.printTree(writer, info, prefix, null);
    }

    @Override
    public final void printTree(PrintWriter writer, StatisticPrintInfo info, String prefix, RowData examples) {
        int arity = this.getNbChildren();
        if (arity > 0) {
            writer.println(this.m_OptionNodeText);
            for (int i = 0; i < arity; ++i) {
                writer.print(prefix + "+--o" + (i + 1) + " (" + this.m_HeuristicRatios[i] + "): ");
                if (i != arity - 1) {
                    this.getChild(i).printTree(writer, info, prefix + "|       ", examples);
                    continue;
                }
                this.getChild(i).printTree(writer, info, prefix + "        ", examples);
            }
        } else {
            throw new RuntimeException(this.getClass().getName() + ": should never happen");
        }
    }

    @Override
    public final void printTreeInDatabase(PrintWriter writer, String[] tabitem, int[] tabexist, int cpt, String typetree) {
        int arity = this.getNbChildren();
        if (arity > 0) {
            tabitem[cpt] = this.m_OptionNodeText;
            tabexist[cpt] = 1;
            ++cpt;
            for (int i = 0; i < arity; ++i) {
                this.getChild(i).printTreeInDatabase(writer, tabitem, tabexist, cpt, typetree);
                --cpt;
            }
        }
    }

    public String printTestNode(String a, int pres) {
        if (pres == 1) {
            return a;
        }
        return "not(" + a + ")";
    }

    public final void printTreeToPythonScript(PrintWriter writer, String prefix) {
    }

    @Override
    public int getMaxLeafDepth() {
        int nb = this.getNbChildren();
        if (nb == 0) {
            return 1;
        }
        int max = 0;
        for (int i = 0; i < nb; ++i) {
            MyNode node = this.getChild(i);
            max = Math.max(max, node.getMaxLeafDepth());
        }
        return max;
    }

    @Override
    public int getLevel() {
        int depth = 0;
        for (Node node = this.getParent(); node != null; node = node.getParent()) {
            if (!(node instanceof ClusSplitNode)) continue;
            ++depth;
        }
        return depth;
    }

    @Override
    public String getModelInfo() {
        return "Nodes = " + this.getNbNodes() + " (Leaves: " + this.getNbLeaves() + ", OptionNodes: " + this.getNbOptionNodes() + ", Options: " + this.getNbOptions() + ")";
    }

    @Override
    public JsonObject getModelJSON() {
        return null;
    }

    @Override
    public JsonObject getModelJSON(StatisticPrintInfo info) {
        return null;
    }

    @Override
    public JsonObject getModelJSON(StatisticPrintInfo info, RowData examples) {
        return null;
    }

    @Override
    public void attachModel(HashMap table) throws ClusException {
    }

    public void retrieveStatistics(ArrayList list) {
    }

    @Override
    public void applyModelProcessors(DataTuple tuple, MyArray mproc) throws IOException {
    }

    @Override
    public int getModelSize() {
        return 0;
    }

    @Override
    public ClusModel prune(int prunetype) {
        return null;
    }

    @Override
    public void makeLeaf() {
    }
}

