/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ilevelc;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.io.ARFFFile;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.ext.ilevelc.ILevelConstraint;
import si.ijs.kt.clus.ext.ilevelc.SimpleClusterModel;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.FileUtil;

public class MPCKMeansWrapper {
    protected ClusStatManager m_Manager;

    public MPCKMeansWrapper(ClusStatManager statManager) {
        this.m_Manager = statManager;
    }

    public ClusStatManager getStatManager() {
        return this.m_Manager;
    }

    public static void writeStream(InputStream in) throws IOException {
        int ch = -1;
        StringBuffer sb = new StringBuffer();
        while ((ch = in.read()) != -1) {
            sb.append((char)ch);
        }
        ClusLogger.info(sb.toString());
    }

    public double computeRandIndex(RowData data, int[] assign, String tpe) {
        int a = 0;
        int b = 0;
        int nbex = data.getNbRows();
        ClusSchema schema = data.getSchema();
        NominalAttrType classtype = (NominalAttrType)schema.getAttrType(schema.getNbAttributes() - 1);
        for (int i = 0; i < nbex; ++i) {
            DataTuple ti = data.getTuple(i);
            int cia = classtype.getNominal(ti);
            int cib = assign[ti.getIndex()];
            for (int j = i + 1; j < nbex; ++j) {
                DataTuple tj = data.getTuple(j);
                int cja = classtype.getNominal(tj);
                int cjb = assign[tj.getIndex()];
                if (cia == cja && cib == cjb) {
                    ++a;
                }
                if (cia == cja || cib == cjb) continue;
                ++b;
            }
        }
        double rand = 1.0 * (double)(a + b) / (double)(nbex * (nbex - 1) / 2);
        ClusLogger.info(tpe + "Rand = " + rand + " (nbex = " + nbex + ")");
        return rand;
    }

    public ClusModel induce(RowData data, RowData test, ArrayList constraints, int cls) throws IOException, ClusException {
        String main = this.getStatManager().getSettings().getGeneric().getAppName();
        String datf = main + "-temp-MPCKMeans.arff";
        String cons = main + "-temp-MPCKMeans.cons";
        String outf = main + "-temp-MPCKMeans.assign";
        ClusLogger.info("Calling MPCKMeans: " + main);
        FileUtil.delete(datf);
        FileUtil.delete(cons);
        FileUtil.delete(outf);
        ARFFFile.writeArff(datf, data);
        PrintWriter wrt = new PrintWriter(new OutputStreamWriter(new FileOutputStream(cons)));
        for (int i = 0; i < constraints.size(); ++i) {
            int mtype;
            int t2;
            ILevelConstraint ic = (ILevelConstraint)constraints.get(i);
            int type = ic.getType();
            int t1 = ic.getT1().getIndex();
            if (t1 >= (t2 = ic.getT2().getIndex())) {
                int temp = t1;
                t1 = t2;
                t2 = temp;
            }
            int n = mtype = type == 0 ? 1 : -1;
            if (t1 == t2) continue;
            wrt.println(t1 + "\t" + t2 + "\t" + mtype);
        }
        wrt.close();
        String script = System.getenv("MPCKMEANS_SCRIPT");
        ClusLogger.info("Running script: " + script);
        if (script == null) {
            return new SimpleClusterModel(null, this.getStatManager());
        }
        try {
            String line = "";
            int[] assign = new int[data.getNbRows()];
            Arrays.fill(assign, -1);
            String cmdline = "-D " + datf + " -C " + cons + " -O " + outf;
            Process proc = Runtime.getRuntime().exec(script + " " + cmdline);
            proc.waitFor();
            MPCKMeansWrapper.writeStream(proc.getInputStream());
            MPCKMeansWrapper.writeStream(proc.getErrorStream());
            try (LineNumberReader rdr = new LineNumberReader(new InputStreamReader(new FileInputStream(outf)));){
                while ((line = rdr.readLine()) != null) {
                    int cl;
                    if ((line = line.trim()).equals("")) continue;
                    String[] arr = line.split("\t");
                    if (arr.length != 2) {
                        throw new ClusException("MPCKMeans error in output");
                    }
                    int idx = Integer.parseInt(arr[0]);
                    assign[idx] = cl = Integer.parseInt(arr[1]);
                }
            }
            ClusLogger.info("--------the file" + cons + "is not deleted !!!");
            this.computeRandIndex(data, assign, "All data: ");
            if (test != null) {
                this.computeRandIndex(test, assign, "Test data: ");
            }
            return new SimpleClusterModel(assign, this.getStatManager());
        }
        catch (InterruptedException interruptedException) {
            return new SimpleClusterModel(null, this.getStatManager());
        }
    }
}

