/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ilevelc;

import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;

public class ILevelCStatistic
extends RegressionStat {
    public static final long serialVersionUID = 1L;
    protected NumericAttrType[] m_Numeric;
    protected int m_ClusterID = -1;

    public ILevelCStatistic(Settings sett, NumericAttrType[] num) {
        super(sett, num);
        this.m_Numeric = num;
    }

    public void setClusterID(int id) {
        this.m_ClusterID = id;
    }

    public int getClusterID() {
        return this.m_ClusterID;
    }

    @Override
    public ClusStatistic cloneStat() {
        return new ILevelCStatistic(this.m_Settings, this.m_Numeric);
    }

    @Override
    public String getString(StatisticPrintInfo info) {
        String res = super.getString(info);
        return res + " L=" + this.getClusterID();
    }

    @Override
    public String getPredictWriterString(DataTuple tuple) {
        return "";
    }

    public void assignInstances(RowData data, int[] clusters) {
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            clusters[tuple.getIndex()] = this.getClusterID();
        }
    }
}

