/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ilevelc;

import java.io.IOException;
import java.util.ArrayList;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.algo.tdidt.DepthFirstInduce;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.attweights.ClusNormalizedAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.rows.RowDataSortHelper;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.ilevelc.COPKMeans;
import si.ijs.kt.clus.ext.ilevelc.COPKMeansModel;
import si.ijs.kt.clus.ext.ilevelc.DerivedConstraintsComputer;
import si.ijs.kt.clus.ext.ilevelc.ILevelCHeurStat;
import si.ijs.kt.clus.ext.ilevelc.ILevelCStatistic;
import si.ijs.kt.clus.ext.ilevelc.ILevelConstraint;
import si.ijs.kt.clus.ext.ilevelc.MPCKMeansWrapper;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.model.test.NumericTest;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusRandom;
import si.ijs.kt.clus.util.exception.ClusException;

public class ILevelCInduce
extends DepthFirstInduce {
    protected NodeTest m_BestTest;
    protected ClusNode m_BestLeaf;
    protected RowDataSortHelper m_SortHelper = new RowDataSortHelper();
    protected double m_BestHeur = Double.POSITIVE_INFINITY;
    protected int m_NbClasses = 1;
    protected int m_MaxNbClasses = 2;
    protected double m_MinLeafWeight;
    protected int m_NbTrain;
    protected double m_GlobalSS;
    protected ArrayList<ILevelConstraint> m_Constraints;
    protected int[][] m_ConstraintsIndex;
    protected ClusNormalizedAttributeWeights m_Scale;

    public ILevelCInduce(ClusSchema schema, Settings sett) throws ClusException, IOException {
        super(schema, sett);
    }

    public int[][] createConstraintsIndex() {
        ArrayList[] crIndex = new ArrayList[this.m_NbTrain];
        for (int i = 0; i < this.m_Constraints.size(); ++i) {
            ILevelConstraint ic = this.m_Constraints.get(i);
            int t1 = ic.getT1().getIndex();
            int t2 = ic.getT2().getIndex();
            if (crIndex[t1] == null) {
                crIndex[t1] = new ArrayList();
            }
            if (crIndex[t2] == null) {
                crIndex[t2] = new ArrayList();
            }
            crIndex[t1].add(new Integer(i));
            crIndex[t2].add(new Integer(i));
        }
        int[][] index = new int[this.m_NbTrain][];
        for (int i = 0; i < this.m_NbTrain; ++i) {
            if (crIndex[i] == null) continue;
            int nb = crIndex[i].size();
            index[i] = new int[nb];
            for (int j = 0; j < nb; ++j) {
                Integer value = (Integer)crIndex[i].get(j);
                index[i][j] = value;
            }
        }
        return index;
    }

    public ILevelConstraint[] getSubsetConstraints(RowData data) {
        int count = 0;
        boolean[] constr = new boolean[this.m_Constraints.size()];
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            int[] index = this.m_ConstraintsIndex[tuple.getIndex()];
            if (index == null) continue;
            for (int j = 0; j < index.length; ++j) {
                int cid = index[j];
                if (constr[cid]) continue;
                constr[cid] = true;
                ++count;
            }
        }
        int pos = 0;
        ILevelConstraint[] result = new ILevelConstraint[count];
        for (int i = 0; i < this.m_Constraints.size(); ++i) {
            if (!constr[i]) continue;
            result[pos++] = this.m_Constraints.get(i);
        }
        return result;
    }

    public int[] createIE(RowData data) {
        int[] ie = new int[this.m_NbTrain];
        for (int i = 0; i < data.getNbRows(); ++i) {
            ie[data.getTuple((int)i).getIndex()] = 2;
        }
        return ie;
    }

    public double computeHeuristic(int violated, double ss) {
        double ss_norm = ss / this.m_GlobalSS;
        double violated_norm = 1.0 * (double)violated / (double)this.m_Constraints.size();
        double alpha = this.getSettings().getILevelC().getILevelCAlpha();
        double heur = (1.0 - alpha) * ss_norm + alpha * violated_norm;
        return heur;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double computeHeuristic(ILevelCHeurStat pos, ILevelCHeurStat neg, ILevelCStatistic ps, boolean use_p_lab, double ss_offset, int nb_violated) {
        if (pos.getTotalWeight() < this.m_MinLeafWeight) {
            return Double.POSITIVE_INFINITY;
        }
        if (neg.getTotalWeight() < this.m_MinLeafWeight) {
            return Double.POSITIVE_INFINITY;
        }
        int pLabel = -1;
        int nbLabels = this.m_NbClasses;
        if (use_p_lab) {
            nbLabels = this.m_NbClasses - 1;
            pLabel = ps.getClusterID();
        }
        int v1 = this.tryLabel(pos, neg, pLabel, nbLabels);
        int v2 = this.tryLabel(neg, pos, pLabel, nbLabels);
        if (v1 == -1) {
            if (v2 == -1) return Double.POSITIVE_INFINITY;
            nb_violated += v2;
        } else if (v2 == -1) {
            if (v1 == -1) return Double.POSITIVE_INFINITY;
            nb_violated += v1;
        } else {
            nb_violated += Math.min(v1, v2);
        }
        double ss_pos = pos.getSVarS(this.m_Scale);
        double ss_neg = neg.getSVarS(this.m_Scale);
        double ss = ss_offset + ss_pos + ss_neg;
        return this.computeHeuristic(nb_violated, ss);
    }

    public void findNumericConstraints(NumericAttrType at, ClusNode leaf, boolean use_p_lab, double ss_offset, int violated_offset, int violated_leaf, int[] clusters) throws ClusException {
        RowData data = (RowData)leaf.getVisitor();
        ILevelCStatistic tot = (ILevelCStatistic)leaf.getClusteringStat();
        int idx = at.getArrayIndex();
        if (at.isSparse()) {
            data.sortSparse(at, this.m_SortHelper);
        } else {
            data.sort(at);
        }
        int nb_rows = data.getNbRows();
        if (at.hasMissing()) {
            throw new ClusException("Does not support attributes with missing values: " + at.getName());
        }
        ILevelCStatistic cs = (ILevelCStatistic)leaf.getClusteringStat();
        ILevelCHeurStat pos = new ILevelCHeurStat(this.getSettings(), cs, this.m_NbClasses);
        ILevelCHeurStat neg = new ILevelCHeurStat(this.getSettings(), cs, this.m_NbClasses);
        int[] ie = this.createIE(data);
        pos.setIndices(this.m_ConstraintsIndex, this.m_Constraints, ie, clusters);
        neg.setIndices(this.m_ConstraintsIndex, this.m_Constraints, ie, clusters);
        for (int i = 0; i < nb_rows; ++i) {
            DataTuple tuple = data.getTuple(i);
            neg.updateWeighted(tuple, tuple.getWeight());
        }
        int nb_violated = violated_leaf;
        double prev = Double.NaN;
        for (int i = 0; i < nb_rows; ++i) {
            DataTuple tuple = data.getTuple(i);
            double value = tuple.getDoubleVal(idx);
            if (value != prev && !Double.isNaN(prev)) {
                double heuristic = this.computeHeuristic(pos, neg, tot, use_p_lab, ss_offset, violated_offset + nb_violated);
                if (heuristic < this.m_BestHeur) {
                    this.m_BestHeur = heuristic;
                    this.m_BestLeaf = leaf;
                    double pos_freq = pos.getTotalWeight() / tot.getTotalWeight();
                    double splitpoint = (value + prev) / 2.0;
                    this.m_BestTest = new NumericTest(at, splitpoint, pos_freq);
                }
                prev = value;
            }
            pos.updateWeighted(tuple, tuple.getWeight());
            neg.removeWeighted(tuple, tuple.getWeight());
            int tidx = tuple.getIndex();
            int[] cidx = this.m_ConstraintsIndex[tidx];
            if (cidx != null) {
                for (int j = 0; j < cidx.length; ++j) {
                    ILevelConstraint cons = this.m_Constraints.get(cidx[j]);
                    int otidx = cons.getOtherTupleIdx(tuple);
                    if (ie[otidx] == 0) continue;
                    boolean was_violated = false;
                    if (cons.getType() == 0) {
                        if (ie[tidx] != ie[otidx]) {
                            was_violated = true;
                        }
                    } else if (ie[tidx] == ie[otidx]) {
                        was_violated = true;
                    }
                    if (was_violated) {
                        --nb_violated;
                        continue;
                    }
                    ++nb_violated;
                }
            }
            ie[tidx] = 1;
        }
    }

    public void tryGivenLeaf(ClusNode leaf, boolean use_p_lab, int violated, double ss, int[] clusters) throws ClusException {
        ILevelCStatistic stat = (ILevelCStatistic)leaf.getClusteringStat();
        if (stat.getTotalWeight() <= this.m_MinLeafWeight) {
            return;
        }
        RowData leaf_data = (RowData)leaf.getVisitor();
        double ss_leaf = stat.getSVarS(this.m_Scale);
        double ss_offset = ss - ss_leaf;
        int[] v_info = this.countViolatedConstaints(leaf_data, clusters);
        int violated_offset = violated - v_info[0];
        ClusLogger.info("Violated by leaf: " + v_info[0] + " internal ML: " + v_info[1] + " (of " + violated + " total)");
        ClusSchema schema = this.getSchema();
        ClusAttrType[] attrs = schema.getDescriptiveAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            ClusAttrType at = attrs[i];
            if (!(at instanceof NumericAttrType)) {
                throw new ClusException("Unsupported descriptive attribute type: " + at.getName());
            }
            this.findNumericConstraints((NumericAttrType)at, leaf, use_p_lab, ss_offset, violated_offset, v_info[1], clusters);
        }
    }

    public void tryEachLeaf(ClusNode tree, ClusNode root, int violated, double ss, int[] clusters) throws ClusException {
        int nb_c = tree.getNbChildren();
        if (nb_c == 0) {
            ILevelCStatistic ps = (ILevelCStatistic)tree.getClusteringStat();
            int nbParLabel = this.countLabel(root, ps.getClusterID());
            this.tryGivenLeaf(tree, nbParLabel <= 1, violated, ss, clusters);
        } else {
            for (int i = 0; i < nb_c; ++i) {
                ClusNode child = (ClusNode)tree.getChild(i);
                this.tryEachLeaf(child, root, violated, ss, clusters);
            }
        }
    }

    public ILevelCHeurStat computeCHeurStat(ClusNode leaf, ClusNode par, int[] ie, int[] clusters) {
        RowData data = (RowData)leaf.getVisitor();
        ILevelCStatistic cs = (ILevelCStatistic)leaf.getClusteringStat();
        ILevelCHeurStat lstat = new ILevelCHeurStat(this.getSettings(), cs, this.m_NbClasses);
        lstat.setIndices(this.m_ConstraintsIndex, this.m_Constraints, ie, clusters);
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            lstat.updateWeighted(tuple, tuple.getWeight());
        }
        return lstat;
    }

    public int tryLabel(ILevelCHeurStat a, ILevelCHeurStat b, int parlabel, int nb) {
        int v1 = a.computeMinimumExtViolated(parlabel, -1, nb < this.m_MaxNbClasses);
        int label_a = a.getClusterID();
        if (label_a == -1) {
            ++nb;
        }
        int v2 = b.computeMinimumExtViolated(parlabel, label_a, nb < this.m_MaxNbClasses);
        return v1 == -1 || v2 == -1 ? -1 : v1 + v2;
    }

    public void assignLabels(ILevelCHeurStat a, ILevelCHeurStat b, ClusNode root, int parlabel, int nb) throws ClusException {
        int v1 = a.computeMinimumExtViolated(parlabel, -1, nb < this.m_MaxNbClasses);
        int label_a = a.getClusterID();
        if (label_a == -1) {
            ++nb;
            label_a = this.freeLabel(root, -1);
            this.m_NbClasses = Math.max(label_a + 1, this.m_NbClasses);
            a.setClusterID(label_a);
        }
        int v2 = b.computeMinimumExtViolated(parlabel, label_a, nb < this.m_MaxNbClasses);
        if (b.getClusterID() == -1) {
            int label_b = this.freeLabel(root, label_a);
            this.m_NbClasses = Math.max(label_b + 1, this.m_NbClasses);
            b.setClusterID(label_b);
        }
        if (v1 == -1 || v2 == -1) {
            throw new ClusException("Error: can't assign labels: v1 = " + v1 + " v2 = " + v2);
        }
    }

    public void storeLabels(ClusNode leaf, ILevelCHeurStat stat) {
        ILevelCStatistic cs = (ILevelCStatistic)leaf.getClusteringStat();
        ILevelCStatistic ts = (ILevelCStatistic)leaf.getTargetStat();
        cs.setClusterID(stat.getClusterID());
        ts.setClusterID(stat.getClusterID());
    }

    public void enterBestTest(ClusNode tree, ClusNode root, int[] clusters) throws ClusException {
        int nb_c = tree.getNbChildren();
        if (nb_c == 0) {
            if (tree == this.m_BestLeaf) {
                RowData data = (RowData)tree.getVisitor();
                tree.setTest(this.m_BestTest);
                int arity = tree.updateArity();
                NodeTest test = tree.getTest();
                for (int j = 0; j < arity; ++j) {
                    ClusNode child = new ClusNode();
                    tree.setChild(child, j);
                    RowData subset = data.applyWeighted(test, j);
                    child.initClusteringStat(this.getStatManager(), subset);
                    child.initTargetStat(this.getStatManager(), subset);
                    child.getTargetStat().calcMean();
                    child.setVisitor(subset);
                }
                int[] ie = this.createIE(data);
                ILevelCStatistic ps = (ILevelCStatistic)tree.getClusteringStat();
                ILevelCHeurStat left = this.computeCHeurStat((ClusNode)tree.getChild(0), tree, ie, clusters);
                ILevelCHeurStat right = this.computeCHeurStat((ClusNode)tree.getChild(1), tree, ie, clusters);
                int nbParLabel = this.countLabel(root, ps.getClusterID());
                int pLabel = -1;
                int nbLabels = this.m_NbClasses;
                if (nbParLabel <= 0) {
                    nbLabels = this.m_NbClasses - 1;
                    pLabel = ps.getClusterID();
                }
                int v1 = this.tryLabel(left, right, pLabel, nbLabels);
                int v2 = this.tryLabel(right, left, pLabel, nbLabels);
                if (v1 == -1 || v2 == -1) {
                    v1 = this.tryLabel(left, right, pLabel, nbLabels);
                    v2 = this.tryLabel(right, left, pLabel, nbLabels);
                }
                if (v1 <= v2 && v1 != -1 || v2 == -1) {
                    this.assignLabels(left, right, root, pLabel, nbLabels);
                } else {
                    this.assignLabels(right, left, root, pLabel, nbLabels);
                }
                this.storeLabels((ClusNode)tree.getChild(0), left);
                this.storeLabels((ClusNode)tree.getChild(1), right);
                tree.setVisitor(null);
            }
        } else {
            for (int i = 0; i < nb_c; ++i) {
                ClusNode child = (ClusNode)tree.getChild(i);
                this.enterBestTest(child, root, clusters);
            }
        }
    }

    public int freeLabel(ClusNode tree, int ignore) {
        boolean[] set = new boolean[this.m_NbClasses];
        this.labelSet(tree, set);
        for (int i = 0; i < set.length; ++i) {
            if (set[i] || i == ignore) continue;
            return i;
        }
        if (this.m_NbClasses < this.m_MaxNbClasses) {
            return this.m_NbClasses;
        }
        return -1;
    }

    public void labelSet(ClusNode tree, boolean[] set) {
        int nb_c = tree.getNbChildren();
        if (nb_c == 0) {
            ILevelCStatistic cs = (ILevelCStatistic)tree.getClusteringStat();
            if (cs.getClusterID() != -1) {
                set[cs.getClusterID()] = true;
            }
        } else {
            for (int i = 0; i < nb_c; ++i) {
                ClusNode child = (ClusNode)tree.getChild(i);
                this.labelSet(child, set);
            }
        }
    }

    public int countLabel(ClusNode tree, int label) {
        int nb_c = tree.getNbChildren();
        if (nb_c == 0) {
            ILevelCStatistic cs = (ILevelCStatistic)tree.getClusteringStat();
            return cs.getClusterID() == label ? 1 : 0;
        }
        int count = 0;
        for (int i = 0; i < nb_c; ++i) {
            ClusNode child = (ClusNode)tree.getChild(i);
            count += this.countLabel(child, label);
        }
        return count;
    }

    public void iLevelCInduce(ClusNode root) throws ClusException {
        double ss = root.estimateClusteringSS(this.m_Scale);
        int[] clusters = this.assignAllInstances(root);
        int violated = this.countViolatedConstaints(clusters);
        this.computeHeuristic(violated, ss);
        this.m_BestHeur = Double.POSITIVE_INFINITY;
        while (true) {
            this.m_BestTest = null;
            this.m_BestLeaf = null;
            this.tryEachLeaf(root, root, violated, ss, clusters);
            if (this.m_BestTest == null) {
                return;
            }
            this.enterBestTest(root, root, clusters);
            ClusLogger.info("Tree:");
            root.printTree();
            ss = root.estimateClusteringSS(this.m_Scale);
            clusters = this.assignAllInstances(root);
            violated = this.countViolatedConstaints(clusters);
            double heur = this.computeHeuristic(violated, ss);
            if (Math.abs(heur - this.m_BestHeur) > 1.0E-6) {
                throw new ClusException("Error: heuristic " + heur + " <> " + this.m_BestHeur);
            }
            ClusLogger.info("CHECK heuristic " + heur + " == " + this.m_BestHeur + " [OK]");
        }
    }

    public void assignAllInstances(ClusNode tree, int[] clusters) {
        int nb_c = tree.getNbChildren();
        if (nb_c == 0) {
            ILevelCStatistic stat = (ILevelCStatistic)tree.getClusteringStat();
            stat.assignInstances((RowData)tree.getVisitor(), clusters);
        }
        for (int i = 0; i < nb_c; ++i) {
            ClusNode child = (ClusNode)tree.getChild(i);
            this.assignAllInstances(child, clusters);
        }
    }

    public int[] assignAllInstances(ClusNode root) {
        int[] clusters = new int[this.m_NbTrain];
        this.assignAllInstances(root, clusters);
        return clusters;
    }

    public int[] countViolatedConstaints(RowData data, int[] clusters) {
        int violated = 0;
        int violated_internal = 0;
        int[] ie = this.createIE(data);
        ILevelConstraint[] constr = this.getSubsetConstraints(data);
        for (int i = 0; i < constr.length; ++i) {
            ILevelConstraint ic = constr[i];
            int type = ic.getType();
            int t1 = ic.getT1().getIndex();
            int t2 = ic.getT2().getIndex();
            if (type == 0) {
                if (clusters[t1] == clusters[t2]) continue;
                ++violated;
                continue;
            }
            if (clusters[t1] != clusters[t2]) continue;
            ++violated;
            if (ie[t1] == 0 || ie[t2] == 0) continue;
            ++violated_internal;
        }
        int[] result = new int[]{violated, violated_internal};
        return result;
    }

    public int countViolatedConstaints(int[] clusters) {
        int violated = 0;
        for (int i = 0; i < this.m_Constraints.size(); ++i) {
            ILevelConstraint ic = this.m_Constraints.get(i);
            int type = ic.getType();
            int t1 = ic.getT1().getIndex();
            int t2 = ic.getT2().getIndex();
            if (type == 0) {
                if (clusters[t1] == clusters[t2]) continue;
                ++violated;
                continue;
            }
            if (clusters[t1] != clusters[t2]) continue;
            ++violated;
        }
        return violated;
    }

    public ArrayList<ILevelConstraint> createConstraints(RowData data, int nbRows) {
        ArrayList<ILevelConstraint> constr = new ArrayList<ILevelConstraint>();
        ClusAttrType type = this.getSchema().getAttrType(this.getSchema().getNbAttributes() - 1);
        if (type.getAttributeType().equals((Object)ClusAttrType.AttributeType.Nominal)) {
            NominalAttrType cls = (NominalAttrType)type;
            this.m_MaxNbClasses = cls.getNbValues();
            int nbConstraints = this.getSettings().getILevelC().getILevelCNbRandomConstraints();
            for (int i = 0; i < nbConstraints; ++i) {
                int t1i = ClusRandom.nextInt(4, nbRows);
                int t2i = ClusRandom.nextInt(4, nbRows);
                DataTuple t1 = data.getTuple(t1i);
                DataTuple t2 = data.getTuple(t2i);
                if (cls.getNominal(t1) == cls.getNominal(t2)) {
                    constr.add(new ILevelConstraint(t1, t2, 0));
                    continue;
                }
                constr.add(new ILevelConstraint(t1, t2, 1));
            }
        }
        return constr;
    }

    @Override
    public ClusModel induceSingleUnpruned(ClusRun cr) throws ClusException, IOException, InterruptedException {
        this.m_NbClasses = 1;
        ClusRandom.reset(4);
        RowData data = (RowData)cr.getTrainingSet();
        int nbTrain = data.getNbRows();
        RowData test = cr.getTestSet();
        if (test != null) {
            ArrayList<DataTuple> allData = new ArrayList<DataTuple>();
            data.addTo(allData);
            test.addTo(allData);
            data = new RowData(allData, data.getSchema());
        }
        ClusLogger.info("All data: " + data.getNbRows());
        data.addIndices();
        this.m_NbTrain = data.getNbRows();
        this.m_MinLeafWeight = this.getSettings().getModel().getMinimalWeight();
        ArrayList<DataTuple> points = data.toArrayList();
        if (this.getSettings().getILevelC().hasILevelCFile()) {
            String fname = this.getSettings().getILevelC().getILevelCFile();
            this.m_Constraints = ILevelConstraint.loadConstraints(fname, points);
        } else {
            this.m_Constraints = this.createConstraints(data, nbTrain);
        }
        if (this.getSettings().getILevelC().isILevelCCOPKMeans()) {
            COPKMeans km = new COPKMeans(this.m_MaxNbClasses, this.getStatManager());
            COPKMeansModel model = null;
            int sumIter = 0;
            for (int i = 0; i < 100000; ++i) {
                model = (COPKMeansModel)km.induce(data, this.m_Constraints);
                sumIter = Math.max(sumIter, model.getIterations());
                model.setCSets(i + 1);
                model.setAvgIter(sumIter);
                if (!model.isIllegal()) {
                    return model;
                }
                this.m_Constraints = this.createConstraints(data, nbTrain);
            }
            return model;
        }
        if (this.getSettings().getILevelC().isILevelCMPCKMeans()) {
            MPCKMeansWrapper wrap = new MPCKMeansWrapper(this.getStatManager());
            return wrap.induce(data, test, this.m_Constraints, this.m_MaxNbClasses);
        }
        DerivedConstraintsComputer comp = new DerivedConstraintsComputer(points, this.m_Constraints);
        comp.compute();
        this.m_ConstraintsIndex = this.createConstraintsIndex();
        ClusLogger.info("Number of instance level constraints: " + this.m_Constraints.size());
        ClusNode root = new ClusNode();
        root.initClusteringStat(this.m_StatManager, data);
        root.initTargetStat(this.m_StatManager, data);
        root.setVisitor(data);
        ILevelCStatistic ilevels = (ILevelCStatistic)root.getClusteringStat();
        ilevels.setClusterID(0);
        this.m_Scale = (ClusNormalizedAttributeWeights)this.getStatManager().getClusteringWeights();
        this.m_GlobalSS = ilevels.getSVarS(this.m_Scale);
        ClusLogger.info("Global SS: " + this.m_GlobalSS);
        this.initSelectorAndSplit(root.getClusteringStat());
        this.iLevelCInduce(root);
        root.afterInduce(null);
        this.cleanSplit();
        return root;
    }
}

