/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ilevelc;

import java.util.ArrayList;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.ext.ilevelc.ILevelCStatistic;
import si.ijs.kt.clus.ext.ilevelc.ILevelConstraint;
import si.ijs.kt.clus.main.settings.Settings;

public class ILevelCHeurStat
extends ILevelCStatistic {
    public static final long serialVersionUID = 1L;
    public static final int EXT = 0;
    public static final int POS = 1;
    public static final int NEG = 2;
    protected int m_NbClass;
    protected ArrayList m_Constraints;
    protected int[][] m_ConstraintIndex;
    protected int[] m_IE;
    protected int[] m_Clusters;
    protected int[] m_CL;
    protected int[] m_ML;

    public ILevelCHeurStat(Settings sett, ILevelCStatistic stat, int nbclass) {
        super(sett, stat.m_Numeric);
        this.m_NbClass = nbclass;
        this.m_CL = new int[nbclass];
        this.m_ML = new int[nbclass];
    }

    @Override
    public void updateWeighted(DataTuple tuple, double weight) {
        super.updateWeighted(tuple, weight);
        int tidx = tuple.getIndex();
        int[] cidx = this.m_ConstraintIndex[tidx];
        if (cidx == null) {
            return;
        }
        for (int i = 0; i < cidx.length; ++i) {
            ILevelConstraint cons = (ILevelConstraint)this.m_Constraints.get(cidx[i]);
            int otidx = cons.getOtherTupleIdx(tuple);
            if (this.m_IE[otidx] != 0) continue;
            int oclass = this.m_Clusters[otidx];
            if (cons.getType() == 0) {
                int n = oclass;
                this.m_ML[n] = this.m_ML[n] + 1;
                continue;
            }
            int n = oclass;
            this.m_CL[n] = this.m_CL[n] + 1;
        }
    }

    public void removeWeighted(DataTuple tuple, double weight) {
        super.updateWeighted(tuple, -1.0 * weight);
        int tidx = tuple.getIndex();
        int[] cidx = this.m_ConstraintIndex[tidx];
        if (cidx == null) {
            return;
        }
        for (int i = 0; i < cidx.length; ++i) {
            ILevelConstraint cons = (ILevelConstraint)this.m_Constraints.get(cidx[i]);
            int otidx = cons.getOtherTupleIdx(tuple);
            if (this.m_IE[otidx] != 0) continue;
            int oclass = this.m_Clusters[otidx];
            if (cons.getType() == 0) {
                int n = oclass;
                this.m_ML[n] = this.m_ML[n] - 1;
                continue;
            }
            int n = oclass;
            this.m_CL[n] = this.m_CL[n] - 1;
        }
    }

    public void setIndices(int[][] considx, ArrayList constr, int[] ie, int[] clusters) {
        this.m_IE = ie;
        this.m_Constraints = constr;
        this.m_ConstraintIndex = considx;
        this.m_Clusters = clusters;
    }

    public int computeMinimumExtViolated(int ig1, int ig2, boolean allownew) {
        int totalml = 0;
        for (int i = 0; i < this.m_NbClass; ++i) {
            totalml += this.m_ML[i];
        }
        int best = -2;
        int bestviolated = Integer.MAX_VALUE;
        for (int i = 0; i < this.m_NbClass; ++i) {
            int violated;
            if (i == ig1 || i == ig2 || this.m_ML[i] <= 0 || (violated = this.m_CL[i] + (totalml - this.m_ML[i])) >= bestviolated) continue;
            bestviolated = violated;
            best = i;
        }
        if (allownew && totalml < bestviolated) {
            bestviolated = totalml;
            best = -1;
        }
        this.setClusterID(best);
        return best == -2 ? -1 : bestviolated;
    }
}

