/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ilevelc;

import java.util.ArrayList;
import java.util.HashSet;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.ext.ilevelc.ILevelConstraint;
import si.ijs.kt.clus.util.jeans.util.DisjointSetForest;

public class DerivedConstraintsComputer {
    public ArrayList m_Points;
    public ArrayList<ILevelConstraint> m_Constraints;

    public DerivedConstraintsComputer(ArrayList points, ArrayList<ILevelConstraint> constr) {
        this.m_Points = points;
        this.m_Constraints = constr;
    }

    public void compute() {
        this.indexPoints();
        DisjointSetForest dsf = this.createDSFWithMustLinks();
        ArrayList[] comps = this.assignPointsToComponents(dsf);
        HashSet<int[]> set = this.createCannotLinkSet(dsf);
        this.m_Constraints.clear();
        this.addTransitiveClosureOfMustLinks(comps);
        this.addCannotLinkConstraints(set, comps);
    }

    public DisjointSetForest createDSFWithMustLinks() {
        DisjointSetForest dsf = new DisjointSetForest(this.m_Points.size());
        dsf.makeSets(this.m_Points.size());
        for (int i = 0; i < this.m_Constraints.size(); ++i) {
            ILevelConstraint ic = this.m_Constraints.get(i);
            int type = ic.getType();
            if (type != 0) continue;
            int t1 = ic.getT1().getIndex();
            int t2 = ic.getT2().getIndex();
            dsf.union(t1, t2);
        }
        return dsf;
    }

    public ArrayList[] assignPointsToComponents(DisjointSetForest dsf) {
        int i;
        int nbComps = dsf.numberComponents();
        ArrayList[] comps = new ArrayList[nbComps];
        for (i = 0; i < nbComps; ++i) {
            comps[i] = new ArrayList();
        }
        for (i = 0; i < this.m_Points.size(); ++i) {
            comps[dsf.getComponent(i)].add(this.m_Points.get(i));
        }
        return comps;
    }

    public HashSet<int[]> createCannotLinkSet(DisjointSetForest dsf) {
        HashSet<int[]> set = new HashSet<int[]>();
        for (int i = 0; i < this.m_Constraints.size(); ++i) {
            ILevelConstraint ic = this.m_Constraints.get(i);
            int type = ic.getType();
            if (type != 1) continue;
            int c1 = dsf.getComponent(ic.getT1().getIndex());
            int c2 = dsf.getComponent(ic.getT2().getIndex());
            set.add(this.makeEdge(c1, c2));
        }
        return set;
    }

    public void addTransitiveClosureOfMustLinks(ArrayList<DataTuple>[] comps) {
        for (int i = 0; i < comps.length; ++i) {
            ArrayList<DataTuple> compcomps = comps[i];
            for (int j = 0; j < compcomps.size(); ++j) {
                DataTuple tj = compcomps.get(j);
                for (int k = j + 1; k < compcomps.size(); ++k) {
                    DataTuple tk = compcomps.get(k);
                    this.m_Constraints.add(new ILevelConstraint(tj, tk, 0));
                }
            }
        }
    }

    public void addCannotLinkConstraints(HashSet set, ArrayList[] comps) {
        for (int[] edge : set) {
            ArrayList comp1 = comps[edge[0]];
            ArrayList comp2 = comps[edge[1]];
            for (int j = 0; j < comp1.size(); ++j) {
                DataTuple tj = (DataTuple)comp1.get(j);
                for (int k = 0; k < comp2.size(); ++k) {
                    DataTuple tk = (DataTuple)comp2.get(k);
                    this.m_Constraints.add(new ILevelConstraint(tj, tk, 1));
                }
            }
        }
    }

    public int[] makeEdge(int i1, int i2) {
        return new int[]{Math.min(i1, i2), Math.max(i1, i2)};
    }

    public void indexPoints() {
        for (int i = 0; i < this.m_Points.size(); ++i) {
            DataTuple tuple = (DataTuple)this.m_Points.get(i);
            tuple.setIndex(i);
        }
    }
}

