/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ilevelc;

import java.io.PrintWriter;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.ext.ilevelc.COPKMeansCluster;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;

public class COPKMeansModel
extends ClusNode {
    public static final long serialVersionUID = 1L;
    protected int m_K;
    protected int m_Iterations;
    protected int m_CSets;
    protected int m_AvgIter;
    protected boolean m_Illegal;
    protected double m_RandIndex;
    protected COPKMeansCluster[] m_Clusters;

    public void setK(int k) {
        this.m_K = k;
    }

    @Override
    public int getModelSize() {
        return this.m_K;
    }

    @Override
    public ClusStatistic predictWeighted(DataTuple tuple) {
        if (this.m_Illegal) {
            return null;
        }
        int best_cl = -1;
        double min_dist = Double.POSITIVE_INFINITY;
        for (int j = 0; j < this.m_K; ++j) {
            double dist = this.m_Clusters[j].computeDistance(tuple);
            if (!(dist < min_dist)) continue;
            best_cl = j;
            min_dist = dist;
        }
        return this.m_Clusters[best_cl].getCenter();
    }

    @Override
    public void printModel(PrintWriter wrt, StatisticPrintInfo info) {
        wrt.println("COPKMeans(" + this.m_K + ", iter = " + this.m_Iterations + ", max = " + this.m_AvgIter + ", csets = " + this.m_CSets + ")");
        if (this.m_Illegal) {
            wrt.println("   Illegal");
        } else {
            for (int j = 0; j < this.m_K; ++j) {
                wrt.println("  " + this.m_Clusters[j].getCenter().getString(info));
            }
        }
    }

    @Override
    public String getModelInfo() {
        if (this.m_Illegal) {
            return "Rand Index = ?";
        }
        return "Rand Index = " + this.m_RandIndex;
    }

    public void setCSets(int sets) {
        this.m_CSets = sets;
    }

    public int getCSets() {
        return this.m_CSets;
    }

    public void setAvgIter(int avg) {
        this.m_AvgIter = avg;
    }

    public void setIllegal(boolean illegal) {
        this.m_Illegal = illegal;
    }

    public void setRandIndex(double value) {
        this.m_RandIndex = value;
    }

    public void setClusters(COPKMeansCluster[] clusters) {
        this.m_Clusters = clusters;
    }

    public void setIterations(int i) {
        this.m_Iterations = i;
    }

    public int getIterations() {
        return this.m_Iterations;
    }

    public boolean isIllegal() {
        return this.m_Illegal;
    }
}

