/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.hierarchicalmtr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ClusHMTRNode
implements Serializable {
    private boolean isRoot;
    private String name;
    private boolean isAggregate;
    private List<ClusHMTRNode> children;

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public void setAggregate(boolean aggregate) {
        this.isAggregate = aggregate;
    }

    public String getName() {
        return this.name;
    }

    public List<ClusHMTRNode> getChildren() {
        return this.children;
    }

    public int getNumberOfChildren() {
        return this.getChildren().size();
    }

    public void addChild(ClusHMTRNode child) {
        this.children.add(child);
    }

    public boolean hasChildren() {
        return this.getChildren().size() > 0;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public ClusHMTRNode(boolean isRoot, String name) {
        this.isRoot = isRoot;
        this.name = name;
        this.children = new ArrayList<ClusHMTRNode>();
        this.isAggregate = false;
    }

    public ClusHMTRNode(String name) {
        this.isRoot = false;
        this.name = name;
        this.children = new ArrayList<ClusHMTRNode>();
        this.isAggregate = false;
    }

    public String printNodeAndChildren() {
        String childrenConcat = "";
        int i = 1;
        for (ClusHMTRNode child : this.getChildren()) {
            childrenConcat = childrenConcat + "Child " + i + ": \"" + child.getName() + "\" ";
            ++i;
        }
        return "Node name: \"" + this.getName() + "\" " + childrenConcat;
    }
}

