/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.hierarchicalmtr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import si.ijs.kt.clus.ext.hierarchicalmtr.ClusHMTRNode;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.util.ClusLogger;

public class ClusHMTRHierarchy {
    private boolean m_IsUsingDump = false;
    private List<ClusHMTRNode> m_Nodes = new ArrayList<ClusHMTRNode>();
    private Map<String, Integer> m_NodeDepth;
    private Map<String, Double> m_NodeWeights;

    public ClusHMTRHierarchy(String hierarchyName) {
    }

    public ClusHMTRHierarchy() {
        this("default");
    }

    public boolean isUsingDump() {
        return this.m_IsUsingDump;
    }

    public void setIsUsingDump(boolean isUsingDump) {
        this.m_IsUsingDump = isUsingDump;
    }

    public List<ClusHMTRNode> getNodes() {
        return this.m_Nodes;
    }

    private void calculateDepth() {
        this.m_NodeDepth = new HashMap<String, Integer>();
        for (ClusHMTRNode node : this.m_Nodes) {
            this.m_NodeDepth.put(node.getName(), this.getNodeDepth(node.getName()));
        }
    }

    public void printDepth() {
        for (Map.Entry<String, Integer> entry : this.m_NodeDepth.entrySet()) {
            ClusLogger.info("Attribute: " + entry.getKey() + ", depth: " + entry.getValue());
        }
    }

    public void printWeights() {
        for (Map.Entry<String, Double> entry : this.m_NodeWeights.entrySet()) {
            ClusLogger.info("Attribute: " + entry.getKey() + ", weight: " + entry.getValue());
        }
    }

    public void initialize(Settings sett) {
        String hier = sett.getHMTR().getHMTRHierarchyString();
        double weight = sett.getHMTR().getHMTRHierarchyWeight().getValue();
        hier = hier.replace("(", "").replace(")", "").replace(" ", "").replace(">", "");
        String[] relationships = hier.split(",");
        boolean root = true;
        for (String relationship : relationships) {
            String[] pcr = relationship.split("-");
            if (root) {
                this.m_Nodes.add(new ClusHMTRNode(true, pcr[0]));
            }
            root = false;
            if (!this.nodeExists(pcr[0])) {
                this.m_Nodes.add(new ClusHMTRNode(pcr[0]));
            }
            if (!this.nodeExists(pcr[1])) {
                this.m_Nodes.add(new ClusHMTRNode(pcr[1]));
            }
            this.getNode(pcr[0]).addChild(this.getNode(pcr[1]));
        }
        this.calculateDepth();
        this.calculateWeights(weight);
        sett.getHMTR().setSectionHMTREnabled(true);
    }

    public double getWeight(String name) {
        return this.m_NodeWeights.get(name);
    }

    public List<ClusHMTRNode> getParents(ClusHMTRNode node) {
        ArrayList<ClusHMTRNode> parents = new ArrayList<ClusHMTRNode>();
        for (ClusHMTRNode aNode : this.m_Nodes) {
            if (!aNode.getChildren().contains(node)) continue;
            parents.add(aNode);
        }
        return parents;
    }

    public boolean hasParents(ClusHMTRNode node) {
        return this.getParents(node).size() > 0;
    }

    public void printHierarchy() {
        ClusLogger.info("Hiearchy: ");
        for (ClusHMTRNode node : this.m_Nodes) {
            ClusLogger.info(node.printNodeAndChildren());
            List<ClusHMTRNode> parents = this.getParents(node);
            System.out.print("Node parents: ");
            for (ClusHMTRNode parent : parents) {
                System.out.print("\"" + parent.getName() + "\" ");
            }
            ClusLogger.info();
        }
        ClusLogger.info();
    }

    public String printHierarchyTree(ClusHMTRNode node) {
        int indent = 0;
        StringBuilder sb = new StringBuilder();
        this.printHierarchyTree(node, indent, sb);
        return sb.toString();
    }

    public String printHierarchyTree() {
        for (ClusHMTRNode n : this.getNodes()) {
            if (!n.isRoot()) continue;
            return this.printHierarchyTree(n);
        }
        return "";
    }

    private void printHierarchyTree(ClusHMTRNode node, int indent, StringBuilder sb) {
        sb.append(this.getIndentString(indent));
        if (this.hasParents(node)) {
            sb.append(this.getHorizontalLineText());
        }
        sb.append(node.getName());
        sb.append(System.lineSeparator());
        for (ClusHMTRNode n : node.getChildren()) {
            this.printHierarchyTree(n, indent + 1, sb);
        }
    }

    private String getIndentString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < indent; ++i) {
            sb.append(this.getVerticalLineText());
        }
        return sb.toString();
    }

    private int getNodeDepth(String nodeName) {
        return this.getNodeDepth(nodeName, 0);
    }

    private int getNodeDepth(String nodeName, int currentDepth) {
        ClusHMTRNode node = this.getNode(nodeName);
        if (node.isRoot()) {
            return currentDepth;
        }
        List<ClusHMTRNode> parents = this.getParents(node);
        int depth = Integer.MAX_VALUE;
        for (ClusHMTRNode parent : parents) {
            int parDepth = this.getNodeDepth(parent.getName(), currentDepth + 1);
            if (parDepth >= depth) continue;
            depth = parDepth;
        }
        if (depth == Integer.MAX_VALUE) {
            try {
                throw new IOException("Depth for " + node.getName() + " was not calculated!");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return depth;
    }

    private ClusHMTRNode getNode(String nodeName) {
        for (ClusHMTRNode node : this.getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    private boolean nodeExists(String name) {
        for (ClusHMTRNode node : this.getNodes()) {
            if (!node.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void calculateWeights(double weight) {
        if (weight > 1.0 || weight < 0.1) {
            System.err.println("Weird initialisation of HMTR weight! Weight = " + weight + "\nTypical weights: 0.75, 0.8333 etc.\nWeight 1 = pure MTR (not taking the hierarchy into account)\nSmaller values = more influence on the upper levels of the hierarchy\nProgram will continue anyways...");
        }
        this.m_NodeWeights = new HashMap<String, Double>();
        for (Map.Entry<String, Integer> entry : this.m_NodeDepth.entrySet()) {
            this.m_NodeWeights.put(entry.getKey(), Math.pow(weight, entry.getValue().intValue()));
        }
    }

    private String getVerticalLineText() {
        return "|" + this.getSpaces();
    }

    private String getHorizontalLineText() {
        String corner = "+";
        String dash = "-";
        return corner + dash + dash + " ";
    }

    private String getSpaces(int howmany) {
        StringBuilder sb = new StringBuilder(howmany);
        for (int i = 0; i < howmany; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private String getSpaces() {
        return this.getSpaces(5);
    }
}

