/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.hierarchical;

import java.util.ArrayList;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassTerm;
import si.ijs.kt.clus.main.settings.section.SettingsHMLC;

public class HierNodeWeights {
    double[] m_Weights;
    String m_Name;

    public final double getWeight(int nodeidx) {
        return this.m_Weights[nodeidx];
    }

    public final double[] getWeights() {
        return this.m_Weights;
    }

    public final String getName() {
        return this.m_Name;
    }

    public boolean allParentsOk(ClassTerm term, boolean[] computed) {
        for (int j = 0; j < term.getNbParents(); ++j) {
            ClassTerm parent = term.getParent(j);
            if (parent.getIndex() == -1 || computed[parent.getIndex()]) continue;
            return false;
        }
        return true;
    }

    public void initExponentialDepthWeightsDAG(ClassHierarchy hier, SettingsHMLC.HierarchyWeight wtype, double w0) {
        double rootWeight = 1.0 / w0;
        boolean[] weight_computed = new boolean[hier.getTotal()];
        ArrayList<ClassTerm> todo = new ArrayList<ClassTerm>();
        for (int i = 0; i < hier.getTotal(); ++i) {
            ClassTerm term = hier.getTermAt(i);
            todo.add(term);
        }
        int nb_done = 0;
        while (nb_done < hier.getTotal()) {
            for (int i = todo.size() - 1; i >= 0; --i) {
                ClassTerm parent;
                int j;
                double agg_wi;
                ClassTerm term = (ClassTerm)todo.get(i);
                if (!this.allParentsOk(term, weight_computed)) continue;
                int maxDepth = 0;
                int minDepth = Integer.MAX_VALUE;
                for (int j2 = 0; j2 < term.getNbParents(); ++j2) {
                    ClassTerm parent2 = term.getParent(j2);
                    maxDepth = Math.max(maxDepth, parent2.getMaxDepth() + 1);
                    minDepth = Math.min(minDepth, parent2.getMinDepth() + 1);
                }
                term.setMinDepth(minDepth);
                term.setMaxDepth(maxDepth);
                if (wtype.equals((Object)SettingsHMLC.HierarchyWeight.ExpMinParentWeight)) {
                    agg_wi = Double.MAX_VALUE;
                    for (j = 0; j < term.getNbParents(); ++j) {
                        parent = term.getParent(j);
                        agg_wi = parent.getIndex() == -1 ? Math.min(agg_wi, rootWeight) : Math.min(agg_wi, this.m_Weights[parent.getIndex()]);
                    }
                } else if (wtype.equals((Object)SettingsHMLC.HierarchyWeight.ExpMaxParentWeight)) {
                    agg_wi = Double.MIN_VALUE;
                    for (j = 0; j < term.getNbParents(); ++j) {
                        parent = term.getParent(j);
                        agg_wi = parent.getIndex() == -1 ? Math.max(agg_wi, rootWeight) : Math.max(agg_wi, this.m_Weights[parent.getIndex()]);
                    }
                } else {
                    agg_wi = 0.0;
                    for (j = 0; j < term.getNbParents(); ++j) {
                        parent = term.getParent(j);
                        if (parent.getIndex() == -1) {
                            agg_wi += rootWeight;
                            continue;
                        }
                        agg_wi += this.m_Weights[parent.getIndex()];
                    }
                    if (wtype.equals((Object)SettingsHMLC.HierarchyWeight.ExpAvgParentWeight)) {
                        agg_wi /= (double)term.getNbParents();
                    }
                }
                this.m_Weights[term.getIndex()] = w0 * agg_wi;
                weight_computed[term.getIndex()] = true;
                todo.remove(i);
                ++nb_done;
            }
        }
    }

    public void initExponentialDepthWeightsRec(ClassTerm node, int depth, double w0) {
        for (int i = 0; i < node.getNbChildren(); ++i) {
            ClassTerm child = (ClassTerm)node.getChild(i);
            child.setMinDepth(depth);
            child.setMaxDepth(depth);
            this.m_Weights[child.getIndex()] = HierNodeWeights.calcExponentialDepthWeight(depth, w0);
            this.initExponentialDepthWeightsRec(child, depth + 1, w0);
        }
    }

    public void initNoWeights(ClassHierarchy hier) {
        boolean[] weight_computed = new boolean[hier.getTotal()];
        ArrayList<ClassTerm> todo = new ArrayList<ClassTerm>();
        for (int i = 0; i < hier.getTotal(); ++i) {
            ClassTerm term = hier.getTermAt(i);
            todo.add(term);
        }
        int nb_done = 0;
        while (nb_done < hier.getTotal()) {
            for (int i = todo.size() - 1; i >= 0; --i) {
                ClassTerm term = (ClassTerm)todo.get(i);
                if (!this.allParentsOk(term, weight_computed)) continue;
                int maxDepth = 0;
                int minDepth = Integer.MAX_VALUE;
                for (int j = 0; j < term.getNbParents(); ++j) {
                    ClassTerm parent = term.getParent(j);
                    maxDepth = Math.max(maxDepth, parent.getMaxDepth() + 1);
                    minDepth = Math.min(minDepth, parent.getMinDepth() + 1);
                }
                term.setMinDepth(minDepth);
                term.setMaxDepth(maxDepth);
                this.m_Weights[term.getIndex()] = 1.0;
                weight_computed[term.getIndex()] = true;
                todo.remove(i);
                ++nb_done;
            }
        }
    }

    public void initExponentialDepthWeights(ClassHierarchy hier, SettingsHMLC.HierarchyWeight wtype, double w0) {
        this.m_Weights = new double[hier.getTotal()];
        if (wtype.equals((Object)SettingsHMLC.HierarchyWeight.NoWeight)) {
            this.initNoWeights(hier);
        } else {
            ClassTerm root = hier.getRoot();
            if (hier.isTree()) {
                this.initExponentialDepthWeightsRec(root, 0, w0);
                this.m_Name = "Exponential depth weights (tree) " + w0;
            } else {
                root.setMinDepth(-1);
                root.setMaxDepth(-1);
                this.initExponentialDepthWeightsDAG(hier, wtype, w0);
                this.m_Name = "Exponential depth weights (DAG) " + w0;
            }
        }
    }

    private static final double calcExponentialDepthWeight(int depth, double w0) {
        return Math.pow(w0, depth);
    }
}

