/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.hierarchical;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassTerm;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.jeans.util.StringUtils;
import si.ijs.kt.clus.util.jeans.util.array.StringTable;

public class HierIO {
    public static final int TAB_SIZE = 8;
    protected StringTable m_Stab = new StringTable();

    public ClassHierarchy readHierarchy(String fname) throws IOException, ClusException {
        HierIOReader rdr = new HierIOReader(fname);
        ClassHierarchy hier = new ClassHierarchy();
        rdr.readHierarchy(hier.getRoot(), 0);
        return hier;
    }

    public StringTable getTable() {
        return this.m_Stab;
    }

    public static int getDepth(String line) {
        int spc = 0;
        int tab = 0;
        int len = line.length();
        for (int idx = 0; idx < len && (line.charAt(idx) == ' ' || line.charAt(idx) == '\t'); ++idx) {
            if (line.charAt(idx) == ' ') {
                ++spc;
            }
            if (line.charAt(idx) != '\t') continue;
            ++tab;
        }
        return spc / 8 + tab;
    }

    public String getID(String line) {
        String id = StringUtils.trimSpacesAndTabs(line);
        return this.m_Stab.get(id);
    }

    public static void writePrologTerm(ClassTerm term, PrintWriter writer) {
        String prologID = StringUtils.removeChar(term.getID(), '\'');
        writer.print("node('" + prologID + "',[");
        for (int i = 0; i < term.getNbChildren(); ++i) {
            if (i != 0) {
                writer.print(",");
            }
            ClassTerm subterm = (ClassTerm)term.getChild(i);
            HierIO.writePrologTerm(subterm, writer);
        }
        writer.print("])");
    }

    public static boolean hasActiveChild(ClassTerm term, boolean[] bits) {
        for (int i = 0; i < term.getNbChildren(); ++i) {
            ClassTerm child = (ClassTerm)term.getChild(i);
            if (!bits[child.getIndex()]) continue;
            return true;
        }
        return false;
    }

    public static void writePrologTerm(ClassTerm term, boolean[] bits, PrintWriter writer) {
        writer.print("node([");
        for (int i = 0; i < term.getNbChildren(); ++i) {
            ClassTerm subterm;
            if (i != 0) {
                writer.print(",");
            }
            if (bits[(subterm = (ClassTerm)term.getChild(i)).getIndex()]) {
                if (HierIO.hasActiveChild(subterm, bits)) {
                    HierIO.writePrologTerm(subterm, bits, writer);
                    continue;
                }
                writer.print("1");
                continue;
            }
            writer.print("0");
        }
        writer.print("])");
    }

    public static void writePrologGraph(String name, ClassTerm term, PrintWriter writer) {
        ClassTerm subterm;
        int i;
        String prologID = StringUtils.removeChar(term.getID(), '\'');
        writer.println(name + "_name(" + term.getIndex() + ",'" + prologID + "').");
        writer.print(name + "_children(" + term.getIndex() + ",[");
        for (i = 0; i < term.getNbChildren(); ++i) {
            if (i != 0) {
                writer.print(",");
            }
            subterm = (ClassTerm)term.getChild(i);
            writer.print(subterm.getIndex());
        }
        writer.println("]).");
        for (i = 0; i < term.getNbChildren(); ++i) {
            subterm = (ClassTerm)term.getChild(i);
            writer.println(name + "_child(" + term.getIndex() + "," + subterm.getIndex() + ").");
        }
        writer.println();
        for (i = 0; i < term.getNbChildren(); ++i) {
            subterm = (ClassTerm)term.getChild(i);
            HierIO.writePrologGraph(name, subterm, writer);
        }
    }

    public void writeHierarchy(ClassTerm term) {
        this.writeHierarchy(term, ClusFormat.OUT_WRITER);
        ClusFormat.OUT_WRITER.flush();
    }

    public void writeHierarchy(ClassTerm term, PrintWriter writer) {
        this.writeHierarchy(0, term, writer);
        writer.flush();
    }

    public void writeHierarchy(int tabs, ClassTerm term, PrintWriter writer) {
        for (int i = 0; i < term.getNbChildren(); ++i) {
            ClassTerm subterm = (ClassTerm)term.getChild(i);
            writer.print(StringUtils.makeString('\t', tabs) + subterm.getID());
            writer.println();
            this.writeHierarchy(tabs + 1, subterm, writer);
        }
    }

    private class HierIOReader {
        protected LineNumberReader m_Reader;
        protected String m_LastLine;

        public HierIOReader(String fname) throws IOException {
            this.m_Reader = new LineNumberReader(new InputStreamReader(new FileInputStream(fname)));
            this.m_LastLine = null;
        }

        public void readHierarchy(ClassTerm parent, int depth) throws IOException, ClusException {
            ClassTerm child = null;
            String line = this.getLine();
            while (line != null) {
                int mydepth = HierIO.getDepth(line);
                if (mydepth == depth) {
                    String id = HierIO.this.getID(line);
                    child = new ClassTerm(id);
                    child.addParent(parent);
                    parent.addChild(child);
                } else {
                    this.setLastLine(line);
                    if (mydepth < depth) {
                        return;
                    }
                    if (mydepth > depth + 1) {
                        throw new ClusException("Jump to big in hierarchy");
                    }
                    if (child == null) {
                        throw new ClusException("Term has no parent");
                    }
                    this.readHierarchy(child, depth + 1);
                }
                line = this.getLine();
            }
        }

        public String getLine() throws IOException {
            if (this.m_LastLine != null) {
                String result = this.m_LastLine;
                this.clearLastLine();
                return result;
            }
            return this.m_Reader.readLine();
        }

        public void setLastLine(String line) {
            this.m_LastLine = line;
        }

        public void clearLastLine() {
            this.m_LastLine = null;
        }
    }
}

