/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.hierarchical;

import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.pruning.PruneTree;
import si.ijs.kt.clus.statistic.WHTDStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public class HierClassTresholdPruner
extends PruneTree {
    protected double[] m_Thresholds;

    public HierClassTresholdPruner(double[] tresholds) {
        this.m_Thresholds = tresholds;
    }

    @Override
    public void prune(ClusNode node) throws ClusException {
        this.prune(0, node);
    }

    @Override
    public int getNbResults() {
        return this.m_Thresholds.length;
    }

    @Override
    public String getPrunedName(int i) {
        return "T(" + this.m_Thresholds[i] + ")";
    }

    public double getThreshold(int i) {
        return this.m_Thresholds[i];
    }

    @Override
    public void updatePrunedModelInfo(ClusModelInfo info) {
        info.setShouldWritePredictions(false);
    }

    @Override
    public void prune(int result, ClusNode node) throws ClusException {
        this.pruneRecursive(node, this.m_Thresholds[result]);
    }

    public void pruneRecursive(ClusNode node, double threshold) throws ClusException {
        WHTDStatistic stat = (WHTDStatistic)node.getTargetStat();
        WHTDStatistic new_stat = (WHTDStatistic)stat.cloneStat();
        new_stat.copyAll(stat);
        new_stat.setThreshold(threshold);
        new_stat.calcMean();
        node.setTargetStat(new_stat);
        for (int i = 0; i < node.getNbChildren(); ++i) {
            this.pruneRecursive((ClusNode)node.getChild(i), threshold);
        }
    }
}

