/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.hierarchical;

import java.io.Serializable;
import java.util.StringTokenizer;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassTerm;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.array.StringTable;

public class ClassesValue
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static String HIERARCY_SEPARATOR = "/";
    public static String ABUNDANCE_SEPARATOR = ":";
    public static String EMPTY_SET_INDICATOR = "?";
    public static final int NO_ABUNDANCE = 0;
    public static final int PATH_ABUNDANCE = 1;
    public static final int NODE_ABUNDANCE = 2;
    protected String[] m_Path;
    protected boolean m_Intermediate;
    protected double m_Abundance = 1.0;
    protected ClassTerm m_ClassTerm;

    public ClassesValue(String constr, StringTable table) throws ClusException {
        StringTokenizer tokens = new StringTokenizer(constr, HIERARCY_SEPARATOR + ABUNDANCE_SEPARATOR);
        int plen = tokens.countTokens();
        this.m_Path = new String[plen];
        if (plen == 0) {
            throw new ClusException("Path length should be >= 1");
        }
        int idx = 0;
        while (tokens.hasMoreTokens()) {
            String st = table.get(tokens.nextToken());
            if (st.equals("0")) {
                String[] old_path = this.m_Path;
                this.m_Path = new String[idx];
                System.arraycopy(old_path, 0, this.m_Path, 0, this.m_Path.length);
                while (tokens.hasMoreTokens()) {
                    st = table.get(tokens.nextToken());
                    if (st.equals("0")) continue;
                    throw new ClusException("Hierarchical class must not contain internal zeros");
                }
                return;
            }
            this.m_Path[idx] = st;
            ++idx;
        }
    }

    public ClassesValue(ClassTerm term) {
        this.m_ClassTerm = term;
    }

    public ClassesValue(ClassTerm term, double abundance) {
        this.m_Abundance = abundance;
        this.m_ClassTerm = term;
    }

    public ClassesValue(int len) {
        this.m_Path = new String[len];
    }

    public boolean isRoot() {
        return this.getTerm().getIndex() == -1;
    }

    public ClassTerm getTerm() {
        return this.m_ClassTerm;
    }

    public void setClassTerm(ClassTerm term) {
        this.m_ClassTerm = term;
    }

    public final int getIndex() {
        return this.m_ClassTerm.getIndex();
    }

    public ClassesValue toFlat(StringTable table) {
        ClassesValue val = new ClassesValue(1);
        val.setPath(table.get(this.toPathString()), 0);
        return val;
    }

    public double getAbundance() {
        return this.m_Abundance;
    }

    public void setAbundance(double abundance) {
        this.m_Abundance = abundance;
    }

    public void setIntermediate(boolean inter) {
        this.m_Intermediate = inter;
    }

    public boolean isIntermediate() {
        return this.m_Intermediate;
    }

    public static void setHSeparator(String hsep) {
        HIERARCY_SEPARATOR = hsep;
    }

    public static void setEmptySetIndicator(String empty) {
        EMPTY_SET_INDICATOR = empty;
    }

    public boolean equalsValue(ClassesValue other) {
        if (this.m_Path.length != other.m_Path.length) {
            return false;
        }
        for (int i = 0; i < this.m_Path.length; ++i) {
            if (this.m_Path[i].equals(other.m_Path[i])) continue;
            return false;
        }
        return true;
    }

    public String getMostSpecificClass() {
        return this.m_Path[this.m_Path.length - 1];
    }

    public String getClassID(int level) {
        return this.m_Path[level];
    }

    public int getNbLevels() {
        return this.m_Path.length;
    }

    public void setPath(String strg, int i) {
        this.m_Path[i] = strg;
    }

    public final void addHierarchyIndices(ClassHierarchy hier) throws ClusException {
        ClassTerm term = hier.getClassTerm(this);
        this.setClassTerm(term);
    }

    public String toPathString() {
        ClassTerm term = this.getTerm();
        if (term != null) {
            return term.toPathString();
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.getNbLevels(); ++i) {
            if (i != 0) {
                buf.append('/');
            }
            buf.append(this.getClassID(i));
        }
        return buf.toString();
    }

    public String toStringData(ClassHierarchy hier) {
        if (hier != null && hier.isDAG()) {
            return this.getTerm().getID();
        }
        return this.toPathString();
    }

    public String toStringWithDepths(ClassHierarchy hier) {
        if (hier != null && hier.isDAG()) {
            ClassTerm term = this.getTerm();
            if (term.getMinDepth() == term.getMaxDepth()) {
                return this.getTerm().getID() + "[" + term.getMinDepth() + "]";
            }
            return this.getTerm().getID() + "[" + term.getMinDepth() + ";" + term.getMaxDepth() + "]";
        }
        return this.toPathString();
    }

    public String toString() {
        return this.toPathString();
    }
}

