/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.hierarchical;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassTerm;
import si.ijs.kt.clus.ext.hierarchical.ClassesValue;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.array.StringTable;

public class ClassesTuple
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected ClassesValue[] m_Tuple;
    protected int m_Count;

    public ClassesTuple() {
    }

    public ClassesTuple(String constr, StringTable table) throws ClusException {
        if (constr.equals(ClassesValue.EMPTY_SET_INDICATOR)) {
            this.m_Tuple = new ClassesValue[0];
        } else {
            int idx = 0;
            StringTokenizer tokens = new StringTokenizer(constr, "@");
            int tlen = tokens.countTokens();
            this.m_Tuple = new ClassesValue[tlen];
            while (tokens.hasMoreTokens()) {
                ClassesValue val = new ClassesValue(tokens.nextToken(), table);
                this.m_Tuple[idx++] = val;
            }
            if (tlen == 0) {
                new ClusException("Number of classes should be >= 1");
            }
        }
    }

    public ClassesTuple(int size) {
        this.m_Tuple = new ClassesValue[size];
    }

    public boolean isRoot() {
        if (this.m_Tuple.length == 0) {
            return true;
        }
        if (this.m_Tuple.length == 1) {
            return this.m_Tuple[0].isRoot();
        }
        return false;
    }

    public boolean hasClass(int index) {
        for (int i = 0; i < this.m_Tuple.length; ++i) {
            ClassesValue val = this.getClass(i);
            if (index != val.getIndex()) continue;
            return true;
        }
        return false;
    }

    public ClassesTuple toFlat(StringTable table) {
        ClassesTuple tuple = new ClassesTuple(this.m_Tuple.length);
        for (int i = 0; i < this.m_Tuple.length; ++i) {
            tuple.setItemAt(this.getClass(i).toFlat(table), i);
        }
        return tuple;
    }

    public void setLength(int size) {
        ClassesValue[] old = this.m_Tuple;
        this.m_Tuple = new ClassesValue[size];
        System.arraycopy(old, 0, this.m_Tuple, 0, size);
    }

    public boolean equalsTuple(ClassesTuple other) {
        if (this.m_Tuple.length != other.m_Tuple.length) {
            return false;
        }
        for (int i = 0; i < this.m_Tuple.length; ++i) {
            if (this.m_Tuple[i].equalsValue(other.m_Tuple[i])) continue;
            return false;
        }
        return true;
    }

    public final void setSize(int size) {
        this.m_Tuple = new ClassesValue[size];
    }

    public final void setItemAt(ClassesValue item, int pos) {
        this.m_Tuple[pos] = item;
    }

    public final void addItem(ClassesValue item) {
        this.m_Tuple[this.m_Count++] = item;
    }

    public int getPosition(int idx) {
        return this.m_Tuple[idx].getIndex();
    }

    public final int getNbClasses() {
        return this.m_Tuple.length;
    }

    public final ClassesValue getClass(int idx) {
        return this.m_Tuple[idx];
    }

    public void updateDistribution(double[] distr, double weight) {
        for (int i = 0; i < this.getNbClasses(); ++i) {
            int n = this.getClass(i).getIndex();
            distr[n] = distr[n] + weight;
        }
    }

    public final boolean[] getVectorBoolean(ClassHierarchy hier) {
        boolean[] vec = new boolean[hier.getTotal()];
        for (int i = 0; i < this.getNbClasses(); ++i) {
            vec[this.getClass((int)i).getIndex()] = true;
        }
        return vec;
    }

    public final double[] getVector(ClassHierarchy hier) {
        double[] vec = new double[hier.getTotal()];
        for (int i = 0; i < this.getNbClasses(); ++i) {
            vec[this.getClass((int)i).getIndex()] = 1.0;
        }
        return vec;
    }

    public final boolean[] getVectorBooleanNodeAndAncestors(ClassHierarchy hier) {
        boolean[] vec = new boolean[hier.getTotal()];
        this.fillBoolArrayNodeAndAncestors(vec);
        return vec;
    }

    public final double[] getVectorNodeAndAncestors(ClassHierarchy hier) {
        double[] vec = new double[hier.getTotal()];
        for (int i = 0; i < this.getNbClasses(); ++i) {
            ClassesValue val = this.getClass(i);
            val.getTerm().fillVectorNodeAndAncestors(vec);
        }
        return vec;
    }

    public final void fillBoolArrayNodeAndAncestors(boolean[] interms) {
        for (int i = 0; i < this.getNbClasses(); ++i) {
            ClassesValue val = this.getClass(i);
            val.getTerm().fillBoolArrayNodeAndAncestors(interms);
        }
    }

    public final void addIntermediateElems(ClassHierarchy hier, boolean[] alllabels, ArrayList<ClassesValue> added) {
        this.fillBoolArrayNodeAndAncestors(alllabels);
        for (int i = 0; i < hier.getTotal(); ++i) {
            if (!alllabels[i]) continue;
            ClassTerm term = hier.getTermAt(i);
            ClassesValue val = new ClassesValue(term);
            val.setIntermediate(term.hasChildrenIn(alllabels));
            added.add(val);
        }
        this.m_Tuple = new ClassesValue[added.size()];
        System.arraycopy(added.toArray(), 0, this.m_Tuple, 0, added.size());
    }

    public final void cloneFrom(ClassesTuple tuple) {
        int size = tuple.m_Tuple.length;
        this.m_Tuple = new ClassesValue[size];
        System.arraycopy(tuple.m_Tuple, 0, this.m_Tuple, 0, size);
    }

    public String toString() {
        return this.toString(null, '@', false);
    }

    public String toStringHuman(ClassHierarchy hier) {
        return this.toString(hier, ',', false);
    }

    public String toStringData(ClassHierarchy hier) {
        return this.toString(hier, '@', false);
    }

    public String toString(ClassHierarchy hier, char separator, boolean allowinterm) {
        if (this.getNbClasses() > 0) {
            int idx = 0;
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.getNbClasses(); ++i) {
                ClassesValue val = this.getClass(i);
                if (!allowinterm && val.isIntermediate()) continue;
                if (idx != 0) {
                    buf.append(separator);
                }
                buf.append(val.toStringData(hier));
                ++idx;
            }
            return buf.toString();
        }
        return "none";
    }

    public void setAllIntermediate(boolean inter) {
        for (int i = 0; i < this.m_Tuple.length; ++i) {
            this.m_Tuple[i].setIntermediate(inter);
        }
    }

    public final void addToHierarchy(ClassHierarchy hier) {
        for (int i = 0; i < this.getNbClasses(); ++i) {
            hier.addClass(this.getClass(i));
        }
    }

    public final void addHierarchyIndices(ClassHierarchy hier) throws ClusException {
        for (int i = 0; i < this.getNbClasses(); ++i) {
            ClassesValue val = this.getClass(i);
            ClassTerm term = hier.getClassTerm(val);
            val.setClassTerm(term);
        }
    }

    public void removeLabels(boolean[] removed) {
        int i;
        ArrayList<ClassesValue> left = new ArrayList<ClassesValue>();
        for (i = 0; i < this.getNbClasses(); ++i) {
            ClassesValue val = this.getClass(i);
            if (removed[val.getIndex()]) continue;
            left.add(val);
        }
        this.m_Tuple = new ClassesValue[left.size()];
        for (i = 0; i < left.size(); ++i) {
            this.m_Tuple[i] = (ClassesValue)left.get(i);
        }
    }

    public static ClassesTuple readFromFile(String fname, ClassHierarchy hier) throws ClusException, IOException {
        int idx = 0;
        BufferedReader input = new BufferedReader(new FileReader(fname));
        StringBuffer classes = new StringBuffer();
        String line = input.readLine();
        while (line != null) {
            if (!(line = line.trim()).equals("")) {
                if (idx != 0) {
                    classes.append("@");
                }
                classes.append(line);
            }
            line = input.readLine();
            ++idx;
        }
        input.close();
        ClassesTuple tuple = new ClassesTuple(classes.toString(), hier.getType().getTable());
        tuple.addHierarchyIndices(hier);
        return tuple;
    }
}

