/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.hierarchical;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassesValue;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.jeans.math.SingleStat;
import si.ijs.kt.clus.util.jeans.tree.Node;
import si.ijs.kt.clus.util.jeans.util.StringUtils;
import si.ijs.kt.clus.util.jeans.util.compound.IndexedItem;

public class ClassTerm
extends IndexedItem
implements Node,
Comparable<ClassTerm> {
    public static final long serialVersionUID = 1L;
    protected String m_ID;
    protected HashMap<String, ClassTerm> m_Hash = new HashMap();
    protected ArrayList<ClassTerm> m_SubTerms = new ArrayList();
    protected ArrayList<ClassTerm> m_Parents = new ArrayList();
    protected int m_MinDepth = Integer.MAX_VALUE;
    protected int m_MaxDepth = 0;
    protected double m_Depth;

    public ClassTerm() {
        this.m_ID = "root";
    }

    public ClassTerm(String id) {
        this.m_ID = id;
    }

    public void addParent(ClassTerm term) {
        this.m_Parents.add(term);
    }

    public int getNbParents() {
        return this.m_Parents.size();
    }

    public ClassTerm getParent(int i) {
        return this.m_Parents.get(i);
    }

    public boolean isNumeric() {
        for (int i = 0; i < this.m_ID.length(); ++i) {
            if (this.m_ID.charAt(i) >= '0' && this.m_ID.charAt(i) <= '9') continue;
            return false;
        }
        return true;
    }

    public void addClass(ClassesValue val, int level, ClassHierarchy hier) {
        String cl_idx = val.getClassID(level);
        if (!cl_idx.equals("0")) {
            ClassTerm found = this.m_Hash.get(cl_idx);
            if (found == null) {
                boolean is_dag = hier.isDAG();
                found = is_dag ? hier.getClassTermByNameAddIfNotIn(cl_idx) : new ClassTerm(cl_idx);
                found.addParent(this);
                this.m_Hash.put(cl_idx, found);
                this.m_SubTerms.add(found);
            }
            if (++level < val.getNbLevels()) {
                found.addClass(val, level, hier);
            }
        }
    }

    public void sortChildrenByID() {
        Collections.sort(this.m_SubTerms);
    }

    public void getMeanBranch(boolean[] enabled, SingleStat stat) {
        int nb_branch = 0;
        for (int i = 0; i < this.getNbChildren(); ++i) {
            ClassTerm child = (ClassTerm)this.getChild(i);
            if (enabled != null && !enabled[child.getIndex()]) continue;
            ++nb_branch;
            child.getMeanBranch(enabled, stat);
        }
        if (nb_branch != 0) {
            stat.addFloat(nb_branch);
        }
    }

    public boolean hasChildrenIn(boolean[] enable) {
        for (int i = 0; i < this.getNbChildren(); ++i) {
            ClassTerm child = (ClassTerm)this.getChild(i);
            if (!enable[child.getIndex()]) continue;
            return true;
        }
        return false;
    }

    @Override
    public Node getParent() {
        return null;
    }

    @Override
    public Node getChild(int idx) {
        return this.m_SubTerms.get(idx);
    }

    @Override
    public int getNbChildren() {
        return this.m_SubTerms.size();
    }

    @Override
    public boolean atTopLevel() {
        return this.m_Parents.size() == 0;
    }

    @Override
    public boolean atBottomLevel() {
        return this.m_SubTerms.size() == 0;
    }

    @Override
    public void setParent(Node parent) {
    }

    public final String getID() {
        return this.m_ID;
    }

    public final void setID(String id) {
        this.m_ID = id;
    }

    public String getKeysVector() {
        StringBuffer buf = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(this.m_Hash.keySet());
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(keys.get(i));
        }
        return buf.toString();
    }

    public final ClassTerm getByName(String name) {
        return this.m_Hash.get(name);
    }

    public final ClassTerm getCTParent() {
        return null;
    }

    public final void print(int tabs, PrintWriter wrt, double[] counts, double[] weights) {
        for (int i = 0; i < this.m_SubTerms.size(); ++i) {
            int no;
            ClassTerm subterm = this.m_SubTerms.get(i);
            wrt.print(StringUtils.makeString(' ', tabs) + subterm.getID());
            int nb_par = subterm.getNbParents();
            if (nb_par > 1) {
                int p_idx = 0;
                StringBuffer buf = new StringBuffer();
                buf.append("(p: ");
                for (int j = 0; j < nb_par; ++j) {
                    ClassTerm cr_par = subterm.getParent(j);
                    if (cr_par == this) continue;
                    if (p_idx != 0) {
                        buf.append(",");
                    }
                    buf.append(cr_par.getID());
                    ++p_idx;
                }
                buf.append(")");
                wrt.print(" " + buf.toString());
            }
            if ((no = subterm.getIndex()) == -1) {
                wrt.print(": [error index -1]");
            } else {
                if (counts != null) {
                    double count = counts[no];
                    wrt.print(": " + ClusFormat.FOUR_AFTER_DOT.format(count));
                }
                if (weights != null) {
                    double weight = weights[no];
                    wrt.print(": " + ClusFormat.THREE_AFTER_DOT.format(weight));
                }
            }
            wrt.println();
            subterm.print(tabs + 6, wrt, counts, weights);
        }
    }

    public void fillVectorNodeAndAncestors(double[] array) {
        int idx = this.getIndex();
        if (idx != -1 && array[idx] == 0.0) {
            array[idx] = 1.0;
            for (int i = 0; i < this.getNbParents(); ++i) {
                this.getParent(i).fillVectorNodeAndAncestors(array);
            }
        }
    }

    public void fillBoolArrayNodeAndAncestors(boolean[] array) {
        int idx = this.getIndex();
        if (idx != -1 && !array[idx]) {
            array[idx] = true;
            for (int i = 0; i < this.getNbParents(); ++i) {
                this.getParent(i).fillBoolArrayNodeAndAncestors(array);
            }
        }
    }

    public int getNbLeaves() {
        int nbc = this.m_SubTerms.size();
        if (nbc == 0) {
            return 1;
        }
        int total = 0;
        for (int i = 0; i < this.m_SubTerms.size(); ++i) {
            ClassTerm subterm = this.m_SubTerms.get(i);
            total += subterm.getNbLeaves();
        }
        return total;
    }

    @Override
    public void addChild(Node node) {
        ClassTerm t = (ClassTerm)node;
        String id = t.getID();
        this.m_Hash.put(id, t);
        this.m_SubTerms.add(t);
    }

    public void addChildCheckAndParent(ClassTerm node) {
        String id = node.getID();
        if (!this.m_Hash.containsKey(id)) {
            this.m_Hash.put(id, node);
            this.m_SubTerms.add(node);
            node.addParent(this);
        }
    }

    public void removeChild(int idx) {
        ClassTerm child = (ClassTerm)this.getChild(idx);
        this.m_Hash.remove(child.getID());
        this.m_SubTerms.remove(idx);
    }

    public void numberChildren() {
        this.m_Hash.clear();
        for (int i = 0; i < this.m_SubTerms.size(); ++i) {
            ClassTerm subterm = this.m_SubTerms.get(i);
            String key = String.valueOf(i + 1);
            subterm.setID(key);
            this.m_Hash.put(key, subterm);
        }
    }

    @Override
    public void removeChild(Node node) {
        ClassTerm child = (ClassTerm)node;
        this.m_Hash.remove(child.getID());
        this.m_SubTerms.remove(child);
    }

    @Override
    public int getLevel() {
        int depth = 0;
        ClassTerm parent = this.getCTParent();
        while (parent != null) {
            parent = parent.getCTParent();
            ++depth;
        }
        return depth;
    }

    public int getMaxDepth() {
        return this.m_MaxDepth;
    }

    public int getMinDepth() {
        return this.m_MinDepth;
    }

    public void setMinDepth(int depth) {
        this.m_MinDepth = depth;
    }

    public void setMaxDepth(int depth) {
        this.m_MaxDepth = depth;
    }

    public String toPathString() {
        return this.toPathString("/");
    }

    public String toPathString(String sep) {
        if (this.getIndex() == -1) {
            return "R";
        }
        ClassTerm term = this;
        String path = term.getID();
        int nb_par;
        while ((nb_par = term.getNbParents()) == 1) {
            if ((term = term.getParent(0)).getIndex() == -1) {
                return path;
            }
            path = term.getID() + sep + path;
        }
        return "P" + sep + path;
    }

    public String toString() {
        return this.toStringHuman(null);
    }

    public String toStringHuman(ClassHierarchy hier) {
        if (hier != null && hier.isDAG()) {
            return this.getID();
        }
        return this.toPathString();
    }

    public void setDepth(double depth) {
        this.m_Depth = depth;
    }

    public double getDepth() {
        return this.m_Depth;
    }

    public ArrayList<ClassTerm> getAllAncestors(boolean includeTerm) {
        ArrayList<ClassTerm> ancestors = new ArrayList<ClassTerm>();
        if (includeTerm) {
            ancestors.add(this);
        }
        HashSet<Integer> visited = new HashSet<Integer>();
        Stack<ClassTerm> toVisit = new Stack<ClassTerm>();
        toVisit.push(this);
        while (!toVisit.isEmpty()) {
            ClassTerm term = (ClassTerm)toVisit.pop();
            for (int parentInd = 0; parentInd < term.getNbParents(); ++parentInd) {
                ClassTerm parent = term.getParent(parentInd);
                int hierParentInd = parent.getIndex();
                if (parent.atTopLevel() || visited.contains(hierParentInd)) continue;
                ancestors.add(parent);
                toVisit.push(parent);
                visited.add(hierParentInd);
            }
        }
        return ancestors;
    }

    @Override
    public int compareTo(ClassTerm o) {
        String s2;
        ClassTerm other = o;
        String s1 = this.getID();
        if (s1.equals(s2 = other.getID())) {
            return 0;
        }
        if (this.isNumeric() && other.isNumeric()) {
            int i2;
            int i1 = Integer.parseInt(s1);
            return i1 > (i2 = Integer.parseInt(s2)) ? 1 : -1;
        }
        return s1.compareTo(s2);
    }
}

