/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.hierarchical;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import si.ijs.kt.clus.data.type.hierarchies.ClassesAttrType;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassTerm;
import si.ijs.kt.clus.ext.hierarchical.ClassesTuple;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.tree.CompleteTreeIterator;
import si.ijs.kt.clus.util.jeans.util.MStreamTokenizer;
import si.ijs.kt.clus.util.jeans.util.array.StringTable;

public class ClassHierarchyIO {
    protected StringTable m_Table = new StringTable();

    public ClassHierarchy loadHierarchy(String fname) throws ClusException, IOException {
        ClassHierarchy hier = new ClassHierarchy((ClassTerm)null);
        this.loadHierarchy(fname, hier);
        return hier;
    }

    public ClassHierarchy loadHierarchy(String fname, ClassesAttrType type) throws ClusException, IOException {
        ClassHierarchy hier = new ClassHierarchy(type);
        this.loadHierarchy(fname, hier);
        return hier;
    }

    public void loadHierarchy(String fname, ClassHierarchy hier) throws ClusException, IOException {
        MStreamTokenizer tokens = new MStreamTokenizer(fname);
        String token = tokens.getToken();
        while (token != null) {
            ClassesTuple tuple = new ClassesTuple(token, this.m_Table);
            tuple.addToHierarchy(hier);
            token = tokens.getToken();
        }
        tokens.close();
    }

    public void saveHierarchy(String fname, ClassHierarchy hier) throws IOException {
        PrintWriter wrt = new PrintWriter(new OutputStreamWriter(new FileOutputStream(fname)));
        CompleteTreeIterator iter = hier.getNoRootIter();
        while (iter.hasMoreNodes()) {
            ClassTerm node = (ClassTerm)iter.getNextNode();
            wrt.println(node.toString());
        }
        wrt.close();
    }

    public StringTable getStringTable() {
        return this.m_Table;
    }
}

