/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.featureRanking.relief.statistics;

import java.util.Arrays;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.ext.featureRanking.relief.ClusReliefFeatureRanking;
import si.ijs.kt.clus.ext.featureRanking.relief.nearestNeighbour.NearestNeighbour;
import si.ijs.kt.clus.ext.featureRanking.relief.statistics.Statistics;
import si.ijs.kt.clus.util.exception.ClusException;

public class Variance
extends Statistics {
    private double[][][] mVariances;
    private double[] tempS1;
    private double[] tempS2;

    public Variance(ClusReliefFeatureRanking relief, int nbTargets, int nbDiffNbNeighbours, int nbDescriptiveAttributes) {
        this.initializeSuperFields(relief, nbDescriptiveAttributes);
        this.mVariances = new double[nbTargets][nbDiffNbNeighbours][nbDescriptiveAttributes];
        this.tempS1 = new double[nbDescriptiveAttributes];
        this.tempS2 = new double[nbDescriptiveAttributes];
        if (nbTargets > 1) {
            throw new RuntimeException("The number of targets " + nbTargets + " is not 1.");
        }
    }

    @Override
    public void updateTempStatistics(int targetIndex, boolean isStdClassification, DataTuple tuple, RowData data, NearestNeighbour neigh, double neighWeightNonnormalized, int trueIndex, int targetValue) throws ClusException {
        int attrInd = 0;
        while (attrInd < this.m_NbDescriptiveAttrs) {
            ClusAttrType attr = this.mRelief.getDescriptiveAttribute(attrInd);
            double distAttr = this.mRelief.computeDistance1D(tuple, data.getTuple(neigh.getIndexInDataset()), attr) * neighWeightNonnormalized;
            int n = attrInd++;
            this.tempS1[n] = this.tempS1[n] + distAttr;
        }
    }

    @Override
    public void updateStatistics(int targetIndex, int numNeighInd, double sumNeighbourWeights) {
        for (int attrInd = 0; attrInd < this.m_NbDescriptiveAttrs; ++attrInd) {
            double[] dArray = this.mVariances[targetIndex + 1][numNeighInd];
            int n = attrInd;
            dArray[n] = dArray[n] + this.tempS1[attrInd] / sumNeighbourWeights;
        }
    }

    @Override
    public void resetTempFields() {
        Arrays.fill(this.tempS1, 0.0);
    }

    @Override
    public double computeImportances(int targetIndex, int nbNeighInd, int attrInd, boolean isStdClassification, double[] successfulItearions) {
        return 1.0 / (this.mVariances[targetIndex + 1][nbNeighInd][attrInd] / successfulItearions[targetIndex + 1]);
    }
}

