/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.featureRanking.relief.statistics;

import java.util.Arrays;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.ext.featureRanking.relief.ClusReliefFeatureRanking;
import si.ijs.kt.clus.ext.featureRanking.relief.nearestNeighbour.NearestNeighbour;
import si.ijs.kt.clus.ext.featureRanking.relief.statistics.Statistics;
import si.ijs.kt.clus.util.exception.ClusException;

public class Classic
extends Statistics {
    private double[][][] m_SumDistAttr;
    private double[][] m_SumDistTarget;
    private double[][][] m_SumDistAttrTarget;
    double tempSumDistTarget;
    double[] tempSumDistAttr;
    double[] tempSumDistAttrTarget;

    public Classic(ClusReliefFeatureRanking relief, int nbTargets, int nbDiffNbNeighbours, int nbDescriptiveAttributes) {
        this.initializeSuperFields(relief, nbDescriptiveAttributes);
        this.m_SumDistAttr = new double[nbTargets][nbDiffNbNeighbours][nbDescriptiveAttributes];
        this.m_SumDistTarget = new double[nbTargets][nbDiffNbNeighbours];
        this.m_SumDistAttrTarget = new double[nbTargets][nbDiffNbNeighbours][nbDescriptiveAttributes];
        this.tempSumDistTarget = 0.0;
        this.tempSumDistAttr = new double[nbDescriptiveAttributes];
        this.tempSumDistAttrTarget = new double[nbDescriptiveAttributes];
    }

    @Override
    public void updateTempStatistics(int targetIndex, boolean isStdClassification, DataTuple tuple, RowData data, NearestNeighbour neigh, double neighWeightNonnormalized, int trueIndex, int targetValue) throws ClusException {
        double targetDistance = 0.0;
        targetDistance = targetIndex >= 0 && !isStdClassification ? this.mRelief.computeDistance1D(tuple, data.getTuple(neigh.getIndexInDataset()), this.mRelief.getTargetAttribute(trueIndex)) : (tuple.isUnlabeled() || data.getTuple(neigh.getIndexInDataset()).isUnlabeled() ? neigh.getDescriptiveDidstance() : this.mRelief.computeDistance(tuple, data.getTuple(neigh.getIndexInDataset()), 1));
        if (!isStdClassification) {
            this.tempSumDistTarget += targetDistance * neighWeightNonnormalized;
        }
        for (int attrInd = 0; attrInd < this.m_NbDescriptiveAttrs; ++attrInd) {
            ClusAttrType attr = this.mRelief.getDescriptiveAttribute(attrInd);
            double distAttr = this.mRelief.computeDistance1D(tuple, data.getTuple(neigh.getIndexInDataset()), attr) * neighWeightNonnormalized;
            if (isStdClassification) {
                int tupleTarget = ((NominalAttrType)this.mRelief.getTargetAttribute(trueIndex)).getNominal(tuple);
                if (targetValue == tupleTarget) {
                    int n = attrInd;
                    this.tempSumDistAttr[n] = this.tempSumDistAttr[n] - distAttr;
                    continue;
                }
                double pTupleTarget = this.mRelief.getTargetProbability(targetIndex, tupleTarget);
                double pNeighTarget = this.mRelief.getTargetProbability(targetIndex, targetValue);
                int n = attrInd;
                this.tempSumDistAttr[n] = this.tempSumDistAttr[n] + pNeighTarget / (1.0 - pTupleTarget) * distAttr;
                continue;
            }
            int n = attrInd;
            this.tempSumDistAttr[n] = this.tempSumDistAttr[n] + distAttr;
            int n2 = attrInd;
            this.tempSumDistAttrTarget[n2] = this.tempSumDistAttrTarget[n2] + distAttr * targetDistance;
        }
    }

    @Override
    public void updateStatistics(int targetIndex, int numNeighInd, double sumNeighbourWeights) {
        double normalizedTempDistTarget = this.tempSumDistTarget / sumNeighbourWeights;
        double[] dArray = this.m_SumDistTarget[targetIndex + 1];
        int n = numNeighInd;
        dArray[n] = dArray[n] + normalizedTempDistTarget;
        int attrInd = 0;
        while (attrInd < this.m_NbDescriptiveAttrs) {
            double normalizedTempDistAttr = this.tempSumDistAttr[attrInd] / sumNeighbourWeights;
            double normalizedTempTistAttrTarget = this.tempSumDistAttrTarget[attrInd] / sumNeighbourWeights;
            double[] dArray2 = this.m_SumDistAttr[targetIndex + 1][numNeighInd];
            int n2 = attrInd;
            dArray2[n2] = dArray2[n2] + normalizedTempDistAttr;
            double[] dArray3 = this.m_SumDistAttrTarget[targetIndex + 1][numNeighInd];
            int n3 = attrInd++;
            dArray3[n3] = dArray3[n3] + normalizedTempTistAttrTarget;
        }
    }

    @Override
    public double computeImportances(int targetIndex, int nbNeighInd, int attrInd, boolean isStdClassification, double[] successfulItearions) {
        double sumDistAttr = this.m_SumDistAttr[targetIndex + 1][nbNeighInd][attrInd];
        double sumDistTarget = this.m_SumDistTarget[targetIndex + 1][nbNeighInd];
        double sumDistAttrTarget = this.m_SumDistAttrTarget[targetIndex + 1][nbNeighInd][attrInd];
        if (isStdClassification) {
            return sumDistAttr / successfulItearions[targetIndex + 1];
        }
        double p1 = sumDistAttrTarget / sumDistTarget;
        double p2 = (sumDistAttr - sumDistAttrTarget) / (successfulItearions[targetIndex + 1] - sumDistTarget);
        return p1 - p2;
    }

    @Override
    public void resetTempFields() {
        this.tempSumDistTarget = 0.0;
        Arrays.fill(this.tempSumDistAttr, 0.0);
        Arrays.fill(this.tempSumDistAttrTarget, 0.0);
    }
}

