/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.featureRanking.relief.nearestNeighbour;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import si.ijs.kt.clus.ext.featureRanking.relief.nearestNeighbour.NearestNeighbour;
import si.ijs.kt.clus.util.ClusLogger;

public class SaveLoadNeighbours {
    private String m_OutputFile;
    private String[] m_InputFiles;
    private static final String START_TARGET = "START_TARGET";
    private static final String END_TARGET = "END_TARGET";
    private static final String START_TUPLE = "START_TUPLE";
    private static final String END_TUPLE = "END_TUPLE";
    private static final String NB_TARGET_VALUES = "NB_TARGET_VALUES";
    private static final String NN_SEPARATOR = "&";
    public static final Integer DUMMY_TARGET = -1;

    public SaveLoadNeighbours(String[] m_NearestNeighbourInputFiles, String m_NearestNeighbourOutputFile) {
        this.m_InputFiles = m_NearestNeighbourInputFiles;
        this.m_OutputFile = m_NearestNeighbourOutputFile;
    }

    public void saveNeighboursToFile(HashMap<Integer, HashMap<Integer, NearestNeighbour[][]>> nearestNeighbours) throws IOException {
        PrintWriter writer = new PrintWriter(this.m_OutputFile, "UTF-8");
        ArrayList<String> lines = new ArrayList<String>();
        for (Integer targetInd : nearestNeighbours.keySet()) {
            ClusLogger.info("Saving target index " + targetInd.toString());
            lines.add(String.format("%s;%d", START_TARGET, targetInd));
            HashMap<Integer, NearestNeighbour[][]> neighboursTarget = nearestNeighbours.get(targetInd);
            for (Integer tupleInd : neighboursTarget.keySet()) {
                lines.add(String.format("%s;%d", START_TUPLE, tupleInd));
                NearestNeighbour[][] nnss = neighboursTarget.get(tupleInd);
                lines.add(String.format("%s;%d", NB_TARGET_VALUES, nnss.length));
                for (NearestNeighbour[] nns : nnss) {
                    CharSequence[] nnsString = new String[nns.length];
                    for (int i = 0; i < nns.length; ++i) {
                        nnsString[i] = nns[i].toFileString();
                    }
                    lines.add(String.join((CharSequence)NN_SEPARATOR, nnsString));
                }
                lines.add(END_TUPLE);
            }
            lines.add(END_TARGET);
            if (lines.size() <= 1000) continue;
            writer.println(String.join((CharSequence)"\n", lines));
            lines = new ArrayList();
        }
        if (lines.size() > 0) {
            writer.println(String.join((CharSequence)"\n", lines));
            lines = new ArrayList();
        }
        writer.close();
        ClusLogger.info("Nearest neighbours written to: " + this.m_OutputFile);
    }

    public HashMap<Integer, HashMap<Integer, NearestNeighbour[][]>> loadNeighboursFromFile(String nearestNeighboursFile) throws IOException {
        ClusLogger.info("Loading from " + nearestNeighboursFile);
        HashMap<Integer, HashMap<Integer, NearestNeighbour[][]>> nearestNeighbours = new HashMap<Integer, HashMap<Integer, NearestNeighbour[][]>>();
        int dummy = -123;
        Integer targetInd = dummy;
        Integer tupleInd = dummy;
        NearestNeighbour[][] nnss = new NearestNeighbour[0][0];
        int targetValueInd = dummy;
        int nbTargetValues = dummy;
        BufferedReader br = new BufferedReader(new FileReader(nearestNeighboursFile));
        String line = br.readLine();
        while (line != null) {
            if (line.startsWith(START_TARGET)) {
                ClusLogger.info(line);
                targetInd = SaveLoadNeighbours.intAfterSemicolon(line);
                nearestNeighbours.put(targetInd, new HashMap());
            } else if (line.startsWith(START_TUPLE)) {
                tupleInd = SaveLoadNeighbours.intAfterSemicolon(line);
            } else if (line.startsWith(NB_TARGET_VALUES)) {
                nbTargetValues = SaveLoadNeighbours.intAfterSemicolon(line);
                nnss = new NearestNeighbour[nbTargetValues][];
                targetValueInd = 0;
            } else if (0 <= targetValueInd) {
                String[] nnsString;
                if (line.startsWith("NN")) {
                    nnsString = line.trim().split(NN_SEPARATOR);
                } else {
                    nnsString = new String[]{};
                    System.err.println(String.format("No neighbours for %dth tuple, %dth target and its %dth value (all three indices 0-based)", tupleInd, targetInd, targetValueInd));
                }
                NearestNeighbour[] nns = new NearestNeighbour[nnsString.length];
                for (int i = 0; i < nns.length; ++i) {
                    nns[i] = new NearestNeighbour(nnsString[i]);
                }
                nnss[targetValueInd] = nns;
                if (++targetValueInd == nbTargetValues) {
                    targetValueInd = dummy;
                }
            } else if (line.startsWith(END_TUPLE)) {
                nearestNeighbours.get(targetInd).put(tupleInd, nnss);
                if (targetValueInd != dummy) {
                    throw new RuntimeException("Something wrong with parsing file " + nearestNeighboursFile);
                }
                nbTargetValues = dummy;
            } else if (line.startsWith(END_TARGET)) {
                // empty if block
            }
            line = br.readLine();
        }
        br.close();
        ClusLogger.info("Loaded");
        return nearestNeighbours;
    }

    public HashMap<Integer, HashMap<Integer, NearestNeighbour[][]>> loadNeighboursFromFiles() throws IOException {
        HashMap<Integer, HashMap<Integer, NearestNeighbour[][]>> nearestNeighbours = new HashMap<Integer, HashMap<Integer, NearestNeighbour[][]>>();
        for (String inFile : this.m_InputFiles) {
            HashMap<Integer, HashMap<Integer, NearestNeighbour[][]>> partialNNs = this.loadNeighboursFromFile(inFile);
            for (Integer targetInd : partialNNs.keySet()) {
                if (!nearestNeighbours.containsKey(targetInd)) {
                    nearestNeighbours.put(targetInd, new HashMap());
                }
                HashMap<Integer, NearestNeighbour[][]> neighboursTargetPartial = partialNNs.get(targetInd);
                HashMap<Integer, NearestNeighbour[][]> neighboursTargetAll = nearestNeighbours.get(targetInd);
                for (Integer tupleInd : neighboursTargetPartial.keySet()) {
                    if (neighboursTargetAll.containsKey(tupleInd)) {
                        String warning = "Warning: Neighbours for tuple with index %d and target with index %d are computed in at least two input files.\nIf the neighbours are not the same, an exception will be thrown.";
                        System.err.println(String.format(warning, (int)tupleInd, (int)targetInd));
                        if (Arrays.deepEquals((Object[])neighboursTargetAll.get(tupleInd), (Object[])neighboursTargetPartial.get(tupleInd))) continue;
                        throw new RuntimeException("Different neighbours!\n" + Arrays.deepToString((Object[])neighboursTargetAll.get(tupleInd)) + "\n" + Arrays.deepToString((Object[])neighboursTargetPartial.get(tupleInd)));
                    }
                    neighboursTargetAll.put(tupleInd, neighboursTargetPartial.get(tupleInd));
                }
            }
        }
        return nearestNeighbours;
    }

    private static int intAfterSemicolon(String myString) {
        return Integer.parseInt(myString.substring(myString.indexOf(";") + 1));
    }

    public static void assureIsFlatNearestNeighbours(HashMap<Integer, HashMap<Integer, NearestNeighbour[][]>> nnss) {
        if (nnss.size() != 1) {
            throw new RuntimeException("Nearest neighbours cannot be safely flattened (more than one target value)!");
        }
        if (!nnss.containsKey(DUMMY_TARGET)) {
            throw new RuntimeException(String.format("Nearest neighbours cannot be safely flattened (missing expected target: %s)!", DUMMY_TARGET.toString()));
        }
        HashMap<Integer, NearestNeighbour[][]> temp = nnss.get(DUMMY_TARGET);
        for (Integer tupleIndex : temp.keySet()) {
            NearestNeighbour[][] nns = temp.get(tupleIndex);
            if (nns.length == 1) continue;
            throw new RuntimeException(String.format("Nearest neighbours cannot be safely flattened (tuple with index %s has computed neigbours for more than one target value)!", tupleIndex.toString()));
        }
    }
}

