/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.featureRanking.relief;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.rows.SparseDataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.hierarchies.ClassesAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.data.type.primitive.StringAttrType;
import si.ijs.kt.clus.data.type.primitive.TimeSeriesAttrType;
import si.ijs.kt.clus.distance.primitive.relief.HierarchicalMultiLabelDistance;
import si.ijs.kt.clus.distance.primitive.relief.Levenshtein;
import si.ijs.kt.clus.distance.primitive.relief.MultiLabelDistance;
import si.ijs.kt.clus.distance.primitive.timeseries.DTWTimeSeriesDist;
import si.ijs.kt.clus.distance.primitive.timeseries.QDMTimeSeriesDist;
import si.ijs.kt.clus.distance.primitive.timeseries.TSCTimeSeriesDist;
import si.ijs.kt.clus.ext.ensemble.ClusReadWriteLock;
import si.ijs.kt.clus.ext.featureRanking.ClusFeatureRanking;
import si.ijs.kt.clus.ext.featureRanking.relief.nearestNeighbour.FindNeighboursCallable;
import si.ijs.kt.clus.ext.featureRanking.relief.nearestNeighbour.NearestNeighbour;
import si.ijs.kt.clus.ext.featureRanking.relief.nearestNeighbour.SaveLoadNeighbours;
import si.ijs.kt.clus.ext.featureRanking.relief.statistics.Classic;
import si.ijs.kt.clus.ext.featureRanking.relief.statistics.DistanceSimplified;
import si.ijs.kt.clus.ext.featureRanking.relief.statistics.Statistics;
import si.ijs.kt.clus.ext.featureRanking.relief.statistics.Steepness;
import si.ijs.kt.clus.ext.featureRanking.relief.statistics.Variance;
import si.ijs.kt.clus.ext.imputation.MissingTargetImputation;
import si.ijs.kt.clus.ext.timeseries.TimeSeries;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsRelief;
import si.ijs.kt.clus.main.settings.section.SettingsTimeSeries;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.tuple.Triple;

public class ClusReliefFeatureRanking
extends ClusFeatureRanking {
    public static final int DESCRIPTIVE_SPACE = 0;
    public static final int TARGET_SPACE = 1;
    public static final int[] SPACE_TYPES = new int[]{0, 1};
    private RowData m_Data;
    private int[] m_NbNeighbours;
    private int m_MaxNbNeighbours;
    private int[] m_NbIterations;
    private int m_MaxNbIterations;
    private int[] m_Order;
    private boolean m_WeightNeighbours;
    private double m_Sigma;
    private double[] m_NeighbourWeights;
    private ClusAttrType[][] m_DescriptiveTargetAttr = new ClusAttrType[2][];
    private int[][] m_DistanceDescriptiveTargetAttr = new int[2][];
    private int m_NbDescriptiveAttrs;
    private int m_NbTargetAttrs;
    private int m_NbGeneralisedTargetAttrs;
    private HashMap<String, Double> m_numMins;
    private HashMap<String, Double> m_numMaxs;
    private int m_NbExamples;
    private boolean m_IsSparse;
    public static double BOTH_MISSING_DIST = 1.0;
    private Random m_rnd;
    private boolean[] m_IsStandardClassification;
    private int[] m_NbTargetValues;
    private double[][] m_TargetProbabilities;
    private boolean m_PerformPerTargetRanking;
    private Statistics mStats;
    private HierarchicalMultiLabelDistance m_HierarMLCDist = new HierarchicalMultiLabelDistance();
    private boolean m_IsMLC;
    private MultiLabelDistance m_MLCDist;
    private SettingsRelief.MultilabelDistance m_MLCDistanceType;
    private SettingsTimeSeries.TimeSeriesDistanceMeasure m_TimeSeriesDistance;
    private int m_Percents = 0;
    private HashMap<Integer, HashMap<Integer, NearestNeighbour[][]>> m_NearestNeighbours;
    private int m_NbThreads;
    private boolean m_ShouldLoadNeighbours;
    private boolean m_ShouldSaveNeighbours;
    private String[] m_LoadNearestNeigbhoursFiles;
    private String m_SaveNearestNeigbhoursFile;
    private SettingsRelief.MissingTargetHandling m_MissingTargetHandling;
    private double[] m_SSLW;
    private double[] m_SSLWs;
    private static double m_BASIC_SSLw = 1.0;
    private ClusRun m_Run;
    private int m_NeighCounter;
    private int m_NeighCounterBound;
    private int m_NeighPercents;
    private ClusReadWriteLock m_CounterLock = new ClusReadWriteLock();

    public ClusReliefFeatureRanking(RowData data, int[] neighbours, int[] iterations, boolean weightNeighbours, double sigma, int seed, Settings sett, SettingsRelief.MissingTargetHandling missingTargetHandling, double[] sslWinterval, ClusRun cr) {
        super(sett);
        this.m_Data = data;
        this.m_NbNeighbours = neighbours;
        this.m_MaxNbNeighbours = this.m_NbNeighbours[this.m_NbNeighbours.length - 1];
        this.m_NbIterations = iterations;
        this.m_MaxNbIterations = this.m_NbIterations[this.m_NbIterations.length - 1];
        this.m_WeightNeighbours = weightNeighbours;
        this.m_Sigma = this.m_WeightNeighbours ? sigma : 0.0;
        this.m_NeighbourWeights = new double[this.m_MaxNbNeighbours];
        this.m_rnd = new Random(seed);
        this.m_MissingTargetHandling = missingTargetHandling;
        this.m_SSLW = sslWinterval;
        this.m_Run = cr;
        this.initialize();
    }

    private void initialize() {
        ClusReliefFeatureRanking.printMessage("Preprocessing steps ...", 1, this.getSettings().getGeneral().getVerbose());
        this.m_NbExamples = this.m_Data.getNbRows();
        this.setReliefDescription(this.m_NbNeighbours, this.m_NbIterations);
        this.initializeNeigbhourLoadSave();
        this.initializeNeighbourWeights();
        this.initializeInstanceOrder();
        this.initializeTimeSeriesDistance();
        this.initializeDescriptiveTargetAttributes();
        this.initializeNumericRanges();
        this.prepareForSemiSupervised();
        this.initializeRankings();
        this.m_IsMLC = this.getSettings().getMLC().getSectionMultiLabel().isEnabled();
        this.initializeTargetProbabilities();
        if (this.m_IsMLC) {
            this.m_MLCDistanceType = this.getSettings().getRelief().getMultilabelDistance();
            double[] dArray = new double[this.m_NbTargetAttrs];
            String labelPresent = "1";
            for (int i = 0; i < this.m_NbTargetAttrs; ++i) {
                NominalAttrType attr = (NominalAttrType)this.m_DescriptiveTargetAttr[1][i];
                dArray[i] = this.m_TargetProbabilities[i + 1][attr.getValueIndex(labelPresent)];
            }
            this.m_MLCDist = new MultiLabelDistance(this.m_MLCDistanceType, this.m_DescriptiveTargetAttr[1], dArray);
        }
        for (int space : SPACE_TYPES) {
            for (int attrInd = 0; attrInd < this.m_DescriptiveTargetAttr[space].length; ++attrInd) {
                if (!this.m_DescriptiveTargetAttr[space][attrInd].isClasses()) continue;
                ClassesAttrType attr = (ClassesAttrType)this.m_DescriptiveTargetAttr[space][attrInd];
                this.m_HierarMLCDist.processAttribute(attr, this.m_Data);
            }
        }
        SettingsRelief.ReliefStatisticsType reliefStatisticsType = this.getSettings().getRelief().getReliefStatisticsType();
        if (Arrays.stream(this.m_SSLWs).min().getAsDouble() < m_BASIC_SSLw && !reliefStatisticsType.equals((Object)SettingsRelief.ReliefStatisticsType.DistanceClassic)) {
            throw new RuntimeException("Using unsupervised data is supported only in DistanceClassic statisic type, but yours is " + (Object)((Object)reliefStatisticsType));
        }
        switch (reliefStatisticsType) {
            case DistanceClassic: {
                this.mStats = new Classic(this, this.m_NbGeneralisedTargetAttrs, this.m_NbNeighbours.length, this.m_NbDescriptiveAttrs);
                break;
            }
            case DistanceSimplified: {
                this.mStats = new DistanceSimplified(this, this.m_NbGeneralisedTargetAttrs, this.m_NbNeighbours.length, this.m_NbDescriptiveAttrs);
                break;
            }
            case Steepness: {
                this.mStats = new Steepness(this, this.m_NbGeneralisedTargetAttrs, this.m_NbNeighbours.length, this.m_NbDescriptiveAttrs, this.m_MaxNbNeighbours, false, true);
                break;
            }
            case Variance: {
                this.mStats = new Variance(this, this.m_NbGeneralisedTargetAttrs, this.m_NbNeighbours.length, this.m_NbDescriptiveAttrs);
                break;
            }
            default: {
                throw new RuntimeException("Wrong value for statistics type: " + (Object)((Object)reliefStatisticsType));
            }
        }
        this.m_NearestNeighbours = new HashMap();
        this.m_NbThreads = this.m_Data.getSchema().getSettings().getEnsemble().getNumberOfThreads();
    }

    private void initializeNeigbhourLoadSave() {
        this.m_ShouldLoadNeighbours = this.getSettings().getKNN().shouldLoadNeighbours();
        this.m_LoadNearestNeigbhoursFiles = this.m_ShouldLoadNeighbours ? this.getSettings().getKNN().getLoadNeighboursFiles() : new String[]{};
        this.m_ShouldSaveNeighbours = this.getSettings().getKNN().shouldSaveNeighbours();
        this.m_SaveNearestNeigbhoursFile = this.m_ShouldSaveNeighbours ? this.getSettings().getKNN().getSaveNeighboursFile() : "";
    }

    private void initializeNeighbourWeights() {
        if (this.m_WeightNeighbours) {
            for (int neigh = 0; neigh < this.m_MaxNbNeighbours; ++neigh) {
                this.m_NeighbourWeights[neigh] = Math.exp(-(this.m_Sigma * (double)neigh) * (this.m_Sigma * (double)neigh));
            }
        } else {
            Arrays.fill(this.m_NeighbourWeights, 1.0);
        }
    }

    private void initializeInstanceOrder() {
        this.m_Order = this.getSettings().getRelief().getChosenIntances();
        if (Arrays.equals(this.m_Order, SettingsRelief.DUMMY_INSTANCES)) {
            this.m_Order = this.randomPermutation(this.m_NbExamples);
        }
        if (this.m_Order.length < this.m_MaxNbIterations) {
            System.err.println(String.format("Warning! Maximal number of iterations = %d > %d = number of chosen instances.", this.m_MaxNbIterations, this.m_Order.length));
            System.err.println("Setting the maximal number of iterations to the number of chosen instances.");
            this.m_MaxNbIterations = this.m_Order.length;
        }
    }

    private void initializeTimeSeriesDistance() {
        this.m_TimeSeriesDistance = this.m_Data.m_Schema.getSettings().getTimeSeries().getTimeSeriesDistance();
    }

    private void initializeDescriptiveTargetAttributes() {
        for (int space : SPACE_TYPES) {
            ClusAttrType.AttributeUseType attrType;
            ClusAttrType.AttributeUseType attributeUseType = attrType = space == 0 ? ClusAttrType.AttributeUseType.Descriptive : ClusAttrType.AttributeUseType.Target;
            if (this.m_DescriptiveTargetAttr[space] != null) continue;
            this.m_DescriptiveTargetAttr[space] = this.m_Data.m_Schema.getAllAttrUse(attrType);
        }
        this.m_NbDescriptiveAttrs = this.m_DescriptiveTargetAttr[0].length;
        this.m_NbTargetAttrs = this.m_DescriptiveTargetAttr[1].length;
        this.m_IsSparse = this.m_Data.isSparse();
        int nbNonNumericDescriptive = this.m_NbDescriptiveAttrs;
        int nbNonNumericTarget = this.m_NbTargetAttrs;
        if (this.m_IsSparse) {
            nbNonNumericDescriptive -= this.m_Data.getSchema().getNbNumericAttrUse(ClusAttrType.AttributeUseType.Descriptive);
            nbNonNumericTarget -= this.m_Data.getSchema().getNbNumericAttrUse(ClusAttrType.AttributeUseType.Target);
        }
        this.m_DistanceDescriptiveTargetAttr[0] = new int[nbNonNumericDescriptive];
        this.m_DistanceDescriptiveTargetAttr[1] = new int[nbNonNumericTarget];
        for (int space : SPACE_TYPES) {
            int place = 0;
            for (int i = 0; i < this.m_DescriptiveTargetAttr[space].length; ++i) {
                if (this.m_IsSparse && this.m_DescriptiveTargetAttr[space][i].isNumeric()) continue;
                this.m_DistanceDescriptiveTargetAttr[space][place] = i;
                ++place;
            }
            if (place == this.m_DistanceDescriptiveTargetAttr[space].length) continue;
            throw new RuntimeException("Something fishy with the number of nonumeric attributes.");
        }
    }

    private void initializeRankings() {
        this.m_PerformPerTargetRanking = this.m_Data.m_Schema.getSettings().getEnsemble().shouldPerformRankingPerTarget();
        if (this.m_PerformPerTargetRanking && this.m_NbTargetAttrs == 1) {
            System.err.println("Situation:");
            System.err.println("  - Per-target rankings were desired.");
            System.err.println("  - The number of targets is 1, hence per-target ranking == overall ranking.");
            System.err.println("Consequence:");
            System.err.println("  - Only overall feature ranking(s) will be computed.");
            this.m_PerformPerTargetRanking = false;
        }
        this.m_NbGeneralisedTargetAttrs = 1 + (this.m_PerformPerTargetRanking ? this.m_NbTargetAttrs : 0);
        this.setNbFeatureRankings();
        this.m_IsStandardClassification = this.computeStandardClassification();
        this.m_NbTargetValues = this.nbTargetValues();
    }

    private void initializeTargetProbabilities() {
        int upperBound = this.m_IsMLC ? 1 + this.m_NbTargetAttrs : this.m_NbGeneralisedTargetAttrs;
        this.m_TargetProbabilities = new double[upperBound][];
        for (int targetIndex = -1; targetIndex < this.m_TargetProbabilities.length - 1; ++targetIndex) {
            if ((!this.m_IsMLC || targetIndex < 0) && !this.m_IsStandardClassification[targetIndex + 1]) continue;
            this.m_TargetProbabilities[targetIndex + 1] = this.nominalClassCounts(targetIndex);
        }
    }

    private void initializeNumericRanges() {
        this.m_numMins = new HashMap();
        this.m_numMaxs = new HashMap();
        for (int space : SPACE_TYPES) {
            ClusAttrType.AttributeUseType attrType = space == 0 ? ClusAttrType.AttributeUseType.Descriptive : ClusAttrType.AttributeUseType.Target;
            for (NumericAttrType numAttr : this.m_Data.m_Schema.getNumericAttrUse(attrType)) {
                String attrName = numAttr.getName();
                this.m_numMins.put(attrName, Double.POSITIVE_INFINITY);
                this.m_numMaxs.put(attrName, Double.NEGATIVE_INFINITY);
                for (int example = 0; example < this.m_NbExamples; ++example) {
                    double value = numAttr.getNumeric(this.m_Data.getTuple(example));
                    if (value < this.m_numMins.get(attrName)) {
                        this.m_numMins.put(attrName, value);
                    }
                    if (!(value > this.m_numMaxs.get(attrName)) || value == Double.POSITIVE_INFINITY) continue;
                    this.m_numMaxs.put(attrName, value);
                }
            }
        }
    }

    private void prepareForSemiSupervised() {
        this.m_SSLWs = new double[this.m_NbExamples];
        Arrays.fill(this.m_SSLWs, m_BASIC_SSLw);
        HashMap<Integer, ArrayList<Integer>> missingTargetValues = this.m_Data.getMissingTargets();
        if (missingTargetValues.size() > 0) {
            switch (this.m_MissingTargetHandling) {
                case Impute: {
                    MissingTargetImputation.impute(this.m_Run, missingTargetValues);
                    break;
                }
                case UseDescriptive: {
                    this.computeAmountsOfSupervision();
                    break;
                }
                default: {
                    ClusReliefFeatureRanking.ignoreMissing();
                }
            }
        }
    }

    private static void ignoreMissing() {
        ClusLogger.info("Examples with missing values will be mostly ignored.");
    }

    private void computeAmountsOfSupervision() {
        double[] distancesToNotUnlabeled = new double[this.m_NbExamples];
        for (int i = 0; i < this.m_NbExamples; ++i) {
            try {
                distancesToNotUnlabeled[i] = this.findDistanceToFirstNotUnlabeledNeighbour(i);
                continue;
            }
            catch (ClusException e) {
                e.printStackTrace();
            }
        }
        double dMin = Arrays.stream(distancesToNotUnlabeled).min().getAsDouble();
        double dMax = Arrays.stream(distancesToNotUnlabeled).max().getAsDouble();
        double wMin = this.m_SSLW[0];
        double wMax = this.m_SSLW[1];
        if (dMax == 0.0) {
            ClusLogger.info("The data seems to be supervised or all nearest neighbours are 0 away.");
        } else if ((dMax - dMin) / dMax < 1.0E-6) {
            Arrays.fill(this.m_SSLWs, (wMin + wMax) / 2.0);
        } else {
            for (int i = 0; i < this.m_SSLWs.length; ++i) {
                if (!this.m_Data.getTuple(i).isUnlabeled()) continue;
                this.m_SSLWs[i] = ClusReliefFeatureRanking.computeAmountOfSupervision(distancesToNotUnlabeled[i], dMin, dMax, wMin, wMax);
            }
        }
    }

    private static double computeAmountOfSupervision(double d, double minD, double maxD, double minW, double maxW) {
        double k = (maxW - minW) / (minD - maxD);
        return k * (d - minD) + maxW;
    }

    private void setNbFeatureRankings() {
        ArrayList<String> rankings = new ArrayList<String>();
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add("overall");
        if (this.m_PerformPerTargetRanking) {
            for (int targetInd = 0; targetInd < this.m_NbTargetAttrs; ++targetInd) {
                prefixes.add(this.m_DescriptiveTargetAttr[1][targetInd].getName());
            }
        }
        boolean useIndices = this.m_Run.getStatManager().getSettings().getRelief().shouldUseIndicesInNames();
        for (String prefix : prefixes) {
            for (int iterInd = 0; iterInd < this.m_NbIterations.length; ++iterInd) {
                for (int neighInd = 0; neighInd < this.m_NbNeighbours.length; ++neighInd) {
                    int iter = useIndices ? iterInd : this.m_NbIterations[iterInd];
                    int neig = useIndices ? neighInd : this.m_NbNeighbours[neighInd];
                    rankings.add(String.format("%sIter%dNeigh%d", prefix, iter, neig));
                }
            }
        }
        this.setReliefFimpHeader(rankings);
        this.setNbFeatureRankings(prefixes.size() * this.m_NbNeighbours.length * this.m_NbIterations.length);
    }

    private int rankingIndex(int iterationsIndex, int neighboursIndex, int targetIndex) {
        int perTargetShift = (targetIndex + 1) * this.m_NbIterations.length * this.m_NbNeighbours.length;
        return perTargetShift + iterationsIndex * this.m_NbNeighbours.length + neighboursIndex;
    }

    public void computeReliefImportance(RowData data) throws ClusException, InterruptedException, ExecutionException, IOException {
        SettingsRelief.ReliefStatisticsType s;
        int nbTargets = this.m_PerformPerTargetRanking ? 1 + this.m_NbTargetAttrs : 1;
        double[] successfulIterations = new double[nbTargets];
        this.computeNearestNeighbours(this.m_Order);
        int insufficientNbNeighbours = 0;
        int numIterInd = 0;
        boolean[] shouldUpdate = new boolean[nbTargets];
        ClusReliefFeatureRanking.printMessage("Calculating importances ...", 1, this.getSettings().getGeneral().getVerbose());
        for (int iteration = 0; iteration < this.m_MaxNbIterations; ++iteration) {
            this.printProgress(iteration);
            int tupleInd = this.m_Order[iteration];
            DataTuple tuple = data.getTuple(tupleInd);
            for (int targetIndex = -1; targetIndex < this.m_NbGeneralisedTargetAttrs - 1; ++targetIndex) {
                if (!this.shouldUseTuple(targetIndex, tuple)) continue;
                int n = targetIndex + 1;
                successfulIterations[n] = successfulIterations[n] + 1.0;
                NearestNeighbour[][] nearestNeighbours = this.m_IsStandardClassification[targetIndex + 1] && targetIndex >= 0 ? this.m_NearestNeighbours.get(targetIndex).get(tupleInd) : this.m_NearestNeighbours.get(-1).get(tupleInd);
                insufficientNbNeighbours += this.updateDistanceStatistics(data, tuple, tupleInd, nearestNeighbours, targetIndex);
                shouldUpdate[targetIndex + 1] = true;
            }
            if (iteration + 1 != this.m_NbIterations[numIterInd]) continue;
            this.updateImportances(data, numIterInd, successfulIterations, shouldUpdate);
            ++numIterInd;
            shouldUpdate = new boolean[nbTargets];
        }
        if (insufficientNbNeighbours > 0) {
            int ver = this.getSettings().getGeneral().getVerbose();
            String message1 = "Maximal number of neighbours: " + this.m_MaxNbNeighbours;
            String message2 = "Number of cases when we could not find that many neighbours: " + insufficientNbNeighbours;
            ClusReliefFeatureRanking.printMessage(message1 + "\n" + message2, 1, ver);
        }
        if (!(s = this.getSettings().getRelief().getReliefStatisticsType()).equals((Object)SettingsRelief.ReliefStatisticsType.DistanceClassic)) {
            this.normalizeImportances();
        }
    }

    private void normalizeImportances() throws InterruptedException {
        ClusReliefFeatureRanking.printMessage("Normalising importances ... (x --> -1 / x)", 1, this.getSettings().getGeneral().getVerbose());
        for (int a = 0; a < this.m_NbDescriptiveAttrs; ++a) {
            ClusAttrType attr = this.m_DescriptiveTargetAttr[0][a];
            double[] info = this.getAttributeInfo(attr.getName());
            for (int r = 0; r < this.getNbFeatureRankings(); ++r) {
                info[2 + r] = -1.0 / info[2 + r];
            }
            this.putAttributeInfo(attr.getName(), info);
        }
    }

    private void updateImportances(RowData data, int numIterInd, double[] successfulItearions, boolean[] shouldUpdate) throws InterruptedException {
        for (int attrInd = 0; attrInd < this.m_NbDescriptiveAttrs; ++attrInd) {
            ClusAttrType attr = this.m_DescriptiveTargetAttr[0][attrInd];
            double[] info = this.getAttributeInfo(attr.getName());
            for (int targetIndex = -1; targetIndex < this.m_NbGeneralisedTargetAttrs - 1; ++targetIndex) {
                if (!shouldUpdate[targetIndex + 1]) continue;
                boolean isStdClassification = this.m_IsStandardClassification[targetIndex + 1];
                for (int nbNeighInd = 0; nbNeighInd < this.m_NbNeighbours.length; ++nbNeighInd) {
                    int rankingInd = this.rankingIndex(numIterInd, nbNeighInd, targetIndex);
                    int n = 2 + rankingInd;
                    info[n] = info[n] + this.mStats.computeImportances(targetIndex, nbNeighInd, attrInd, isStdClassification, successfulItearions);
                }
            }
            this.putAttributeInfo(attr.getName(), info);
        }
    }

    private int updateDistanceStatistics(RowData data, DataTuple tuple, int tupleIndex, NearestNeighbour[][] nearestNeighbours, int targetIndex) throws ClusException {
        int tempInsufficientNbNeighbours = 0;
        int nbTargetValues = this.m_NbTargetValues[targetIndex + 1];
        for (int targetValue = 0; targetValue < nbTargetValues; ++targetValue) {
            this.mStats.resetTempFields();
            double sumNeighbourWeights = 0.0;
            boolean isStdClassification = this.m_IsStandardClassification[targetIndex + 1];
            int trueIndex = this.getTrueTargetIndex(targetIndex);
            int numNeighInd = 0;
            int nbNeighbours = Math.min(this.m_MaxNbNeighbours, nearestNeighbours[targetValue].length);
            for (int neighbour = 0; neighbour < nbNeighbours; ++neighbour) {
                if (nearestNeighbours[targetValue].length < this.m_MaxNbNeighbours) {
                    ++tempInsufficientNbNeighbours;
                }
                sumNeighbourWeights += this.m_NeighbourWeights[neighbour];
                double neighWeightNonnormalized = this.m_NeighbourWeights[neighbour];
                NearestNeighbour neigh = nearestNeighbours[targetValue][neighbour];
                this.mStats.updateTempStatistics(targetIndex, isStdClassification, tuple, data, neigh, neighWeightNonnormalized *= this.m_SSLWs[tupleIndex] * this.m_SSLWs[neigh.getIndexInDataset()], trueIndex, targetValue);
                if (neighbour + 1 != this.m_NbNeighbours[numNeighInd]) continue;
                this.mStats.updateStatistics(targetIndex, numNeighInd, sumNeighbourWeights);
                ++numNeighInd;
            }
        }
        return tempInsufficientNbNeighbours;
    }

    private boolean[] computeStandardClassification() {
        boolean[] isPerTarget = new boolean[this.m_NbGeneralisedTargetAttrs];
        SettingsRelief.ReliefStatisticsType s = this.getSettings().getRelief().getReliefStatisticsType();
        if (!s.equals((Object)SettingsRelief.ReliefStatisticsType.DistanceClassic)) {
            return isPerTarget;
        }
        if (this.m_MissingTargetHandling.equals((Object)SettingsRelief.MissingTargetHandling.UseDescriptive)) {
            ClusLogger.info("Using Descriptive distances make us use regressive definition of the Relief.");
            return isPerTarget;
        }
        isPerTarget[0] = this.m_NbTargetAttrs == 1 && this.m_DescriptiveTargetAttr[1][0] instanceof NominalAttrType;
        for (int targetIndex = 1; targetIndex < this.m_NbGeneralisedTargetAttrs; ++targetIndex) {
            isPerTarget[targetIndex] = this.m_DescriptiveTargetAttr[1][targetIndex - 1] instanceof NominalAttrType;
        }
        return isPerTarget;
    }

    private int[] nbTargetValues() {
        int[] nbValues = new int[this.m_IsStandardClassification.length];
        for (int targetIndex = -1; targetIndex < this.m_NbGeneralisedTargetAttrs - 1; ++targetIndex) {
            int trueIndex = this.getTrueTargetIndex(targetIndex);
            nbValues[targetIndex + 1] = this.m_IsStandardClassification[targetIndex + 1] ? ((NominalAttrType)this.m_DescriptiveTargetAttr[1][trueIndex]).getNbValues() : 1;
        }
        return nbValues;
    }

    private double[] nominalClassCounts(int nominalTargetIndex) {
        int nbValues = this.m_IsMLC ? 2 : this.m_NbTargetValues[nominalTargetIndex + 1];
        double[] targetProbabilities = new double[nbValues + 1];
        int trueIndex = this.getTrueTargetIndex(nominalTargetIndex);
        NominalAttrType attr = (NominalAttrType)this.m_DescriptiveTargetAttr[1][trueIndex];
        for (int example = 0; example < this.m_NbExamples; ++example) {
            int n = attr.getNominal(this.m_Data.getTuple(example));
            targetProbabilities[n] = targetProbabilities[n] + 1.0;
        }
        if ((double)this.m_NbExamples > 1.0E-9 + targetProbabilities[nbValues]) {
            int value = 0;
            while (value < nbValues) {
                int n = value++;
                targetProbabilities[n] = targetProbabilities[n] / ((double)this.m_NbExamples - targetProbabilities[nbValues]);
            }
        }
        return targetProbabilities;
    }

    @Deprecated
    public NearestNeighbour[][] findNearestNeighbours(int tupleInd, int targetIndex) throws ClusException, InterruptedException {
        DataTuple tuple = this.m_Data.getTuple(tupleInd);
        boolean isStdClassification = this.m_IsStandardClassification[targetIndex + 1];
        int nbTargetValues = this.m_NbTargetValues[targetIndex + 1];
        int trueIndex = this.getTrueTargetIndex(targetIndex);
        int[][] neighbours = new int[nbTargetValues][this.m_MaxNbNeighbours];
        double[] distances = new double[this.m_NbExamples];
        int[] whereToPlaceNeigh = new int[nbTargetValues];
        for (int i = 0; i < this.m_NbExamples; ++i) {
            distances[i] = this.computeDistance(tuple, this.m_Data.getTuple(i), 0);
        }
        boolean[] isSorted = new boolean[nbTargetValues];
        for (int i = 0; i < this.m_NbExamples; ++i) {
            int targetValue;
            boolean sortingNeeded = false;
            if (i == tupleInd) continue;
            int n = targetValue = isStdClassification ? this.m_DescriptiveTargetAttr[1][trueIndex].getNominal(this.m_Data.getTuple(i)) : 0;
            if (targetValue < nbTargetValues) {
                if (whereToPlaceNeigh[targetValue] < this.m_MaxNbNeighbours) {
                    neighbours[targetValue][whereToPlaceNeigh[targetValue]] = i;
                    int n2 = targetValue;
                    whereToPlaceNeigh[n2] = whereToPlaceNeigh[n2] + 1;
                    if (whereToPlaceNeigh[targetValue] == this.m_MaxNbNeighbours) {
                        ClusReliefFeatureRanking.bruteForceSort(neighbours[targetValue], this.m_MaxNbNeighbours, distances);
                        isSorted[targetValue] = true;
                    }
                } else {
                    sortingNeeded = true;
                }
            }
            if (!sortingNeeded || distances[i] >= distances[neighbours[targetValue][0]]) continue;
            for (int j = 1; j < this.m_MaxNbNeighbours && distances[i] < distances[neighbours[targetValue][j]]; ++j) {
                neighbours[targetValue][j - 1] = neighbours[targetValue][j];
            }
            neighbours[targetValue][j - 1] = i;
            isSorted[targetValue] = true;
        }
        NearestNeighbour[][] nearestNeighbours = new NearestNeighbour[nbTargetValues][];
        for (int value = 0; value < nbTargetValues; ++value) {
            nearestNeighbours[value] = new NearestNeighbour[whereToPlaceNeigh[value]];
            if (!isSorted[value]) {
                ClusReliefFeatureRanking.bruteForceSort(neighbours[value], whereToPlaceNeigh[value], distances);
            }
            for (int i = 0; i < whereToPlaceNeigh[value]; ++i) {
                int datasetIndex = neighbours[value][i];
                double descriptiveSpaceDist = distances[neighbours[value][i]];
                nearestNeighbours[value][whereToPlaceNeigh[value] - i - 1] = new NearestNeighbour(datasetIndex, descriptiveSpaceDist);
            }
        }
        int currentCount = this.updateNeighCount();
        this.printProgressParallel(currentCount, this.m_NeighCounterBound);
        return nearestNeighbours;
    }

    public HashMap<Integer, NearestNeighbour[][]> findNearestNeighbours(int tupleInd, ArrayList<Integer> necessaryTargetIndices) throws ClusException, InterruptedException {
        boolean[] isSorted;
        int[] whereToPlaceNeigh;
        int[][] neighbours;
        int nbTargetValues;
        DataTuple tuple = this.m_Data.getTuple(tupleInd);
        double[] distances = new double[this.m_NbExamples];
        for (int i = 0; i < this.m_NbExamples; ++i) {
            distances[i] = this.computeDistance(tuple, this.m_Data.getTuple(i), 0);
        }
        HashMap<Integer, int[][]> neighbourss = new HashMap<Integer, int[][]>();
        HashMap<Integer, int[]> whereToPlaceNeighs = new HashMap<Integer, int[]>();
        HashMap<Integer, boolean[]> isSorteds = new HashMap<Integer, boolean[]>();
        for (int targetIndex : necessaryTargetIndices) {
            nbTargetValues = this.m_NbTargetValues[targetIndex + 1];
            neighbourss.put(targetIndex, new int[nbTargetValues][this.m_MaxNbNeighbours]);
            whereToPlaceNeighs.put(targetIndex, new int[nbTargetValues]);
            isSorteds.put(targetIndex, new boolean[nbTargetValues]);
        }
        for (int targetIndex : necessaryTargetIndices) {
            boolean isStdClassification = this.m_IsStandardClassification[targetIndex + 1];
            nbTargetValues = this.m_NbTargetValues[targetIndex + 1];
            int trueIndex = this.getTrueTargetIndex(targetIndex);
            neighbours = (int[][])neighbourss.get(targetIndex);
            whereToPlaceNeigh = (int[])whereToPlaceNeighs.get(targetIndex);
            isSorted = (boolean[])isSorteds.get(targetIndex);
            for (int i = 0; i < this.m_NbExamples; ++i) {
                int targetValue;
                boolean sortingNeeded = false;
                if (i == tupleInd) continue;
                int n = targetValue = isStdClassification ? this.m_DescriptiveTargetAttr[1][trueIndex].getNominal(this.m_Data.getTuple(i)) : 0;
                if (targetValue < nbTargetValues) {
                    if (whereToPlaceNeigh[targetValue] < this.m_MaxNbNeighbours) {
                        neighbours[targetValue][whereToPlaceNeigh[targetValue]] = i;
                        int n2 = targetValue;
                        whereToPlaceNeigh[n2] = whereToPlaceNeigh[n2] + 1;
                        if (whereToPlaceNeigh[targetValue] == this.m_MaxNbNeighbours) {
                            ClusReliefFeatureRanking.bruteForceSort(neighbours[targetValue], this.m_MaxNbNeighbours, distances);
                            isSorted[targetValue] = true;
                        }
                    } else {
                        sortingNeeded = true;
                    }
                }
                if (!sortingNeeded || distances[i] >= distances[neighbours[targetValue][0]]) continue;
                for (int j = 1; j < this.m_MaxNbNeighbours && distances[i] < distances[neighbours[targetValue][j]]; ++j) {
                    neighbours[targetValue][j - 1] = neighbours[targetValue][j];
                }
                neighbours[targetValue][j - 1] = i;
                isSorted[targetValue] = true;
            }
            int currentCount = this.updateNeighCount();
            this.printProgressParallel(currentCount, this.m_NeighCounterBound);
        }
        HashMap<Integer, NearestNeighbour[][]> nearestNeighbourss = new HashMap<Integer, NearestNeighbour[][]>();
        for (int targetIndex : necessaryTargetIndices) {
            nbTargetValues = this.m_NbTargetValues[targetIndex + 1];
            NearestNeighbour[][] nearestNeighbours = new NearestNeighbour[nbTargetValues][];
            nearestNeighbourss.put(targetIndex, nearestNeighbours);
            whereToPlaceNeigh = (int[])whereToPlaceNeighs.get(targetIndex);
            isSorted = (boolean[])isSorteds.get(targetIndex);
            neighbours = (int[][])neighbourss.get(targetIndex);
            for (int value = 0; value < nbTargetValues; ++value) {
                nearestNeighbours[value] = new NearestNeighbour[whereToPlaceNeigh[value]];
                if (!isSorted[value]) {
                    ClusReliefFeatureRanking.bruteForceSort(neighbours[value], whereToPlaceNeigh[value], distances);
                }
                for (int i = 0; i < whereToPlaceNeigh[value]; ++i) {
                    int datasetIndex = neighbours[value][i];
                    double descriptiveSpaceDist = distances[neighbours[value][i]];
                    nearestNeighbours[value][whereToPlaceNeigh[value] - i - 1] = new NearestNeighbour(datasetIndex, descriptiveSpaceDist);
                }
            }
        }
        return nearestNeighbourss;
    }

    public double findDistanceToFirstNotUnlabeledNeighbour(int tupleInd) throws ClusException {
        DataTuple tuple = this.m_Data.getTuple(tupleInd);
        if (!tuple.isUnlabeled()) {
            return 0.0;
        }
        double minDistance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.m_NbExamples; ++i) {
            double distance;
            if (this.m_Data.getTuple(i).isUnlabeled() || !((distance = this.computeDistance(tuple, this.m_Data.getTuple(i), 0)) < minDistance)) continue;
            minDistance = distance;
        }
        return minDistance;
    }

    private static void bruteForceSort(int[] neighs, int upperBound, double[] distances) {
        for (int ind1 = 0; ind1 < upperBound; ++ind1) {
            for (int ind2 = ind1 + 1; ind2 < upperBound; ++ind2) {
                if (!(distances[neighs[ind1]] < distances[neighs[ind2]])) continue;
                int temp = neighs[ind1];
                neighs[ind1] = neighs[ind2];
                neighs[ind2] = temp;
            }
        }
    }

    @Deprecated
    private double computeDistanceOld(DataTuple t1, DataTuple t2, int space) throws ClusException {
        double dist = 0.0;
        if (this.m_IsMLC && space == 1) {
            return this.m_MLCDist.calculateDist(t1, t2);
        }
        int dimensions = space == 0 ? this.m_NbDescriptiveAttrs : this.m_NbTargetAttrs;
        for (int attrInd = 0; attrInd < dimensions; ++attrInd) {
            ClusAttrType attr = this.m_DescriptiveTargetAttr[space][attrInd];
            dist += this.computeDistance1D(t1, t2, attr);
        }
        return dist / (double)dimensions;
    }

    public double computeDistance(DataTuple t1, DataTuple t2, int space) throws ClusException {
        ClusAttrType attr;
        double dist = 0.0;
        if (this.m_IsMLC && space == 1) {
            return this.m_MLCDist.calculateDist(t1, t2);
        }
        int dimensionsFull = space == 0 ? this.m_NbDescriptiveAttrs : this.m_NbTargetAttrs;
        int dimensions = this.m_DistanceDescriptiveTargetAttr[space].length;
        for (int attrInd = 0; attrInd < dimensions; ++attrInd) {
            attr = this.m_DescriptiveTargetAttr[space][this.m_DistanceDescriptiveTargetAttr[space][attrInd]];
            dist += this.computeDistance1D(t1, t2, attr);
        }
        if (this.m_IsSparse) {
            Set<Integer> inds1 = ((SparseDataTuple)t1).getAttributeIndicesSet();
            Set<Integer> inds2 = ((SparseDataTuple)t2).getAttributeIndicesSet();
            HashSet<Integer> inds = new HashSet<Integer>(inds1);
            inds.addAll(inds2);
            ClusSchema s = t1.getSchema();
            for (int ind : inds) {
                attr = s.getAttrType(ind);
                dist += this.computeDistance1D(t1, t2, attr);
            }
        }
        return dist / (double)dimensionsFull;
    }

    public double computeDistance1D(DataTuple t1, DataTuple t2, ClusAttrType attr) throws ClusException {
        if (attr.isNominal()) {
            return this.computeNominalDist1D(t1, t2, (NominalAttrType)attr);
        }
        if (attr.isNumeric()) {
            double normFactor = this.m_numMaxs.get(attr.getName()) - this.m_numMins.get(attr.getName());
            if (normFactor == 0.0) {
                normFactor = 1.0;
            }
            return this.computeNumericDist1D(t1, t2, (NumericAttrType)attr, normFactor);
        }
        if (attr.isClasses()) {
            return this.computeHierarchicalDist1D(t1, t2, (ClassesAttrType)attr);
        }
        if (attr.isTimeSeries()) {
            return this.computeTimeSeriesDist1D(t1, t2, (TimeSeriesAttrType)attr);
        }
        if (attr.isString()) {
            return this.computeStringDist1D(t1, t2, (StringAttrType)attr);
        }
        throw new ClusException("Unknown attribute type for attribute " + attr.getName() + ": " + attr.getClass().toString());
    }

    public double computeNominalDist1D(DataTuple t1, DataTuple t2, NominalAttrType attr) {
        int v1 = attr.getNominal(t1);
        int v2 = attr.getNominal(t2);
        if (v1 >= attr.getNbValues() || v2 >= attr.getNbValues()) {
            return 1.0 - 1.0 / (double)attr.getNbValues();
        }
        return v1 == v2 ? 0.0 : 1.0;
    }

    public double computeNumericDist1D(DataTuple t1, DataTuple t2, NumericAttrType attr, double normalizationFactor) {
        double t;
        double v1 = attr.getNumeric(t1);
        double v2 = attr.getNumeric(t2);
        if (ClusReliefFeatureRanking.isMissing(v1)) {
            if (ClusReliefFeatureRanking.isMissing(v2)) {
                t = BOTH_MISSING_DIST;
            } else {
                t = (v2 - this.m_numMins.get(attr.getName())) / normalizationFactor;
                t = Math.max(t, 1.0 - t);
            }
        } else if (ClusReliefFeatureRanking.isMissing(v2)) {
            t = (v1 - this.m_numMins.get(attr.getName())) / normalizationFactor;
            t = Math.max(t, 1.0 - t);
        } else {
            t = Math.abs(v1 - v2) / normalizationFactor;
        }
        return t;
    }

    public double computeHierarchicalDist1D(DataTuple t1, DataTuple t2, ClassesAttrType attr) {
        return this.m_HierarMLCDist.calculateDist(t1, t2, attr);
    }

    public double computeTimeSeriesDist1D(DataTuple t1, DataTuple t2, TimeSeriesAttrType attr) throws ClusException {
        TimeSeries ts1 = attr.getTimeSeries(t1);
        TimeSeries ts2 = attr.getTimeSeries(t2);
        switch (this.m_TimeSeriesDistance) {
            case DTW: {
                return new DTWTimeSeriesDist(attr).calcDistance(t1, t2);
            }
            case QDM: {
                if (ts1.length() == ts2.length()) {
                    return new QDMTimeSeriesDist(attr).calcDistance(t1, t2);
                }
                throw new ClusException("QDM Distance is not implemented for time series with different length");
            }
            case TSC: {
                return new TSCTimeSeriesDist(attr).calcDistance(t1, t2);
            }
        }
        throw new ClusException("ClusReliefFeatureRanking.m_TimeSeriesDistance was not set to any known value.");
    }

    public double computeStringDist1D(DataTuple t1, DataTuple t2, StringAttrType attr) {
        return new Levenshtein(t1, t2, attr).getDist();
    }

    private int[] randomPermutation(int examples) {
        int i;
        int[] permuted = new int[examples];
        for (i = 0; i < permuted.length; ++i) {
            permuted[i] = i;
        }
        for (i = permuted.length - 1; i > 0; --i) {
            int ind = this.m_rnd.nextInt(i + 1);
            int temp = permuted[ind];
            permuted[ind] = permuted[i];
            permuted[i] = temp;
        }
        return permuted;
    }

    public void setReliefFimpHeader(ArrayList<String> names) {
        this.setFimpHeader(this.fimpTableHeader(names));
    }

    public void setReliefDescription(int[] neighbours, int[] iterations) {
        String first = "Ranking method: Relief with all combinations of";
        String second = String.format("numbers of neighbours: %s", Arrays.toString(neighbours));
        String third = String.format("numbers of iterations: %s", Arrays.toString(iterations));
        this.setRankingDescription(String.join((CharSequence)"\n", first, second, third));
    }

    private void printProgress(int iteration) {
        double proportion = 100.0 * (double)(iteration + 1) / (double)this.m_MaxNbIterations;
        int verbosity = this.getSettings().getGeneral().getVerbose();
        if (verbosity > 0) {
            while ((double)this.m_Percents < proportion && this.m_Percents < 100) {
                System.out.print(".");
                ++this.m_Percents;
                if (this.m_Percents / 10 * 10 != this.m_Percents) continue;
                ClusLogger.info(String.format(" %3d percents", this.m_Percents));
            }
        }
    }

    private synchronized void printProgressParallel(int counterVal, int counterBound) throws InterruptedException {
        double proportion = 100.0 * (double)(counterVal + 1) / (double)counterBound;
        int verbosity = this.getSettings().getGeneral().getVerbose();
        if (verbosity > 0) {
            this.m_CounterLock.writingLock();
            while ((double)this.m_NeighPercents < proportion && this.m_NeighPercents < 100) {
                System.out.print(".");
                ++this.m_NeighPercents;
                if (this.m_NeighPercents / 10 * 10 != this.m_NeighPercents) continue;
                ClusLogger.info(String.format(" %3d percents", this.m_NeighPercents));
            }
            this.m_CounterLock.writingUnlock();
        }
    }

    private synchronized int updateNeighCount() throws InterruptedException {
        this.m_CounterLock.writingLock();
        ++this.m_NeighCounter;
        int current = this.m_NeighCounter;
        this.m_CounterLock.writingUnlock();
        return current;
    }

    private int getTrueTargetIndex(int targetIndex) {
        if (this.m_IsStandardClassification[0]) {
            return targetIndex + 1;
        }
        return targetIndex;
    }

    private ArrayList<Integer> computeTargetIndicesThatNeedNeigbhours() {
        ArrayList<Integer> answer = new ArrayList<Integer>();
        answer.add(-1);
        for (int targetIndex = 0; targetIndex < this.m_NbGeneralisedTargetAttrs - 1; ++targetIndex) {
            if (!this.m_IsStandardClassification[targetIndex + 1]) continue;
            answer.add(targetIndex);
        }
        return answer;
    }

    private void computeNearestNeighbours(int[] randomPermutation) throws InterruptedException, ExecutionException, IOException, ClusException {
        if (this.m_ShouldLoadNeighbours) {
            ClusReliefFeatureRanking.printMessage("Loading nearest neighbours ...", 1, this.getSettings().getGeneral().getVerbose());
            SaveLoadNeighbours nnLoader = new SaveLoadNeighbours(this.m_LoadNearestNeigbhoursFiles, null);
            this.m_NearestNeighbours = nnLoader.loadNeighboursFromFiles();
        } else {
            ClusReliefFeatureRanking.printMessage("Calculating nearest neighbours ...", 1, this.getSettings().getGeneral().getVerbose());
            ArrayList<Integer> necessaryTargetIndices = this.computeTargetIndicesThatNeedNeigbhours();
            this.m_NeighCounter = 0;
            this.m_NeighCounterBound = necessaryTargetIndices.size() * randomPermutation.length;
            this.m_NeighPercents = 0;
            ExecutorService executor = Executors.newFixedThreadPool(this.m_NbThreads);
            ArrayList<Future<Triple<ArrayList<Integer>, Integer, HashMap<Integer, NearestNeighbour[][]>>>> results = new ArrayList<Future<Triple<ArrayList<Integer>, Integer, HashMap<Integer, NearestNeighbour[][]>>>>();
            for (Integer targetIndex : necessaryTargetIndices) {
                this.m_NearestNeighbours.put(targetIndex, new HashMap());
            }
            for (Object tupleIndex : (Iterator)randomPermutation) {
                DataTuple tuple = this.m_Data.getTuple((int)tupleIndex);
                ArrayList<Integer> appropriateTargets = new ArrayList<Integer>();
                for (Integer targetIndex : necessaryTargetIndices) {
                    if (!this.shouldUseTuple(targetIndex, tuple)) continue;
                    appropriateTargets.add(targetIndex);
                }
                FindNeighboursCallable task = new FindNeighboursCallable(this, (int)tupleIndex, appropriateTargets);
                Future<Triple<ArrayList<Integer>, Integer, HashMap<Integer, NearestNeighbour[][]>>> result = executor.submit(task);
                results.add(result);
            }
            executor.shutdown();
            executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            for (Future futureTriple : results) {
                Triple triple = (Triple)futureTriple.get();
                for (Integer targetIndex : (ArrayList)triple.getFirst()) {
                    this.m_NearestNeighbours.get(targetIndex).put((Integer)triple.getSecond(), (NearestNeighbour[][])((HashMap)triple.getThird()).get(targetIndex));
                }
            }
        }
        if (this.m_ShouldSaveNeighbours) {
            SaveLoadNeighbours nnSaver = new SaveLoadNeighbours(null, this.m_SaveNearestNeigbhoursFile);
            nnSaver.saveNeighboursToFile(this.m_NearestNeighbours);
        }
    }

    @Deprecated
    private void recomputeNeighbourTargetDistances() throws ClusException {
        for (int targetIndex : this.m_NearestNeighbours.keySet()) {
            for (int tupleIndex : this.m_NearestNeighbours.get(targetIndex).keySet()) {
                NearestNeighbour[][] nnss;
                DataTuple t1 = this.m_Data.getTuple(tupleIndex);
                NearestNeighbour[][] nearestNeighbourArray = nnss = this.m_NearestNeighbours.get(targetIndex).get(tupleIndex);
                int n = nearestNeighbourArray.length;
                for (int i = 0; i < n; ++i) {
                    NearestNeighbour[] nns;
                    for (NearestNeighbour nn : nns = nearestNeighbourArray[i]) {
                        DataTuple t2 = this.m_Data.getTuple(nn.getIndexInDataset());
                        nn.setTargetDistance(this.computeDistance(t1, t2, 1));
                    }
                }
            }
        }
    }

    public static void printMessage(String message, int desiredVerboseLevel, int verboseLevel) {
        if (desiredVerboseLevel <= verboseLevel) {
            ClusLogger.info(message);
        }
    }

    private boolean shouldUseTuple(int targetIndex, DataTuple tuple) {
        int trueIndex = this.getTrueTargetIndex(targetIndex);
        return !this.m_IsStandardClassification[targetIndex + 1] || !this.m_DescriptiveTargetAttr[1][trueIndex].isMissing(tuple);
    }

    public String getMultilabelDistance() {
        return this.m_MLCDist.distanceName();
    }

    private static boolean isMissing(double val) {
        return val == Double.POSITIVE_INFINITY;
    }

    public ClusAttrType getDescriptiveAttribute(int attrInd) {
        return this.m_DescriptiveTargetAttr[0][attrInd];
    }

    public ClusAttrType getTargetAttribute(int attrInd) {
        return this.m_DescriptiveTargetAttr[1][attrInd];
    }

    public double getTargetProbability(int targetIndex, int targetValue) {
        return this.m_TargetProbabilities[targetIndex + 1][targetValue];
    }

    public int getMaxNbIterations() {
        return this.m_MaxNbIterations;
    }
}

