/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.featureRanking;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import si.ijs.kt.clus.util.tuple.Quadruple;

public class Fimp {
    private ArrayList<String> m_FimpHeader;
    private Quadruple<String, String, String[], String[]> m_TableHeaderColumnBlocks;
    private ArrayList<Quadruple<Integer, String, int[], double[]>> m_TableContentsColumnBlocks;
    private static String CONTENTS_SEPARATOR = "------";

    public Fimp(String fimp_file) throws IOException {
        this.m_FimpHeader = new ArrayList();
        this.m_TableContentsColumnBlocks = new ArrayList();
        BufferedReader br = new BufferedReader(new FileReader(fimp_file));
        String previous = null;
        String line = br.readLine();
        while (!line.startsWith(CONTENTS_SEPARATOR)) {
            if (previous != null) {
                this.m_FimpHeader.add(previous);
            }
            previous = line;
            line = br.readLine();
        }
        line = previous;
        String[] decomposedHeader = line.split("\t");
        String attributeDatasetIndex = decomposedHeader[0];
        String attributeName = decomposedHeader[1];
        String[] rankNames = Fimp.decomposeArrayStr(decomposedHeader[2]);
        String[] rankingNames = Fimp.decomposeArrayStr(decomposedHeader[3]);
        this.m_TableHeaderColumnBlocks = new Quadruple<String, String, String[], String[]>(attributeDatasetIndex, attributeName, rankNames, rankingNames);
        line = br.readLine();
        while (line != null) {
            String[] indNameRanksRelevances = line.split("\t");
            int ind = Integer.parseInt(indNameRanksRelevances[0]);
            String name = indNameRanksRelevances[1];
            int[] ranks = Fimp.getArrayOfInts(indNameRanksRelevances[2]);
            double[] relevances = Fimp.getArrayOfDoubles(indNameRanksRelevances[3]);
            this.m_TableContentsColumnBlocks.add(new Quadruple<Integer, String, int[], double[]>(ind, name, ranks, relevances));
            line = br.readLine();
        }
        br.close();
    }

    public Fimp(ArrayList<String> fimpHeader, Quadruple<String, String, String[], String[]> tableHeaderColumnBlocks, ArrayList<Quadruple<Integer, String, int[], double[]>> tableContentsColumnBlocks) {
        this.m_FimpHeader = fimpHeader;
        this.m_TableHeaderColumnBlocks = tableHeaderColumnBlocks;
        this.m_TableContentsColumnBlocks = tableContentsColumnBlocks;
    }

    public ArrayList<String> getFimpHeader() {
        return this.m_FimpHeader;
    }

    public Quadruple<String, String, String[], String[]> getTableHeaderColumnBlocks() {
        return this.m_TableHeaderColumnBlocks;
    }

    public ArrayList<Quadruple<Integer, String, int[], double[]>> getTableContentsColumnBlocks() {
        return this.m_TableContentsColumnBlocks;
    }

    public static String[] decomposeArrayStr(String strArray) {
        return strArray.substring(1, strArray.length() - 1).split(",");
    }

    public static int[] getArrayOfInts(String strArray) {
        String[] decomposed = Fimp.decomposeArrayStr(strArray);
        int[] parsed = new int[decomposed.length];
        for (int i = 0; i < parsed.length; ++i) {
            parsed[i] = Integer.parseInt(decomposed[i].trim());
        }
        return parsed;
    }

    public static double[] getArrayOfDoubles(String strArray) {
        String[] decomposed = Fimp.decomposeArrayStr(strArray);
        double[] parsed = new double[decomposed.length];
        for (int i = 0; i < parsed.length; ++i) {
            parsed[i] = Double.parseDouble(decomposed[i].trim());
        }
        return parsed;
    }
}

