/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.exhaustivesearch;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import si.ijs.kt.clus.Clus;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.ClusInductionAlgorithmType;
import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.algo.split.FindBestTest;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.algo.tdidt.ConstraintDFInduce;
import si.ijs.kt.clus.algo.tdidt.processor.BasicExampleCollector;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.beamsearch.ClusBeam;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamHeuristic;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamModel;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamTreeElem;
import si.ijs.kt.clus.ext.constraint.ClusConstraintFile;
import si.ijs.kt.clus.ext.exhaustivesearch.ClusExhaustiveInduce;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.model.io.ClusModelCollectionIO;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.io.MyFile;
import si.ijs.kt.clus.util.jeans.math.SingleStat;
import si.ijs.kt.clus.util.jeans.util.MyArray;
import si.ijs.kt.clus.util.jeans.util.StringUtils;
import si.ijs.kt.clus.util.jeans.util.cmdline.CMDLineArgs;

public class ClusExhaustiveSearch
extends ClusInductionAlgorithmType {
    public static final int HEURISTIC_ERROR = 0;
    public static final int HEURISTIC_SS = 1;
    protected BasicExampleCollector m_Coll = new BasicExampleCollector();
    protected ConstraintDFInduce m_Induce;
    protected ClusExhaustiveInduce m_BeamInduce;
    protected boolean m_BeamChanged;
    protected int m_CurrentModel;
    protected int m_MaxTreeSize;
    protected double m_MaxError;
    protected double m_TotalWeight;
    protected ArrayList m_BeamStats;
    protected ClusBeam m_Beam;
    protected boolean m_BeamPostPruning;
    protected ClusBeamHeuristic m_Heuristic;
    protected ClusHeuristic m_AttrHeuristic;
    protected boolean m_Verbose;

    public ClusExhaustiveSearch(Clus clus) throws ClusException, IOException {
        super(clus);
    }

    public void reset() {
        this.m_Beam = null;
        this.m_BeamChanged = false;
        this.m_CurrentModel = -1;
        this.m_TotalWeight = 0.0;
        this.m_BeamStats = new ArrayList();
    }

    @Override
    public ClusInductionAlgorithm createInduce(ClusSchema schema, Settings sett, CMDLineArgs cargs) throws ClusException, IOException {
        schema.addIndices(0);
        this.m_BeamInduce = new ClusExhaustiveInduce(schema, sett, this);
        this.m_BeamInduce.getStatManager().setBeamSearch(true);
        return this.m_BeamInduce;
    }

    public void initializeHeuristic() {
        ClusStatManager smanager = this.m_BeamInduce.getStatManager();
        Settings sett = smanager.getSettings();
        this.m_MaxTreeSize = sett.getConstraints().getMaxSize();
        this.m_MaxError = sett.getConstraints().getMaxErrorConstraint(0);
        ClusLogger.info("ClusExhaustiveSearch : The Max Error is " + this.m_MaxError);
        this.m_BeamPostPruning = sett.getBeamSearch().isBeamPostPrune();
        this.m_Heuristic = (ClusBeamHeuristic)smanager.getHeuristic();
        SettingsTree.Heuristic attr_heur = sett.getBeamSearch().getBeamAttrHeuristic();
        if (!attr_heur.equals((Object)SettingsTree.Heuristic.Default)) {
            this.m_AttrHeuristic = smanager.createHeuristic(attr_heur);
            this.m_Heuristic.setAttrHeuristic(this.m_AttrHeuristic);
        }
    }

    public final boolean isBeamPostPrune() {
        return this.m_BeamPostPruning;
    }

    public double computeLeafAdd(ClusNode leaf) {
        return this.m_Heuristic.computeLeafAdd(leaf);
    }

    public double estimateBeamMeasure(ClusNode tree) {
        return this.m_Heuristic.estimateBeamMeasure(tree);
    }

    public void initSelector(CurrentBestTestAndHeuristic sel) {
        if (this.hasAttrHeuristic()) {
            sel.setHeuristic(this.m_AttrHeuristic);
        }
    }

    public final boolean hasAttrHeuristic() {
        return this.m_AttrHeuristic != null;
    }

    public ClusBeam initializeBeamExhaustive(ClusRun run) throws Exception {
        ClusStatManager smanager = this.m_BeamInduce.getStatManager();
        Settings sett = smanager.getSettings();
        sett.getModel().setMinimalWeight(1.0);
        ClusBeam beam = new ClusBeam(-1, false);
        RowData train = (RowData)run.getTrainingSet();
        ClusStatistic stat = this.m_Induce.createTotalClusteringStat(train);
        stat.calcMean();
        this.m_Induce.initSelectorAndSplit(stat);
        this.initSelector(this.m_Induce.getBestTest());
        ClusLogger.info("Root statistic: " + stat);
        ClusNode root = null;
        String constr_file = sett.getConstraints().getConstraintFile();
        if (StringUtils.unCaseCompare(constr_file, "None")) {
            root = new ClusNode();
            root.setClusteringStat(stat);
        } else {
            ClusConstraintFile file = ClusConstraintFile.getInstance();
            root = file.getClone(constr_file);
            root.setClusteringStat(stat);
            this.m_Induce.fillInStatsAndTests(root, train);
        }
        double weight = root.getClusteringStat().getTotalWeight();
        this.setTotalWeight(weight);
        double value = this.estimateBeamMeasure(root);
        beam.addModel(new ClusBeamModel(value, root));
        ClusLogger.info("the number of children from the root node is :" + root.getNbChildren());
        return beam;
    }

    public void refineGivenLeafExhaustive(ClusNode leaf, ClusBeamModel root, ClusBeam beam, ClusAttrType[] attrs) throws Exception {
        MyArray arr = (MyArray)leaf.getVisitor();
        RowData data = new RowData(arr.getObjects(), arr.size());
        if (this.m_Induce.initSelectorAndStopCrit(leaf, data)) {
            ClusLogger.info("stopping criterion reached in refineGivenLeafExhaustive");
            return;
        }
        if (leaf.getClusteringStat().getError() == 0.0) {
            return;
        }
        CurrentBestTestAndHeuristic sel = this.m_Induce.getBestTest();
        FindBestTest find = this.m_Induce.getFindBestTest();
        double base_value = root.getValue();
        double leaf_add = this.m_Heuristic.computeLeafAdd(leaf);
        this.m_Heuristic.setTreeOffset(base_value - leaf_add);
        for (int i = 0; i < attrs.length; ++i) {
            sel.resetBestTest();
            double beam_min_value = Double.NEGATIVE_INFINITY;
            sel.setBestHeur(beam_min_value);
            ClusAttrType at = attrs[i];
            if (at instanceof NominalAttrType) {
                find.findNominal((NominalAttrType)at, data, null);
            } else {
                find.findNumeric((NumericAttrType)at, data, null);
            }
            if (!sel.hasBestTest()) continue;
            ClusNode ref_leaf = (ClusNode)leaf.cloneNode();
            ref_leaf.testToNode(sel);
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("Test: " + ref_leaf.getTestString() + " -> " + sel.m_BestHeur + " (" + ref_leaf.getTest().getPosFreq() + ")");
            }
            ClusStatManager mgr = this.m_Induce.getStatManager();
            int arity = ref_leaf.updateArity();
            NodeTest test = ref_leaf.getTest();
            for (int j = 0; j < arity; ++j) {
                ClusNode child = new ClusNode();
                ref_leaf.setChild(child, j);
                RowData subset = data.applyWeighted(test, j);
                child.initClusteringStat(mgr, subset);
                child.initTargetStat(mgr, subset);
                child.getTargetStat().calcMean();
            }
            ClusNode root_model = (ClusNode)root.getModel();
            ClusNode ref_tree = (ClusNode)root_model.cloneTree(leaf, ref_leaf);
            double new_heur = this.sanityCheck(sel.m_BestHeur, ref_tree);
            ClusBeamModel new_model = new ClusBeamModel(new_heur, ref_tree);
            new_model.setParentModelIndex(this.getCurrentModel());
            beam.addModel(new_model);
            this.setBeamChanged(true);
        }
    }

    public void refineEachLeaf(ClusNode tree, ClusBeamModel root, ClusBeam beam, ClusAttrType[] attrs) throws Exception {
        int nb_c = tree.getNbChildren();
        if (nb_c == 0) {
            this.refineGivenLeafExhaustive(tree, root, beam, attrs);
        } else {
            for (int i = 0; i < nb_c; ++i) {
                ClusNode child = (ClusNode)tree.getChild(i);
                this.refineEachLeaf(child, root, beam, attrs);
            }
        }
    }

    public void refineModel(ClusBeamModel model, ClusBeam beam, ClusRun run) throws Exception {
        int size;
        ClusNode tree = (ClusNode)model.getModel();
        if (this.m_MaxTreeSize >= 0 && (size = tree.getNbNodes()) + 2 > this.m_MaxTreeSize) {
            return;
        }
        if (this.m_MaxError > 0.0 && this.m_MaxTreeSize > 0) {
            int NbpossibleSplit = (this.m_MaxTreeSize - tree.getModelSize()) / 2;
            double[] error = ClusExhaustiveSearch.getErrorPerleaf(tree);
            double minerror = 0.0;
            if (error.length > NbpossibleSplit) {
                for (int i = 0; i < error.length - NbpossibleSplit; ++i) {
                    minerror += error[i];
                }
                double minerrorrel = minerror / this.m_TotalWeight;
                if (minerrorrel > this.m_MaxError) {
                    tree.printTree();
                    ClusLogger.info("PRUNE WITH ERROR");
                    return;
                }
            }
        }
        RowData train = (RowData)run.getTrainingSet();
        this.m_Coll.initialize(tree, null);
        int nb_rows = train.getNbRows();
        for (int i = 0; i < nb_rows; ++i) {
            DataTuple tuple = train.getTuple(i);
            tree.applyModelProcessor(tuple, this.m_Coll);
        }
        ClusAttrType[] attrs = train.getSchema().getDescriptiveAttributes();
        this.refineEachLeaf(tree, model, beam, attrs);
        tree.clearVisitors();
    }

    public static double[] getErrorPerleaf(ClusNode tree) {
        int nbleaf = tree.getNbLeaf();
        double[] resulterror = new double[nbleaf];
        if (tree.atBottomLevel()) {
            ClusStatistic total = tree.getClusteringStat();
            resulterror[0] = total.getError();
        } else {
            ClusNode child0 = (ClusNode)tree.getChild(0);
            resulterror = ClusExhaustiveSearch.getErrorPerleaf(child0);
            for (int i = 1; i < tree.getNbChildren(); ++i) {
                ClusNode childi = (ClusNode)tree.getChild(i);
                double[] errori = ClusExhaustiveSearch.getErrorPerleaf(childi);
                resulterror = ClusExhaustiveSearch.concatarraysorted(resulterror, errori);
            }
        }
        return resulterror;
    }

    public static double[] concatarraysorted(double[] array1, double[] array2) {
        int i;
        int size_array = array1.length + array2.length;
        double[] array = new double[size_array];
        for (i = 0; i < array1.length; ++i) {
            array[i] = array1[i];
        }
        for (i = 0; i < array2.length; ++i) {
            array[i + array1.length] = array2[i];
        }
        Arrays.sort(array);
        return array;
    }

    public void refineBeamExhaustive(ClusBeam beam, ClusRun run) throws Exception {
        this.setBeamChanged(false);
        ArrayList models = beam.toArray();
        for (int i = 0; i < models.size(); ++i) {
            System.out.print("Refining model: " + i);
            this.setCurrentModel(i);
            ClusBeamModel model = (ClusBeamModel)models.get(i);
            if (!model.isRefined() && !model.isFinished()) {
                if (this.m_Verbose) {
                    System.out.print("[*]");
                }
                this.refineModel(model, beam, run);
                model.setRefined(true);
                model.setParentModelIndex(-1);
            }
            if (!this.m_Verbose) continue;
            if (model.isRefined()) {
                ClusLogger.info("[R]");
            }
            if (!model.isFinished()) continue;
            ClusLogger.info("[F]");
        }
    }

    @Override
    public Settings getSettings() {
        return this.m_Clus.getSettings();
    }

    public void estimateBeamStats(ClusBeam beam) {
        SingleStat stat_heuristic = new SingleStat();
        SingleStat stat_size = new SingleStat();
        SingleStat stat_same_heur = new SingleStat();
        ArrayList lst = beam.toArray();
        HashSet<NodeTest> tops = new HashSet<NodeTest>();
        for (int i = 0; i < lst.size(); ++i) {
            ClusBeamModel model = (ClusBeamModel)lst.get(i);
            stat_heuristic.addFloat(model.getValue());
            stat_size.addFloat(model.getModel().getModelSize());
            NodeTest top = ((ClusNode)model.getModel()).getTest();
            if (top == null || tops.contains(top)) continue;
            tops.add(top);
        }
        Iterator iter = beam.getIterator();
        while (iter.hasNext()) {
            ClusBeamTreeElem elem = (ClusBeamTreeElem)iter.next();
            stat_same_heur.addFloat(elem.getCount());
        }
        ArrayList<Object> stat = new ArrayList<Object>();
        stat.add(stat_heuristic);
        stat.add(stat_same_heur);
        stat.add(stat_size);
        stat.add(new Integer(tops.size()));
        this.m_BeamStats.add(stat);
    }

    public String getLevelStat(int i) {
        ArrayList stat = (ArrayList)this.m_BeamStats.get(i);
        StringBuffer buf = new StringBuffer();
        buf.append("Level: " + i);
        for (int j = 0; j < stat.size(); ++j) {
            Object elem = stat.get(j);
            buf.append(", ");
            if (elem instanceof SingleStat) {
                SingleStat st = (SingleStat)elem;
                buf.append(st.getMean() + "," + st.getRange());
                continue;
            }
            buf.append(elem.toString());
        }
        return buf.toString();
    }

    public void printBeamStats(int level) {
        ClusLogger.info(this.getLevelStat(level));
    }

    public void saveBeamStats() {
        MyFile stats = new MyFile(this.getSettings().getGeneric().getAppName() + ".bmstats");
        for (int i = 0; i < this.m_BeamStats.size(); ++i) {
            stats.log(this.getLevelStat(i));
        }
        stats.close();
    }

    public void writeModel(ClusModelCollectionIO strm) throws IOException, ClusException {
        this.saveBeamStats();
        ArrayList beam = this.getBeam().toArray();
        for (int i = 0; i < beam.size(); ++i) {
            ClusBeamModel m = (ClusBeamModel)beam.get(i);
            ClusNode node = (ClusNode)m.getModel();
            node.updateTree();
            node.clearVisitors();
        }
        int pos = 1;
        for (int i = beam.size() - 1; i >= 0; --i) {
            ClusBeamModel m = (ClusBeamModel)beam.get(i);
            ClusModelInfo info = new ClusModelInfo("B" + pos + ": " + m.getValue());
            info.setScore(m.getValue());
            info.setModel(m.getModel());
            strm.addModel(info);
            ++pos;
        }
    }

    public void setVerbose(boolean verb) {
        this.m_Verbose = verb;
    }

    public ClusBeam exhaustiveSearch(ClusRun run) throws Exception {
        this.reset();
        ClusLogger.info("Starting exhaustive search");
        this.m_Induce = new ConstraintDFInduce(this.m_BeamInduce);
        ClusBeam beam = this.initializeBeamExhaustive(run);
        ClusBeam beamresult = new ClusBeam(-1, false);
        int cpt_tree_evaluation = 0;
        int i = 0;
        this.setVerbose(true);
        while (true) {
            System.out.print("Step: ");
            if (i != 0) {
                System.out.print(",");
            }
            ClusLogger.info(i);
            System.out.flush();
            this.refineBeamExhaustive(beam, run);
            if (!this.isBeamChanged()) break;
            this.estimateBeamStats(beam);
            ++i;
        }
        ArrayList arraybeam = beam.toArray();
        for (int j = 0; j < arraybeam.size(); ++j) {
            ClusBeamModel m = (ClusBeamModel)arraybeam.get(j);
            ClusNode tree = (ClusNode)m.getModel();
            ++cpt_tree_evaluation;
            if (!(this.m_MaxError <= 0.0) && !(ClusNode.estimateErrorRecursive(tree) / this.m_TotalWeight <= this.m_MaxError)) continue;
            beamresult.addModel(m);
        }
        ClusLogger.info();
        this.setBeam(beamresult);
        ArrayList arraybeamresult = beamresult.toArray();
        ClusLogger.info(" the model that fulfill the constraints are" + arraybeamresult.size());
        ClusLogger.info("The number of tree evaluated is " + cpt_tree_evaluation);
        return beamresult;
    }

    public void setBeam(ClusBeam beam) {
        this.m_Beam = beam;
    }

    public ClusBeam getBeam() {
        return this.m_Beam;
    }

    public boolean isBeamChanged() {
        return this.m_BeamChanged;
    }

    public void setBeamChanged(boolean change) {
        this.m_BeamChanged = change;
    }

    public int getCurrentModel() {
        return this.m_CurrentModel;
    }

    public void setCurrentModel(int model) {
        this.m_CurrentModel = model;
    }

    public void setTotalWeight(double weight) {
        this.m_TotalWeight = weight;
    }

    public double sanityCheck(double value, ClusNode tree) throws ClusException {
        double expected = this.estimateBeamMeasure(tree);
        if (Math.abs(value - expected) > 1.0E-6) {
            ClusLogger.info("Bug in heurisitc: " + value + " <> " + expected);
            PrintWriter wrt = new PrintWriter(System.out);
            tree.printModel(wrt);
            wrt.close();
            System.out.flush();
            throw new ClusException("sanity check failed");
        }
        return expected;
    }

    public void tryLogBeam(MyFile log, ClusBeam beam, String txt) {
        if (log.isEnabled()) {
            log.log(txt);
            log.log("*********************************************");
            beam.print(log.getWriter(), this.m_Clus.getSettings().getBeamSearch().getBeamBestN());
            log.log();
        }
    }

    @Override
    public void pruneAll(ClusRun cr) throws ClusException, IOException {
    }

    @Override
    public ClusModel pruneSingle(ClusModel model, ClusRun cr) throws ClusException, IOException {
        return model;
    }

    @Override
    public void postProcess(ClusRun cr) throws ClusException, IOException {
    }
}

