/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ensemble.ros;

import java.util.HashMap;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduce;
import si.ijs.kt.clus.main.settings.section.SettingsEnsemble;
import si.ijs.kt.clus.util.ClusRandom;

public class ClusROSHelpers {
    public static HashMap<Integer, Integer> generateSubspace(ClusSchema schema, int sizeOfSubspace, SettingsEnsemble.EnsembleROSAlgorithmType rosAT, int bagNumber) {
        if (rosAT.equals((Object)SettingsEnsemble.EnsembleROSAlgorithmType.FixedSubspaces) && bagNumber == 0) {
            return ClusROSHelpers.populateMap(schema.getClusteringAttributes(), schema);
        }
        return ClusROSHelpers.generateSubspace(schema, sizeOfSubspace);
    }

    private static HashMap<Integer, Integer> generateSubspace(ClusSchema schema, int sizeOfSubspace) {
        boolean isRandom = sizeOfSubspace <= 0;
        int subspaceCount = sizeOfSubspace;
        ClusAttrType[] clustering = schema.getClusteringAttributes();
        if (isRandom) {
            subspaceCount = ClusRandom.nextInt(9, 1, clustering.length);
        }
        ClusAttrType[] selected = ClusEnsembleInduce.selectRandomSubspaces(clustering, subspaceCount, 8, null);
        return ClusROSHelpers.populateMap(selected, schema);
    }

    private static HashMap<Integer, Integer> populateMap(ClusAttrType[] selected, ClusSchema schema) {
        HashMap<Integer, Integer> selectedClusteringAttributes = new HashMap<Integer, Integer>();
        ClusAttrType[] all = schema.getClusteringAttributes();
        for (int i = 0; i < all.length; ++i) {
            ClusAttrType a = all[i];
            for (ClusAttrType t : selected) {
                if (a.getIndex() != t.getIndex()) continue;
                selectedClusteringAttributes.put(i, t.getIndex());
            }
        }
        return selectedClusteringAttributes;
    }
}

