/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ensemble;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import si.ijs.kt.clus.algo.rules.ClusRuleSet;
import si.ijs.kt.clus.algo.rules.ClusRulesFromTree;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduce;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduceOptClassification;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduceOptRegHMLC;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduceOptimization;
import si.ijs.kt.clus.ext.ensemble.ClusOOBErrorEstimate;
import si.ijs.kt.clus.ext.ensemble.ClusOOBWeights;
import si.ijs.kt.clus.ext.ensemble.ClusReadWriteLock;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSForestInfo;
import si.ijs.kt.clus.ext.hierarchical.HierClassTresholdPruner;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsOutput;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.model.processor.ClusEnsemblePredictionWriter;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.GeneticDistanceStat;
import si.ijs.kt.clus.statistic.HierSingleLabelStat;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.statistic.RegressionStatBase;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.statistic.WHTDStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusUtil;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.MyArray;

public class ClusForest
implements ClusModel,
Serializable {
    private static final long serialVersionUID = 1L;
    ArrayList<ClusModel> m_Trees;
    private ArrayList<Integer> m_TreeIndices = new ArrayList();
    private int m_NbNodes = 0;
    private int m_NbLeaves = 0;
    private int m_SumDepths;
    private ClusROSForestInfo m_ROSForestInfo = null;
    private ClusOOBWeights m_OOBWeights = null;
    ArrayList<ClusStatistic> m_Votes;
    String m_modelInfo = "";
    HashMap<Integer, Double> m_Proximities;
    int m_Mode;
    private ClusReadWriteLock m_NbModelsLock = new ClusReadWriteLock();
    private ClusReadWriteLock m_NbNodesLock = new ClusReadWriteLock();
    private ClusReadWriteLock m_NbLeavesLock = new ClusReadWriteLock();
    private ClusReadWriteLock m_SumDepthsLock = new ClusReadWriteLock();
    ClusStatistic m_Stat;
    boolean m_PrintModels;
    String m_AppName;
    private ClusEnsembleInduceOptimization m_Optimization;
    protected Settings m_Settings;
    protected ClusStatManager m_StatManager;
    private static String m_PythonFileTreePattern = "_trees";
    private HashMap<String, Integer> m_DescriptiveIndex;

    public ClusForest(ClusStatManager statmgr) {
        this.m_Trees = new ArrayList();
        this.m_Settings = statmgr.getSettings();
        this.m_StatManager = statmgr;
    }

    public ClusForest(ClusStatManager statmgr, ClusEnsembleInduceOptimization opt) {
        this(statmgr);
        switch (statmgr.getTargetMode()) {
            case CLASSIFY: {
                if (statmgr.getSettings().getMLC().getSectionMultiLabel().isEnabled()) {
                    this.m_Stat = new ClassificationStat(statmgr.getSettings(), statmgr.getSchema().getNominalAttrUse(ClusAttrType.AttributeUseType.Target), statmgr.getSettings().getMLC().getMultiLabelThreshold());
                    break;
                }
                this.m_Stat = new ClassificationStat(statmgr.getSettings(), statmgr.getSchema().getNominalAttrUse(ClusAttrType.AttributeUseType.Target));
                break;
            }
            case REGRESSION: {
                this.m_Stat = new RegressionStat(statmgr.getSettings(), statmgr.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.Target));
                break;
            }
            case HIERARCHICAL: {
                if (statmgr.getSettings().getHMLC().getHierSingleLabel()) {
                    this.m_Stat = new HierSingleLabelStat(statmgr.getSettings(), statmgr.getHier());
                    break;
                }
                this.m_Stat = new WHTDStatistic(statmgr.getSettings(), statmgr.getHier());
                break;
            }
            case PHYLO: {
                this.m_Stat = new GeneticDistanceStat(statmgr.getSettings(), statmgr.getSchema().getNominalAttrUse(ClusAttrType.AttributeUseType.Target));
                break;
            }
            default: {
                System.err.println(this.getClass().getName() + " initForest(): Error initializing the statistic for target mode " + (Object)((Object)statmgr.getTargetMode()));
            }
        }
        this.m_AppName = statmgr.getSettings().getGeneric().getFileAbsolute(statmgr.getSettings().getGeneric().getAppName());
        this.m_DescriptiveIndex = ClusUtil.getDescriptiveAttributesIndices(statmgr);
        this.m_Optimization = opt;
    }

    public HashMap<String, Integer> getDescriptiveIndices() {
        return this.m_DescriptiveIndex;
    }

    private Settings getSettings() {
        return this.m_Settings;
    }

    public void setOptimization(ClusEnsembleInduceOptimization opt) {
        this.m_Optimization = opt;
    }

    public void setEnsembleROSForestInfo(ClusROSForestInfo info) {
        this.m_ROSForestInfo = info;
    }

    public ClusROSForestInfo getEnsembleROSForestInfo() {
        return this.m_ROSForestInfo;
    }

    public synchronized void addModelToForest(ClusModel model) {
        this.m_Trees.add(model);
    }

    @Override
    public void applyModelProcessors(DataTuple tuple, MyArray mproc) throws IOException, ClusException {
        for (int i = 0; i < this.m_Trees.size(); ++i) {
            ClusModel model = this.m_Trees.get(i);
            model.applyModelProcessors(tuple, mproc);
        }
    }

    @Override
    public void attachModel(HashMap table) throws ClusException {
        for (int i = 0; i < this.m_Trees.size(); ++i) {
            ClusModel model = this.m_Trees.get(i);
            model.attachModel(table);
        }
    }

    @Override
    public int getID() {
        return 0;
    }

    public int getDescriptiveIndex(String name) {
        return this.m_DescriptiveIndex.get(name);
    }

    public int getNbModels() throws InterruptedException {
        this.m_NbModelsLock.readingLock();
        int ans = this.m_TreeIndices.size();
        this.m_NbModelsLock.readingUnlock();
        return ans;
    }

    private void addTreeIndices(ArrayList<Integer> indices) throws InterruptedException {
        this.m_NbModelsLock.writingLock();
        this.m_TreeIndices.addAll(indices);
        this.m_NbModelsLock.writingUnlock();
    }

    private int getNbNodes() throws InterruptedException {
        this.m_NbNodesLock.readingLock();
        int ans = this.m_NbNodes;
        this.m_NbNodesLock.readingUnlock();
        return ans;
    }

    private void increaseNbNodes(int n) throws InterruptedException {
        this.m_NbNodesLock.writingLock();
        this.m_NbNodes += n;
        this.m_NbNodesLock.writingUnlock();
    }

    private int getNbLeaves() throws InterruptedException {
        this.m_NbLeavesLock.readingLock();
        int ans = this.m_NbLeaves;
        this.m_NbLeavesLock.readingUnlock();
        return ans;
    }

    private void increaseNbLeaves(int n) throws InterruptedException {
        this.m_NbLeavesLock.writingLock();
        this.m_NbLeaves += n;
        this.m_NbLeavesLock.writingUnlock();
    }

    private double getAverageDepth() throws InterruptedException {
        this.m_SumDepthsLock.readingLock();
        double sumDepths = this.m_SumDepths;
        this.m_SumDepthsLock.readingUnlock();
        double models = this.getNbModels();
        return sumDepths / models;
    }

    private void updateDepth(int depth) throws InterruptedException {
        this.m_SumDepthsLock.writingLock();
        this.m_SumDepths += depth;
        this.m_SumDepthsLock.writingUnlock();
    }

    public static int[] countNodesLeaves(ClusNode model) {
        int[] nodesLeavesDepth = model.computeNodesLeavesDepth();
        int nodes = nodesLeavesDepth[0];
        int leaves = nodesLeavesDepth[1];
        int depth = nodesLeavesDepth[2];
        return new int[]{nodes, leaves, depth};
    }

    public void updateCounts(ArrayList<Integer> indices, int nbNodes, int nbLeaves, int depth) throws InterruptedException {
        this.addTreeIndices(indices);
        this.increaseNbNodes(nbNodes);
        this.increaseNbLeaves(nbLeaves);
        this.updateDepth(depth);
    }

    public void setModelInfo(String additionalInfo) {
        this.m_modelInfo = additionalInfo;
    }

    public void setOOBWeightsEstimates(ClusOOBWeights estimates) {
        this.m_OOBWeights = estimates;
    }

    @Override
    public String getModelInfo() throws InterruptedException {
        String targetSubspaces = "";
        String indent = System.lineSeparator() + "\t\t";
        if (this.m_ROSForestInfo != null) {
            targetSubspaces = indent + this.m_ROSForestInfo.getCoverageInfo() + indent + this.m_ROSForestInfo.getCoverageNormalizedInfo() + indent + this.m_ROSForestInfo.getAverageNumberOfTargetsUsedInfo();
        }
        String result = String.format("FOREST with %d models (Total nodes: %d; leaves: %d; average tree depth: %.1f)%s", this.getNbModels(), this.getNbNodes(), this.getNbLeaves(), this.getAverageDepth(), targetSubspaces);
        if (this.getSettings().getEnsemble().isPrintEnsembleModelInfo()) {
            for (int i = 0; i < this.getNbModels(); ++i) {
                result = result + indent + "Model " + this.m_TreeIndices.get(i) + ": " + this.getModel(i).getModelInfo();
                if (this.m_ROSForestInfo == null) continue;
                result = result + " => " + this.m_ROSForestInfo.getROSModelInfo(i).getSubspaceString();
            }
        }
        return this.m_modelInfo + result;
    }

    @Override
    public int getModelSize() {
        return this.m_Trees.size();
    }

    @Override
    public ClusStatistic predictWeighted(DataTuple tuple) throws ClusException, InterruptedException {
        if (this.getSettings().getEnsemble().isEnsembleROSEnabled() && !ClusOOBErrorEstimate.isOOBCalculation()) {
            switch (this.getSettings().getEnsemble().getEnsembleROSVotingType()) {
                case SubspaceAveraging: {
                    return ClusEnsembleInduce.isOptimized() ? this.predictWeightedStandardSubspaceAveragingOpt(tuple) : this.predictWeightedStandardSubspaceAveraging(tuple);
                }
            }
            return ClusEnsembleInduce.isOptimized() ? this.predictWeightedOpt(tuple) : this.predictWeightedStandard(tuple);
        }
        if (ClusOOBErrorEstimate.isOOBCalculation()) {
            return this.predictWeightedOOB(tuple);
        }
        if (ClusEnsembleInduce.isOptimized()) {
            return this.predictWeightedOpt(tuple);
        }
        return this.predictWeightedStandard(tuple);
    }

    public ClusStatistic predictWeightedStandard(DataTuple tuple) throws ClusException, InterruptedException {
        ArrayList<ClusStatistic> votes = new ArrayList<ClusStatistic>();
        for (int i = 0; i < this.m_Trees.size(); ++i) {
            votes.add(this.m_Trees.get(i).predictWeighted(tuple));
        }
        this.m_Stat.reset();
        this.m_Votes = votes;
        if (this.getSettings().getEnsemble().isVotingOOBWeighted()) {
            this.m_Stat.vote(votes, this.m_OOBWeights);
        } else {
            this.m_Stat.vote(votes);
        }
        ClusEnsemblePredictionWriter.setVotes(votes);
        return this.m_Stat;
    }

    public ArrayList<ClusStatistic> getVotes() {
        return this.m_Votes;
    }

    public ArrayList getOOBVotes(DataTuple tuple) throws InterruptedException {
        if (ClusOOBErrorEstimate.containsPredictionForTuple(tuple)) {
            return ClusOOBErrorEstimate.getVotesForTuple(tuple);
        }
        return null;
    }

    public boolean containsOOBForTuple(DataTuple tuple) throws InterruptedException {
        return ClusOOBErrorEstimate.containsPredictionForTuple(tuple);
    }

    public ClusStatistic predictWeightedOOB(DataTuple tuple) throws ClusException, InterruptedException {
        switch (this.m_StatManager.getTargetMode()) {
            case REGRESSION: 
            case HIERARCHICAL: {
                return this.predictWeightedOOBRegressionHMC(tuple);
            }
            case CLASSIFY: {
                return this.predictWeightedOOBClassification(tuple);
            }
        }
        System.err.println(this.getClass().getName() + ".predictWeightedOOB(DataTuple) - Error in Setting the Mode");
        return null;
    }

    public ClusStatistic predictWeightedOOBRegressionHMC(DataTuple tuple) throws ClusException, InterruptedException {
        double[] predictions = null;
        if (ClusOOBErrorEstimate.containsPredictionForTuple(tuple)) {
            predictions = ClusOOBErrorEstimate.getPredictionForRegressionHMCTuple(tuple);
        } else {
            System.err.println(this.getClass().getName() + ".predictWeightedOOBRegressionHMC(DataTuple) - Missing Prediction For Tuple");
            System.err.println("Tuple Hash = " + tuple.hashCode());
        }
        this.m_Stat.reset();
        ((RegressionStatBase)this.m_Stat).m_Means = new double[predictions.length];
        for (int j = 0; j < predictions.length; ++j) {
            ((RegressionStatBase)this.m_Stat).m_Means[j] = predictions[j];
        }
        this.m_Stat = this.m_StatManager.getTargetMode() == ClusStatManager.Mode.HIERARCHICAL ? (WHTDStatistic)this.m_Stat : (RegressionStat)this.m_Stat;
        this.m_Stat.computePrediction();
        return this.m_Stat;
    }

    public ClusStatistic predictWeightedOOBClassification(DataTuple tuple) throws ClusException, InterruptedException {
        double[][] predictions = null;
        if (ClusOOBErrorEstimate.containsPredictionForTuple(tuple)) {
            predictions = ClusOOBErrorEstimate.getPredictionForClassificationTuple(tuple);
        } else {
            System.err.println(this.getClass().getName() + ".predictWeightedOOBClassification(DataTuple) - Missing Prediction For Tuple");
            System.err.println("Tuple Hash = " + tuple.hashCode());
        }
        this.m_Stat.reset();
        ((ClassificationStat)this.m_Stat).m_ClassCounts = new double[predictions.length][];
        for (int m = 0; m < predictions.length; ++m) {
            ((ClassificationStat)this.m_Stat).m_ClassCounts[m] = new double[predictions[m].length];
            for (int n = 0; n < predictions[m].length; ++n) {
                ((ClassificationStat)this.m_Stat).m_ClassCounts[m][n] = predictions[m][n];
            }
        }
        this.m_Stat.computePrediction();
        for (int k = 0; k < this.m_Stat.getNbAttributes(); ++k) {
            ((ClassificationStat)this.m_Stat).m_SumWeights[k] = 1.0;
        }
        return this.m_Stat;
    }

    public ClusStatistic predictWeightedOpt(DataTuple tuple) throws ClusException {
        int position = this.m_Optimization.locateTuple(tuple);
        int predlength = this.m_Optimization.getPredictionLength(position);
        this.m_Stat.reset();
        switch (this.m_StatManager.getTargetMode()) {
            case REGRESSION: 
            case HIERARCHICAL: {
                ((RegressionStatBase)this.m_Stat).m_Means = new double[predlength];
                for (int i = 0; i < predlength; ++i) {
                    ((RegressionStatBase)this.m_Stat).m_Means[i] = ((ClusEnsembleInduceOptRegHMLC)this.m_Optimization).getPredictionValue(position, i);
                }
                this.m_Stat.computePrediction();
                return this.m_Stat;
            }
            case CLASSIFY: {
                ((ClassificationStat)this.m_Stat).m_ClassCounts = new double[predlength][];
                for (int j = 0; j < predlength; ++j) {
                    ((ClassificationStat)this.m_Stat).m_ClassCounts[j] = ((ClusEnsembleInduceOptClassification)this.m_Optimization).getPredictionValueClassification(position, j);
                }
                this.m_Stat.computePrediction();
                for (int k = 0; k < this.m_Stat.getNbAttributes(); ++k) {
                    ((ClassificationStat)this.m_Stat).m_SumWeights[k] = 1.0;
                }
                return this.m_Stat;
            }
        }
        throw new RuntimeException("clus.ext.ensembles.ClusForest.predictWeightedOpt(DataTuple): unhandled ClusStatManager.getMode() case!");
    }

    public ClusStatistic predictWeightedStandardAndGetProximities(DataTuple tuple) throws ClusException {
        this.m_Proximities = new HashMap();
        ArrayList<ClusStatistic> votes = new ArrayList<ClusStatistic>();
        Integer tupleIndex = null;
        double incrementValue = 1.0 / (double)this.m_Trees.size();
        for (int i = 0; i < this.m_Trees.size(); ++i) {
            ClusNode model = (ClusNode)this.m_Trees.get(i);
            LinkedList<Integer> leafTuples = new LinkedList<Integer>();
            votes.add(model.predictWeightedAndGetLeafTuples(tuple, leafTuples));
            for (int j = 0; j < leafTuples.size(); ++j) {
                tupleIndex = (Integer)leafTuples.get(j);
                if (this.m_Proximities.containsKey(tupleIndex)) {
                    this.m_Proximities.put(tupleIndex, this.m_Proximities.get(tupleIndex) + incrementValue);
                    continue;
                }
                this.m_Proximities.put(tupleIndex, incrementValue);
            }
        }
        this.m_Stat.reset();
        this.m_Votes = votes;
        this.m_Stat.vote(votes);
        ClusEnsemblePredictionWriter.setVotes(votes);
        return this.m_Stat;
    }

    public ClusStatistic predictWeightedOOBAndGetProximities(DataTuple tuple) throws ClusException, InterruptedException {
        this.m_Proximities = new HashMap();
        ArrayList<ClusStatistic> votes = new ArrayList<ClusStatistic>();
        double incrementValue = 1.0 / (double)this.m_Trees.size();
        for (int i = 0; i < this.m_Trees.size(); ++i) {
            ClusNode model = (ClusNode)this.m_Trees.get(i);
            if (!ClusOOBErrorEstimate.isOOBForTree(tuple, i + 1)) continue;
            LinkedList<Integer> leafTuples = new LinkedList<Integer>();
            votes.add(model.predictWeightedAndGetLeafTuples(tuple, leafTuples));
            for (int j = 0; j < leafTuples.size(); ++j) {
                Integer tupleIndex = (Integer)leafTuples.get(j);
                if (this.m_Proximities.containsKey(tupleIndex)) {
                    this.m_Proximities.put(tupleIndex, this.m_Proximities.get(tupleIndex) + incrementValue);
                    continue;
                }
                this.m_Proximities.put(tupleIndex, incrementValue);
            }
        }
        this.m_Stat.reset();
        this.m_Votes = votes;
        this.m_Stat.vote(votes);
        ClusEnsemblePredictionWriter.setVotes(votes);
        return this.m_Stat;
    }

    public void initializeProximities(DataTuple t) {
        for (int j = 0; j < this.m_Trees.size(); ++j) {
            ((ClusNode)this.m_Trees.get(j)).incrementProximities(t);
        }
    }

    public HashMap<Integer, Double> getProximities() {
        return this.m_Proximities;
    }

    public ClusStatistic predictWeightedStandardSubspaceAveraging(DataTuple tuple) throws ClusException, InterruptedException {
        ArrayList<ClusStatistic> votes = new ArrayList<ClusStatistic>();
        for (int i = 0; i < this.m_Trees.size(); ++i) {
            votes.add(this.m_Trees.get(i).predictWeighted(tuple));
        }
        if (this.getSettings().getEnsemble().isVotingOOBWeighted()) {
            this.m_Stat.vote(votes, this.m_OOBWeights, this.m_ROSForestInfo);
        } else {
            this.m_Stat.vote(votes, this.m_ROSForestInfo);
        }
        ClusEnsemblePredictionWriter.setVotes(votes);
        return this.m_Stat;
    }

    public ClusStatistic predictWeightedStandardSubspaceAveragingOpt(DataTuple tuple) throws ClusException {
        return this.predictWeightedOpt(tuple);
    }

    @Override
    public void printModel(PrintWriter wrt) throws InterruptedException {
        if (this.getSettings().getEnsemble().isPrintEnsembleModels()) {
            for (int i = 0; i < this.m_Trees.size(); ++i) {
                ClusModel model = this.m_Trees.get(i);
                if (this.m_PrintModels) {
                    this.thresholdToModel(i, this.getThreshold());
                }
                wrt.write("Model " + (i + 1) + ": \n");
                wrt.write("\n");
                model.printModel(wrt);
                wrt.write("\n");
            }
        } else {
            wrt.write("Forest with " + this.getNbModels() + " models\n");
        }
    }

    @Override
    public void printModel(PrintWriter wrt, StatisticPrintInfo info) throws InterruptedException {
        if (this.getSettings().getEnsemble().isPrintEnsembleModels()) {
            for (int i = 0; i < this.m_Trees.size(); ++i) {
                ClusModel model = this.m_Trees.get(i);
                if (this.m_PrintModels) {
                    this.thresholdToModel(i, this.getThreshold());
                }
                wrt.write("Model " + (i + 1) + ": \n");
                wrt.write("\n");
                model.printModel(wrt);
                wrt.write("\n");
            }
        } else {
            wrt.write("Forest with " + this.getNbModels() + " models\n");
        }
    }

    @Override
    public void printModelAndExamples(PrintWriter wrt, StatisticPrintInfo info, RowData examples) {
        for (int i = 0; i < this.m_Trees.size(); ++i) {
            ClusModel model = this.m_Trees.get(i);
            model.printModelAndExamples(wrt, info, examples);
        }
    }

    @Override
    public void printModelToPythonScript(PrintWriter wrt, HashMap<String, Integer> dict) {
        this.printForestToPython(SettingsOutput.PythonModelType.Function);
    }

    @Override
    public void printModelToPythonScript(PrintWriter wrt, HashMap<String, Integer> dict, String modelIdentifier) {
        this.printModelToPythonScript(wrt, dict);
    }

    public void writePythonEnsembleFile(PrintWriter wrtr, String treeFile, SettingsOutput.PythonModelType pyModelType) {
        wrtr.println(String.format("def ensemble_%d(xs):", this.m_TreeIndices.size()));
        wrtr.println(String.format("\tbase_predictions = [None for _ in range(%d)]", this.m_TreeIndices.size()));
        wrtr.println("\tfor i in range(len(base_predictions)):");
        wrtr.println(String.format("\t\ttree = eval(\"%s.tree_{}\".format(i + 1))", treeFile));
        switch (pyModelType) {
            case Function: {
                wrtr.println("\t\tbase_predictions[i] = tree(xs)");
                break;
            }
            case Object: {
                wrtr.println("\t\tbase_predictions[i] = tree.predict(xs)");
                break;
            }
            default: {
                throw new RuntimeException("This will never happen:)");
            }
        }
        wrtr.println("\treturn aggregate(base_predictions)");
        wrtr.println();
        wrtr.println();
    }

    public static String getTreeFile(String appName) {
        return ClusUtil.fileName(appName) + m_PythonFileTreePattern;
    }

    public static void writePythonAggregation(PrintWriter wrtr, String treeFile, ClusStatManager.TargetType targetType) {
        String aggregation;
        wrtr.println(String.format("import %s", treeFile));
        switch (targetType) {
            case CLASSIFICATION: {
                aggregation = "aggregate_classification";
                break;
            }
            case REGRESSION: {
                aggregation = "aggregate_regression";
                break;
            }
            case MULTI_LABEL_CLASSIFICATION: 
            case HIERACHICAL_MULTI_LABEL_CLASSIFICATION: {
                aggregation = "aggregate_multi_label";
                break;
            }
            default: {
                System.err.println("Unsupported mode, you will have to write your own aggregation function.");
                aggregation = "aggregation_other";
            }
        }
        wrtr.println(String.format("from prediction_aggregators import %s as aggregate", aggregation));
        wrtr.print("\n\n");
    }

    @Override
    public JsonObject getModelJSON() {
        return null;
    }

    @Override
    public JsonObject getModelJSON(StatisticPrintInfo info) {
        return null;
    }

    @Override
    public JsonObject getModelJSON(StatisticPrintInfo info, RowData examples) {
        return null;
    }

    public static String pythonTreeFunctionDefinition(int treeIndex) {
        return "def tree_" + treeIndex + "(xs):";
    }

    private String getPythonForestTreesFileName() {
        return this.m_AppName + m_PythonFileTreePattern + ".py";
    }

    public void printForestToPython(SettingsOutput.PythonModelType type) {
        try {
            File pyscript = new File(this.getPythonForestTreesFileName());
            PrintWriter wrtr = new PrintWriter(new FileOutputStream(pyscript));
            wrtr.println("# Python code of the trees in the ensemble");
            wrtr.println();
            if (type == SettingsOutput.PythonModelType.Object) {
                wrtr.println("from tree_as_object import *\n\n");
            }
            for (int i = 0; i < this.m_Trees.size(); ++i) {
                ClusModel model = this.m_Trees.get(i);
                this.printOneTree(wrtr, (ClusNode)model, this.m_TreeIndices.get(i), type);
            }
            wrtr.close();
            ClusLogger.info(String.format("Python trees for the model %s written to: ", this.getModelInfo()) + pyscript.getPath());
        }
        catch (IOException e) {
            System.err.println(this.getClass().getName() + ".printForestToPython(): Error while writing models to python script");
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void printOneTree(PrintWriter wrtr, ClusNode tree, int treeIndex, SettingsOutput.PythonModelType type) {
        wrtr.println("# Model " + treeIndex);
        switch (type) {
            case Function: {
                wrtr.println(ClusForest.pythonTreeFunctionDefinition(treeIndex));
                tree.printModelToPythonScript(wrtr, this.m_DescriptiveIndex);
                break;
            }
            case Object: {
                tree.printModelToPythonScript(wrtr, this.m_DescriptiveIndex, Integer.toString(treeIndex));
                break;
            }
            default: {
                throw new RuntimeException("Wrong PythonModelType: " + (Object)((Object)type));
            }
        }
    }

    public void joinPythonForestInOneFile(ClusRun cr) {
        File pyscript = new File(this.getPythonForestTreesFileName());
        try {
            PrintWriter wrtr = new PrintWriter(new FileOutputStream(pyscript));
            wrtr.println("# Python code of the trees in the ensemble");
            wrtr.println();
            if (cr.getStatManager().getSettings().getOutput().getPythonModelType() == SettingsOutput.PythonModelType.Object) {
                wrtr.println("from tree_as_object import *\n\n");
            }
            for (int i : this.m_TreeIndices) {
                String inputFile = ClusEnsembleInduce.getTemporaryPythonTreeFileName(cr, i);
                String treeString = new String(Files.readAllBytes(Paths.get(inputFile, new String[0])), StandardCharsets.UTF_8);
                wrtr.print(treeString);
                File temp = new File(inputFile);
                if (temp.delete()) continue;
                System.err.println("Warning: the file " + temp + " was not deleted.");
            }
            wrtr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void printModelToQuery(PrintWriter wrt, ClusRun cr, int starttree, int startitem, boolean ex) {
        for (int i = 0; i < this.m_Trees.size(); ++i) {
            ClusModel model = this.m_Trees.get(i);
            model.printModelToQuery(wrt, cr, starttree, startitem, ex);
        }
    }

    @Override
    public ClusModel prune(int prunetype) {
        return null;
    }

    public void retrieveStatistics(ArrayList list) {
    }

    public void showForest() {
        for (int i = 0; i < this.m_Trees.size(); ++i) {
            ClusLogger.info("***************************");
            ClusModel model = this.m_Trees.get(i);
            ((ClusNode)model).printTree();
            ClusLogger.info("***************************");
        }
    }

    public ClusModel getModel(int idx) {
        return this.m_Trees.get(idx);
    }

    @Deprecated
    public int getNbModelsOld() {
        return this.m_Trees.size();
    }

    public ClusStatistic getStat() {
        return this.m_Stat;
    }

    public void setStat(ClusStatistic stat) {
        this.m_Stat = stat;
    }

    public void thresholdToModel(int model_nb, double threshold) {
        try {
            HierClassTresholdPruner pruner = new HierClassTresholdPruner(null);
            pruner.pruneRecursive((ClusNode)this.getModel(model_nb), threshold);
        }
        catch (ClusException e) {
            System.err.println(this.getClass().getName() + " thresholdToModel(): Error while applying threshold " + threshold + " to model " + model_nb);
            e.printStackTrace();
        }
    }

    public ArrayList<ClusModel> getModels() {
        return this.m_Trees;
    }

    public void setModels(ArrayList<ClusModel> models) {
        this.m_Trees = models;
    }

    public ClusForest cloneForestWithThreshold(double threshold) throws InterruptedException {
        ClusForest clone = new ClusForest(this.m_StatManager);
        clone.setModels(this.getModels());
        WHTDStatistic stat = (WHTDStatistic)this.getStat().cloneStat();
        stat.copyAll(this.getStat());
        stat.setThreshold(threshold);
        clone.setStat(stat);
        clone.updateCounts(this.m_TreeIndices, this.m_NbNodes, this.m_NbLeaves, this.m_SumDepths);
        clone.setOptimization(this.m_Optimization);
        return clone;
    }

    public void setPrintModels(boolean print) {
        this.m_PrintModels = print;
    }

    public boolean isPrintModels() {
        return this.m_PrintModels;
    }

    public double getThreshold() {
        return ((WHTDStatistic)this.getStat()).getThreshold();
    }

    public void removeModels() {
        this.m_Trees.clear();
    }

    public void convertToRules(ClusRun cr, boolean addOnlyUnique) throws InterruptedException, ClusException {
        ClusRulesFromTree treeTransform = new ClusRulesFromTree(true, cr.getStatManager().getSettings().getTree().rulesFromTree());
        ClusRuleSet ruleSet = new ClusRuleSet(cr.getStatManager());
        for (int iTree = 0; iTree < this.getNbModels(); ++iTree) {
            ClusNode treeRootNode = (ClusNode)this.getModel(iTree);
            ruleSet.addRuleSet(treeTransform.constructRules(treeRootNode, cr.getStatManager()), addOnlyUnique);
        }
        ruleSet.addDataToRules((RowData)cr.getTrainingSet());
        ClusModelInfo rules_info = cr.addModelInfo("Rules-" + cr.getModelInfo(1).getName());
        rules_info.setModel(ruleSet);
    }
}

