/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ensemble;

import java.io.IOException;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.TupleIterator;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduceOptimization;
import si.ijs.kt.clus.ext.ensemble.ros.ClusEnsembleROSInfo;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.RegressionStatBase;
import si.ijs.kt.clus.util.ClusUtil;
import si.ijs.kt.clus.util.exception.ClusException;

public class ClusEnsembleInduceOptRegHMLC
extends ClusEnsembleInduceOptimization {
    private static final long serialVersionUID = 1L;
    private double[][] m_AvgPredictions;

    public ClusEnsembleInduceOptRegHMLC(TupleIterator train, TupleIterator test, Settings sett) throws IOException, ClusException {
        super(train, test, sett);
    }

    @Override
    public void initPredictions(ClusStatistic stat, ClusEnsembleROSInfo ensembleROSInfo) {
        this.m_AvgPredictions = new double[this.m_TuplePositions.size()][stat.getNbAttributes()];
        this.m_EnsembleROSInfo = ensembleROSInfo;
    }

    @Override
    public synchronized void updatePredictionsForTuples(ClusModel model, TupleIterator train, TupleIterator test) throws IOException, ClusException, InterruptedException {
        ClusStatistic stat;
        int position;
        this.m_NbUpdatesLock.writingLock();
        this.m_AvgPredictionsLock.writingLock();
        ++this.m_NbUpdates;
        if (this.getSettings().getEnsemble().isEnsembleROSEnabled()) {
            throw new ClusException("si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduceOptRegHMLC.updatePredictionsForTuples(ClusModel, TupleIterator, TupleIterator): ROS not implemented for optimized ensembles.");
        }
        if (train != null) {
            train.init();
            DataTuple train_tuple = train.readTuple();
            while (train_tuple != null) {
                position = this.locateTuple(train_tuple);
                stat = (RegressionStatBase)model.predictWeighted(train_tuple);
                this.m_AvgPredictions[position] = this.m_NbUpdates == 1 ? ((RegressionStatBase)stat).getNumericPred() : ClusEnsembleInduceOptRegHMLC.incrementPredictions(this.m_AvgPredictions[position], ((RegressionStatBase)stat).getNumericPred(), this.m_NbUpdates);
                train_tuple = train.readTuple();
            }
            train.init();
        }
        if (test != null) {
            test.init();
            DataTuple test_tuple = test.readTuple();
            while (test_tuple != null) {
                position = this.locateTuple(test_tuple);
                if (this.m_NbUpdates == 1) {
                    stat = (RegressionStatBase)model.predictWeighted(test_tuple);
                    this.m_AvgPredictions[position] = ((RegressionStatBase)stat).getNumericPred();
                } else {
                    stat = model.predictWeighted(test_tuple);
                    this.m_AvgPredictions[position] = ClusEnsembleInduceOptRegHMLC.incrementPredictions(this.m_AvgPredictions[position], stat.getNumericPred(), this.m_NbUpdates);
                }
                test_tuple = test.readTuple();
            }
            test.init();
        }
        this.m_AvgPredictionsLock.writingUnlock();
        this.m_NbUpdatesLock.writingUnlock();
    }

    @Override
    public int getPredictionLength(int tuple) {
        return this.m_AvgPredictions[tuple].length;
    }

    public double getPredictionValue(int tuple, int attribute) {
        return this.m_AvgPredictions[tuple][attribute];
    }

    @Override
    public void roundPredictions() {
        for (int i = 0; i < this.m_AvgPredictions.length; ++i) {
            for (int j = 0; j < this.m_AvgPredictions[i].length; ++j) {
                this.m_AvgPredictions[i][j] = ClusUtil.roundToSignificantFigures(this.m_AvgPredictions[i][j], 4);
            }
        }
    }
}

