/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.ensemble;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.StopWatch;
import si.ijs.kt.clus.Clus;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.algo.tdidt.DepthFirstInduce;
import si.ijs.kt.clus.algo.tdidt.DepthFirstInduceSparse;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.MemoryTupleIterator;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.rows.TupleIterator;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.error.Accuracy;
import si.ijs.kt.clus.error.RMSError;
import si.ijs.kt.clus.error.common.ClusError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ComponentError;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduceOptClassification;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduceOptRegHMLC;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduceOptimization;
import si.ijs.kt.clus.ext.ensemble.ClusForest;
import si.ijs.kt.clus.ext.ensemble.ClusOOBErrorEstimate;
import si.ijs.kt.clus.ext.ensemble.ClusOOBWeights;
import si.ijs.kt.clus.ext.ensemble.callable.InduceOneBagCallable;
import si.ijs.kt.clus.ext.ensemble.container.OneBagResults;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSForestInfo;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSHelpers;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSModelInfo;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSOOBWeights;
import si.ijs.kt.clus.ext.featureRanking.ClusFeatureRanking;
import si.ijs.kt.clus.ext.featureRanking.ensemble.ClusEnsembleFeatureRanking;
import si.ijs.kt.clus.ext.featureRanking.ensemble.ClusEnsembleFeatureRankings;
import si.ijs.kt.clus.ext.imputation.MissingTargetImputation;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.main.ClusOutput;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.ClusSummary;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsEnsemble;
import si.ijs.kt.clus.main.settings.section.SettingsExperimental;
import si.ijs.kt.clus.main.settings.section.SettingsGeneral;
import si.ijs.kt.clus.main.settings.section.SettingsMLC;
import si.ijs.kt.clus.main.settings.section.SettingsOutput;
import si.ijs.kt.clus.main.settings.section.SettingsRules;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.model.io.ClusModelCollectionIO;
import si.ijs.kt.clus.selection.BagSelection;
import si.ijs.kt.clus.selection.BagSelectionSemiSupervised;
import si.ijs.kt.clus.selection.OOBSelection;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.ComponentStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusRandom;
import si.ijs.kt.clus.util.ClusRandomNonstatic;
import si.ijs.kt.clus.util.ResourceInfo;
import si.ijs.kt.clus.util.cloner.Cloner;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.tools.optimization.gd.GDProblem;

public class ClusEnsembleInduce
extends ClusInductionAlgorithm {
    Clus m_BagClus;
    static ClusAttrType[] m_RandomSubspaces;
    private ClusForest[] m_OForests;
    private StopWatch m_Timer;
    private int m_MaxTime;
    private static boolean m_OptMode;
    private ClusEnsembleInduceOptimization[] m_Optimizations;
    int[] m_OutEnsembleAt;
    private static int m_NbMaxBags;
    private boolean m_WriteOOB;
    private Integer m_EnsembleROSSubspaceSize = null;
    private ClusROSForestInfo m_ROSForestInfo = null;
    private ClusOOBWeights m_OOBWeights = null;
    private ClusOOBErrorEstimate m_OOBEstimation;
    boolean m_FeatRank;
    ClusEnsembleFeatureRankings[] m_FeatureRankings;
    private int m_NbThreads;
    private static ArrayList<ParallelTrap> m_WarningsGiven;

    public ClusEnsembleInduce(ClusSchema schema, Settings sett, Clus clus) throws ClusException, IOException {
        super(schema, sett);
        this.initialize(schema, sett, clus);
    }

    public ClusEnsembleInduce(ClusInductionAlgorithm other, Clus clus) throws ClusException, IOException {
        super(other);
        this.initialize(this.getSchema(), this.getSettings(), clus);
    }

    public void initialize(ClusSchema schema, Settings settMain, Clus clus) throws ClusException, IOException {
        List<SettingsMLC.MultiLabelMeasures> rankingMeasures;
        this.m_BagClus = clus;
        this.m_Timer = new StopWatch();
        SettingsEnsemble sett = settMain.getEnsemble();
        this.m_WriteOOB = sett.shouldEstimateOOB();
        this.m_MaxTime = sett.getTimeBudget().getValue();
        m_OptMode = sett.shouldOptimizeEnsemble() && (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.HIERARCHICAL || this.m_StatManager.getTargetMode() == ClusStatManager.Mode.REGRESSION || this.m_StatManager.getTargetMode() == ClusStatManager.Mode.CLASSIFY);
        this.m_EnsembleROSSubspaceSize = sett.calculateNbRandomAttrSelected(schema, SettingsEnsemble.RandomAttributeTypeSelection.Clustering);
        this.m_OutEnsembleAt = sett.getNbBaggingSets().getIntVectorSorted();
        m_NbMaxBags = this.getNbTrees(this.m_OutEnsembleAt.length - 1);
        settMain.getExperimental();
        boolean bl = this.m_FeatRank = sett.shouldPerformRanking() && !SettingsExperimental.IS_XVAL;
        if (this.m_FeatRank && !sett.shouldEstimateOOB() && sett.getRankingMethods().contains((Object)SettingsEnsemble.EnsembleRanking.RForest)) {
            System.err.println("For Feature Ranking RForest, OOB estimate of error should also be performed.");
            System.err.println("OOB Error Estimate is set to true.");
            sett.setOOBestimate(true);
        }
        if (sett.shouldEstimateOOB()) {
            this.m_OOBEstimation = new ClusOOBErrorEstimate(this.getStatManager().getTargetMode(), settMain);
        }
        settMain.getOutput().setWriteOOBFile(true);
        if (this.m_FeatRank && this.m_BagClus.getSettings().getMLC().getSectionMultiLabel().isEnabled() && (rankingMeasures = this.m_BagClus.getSettings().getMLC().getMultiLabelRankingMeasures()).contains((Object)SettingsMLC.MultiLabelMeasures.All)) {
            this.m_BagClus.getSettings().getMLC().setToAllMultiLabelRankingMeasures();
        }
        this.setNumberOfThreads(sett.getNumberOfThreads());
        sett.updateNbRandomAttrSelected(schema);
        sett.determineBoostrapping();
    }

    public void setNumberOfThreads(int nbThreads) {
        this.m_NbThreads = nbThreads == 0 ? Runtime.getRuntime().availableProcessors() : nbThreads;
    }

    public HashMap<SettingsEnsemble.EnsembleRanking, Integer> setNbFeatureRankings(ClusSchema schema, ClusStatManager mgr) {
        HashMap<SettingsEnsemble.EnsembleRanking, Integer> nbRankings = new HashMap<SettingsEnsemble.EnsembleRanking, Integer>();
        for (int forest = 0; forest < this.m_FeatureRankings.length; ++forest) {
            int nbTrees = this.getNbTrees(forest);
            HashMap<SettingsEnsemble.EnsembleRanking, ClusEnsembleFeatureRanking> rankings = this.m_FeatureRankings[forest].getRankings();
            for (SettingsEnsemble.EnsembleRanking r : rankings.keySet()) {
                int nb = this.setNbFeatureRankings(r, rankings.get((Object)r), schema, mgr, nbTrees);
                if (nbRankings.containsKey((Object)r)) {
                    if (nbRankings.get((Object)r) == nb) continue;
                    throw new RuntimeException("Wrong number of rankings.");
                }
                nbRankings.put(r, nb);
            }
        }
        return nbRankings;
    }

    public int setNbFeatureRankings(SettingsEnsemble.EnsembleRanking rankingType, ClusEnsembleFeatureRanking franking, ClusSchema schema, ClusStatManager mgr, int nbTrees) {
        ClusStatistic clusteringStat = mgr.getStatistic(ClusAttrType.AttributeUseType.Clustering);
        SettingsEnsemble sett = schema.getSettings().getEnsemble();
        int nbRankings = 0;
        ClusAttrType[] clusteringAttrs = schema.getAllAttrUse(ClusAttrType.AttributeUseType.Clustering);
        if (clusteringAttrs.length < 2 && sett.shouldPerformRankingPerTarget()) {
            System.err.println("Situation:");
            System.err.println("- there is only one clustering attribute");
            System.err.println("- per target ranking is set to Yes");
            System.err.println("Consequences:");
            System.err.println("- per target ranking == overAll ranking");
            System.err.println("- per target ranking will be set to No");
            sett.setPerformRankingPerTarget(false);
        }
        ArrayList<String> rankingNames = new ArrayList<String>();
        switch (rankingType) {
            case RForest: {
                ClusErrorList errLst = franking.computeErrorList(schema, mgr);
                int nbErrors = errLst.getNbErrors();
                for (int i = 0; i < nbErrors; ++i) {
                    ++nbRankings;
                    rankingNames.add(String.format("%s:%s", errLst.getError(i).getName(), "overall"));
                    if (!sett.shouldPerformRankingPerTarget() || !(errLst.getError(i) instanceof ComponentError)) continue;
                    int nbDim = errLst.getError(i).getDimension();
                    nbRankings += nbDim;
                    for (int j = 0; j < nbDim; ++j) {
                        rankingNames.add(String.format("%s:%s", errLst.getError(i).getName(), clusteringAttrs[j].getName()));
                    }
                }
                franking.setRForestFimpHeader(rankingNames);
                break;
            }
            case Genie3: {
                ++nbRankings;
                rankingNames.add(String.format("overAll", new Object[0]));
                if (sett.shouldPerformRankingPerTarget()) {
                    if (!(clusteringStat instanceof ComponentStatistic)) {
                        System.err.println("Cannot perform per-target ranking for the given type(s) of targets!");
                        System.err.println("This option is now set to false.");
                        sett.setPerformRankingPerTarget(false);
                    } else {
                        int nbComponents = ((ComponentStatistic)((Object)clusteringStat)).getNbStatisticComponents();
                        nbRankings += nbComponents;
                        for (int j = 0; j < nbComponents; ++j) {
                            rankingNames.add(String.format("%s", clusteringAttrs[j].getName()));
                        }
                    }
                }
                franking.setGenie3FimpHeader(rankingNames);
                break;
            }
            case Symbolic: {
                String[] weights = sett.getSymbolicWeights();
                nbRankings = weights.length;
                franking.setSymbolicFimpHeader(weights);
                break;
            }
            default: {
                throw new RuntimeException("Wrong feature ranking method: " + rankingType.toString());
            }
        }
        franking.setNbFeatureRankings(nbRankings);
        return nbRankings;
    }

    public void resetClusOOBErrorEstimate() {
        this.m_OOBEstimation = new ClusOOBErrorEstimate(this.getStatManager().getTargetMode(), this.getSettings());
    }

    @Override
    public void induceAll(ClusRun cr) throws Exception {
        int i;
        SettingsEnsemble set = this.getSettings().getEnsemble();
        SettingsGeneral setg = this.getSettings().getGeneral();
        ClusLogger.info("Memory And Time Optimization = " + m_OptMode);
        ClusLogger.info("Out-Of-Bag Estimate of the error = " + set.shouldEstimateOOB());
        ClusLogger.info("Perform Feature Ranking = " + this.m_FeatRank);
        if (set.isEnsembleROSEnabled()) {
            ClusLogger.info(String.format("ROS: %s  Algorithm: %s%s  Voting: %s%s  Subspace size: %s", new Object[]{System.lineSeparator(), set.getEnsembleROSAlgorithmType(), System.lineSeparator(), set.getEnsembleROSVotingType(), System.lineSeparator(), set.getNbRandomTargetAttrString()}));
        }
        if (this.getSettings().getSSL().imputeMissingTargetValues()) {
            MissingTargetImputation.impute(cr);
        }
        this.m_FeatureRankings = new ClusEnsembleFeatureRankings[this.m_OutEnsembleAt.length];
        for (int forest = 0; forest < this.m_FeatureRankings.length; ++forest) {
            this.m_FeatureRankings[forest] = new ClusEnsembleFeatureRankings(this.getSettings());
        }
        ClusStatManager mgr = this.getStatManager();
        ClusSchema schema = mgr.getSchema();
        HashMap<SettingsEnsemble.EnsembleRanking, Integer> nbRankings = this.setNbFeatureRankings(schema, mgr);
        if (setg.getVerbose() > 0) {
            ClusLogger.info("Number of feature rankings computed:");
            for (SettingsEnsemble.EnsembleRanking r : nbRankings.keySet()) {
                ClusLogger.info(String.format("  - %s: %s", r.toString(), nbRankings.get((Object)r).toString()));
            }
        }
        for (int forest = 0; forest < this.m_FeatureRankings.length; ++forest) {
            this.m_FeatureRankings[forest].initializeAttributes(schema.getDescriptiveAttributes(), nbRankings);
        }
        this.m_OForests = new ClusForest[this.m_OutEnsembleAt.length];
        this.m_Optimizations = new ClusEnsembleInduceOptimization[this.m_OForests.length];
        for (int i2 = 0; i2 < this.m_OForests.length; ++i2) {
            this.m_OForests[i2] = new ClusForest(this.getStatManager(), this.m_Optimizations[i2]);
        }
        TupleIterator train_iterator = null;
        MemoryTupleIterator test_iterator = null;
        if (m_OptMode) {
            train_iterator = cr.getTrainIter();
            if (cr.getTestIter() != null) {
                test_iterator = cr.getTestSet().getIterator();
            }
            for (i = 0; i < this.m_Optimizations.length; ++i) {
                this.m_Optimizations[i] = this.initializeOptimization(train_iterator, test_iterator);
                this.m_Optimizations[i].initPredictions(this.m_OForests[i].getStat(), null);
                this.m_OForests[i].setOptimization(this.m_Optimizations[i]);
            }
        }
        switch (set.getEnsembleMethod()) {
            case Bagging: {
                ClusLogger.info("Ensemble Method: Bagging");
                this.induceBagging(cr);
                break;
            }
            case RForest: {
                ClusLogger.info("Ensemble Method: Random Forest");
                this.induceBagging(cr);
                break;
            }
            case RSubspaces: {
                ClusLogger.info("Ensemble Method: Random Subspaces");
                this.induceRandomSubspaces(cr);
                break;
            }
            case BagSubspaces: {
                ClusLogger.info("Ensemble Method: Bagging of Subspaces");
                this.induceBaggingSubspaces(cr);
                break;
            }
            case RFeatSelection: {
                ClusLogger.info("Ensemble Method: Random Forest without bootstrapping");
                this.induceRForestNoBootstrap(cr);
                break;
            }
            case Pert: {
                ClusLogger.info("Ensemble Method: PERT (in combination with bootstrapping)");
                this.induceBagging(cr);
                break;
            }
            case ExtraTrees: {
                ClusLogger.info("Ensemble Method: Extra-trees");
                this.induceBagging(cr);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unknown ensemble method: %s", set.getEnsembleMethod().toString()));
            }
        }
        if (this.m_FeatRank) {
            for (int forest = 0; forest < this.m_FeatureRankings.length; ++forest) {
                int expectedTrees = this.getNbTrees(forest);
                int realTrees = this.m_OForests[forest].getNbModels();
                this.m_FeatureRankings[forest].setEnsembleRankigDescription(realTrees);
                this.m_FeatureRankings[forest].createFimp(cr, String.format("Trees%d", expectedTrees), expectedTrees, realTrees);
            }
        }
        if (m_OptMode) {
            for (i = 0; i < this.m_Optimizations.length; ++i) {
                this.m_Optimizations[i].roundPredictions();
            }
        }
        this.postProcessForest(cr);
        ClusStatistic stat = cr.getStatManager().createClusteringStat();
        ((RowData)cr.getTrainingSet()).calcTotalStatBitVector(stat);
        stat.showRootInfo();
    }

    @Override
    public ClusModel induceSingleUnpruned(ClusRun cr) throws Exception {
        ClusRun myRun = new ClusRun(cr);
        this.induceAll(myRun);
        ClusModelInfo info = myRun.getModelInfo(1);
        return info.getModel();
    }

    public void induceRForestNoBootstrap(ClusRun cr) throws Exception {
        int i;
        TupleIterator train_iterator = m_OptMode ? cr.getTrainIter() : null;
        TupleIterator test_iterator = m_OptMode ? cr.getTestIter() : null;
        int max_number_of_bags = m_NbMaxBags;
        if (cr.getIsInternalXValRun()) {
            max_number_of_bags = this.m_Schema.getSettings().getSSL().getNumberOfTreesSupervisionOptimisation(m_NbMaxBags);
        }
        Random bagSeedGenerator = new Random(this.getSettings().getGeneral().getRandomSeed());
        int[] seeds = new int[max_number_of_bags];
        for (i = 0; i < max_number_of_bags; ++i) {
            seeds[i] = bagSeedGenerator.nextInt();
        }
        for (i = 1; i <= max_number_of_bags; ++i) {
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("Bag: " + i);
            }
            ClusRandomNonstatic rnd = new ClusRandomNonstatic(seeds[i - 1]);
            ClusRun crSingle = new ClusRun(cr.getTrainingSet(), cr.getSummary());
            DepthFirstInduce ind = this.getSchema().isSparse() ? new DepthFirstInduceSparse(this) : new DepthFirstInduce(this);
            ind.initialize();
            crSingle.getStatManager().initClusteringWeights();
            ClusModel model = ind.induceSingleUnpruned(crSingle, rnd);
            if (m_OptMode) {
                this.updatePredictionsForTuples(model, train_iterator, test_iterator, i);
            } else {
                this.addModelToForests(model, i);
            }
            if (!m_OptMode || i == max_number_of_bags || this.checkToOutEnsemble(i)) {
                // empty if block
            }
            crSingle.deleteData();
            crSingle.setModels(new ArrayList<ClusModelInfo>());
        }
    }

    public void induceRandomSubspaces(ClusRun cr) throws Exception {
        int i;
        TupleIterator train_iterator = m_OptMode ? cr.getTrainIter() : null;
        TupleIterator test_iterator = m_OptMode ? cr.getTestIter() : null;
        for (int i2 = 0; i2 < this.m_OForests.length; ++i2) {
            this.m_OForests[i2].setEnsembleROSForestInfo(new ClusROSForestInfo(this.getSettings().getEnsemble().getEnsembleROSAlgorithmType(), this.getSettings().getEnsemble().getEnsembleROSVotingType(), this.m_Schema.getNbTargetAttributes()));
        }
        int max_number_of_bags = m_NbMaxBags;
        if (cr.getIsInternalXValRun()) {
            max_number_of_bags = this.m_Schema.getSettings().getSSL().getNumberOfTreesSupervisionOptimisation(m_NbMaxBags);
        }
        Random bagSeedGenerator = new Random(this.getSettings().getGeneral().getRandomSeed());
        int[] seeds = new int[max_number_of_bags];
        for (i = 0; i < max_number_of_bags; ++i) {
            seeds[i] = bagSeedGenerator.nextInt();
        }
        for (i = 1; i <= max_number_of_bags; ++i) {
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("Bag: " + i);
            }
            ClusRandomNonstatic rnd = new ClusRandomNonstatic(seeds[i - 1]);
            ClusRun crSingle = new ClusRun(cr.getTrainingSet(), cr.getSummary());
            ClusEnsembleInduce.setRandomSubspaces(ClusEnsembleInduce.selectRandomSubspaces(cr.getStatManager().getSchema().getDescriptiveAttributes(), cr.getStatManager().getSettings().getEnsemble().getNbRandomAttrSelected(), 3, rnd));
            DepthFirstInduce ind = this.getSchema().isSparse() ? new DepthFirstInduceSparse(this) : new DepthFirstInduce(this);
            ind.initialize();
            crSingle.getStatManager().initClusteringWeights();
            this.initializeROSModel(ind, i);
            ClusModel model = ind.induceSingleUnpruned(crSingle, rnd);
            if (m_OptMode) {
                this.updatePredictionsForTuples(model, train_iterator, test_iterator, i);
            } else {
                this.addModelToForests(model, i);
            }
            if (!m_OptMode || i == max_number_of_bags || this.checkToOutEnsemble(i)) {
                // empty if block
            }
            crSingle.deleteData();
            crSingle.setModels(new ArrayList<ClusModelInfo>());
        }
    }

    public void induceBagging(ClusRun cr) throws ClusException, IOException, InterruptedException, ExecutionException {
        Future<OneBagResults> submit;
        InduceOneBagCallable worker;
        ClusRandomNonstatic rnd;
        int i;
        int nbrows = cr.getTrainingSet().getNbRows();
        ((RowData)cr.getTrainingSet()).addIndices();
        if (cr.getTestSet() != null) {
            cr.getTestSet().addIndices();
        }
        TupleIterator train_iterator = m_OptMode ? cr.getTrainIter() : null;
        TupleIterator test_iterator = m_OptMode ? cr.getTestIter() : null;
        OOBSelection oob_total = null;
        OOBSelection oob_sel = null;
        SettingsEnsemble sett = this.getSettings().getEnsemble();
        int nbUnlabeled = 0;
        nbUnlabeled = ((RowData)cr.getTrainingSet()).getNbUnlabeled();
        if (nbUnlabeled > 0 && nbUnlabeled > 0) {
            ((RowData)cr.getTrainingSet()).sortLabeledFirst();
        }
        int origMaxDepth = -1;
        if (sett.isEnsembleRandomDepth()) {
            origMaxDepth = this.getSettings().getConstraints().getTreeMaxDepth();
        }
        BagSelection msel = null;
        int[] bagSelections = sett.getBagSelection().getIntVectorSorted();
        Random bagSeedGenerator = new Random(this.getSettings().getGeneral().getRandomSeed());
        int max_number_of_bags = m_NbMaxBags;
        if (cr.getIsInternalXValRun()) {
            max_number_of_bags = this.m_Schema.getSettings().getSSL().getNumberOfTreesSupervisionOptimisation(m_NbMaxBags);
        }
        int[] seeds = new int[max_number_of_bags];
        for (int i2 = 0; i2 < max_number_of_bags; ++i2) {
            seeds[i2] = bagSeedGenerator.nextInt();
        }
        ClusStatManager clonedStatManager = ClusEnsembleInduce.cloneStatManager(cr.getStatManager());
        ExecutorService executor = Executors.newFixedThreadPool(this.m_NbThreads);
        ArrayList<Future<OneBagResults>> bagResults = new ArrayList<Future<OneBagResults>>();
        if (bagSelections[0] == -1) {
            this.m_Timer.reset();
            this.m_Timer.start();
            for (i = 1; i <= max_number_of_bags; ++i) {
                rnd = new ClusRandomNonstatic(seeds[i - 1]);
                msel = nbUnlabeled > 0 ? new BagSelectionSemiSupervised(nbrows, cr.getTrainingSet().getNbRows() - nbUnlabeled, nbUnlabeled, rnd) : new BagSelection(nbrows, sett.getEnsembleBagSize(), rnd);
                if (sett.shouldEstimateOOB()) {
                    oob_sel = new OOBSelection(msel);
                    if (i == 1) {
                        oob_total = new OOBSelection(msel);
                    } else {
                        oob_total.addToThis(oob_sel);
                    }
                }
                if (sett.isVotingOOBWeighted() && !sett.shouldEstimateOOB()) {
                    oob_sel = new OOBSelection(msel);
                }
                worker = new InduceOneBagCallable(this, cr, i, origMaxDepth, oob_sel, train_iterator, test_iterator, msel, rnd, clonedStatManager);
                submit = executor.submit(worker);
                bagResults.add(submit);
            }
        } else if (bagSelections[0] == 0) {
            this.makeForestFromBags(cr, train_iterator, test_iterator);
        } else {
            for (i = 1; i < bagSelections[0]; ++i) {
                msel = new BagSelection(nbrows, sett.getEnsembleBagSize(), null);
            }
            for (i = bagSelections[0]; i <= bagSelections[1]; ++i) {
                rnd = new ClusRandomNonstatic(seeds[i - 1]);
                msel = nbUnlabeled > 0 ? new BagSelectionSemiSupervised(nbrows, cr.getTrainingSet().getNbRows() - nbUnlabeled, nbUnlabeled, rnd) : new BagSelection(nbrows, sett.getEnsembleBagSize(), rnd);
                if (sett.shouldEstimateOOB()) {
                    oob_sel = new OOBSelection(msel);
                }
                worker = new InduceOneBagCallable(this, cr, i, origMaxDepth, oob_sel, train_iterator, test_iterator, msel, rnd, clonedStatManager);
                submit = executor.submit(worker);
                bagResults.add(submit);
            }
        }
        executor.shutdown();
        executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
        for (i = 1; i <= bagResults.size(); ++i) {
            Future future = (Future)bagResults.get(i - 1);
            try {
                OneBagResults results = (OneBagResults)future.get();
                if (results.getInductionTime() < 0L) continue;
                if (!m_OptMode) {
                    this.addModelToForests(results.getModel(), i);
                }
                if (sett.shouldPerformRanking()) {
                    this.updateFeatureRankings(results.getModelIndex(), results.getFimportances());
                }
                ClusRun crSingle = results.getSingleRun();
                if (!this.checkToOutEnsemble(i) || sett.getBagSelection().getIntVectorSorted()[0] != -1) continue;
                this.postProcessForest(crSingle);
                if (!this.m_WriteOOB) continue;
                if (i == max_number_of_bags) {
                    this.m_OOBEstimation.postProcessForestForOOBEstimate(crSingle, oob_total, (RowData)cr.getTrainingSet(), this.m_BagClus, "");
                    continue;
                }
                this.m_OOBEstimation.postProcessForestForOOBEstimate(crSingle, oob_total, (RowData)cr.getTrainingSet(), this.m_BagClus, "_" + i + "_");
                continue;
            }
            catch (InterruptedException e) {
                throw new ClusException(e.toString());
            }
        }
        if (origMaxDepth != -1) {
            this.getSettings().getConstraints().setTreeMaxDepth(origMaxDepth);
        }
    }

    private void initializeROSModel(ClusInductionAlgorithm ind, int bagNo) throws ClusException {
        ClusStatManager mgr = ind.getStatManager();
        SettingsEnsemble sett = mgr.getSettings().getEnsemble();
        if (sett.isEnsembleROSEnabled()) {
            ClusHeuristic h;
            if (this.m_ROSForestInfo == null) {
                this.m_ROSForestInfo = new ClusROSForestInfo(sett.getEnsembleROSAlgorithmType(), sett.getEnsembleROSVotingType(), mgr.getSchema().getNbTargetAttributes());
            }
            if ((h = mgr.getHeuristic()).getClusteringAttributeWeights() == null) {
                throw new ClusException("ROS: Heuristic %s is not supported!", h.getName());
            }
            HashMap<Integer, Integer> enabled = ClusROSHelpers.generateSubspace(mgr.getSchema(), this.m_EnsembleROSSubspaceSize, sett.getEnsembleROSAlgorithmType(), bagNo - 1);
            ClusROSModelInfo info = new ClusROSModelInfo(bagNo - 1, this.m_EnsembleROSSubspaceSize, enabled, mgr.getSchema().getNbTargetAttributes());
            h.getClusteringAttributeWeights().setROSModelInfo(info);
            this.m_ROSForestInfo.addROSModelInfo(info);
            ClusLogger.info(String.format("ROS (Bag %s): %s", info.getTreeNumber() + 1, info.getSubspaceString()));
        }
    }

    public OneBagResults induceOneBag(ClusRun cr, int i, int origMaxDepth, OOBSelection oob_sel, TupleIterator train_iterator, TupleIterator test_iterator, BagSelection msel, ClusRandomNonstatic rnd, ClusStatManager unmodifiedManager) throws Exception {
        if (this.m_MaxTime > 0 && this.m_Timer.getTime() / 1000L >= (long)this.m_MaxTime) {
            return new OneBagResults(null, null, null, -1L, 0);
        }
        long one_bag_time = ResourceInfo.getTime();
        SettingsEnsemble sett = cr.getStatManager().getSettings().getEnsemble();
        SettingsOutput seto = cr.getStatManager().getSettings().getOutput();
        boolean canForgetTheRun = true;
        ClusRun crSingle = null;
        DepthFirstInduce ind = null;
        ClusStatManager mgr = ClusEnsembleInduce.cloneStatManager(unmodifiedManager);
        ClusLogger.info("Bag: " + i);
        if (sett.isEnsembleRandomDepth()) {
            this.getSettings().getConstraints().setTreeMaxDepth(GDProblem.randDepthWighExponentialDistribution(rnd.nextDouble(2), origMaxDepth));
        }
        crSingle = sett.getEnsembleBootstrapping().equals((Object)SettingsEnsemble.EnsembleBootstrapping.No) ? new ClusRun(cr.getTrainingSet(), cr.getSummary()) : this.m_BagClus.partitionDataBasic(cr.getTrainingSet(), msel, cr.getSummary(), i);
        ind = this.getSchema().isSparse() ? new DepthFirstInduceSparse(this, mgr, true) : new DepthFirstInduce(this, mgr, true);
        ind.initialize();
        crSingle.getStatManager().initClusteringWeights();
        ind.getStatManager().initClusteringWeights();
        this.initializeROSModel(ind, i);
        ClusModel model = ind.induceSingleUnpruned(crSingle, rnd);
        one_bag_time = ResourceInfo.getTime() - one_bag_time;
        this.updateCounts((ClusNode)model, i);
        if (sett.shouldEstimateOOB() && sett.getBagSelection().getIntVectorSorted()[0] == -1) {
            this.m_OOBEstimation.updateOOBTuples(oob_sel, (RowData)cr.getTrainingSet(), model, i);
        }
        if (sett.isVotingOOBWeighted()) {
            this.saveOOBEstimates(model, oob_sel, (RowData)cr.getTrainingSet(), i);
        }
        HashMap<SettingsEnsemble.EnsembleRanking, HashMap<String, double[][]>> fimportances = new HashMap<SettingsEnsemble.EnsembleRanking, HashMap<String, double[][]>>();
        if (this.m_FeatRank) {
            block5: for (SettingsEnsemble.EnsembleRanking r : sett.getRankingMethods()) {
                ClusEnsembleFeatureRanking aRanking = this.m_FeatureRankings[0].getRankings().get((Object)r);
                switch (r) {
                    case RForest: {
                        fimportances.put(r, aRanking.calculateRFimportance(model, cr, oob_sel, rnd, ind.getStatManager()));
                        continue block5;
                    }
                    case Symbolic: {
                        String[] weights = sett.getSymbolicWeights();
                        fimportances.put(r, aRanking.calculateSYMBOLICimportanceIteratively((ClusNode)model, weights));
                        continue block5;
                    }
                    case Genie3: {
                        fimportances.put(r, aRanking.calculateGENIE3importanceIteratively((ClusNode)model, ind.getStatManager()));
                        continue block5;
                    }
                }
                throw new RuntimeException("Unknown ranking method: " + sett.getRankingMethodName());
            }
        }
        if (seto.shouldWritePerBagModelFiles() && (sett.getBagSelection().getIntVectorSorted()[0] != -1 || sett.isPrintEnsembleModelFiles())) {
            ClusModelCollectionIO io = new ClusModelCollectionIO();
            ClusModelInfo orig_info = crSingle.addModelInfo("Original");
            orig_info.setModel(model);
            ArrayList<ClusNode> submodels = ClusNode.cutTrees((ClusNode)model);
            for (int s = 0; s < submodels.size(); ++s) {
                ClusModelInfo subInfo = crSingle.addModelInfo(ClusNode.getSubmodelName(s));
                subInfo.setModel(submodels.get(s));
            }
            this.m_BagClus.saveModels(crSingle, io);
            io.save(this.m_BagClus.getSettings().getGeneric().getFileAbsolute(cr.getStatManager().getSettings().getGeneric().getAppName() + "_bag" + i + ".model"));
            ((ClusNode)model).joinWithSubmodels(submodels);
        }
        if (m_OptMode) {
            this.updatePredictionsForTuples(model, train_iterator, test_iterator, i);
            if (cr.getStatManager().getSettings().getOutput().isOutputPythonModel()) {
                this.writeTreeToTempPythonFile(cr, model, i);
            }
            model = null;
            unmodifiedManager = null;
            ind = null;
        }
        if (sett.isPrintEnsemblePaths()) {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream("tree_" + i + ".path")));
            ((ClusNode)model).numberCompleteTree();
            ((ClusNode)model).printPaths(pw, "", "", (RowData)cr.getTrainingSet(), oob_sel, false);
            if (cr.getTestSet() != null) {
                ((ClusNode)model).printPaths(pw, "", "", cr.getTestSet(), null, true);
            }
        }
        if (this.checkToOutEnsemble(i) && sett.getBagSelection().getIntVectorSorted()[0] == -1) {
            crSingle.setInductionTime(one_bag_time);
            canForgetTheRun = false;
            if (m_OptMode && i != m_NbMaxBags && this.m_NbThreads > 1) {
                ClusEnsembleInduce.giveParallelisationWarning(ParallelTrap.Optimization);
            }
        }
        if (canForgetTheRun) {
            crSingle.deleteData();
            crSingle.setModels(new ArrayList<ClusModelInfo>());
        }
        if (this.m_MaxTime > 0 && this.m_Timer.getTime() / 1000L >= (long)this.m_MaxTime) {
            return new OneBagResults(null, null, null, -1L, 0);
        }
        return new OneBagResults(model, fimportances, crSingle, one_bag_time, i);
    }

    private void saveOOBEstimates(ClusModel model, OOBSelection oob_sel, RowData data, int i) throws ClusException, InterruptedException {
        ClusError error = this.calculateOOBWeights(model, oob_sel, data);
        if (this.m_OOBWeights == null) {
            this.m_OOBWeights = this.getSettings().getEnsemble().isEnsembleROSEnabled() ? new ClusROSOOBWeights(this.getSettings().getEnsemble().getEnsembleVotingType(), this.getSettings().getEnsemble().getEnsembleROSVotingType()) : new ClusOOBWeights(this.getSettings().getEnsemble().getEnsembleVotingType());
        }
        this.m_OOBWeights.setErrors(i - 1, error);
    }

    private ClusError calculateOOBWeights(ClusModel model, OOBSelection oob_sel, RowData data) throws ClusException, InterruptedException {
        ClusError error = null;
        ClusErrorList OOBErrorList = new ClusErrorList();
        switch (this.getStatManager().getTargetMode()) {
            case REGRESSION: {
                error = new RMSError(OOBErrorList, this.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.Target));
                break;
            }
            case CLASSIFY: {
                error = new Accuracy(OOBErrorList, this.getSchema().getNominalAttrUse(ClusAttrType.AttributeUseType.Target));
                break;
            }
            case HIERARCHICAL: {
                break;
            }
            default: {
                String msg = "Unable to calculate OOB estimates!";
                ClusLogger.severe(msg);
                throw new RuntimeException(msg);
            }
        }
        OOBErrorList.addError(error);
        for (int example = 0; example < data.getNbRows(); ++example) {
            if (!oob_sel.isSelected(example)) continue;
            DataTuple tuple = data.getTuple(example);
            ClusStatistic pred = model.predictWeighted(tuple);
            OOBErrorList.addExample(tuple, pred);
        }
        return error;
    }

    public void makeForestFromBags(ClusRun cr, TupleIterator train_iterator, TupleIterator test_iterator) throws ClusException, IOException, InterruptedException {
        int nFound = 0;
        try {
            int i;
            OOBSelection oob_total = null;
            OOBSelection oob_sel = null;
            BagSelection msel = null;
            ClusLogger.info("Start loading models");
            Random bagSeedGenerator = new Random(this.getSettings().getGeneral().getRandomSeed());
            int[] seeds = new int[m_NbMaxBags];
            for (i = 0; i < m_NbMaxBags; ++i) {
                seeds[i] = bagSeedGenerator.nextInt();
            }
            for (i = 1; i <= m_NbMaxBags; ++i) {
                ClusLogger.info("Loading model for bag " + i);
                ClusRandomNonstatic rnd = new ClusRandomNonstatic(seeds[i - 1]);
                String fileName = this.m_BagClus.getSettings().getGeneric().getFileAbsolute(this.getSettings().getGeneric().getAppName() + "_bag" + i + ".model");
                File tempFile = new File(fileName);
                if (!tempFile.exists()) {
                    ClusLogger.info("The corresponding file does not exist. Skipping this bag.");
                    continue;
                }
                ++nFound;
                ClusModelCollectionIO io = ClusModelCollectionIO.load(fileName);
                ClusModel orig_bag_model = io.getModel("Original");
                if (orig_bag_model == null) {
                    throw new ClusException(fileName + " file does not contain model named 'Original'");
                }
                ArrayList<ClusNode> submodels = new ArrayList<ClusNode>();
                for (int s = 0; s < ((ClusNode)orig_bag_model).getNumberSubmodels(); ++s) {
                    ClusNode submodel = (ClusNode)io.getModel(ClusNode.getSubmodelName(s));
                    submodels.add(submodel);
                }
                ((ClusNode)orig_bag_model).joinWithSubmodels(submodels);
                this.updateCounts((ClusNode)orig_bag_model, i);
                if (m_OptMode) {
                    this.updatePredictionsForTuples(orig_bag_model, train_iterator, test_iterator, i);
                } else {
                    this.addModelToForests(orig_bag_model, i);
                }
                if (this.getSettings().getEnsemble().shouldEstimateOOB()) {
                    msel = new BagSelection(cr.getTrainingSet().getNbRows(), this.getSettings().getEnsemble().getEnsembleBagSize(), rnd);
                    oob_sel = new OOBSelection(msel);
                    if (i == 1) {
                        oob_total = new OOBSelection(msel);
                    } else {
                        oob_total.addToThis(oob_sel);
                    }
                    this.m_OOBEstimation.updateOOBTuples(oob_sel, (RowData)cr.getTrainingSet(), orig_bag_model, i);
                }
                if (this.checkToOutEnsemble(i)) {
                    this.postProcessForest(cr);
                    if (this.getSettings().getEnsemble().shouldEstimateOOB()) {
                        if (i == m_NbMaxBags) {
                            this.m_OOBEstimation.postProcessForestForOOBEstimate(cr, oob_total, (RowData)cr.getTrainingSet(), this.m_BagClus, "");
                        } else {
                            this.m_OOBEstimation.postProcessForestForOOBEstimate(cr, oob_total, (RowData)cr.getTrainingSet(), this.m_BagClus, "_" + i + "_");
                        }
                    }
                    if (!m_OptMode || i != m_NbMaxBags) {
                        // empty if block
                    }
                }
                cr.setModels(new ArrayList<ClusModelInfo>());
            }
        }
        catch (ClassNotFoundException e) {
            throw new ClusException("Error: not all of the _bagX.model files were found");
        }
        if (nFound < m_NbMaxBags && nFound > 0) {
            ClusLogger.info("WARNING: Not all model files could be found");
        } else if (nFound == 0) {
            throw new ClusException("No model file could be found");
        }
    }

    public void induceBaggingSubspaces(ClusRun cr) throws Exception {
        int i;
        int nbrows = cr.getTrainingSet().getNbRows();
        long summ_time = 0L;
        TupleIterator train_iterator = m_OptMode ? cr.getTrainIter() : null;
        TupleIterator test_iterator = m_OptMode ? cr.getTestIter() : null;
        OOBSelection oob_total = null;
        OOBSelection oob_sel = null;
        Random bagSeedGenerator = new Random(this.getSettings().getGeneral().getRandomSeed());
        int[] seeds = new int[m_NbMaxBags];
        for (i = 0; i < m_NbMaxBags; ++i) {
            seeds[i] = bagSeedGenerator.nextInt();
        }
        for (i = 1; i <= m_NbMaxBags; ++i) {
            long one_bag_time = ResourceInfo.getTime();
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("Bag: " + i);
            }
            ClusRandomNonstatic rnd = new ClusRandomNonstatic(seeds[i - 1]);
            BagSelection msel = new BagSelection(nbrows, this.getSettings().getEnsemble().getEnsembleBagSize(), rnd);
            ClusRun crSingle = this.m_BagClus.partitionDataBasic(cr.getTrainingSet(), msel, cr.getSummary(), i);
            ClusEnsembleInduce.setRandomSubspaces(ClusEnsembleInduce.selectRandomSubspaces(cr.getStatManager().getSchema().getDescriptiveAttributes(), cr.getStatManager().getSettings().getEnsemble().getNbRandomAttrSelected(), 3, rnd));
            DepthFirstInduce ind = this.getSchema().isSparse() ? new DepthFirstInduceSparse(this) : new DepthFirstInduce(this);
            ind.initialize();
            crSingle.getStatManager().initClusteringWeights();
            ind.initializeHeuristic();
            ClusModel model = ind.induceSingleUnpruned(crSingle, rnd);
            summ_time += ResourceInfo.getTime() - one_bag_time;
            this.updateCounts((ClusNode)model, i);
            if (this.getSettings().getEnsemble().shouldEstimateOOB()) {
                oob_sel = new OOBSelection(msel);
                if (i == 1) {
                    oob_total = new OOBSelection(msel);
                } else {
                    oob_total.addToThis(oob_sel);
                }
                this.m_OOBEstimation.updateOOBTuples(oob_sel, (RowData)cr.getTrainingSet(), model, i);
            }
            if (m_OptMode) {
                this.updatePredictionsForTuples(model, train_iterator, test_iterator, i);
            } else {
                this.addModelToForests(model, i);
            }
            if (this.checkToOutEnsemble(i)) {
                crSingle.setInductionTime(summ_time);
                this.postProcessForest(crSingle);
                if (this.getSettings().getEnsemble().shouldEstimateOOB()) {
                    if (i == m_NbMaxBags) {
                        this.m_OOBEstimation.postProcessForestForOOBEstimate(crSingle, oob_total, (RowData)cr.getTrainingSet(), this.m_BagClus, "");
                    } else {
                        this.m_OOBEstimation.postProcessForestForOOBEstimate(crSingle, oob_total, (RowData)cr.getTrainingSet(), this.m_BagClus, "_" + i + "_");
                    }
                }
                if (!m_OptMode || i != m_NbMaxBags) {
                    // empty if block
                }
            }
            crSingle.deleteData();
            crSingle.setModels(new ArrayList<ClusModelInfo>());
        }
    }

    public boolean checkToOutEnsemble(int idx) {
        for (int i = 0; i < this.m_OutEnsembleAt.length; ++i) {
            if (this.m_OutEnsembleAt[i] != idx) continue;
            return true;
        }
        return false;
    }

    public void postProcessForest(ClusRun cr) throws ClusException, InterruptedException {
        int i;
        String partialForestName = "Forest with %d trees";
        for (i = 0; i < this.m_OForests.length; ++i) {
            int nbTrees = this.m_OForests[i].getNbModels();
            ClusModelInfo modelInfo = cr.addModelInfo(String.format(partialForestName, nbTrees));
            modelInfo.setModel(this.m_OForests[i]);
        }
        if (this.getStatManager().getTargetMode() == ClusStatManager.Mode.HIERARCHICAL) {
            double[] thresholds = this.getSettings().getHMLC().getClassificationThresholds().getDoubleVector();
            for (int i2 = 0; i2 < this.m_OForests.length; ++i2) {
                this.m_OForests[i2].setPrintModels(this.getSettings().getEnsemble().isPrintEnsembleModels());
            }
            if (thresholds != null) {
                for (int forest = 0; forest < this.m_OForests.length; ++forest) {
                    for (int i3 = 0; i3 < thresholds.length; ++i3) {
                        String basicName = String.format(partialForestName, this.m_OForests[forest].getNbModels());
                        String thresholdedName = String.format(Locale.ENGLISH, "%s(T = %.1f)", basicName, thresholds[i3]);
                        ClusModelInfo pruned_info = cr.addModelInfo(thresholdedName);
                        ClusForest new_forest = this.m_OForests[forest].cloneForestWithThreshold(thresholds[i3]);
                        new_forest.setPrintModels(this.getSettings().getEnsemble().isPrintEnsembleModels());
                        pruned_info.setShouldWritePredictions(false);
                        pruned_info.setModel(new_forest);
                    }
                }
            }
        }
        if (!this.getSettings().getTree().rulesFromTree().equals((Object)SettingsOutput.ConvertRules.No) && !this.getSettings().getRules().getCoveringMethod().equals((Object)SettingsRules.CoveringMethod.RulesFromTree)) {
            for (i = 0; i < this.m_OForests.length; ++i) {
                this.m_OForests[i].convertToRules(cr, false);
            }
        }
        if (this.getSettings().getEnsemble().isEnsembleROSEnabled()) {
            for (i = 0; i < this.m_OForests.length; ++i) {
                this.m_OForests[i].setEnsembleROSForestInfo(this.m_ROSForestInfo.getNew(this.m_OutEnsembleAt[i]));
            }
        }
        if (this.getSettings().getEnsemble().isVotingOOBWeighted()) {
            for (i = 0; i < this.m_OForests.length; ++i) {
                ClusOOBWeights weights = null;
                if (this.getSettings().getEnsemble().isEnsembleROSEnabled()) {
                    ClusROSOOBWeights w = (ClusROSOOBWeights)this.m_OOBWeights;
                    w = w.getNew(this.m_OutEnsembleAt[i], this.m_OForests[i].getEnsembleROSForestInfo());
                    weights = w;
                } else {
                    weights = this.m_OOBWeights.getNew(this.m_OutEnsembleAt[i]);
                }
                this.m_OForests[i].setOOBWeightsEstimates(weights);
            }
        }
    }

    public synchronized void outputBetweenForest(ClusRun cr, Clus cl, String addname) throws IOException, ClusException, InterruptedException {
        Settings sett = cr.getStatManager().getSettings();
        ClusSchema schema = cr.getStatManager().getSchema();
        ClusOutput output = new ClusOutput(sett.getGeneric().getAppName() + addname + ".out", schema, sett);
        ClusSummary summary = cr.getSummary();
        this.getStatManager().computeTrainSetStat((RowData)cr.getTrainingSet());
        cl.calcError(cr, null, null);
        if (summary != null) {
            for (int i = 1; i < cr.getNbModels(); ++i) {
                ClusModelInfo summ_info = cr.getModelInfo(i);
                ClusErrorList test_err = summ_info.getTestError();
                summ_info.setTestError(test_err);
            }
        }
        cl.calcExtraTrainingSetErrors(cr);
        output.writeHeader();
        output.writeOutput(cr, true, this.getSettings().getOutput().isOutTrainError());
        output.close();
        cl.getClassifier().saveInformation(sett.getGeneric().getAppName());
        ClusModelCollectionIO io = new ClusModelCollectionIO();
        cl.saveModels(cr, io);
        io.save(cl.getSettings().getGeneric().getFileAbsolute(cr.getStatManager().getSettings().getGeneric().getAppName() + addname + ".model"));
    }

    public static int getMaxNbBags() {
        return m_NbMaxBags;
    }

    public int getNbTrees(int forestIndex) {
        return this.m_OutEnsembleAt[forestIndex];
    }

    public static ClusAttrType[] selectRandomSubspaces(ClusAttrType[] attrs, int select, int randomizerVersion, ClusRandomNonstatic rand) {
        int rnd;
        int origsize = attrs.length;
        int[] samples = new int[origsize];
        boolean randomize = true;
        int i = 0;
        if (rand == null) {
            while (randomize) {
                rnd = ClusRandom.nextInt(randomizerVersion, origsize);
                if (samples[rnd] == 0) {
                    int n = rnd;
                    samples[n] = samples[n] + 1;
                    ++i;
                }
                randomize = i != select;
            }
        } else {
            while (randomize) {
                rnd = rand.nextInt(randomizerVersion, origsize);
                if (samples[rnd] == 0) {
                    int n = rnd;
                    samples[n] = samples[n] + 1;
                    ++i;
                }
                randomize = i != select;
            }
        }
        ClusAttrType[] result = new ClusAttrType[select];
        int res = 0;
        for (int k = 0; k < origsize; ++k) {
            if (samples[k] == 0) continue;
            result[res] = attrs[k];
            ++res;
        }
        return result;
    }

    public static ClusAttrType[] getRandomSubspaces() {
        return m_RandomSubspaces;
    }

    public static void setRandomSubspaces(ClusAttrType[] attrs) {
        m_RandomSubspaces = attrs;
    }

    public static boolean isOptimized() {
        return m_OptMode;
    }

    public ClusFeatureRanking getEnsembleFeatureRanking(int i, SettingsEnsemble.EnsembleRanking rankingType) {
        return this.m_FeatureRankings[i].getRankings().get((Object)rankingType);
    }

    public static synchronized void giveParallelisationWarning(ParallelTrap reason) {
        if (!m_WarningsGiven.contains((Object)reason)) {
            System.err.println("Warning:" + System.lineSeparator() + (Object)((Object)reason) + System.lineSeparator() + "There will be no additional warnings for this.");
            m_WarningsGiven.add(reason);
        }
    }

    private void updateCounts(ClusNode model, int treeNumber) throws InterruptedException {
        int[] additionalNodesLeavesDepth = ClusForest.countNodesLeaves(model);
        ArrayList<Integer> modelInd = new ArrayList<Integer>();
        modelInd.add(treeNumber);
        for (int ii = this.m_OForests.length - 1; ii >= 0 && this.getNbTrees(ii) >= treeNumber; --ii) {
            this.m_OForests[ii].updateCounts(modelInd, additionalNodesLeavesDepth[0], additionalNodesLeavesDepth[1], additionalNodesLeavesDepth[2]);
        }
    }

    private void updateFeatureRankings(int treeIndex, HashMap<SettingsEnsemble.EnsembleRanking, HashMap<String, double[][]>> fimportances) throws InterruptedException {
        for (int forest = this.m_OForests.length - 1; forest >= 0 && this.getNbTrees(forest) >= treeIndex; --forest) {
            this.m_FeatureRankings[forest].putAttributesInfos(fimportances);
        }
    }

    private void addModelToForests(ClusModel model, int treeNumber) {
        for (int forest = this.m_OForests.length - 1; forest >= 0 && this.getNbTrees(forest) >= treeNumber; --forest) {
            this.m_OForests[forest].addModelToForest(model);
        }
    }

    private ClusEnsembleInduceOptimization initializeOptimization(TupleIterator train_iterator, TupleIterator test_iterator) throws IOException, ClusException {
        if (this.getStatManager().getTargetMode() == ClusStatManager.Mode.HIERARCHICAL || this.getStatManager().getTargetMode() == ClusStatManager.Mode.REGRESSION) {
            return new ClusEnsembleInduceOptRegHMLC(train_iterator, test_iterator, this.getSettings());
        }
        if (this.getStatManager().getTargetMode() == ClusStatManager.Mode.CLASSIFY) {
            return new ClusEnsembleInduceOptClassification(train_iterator, test_iterator, this.getSettings());
        }
        ClusStatManager.Mode[] values = new ClusStatManager.Mode[]{ClusStatManager.Mode.HIERARCHICAL, ClusStatManager.Mode.REGRESSION, ClusStatManager.Mode.CLASSIFY, this.getStatManager().getTargetMode()};
        String line1 = "Optimization supported only for the following target modes:";
        String line2 = String.format("MODE_HIERARCHICAL = %d, MODE_REGRESSION = %d and MODE_CLASSIFY = %d", new Object[]{values[0], values[1], values[2]});
        String line3 = String.format("Unfortunately: m_Mode = %d", new Object[]{values[3]});
        String message = String.join((CharSequence)"\n", line1, line2, line3);
        throw new ClusException(message);
    }

    private void updatePredictionsForTuples(ClusModel model, TupleIterator train_iterator, TupleIterator test_iterator, int treeNumber) throws IOException, ClusException, InterruptedException {
        for (int forest = this.m_OForests.length - 1; forest >= 0 && this.getNbTrees(forest) >= treeNumber; --forest) {
            this.m_Optimizations[forest].updatePredictionsForTuples(model, train_iterator, test_iterator);
        }
    }

    private static ClusStatManager cloneStatManager(ClusStatManager statManager) {
        Cloner cloner = new Cloner();
        return cloner.deepClone(statManager);
    }

    private void writeTreeToTempPythonFile(ClusRun cr, ClusModel tree, int treeIndex) throws FileNotFoundException {
        File tempPy = new File(ClusEnsembleInduce.getTemporaryPythonTreeFileName(cr, treeIndex));
        SettingsOutput.PythonModelType modelType = cr.getStatManager().getSettings().getOutput().getPythonModelType();
        PrintWriter wrtr = new PrintWriter(new FileOutputStream(tempPy));
        this.m_OForests[0].printOneTree(wrtr, (ClusNode)tree, treeIndex, modelType);
        wrtr.close();
    }

    public static String getTemporaryPythonTreeFileName(ClusRun cr, int treeIndex) {
        return cr.getStatManager().getSettings().getGeneric().getFileAbsolute(String.format("temp_tree%d.py", treeIndex));
    }

    static {
        m_WarningsGiven = new ArrayList();
    }

    public static enum ParallelTrap {
        BestFirst_getDescriptiveAttributes("clus.ext.bestfirst.BestFirstInduce.getDescriptiveAttributes() has been called. This may not work in parallel setting."),
        DepthFirst_getDescriptiveAttributes("clus.algo.tdidt.DepthFirstInduce.getDescriptiveAttributes(ClusRandomNonstatic) has been called. This may not work in parallel setting."),
        StaticRandom("Static random has been called. This may not work in parallel setting."),
        Optimization("Memory usage optimization is on. You have reached a place where there might be some unexpected behaviour in parallel setting because of that.");

        private String m_Message = "";

        private ParallelTrap(String msg) {
            this.m_Message = msg;
        }

        public String toString() {
            return this.m_Message;
        }
    }
}

