/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.beamsearch;

import java.io.IOException;
import java.util.ArrayList;
import si.ijs.kt.clus.Clus;
import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.algo.split.FindBestTest;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.beamsearch.ClusBeam;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamAttrSelector;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamModel;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamSearch;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamSizeConstraints;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;

public class ClusFastBeamSearch
extends ClusBeamSearch {
    ClusBeamSizeConstraints m_Constr = new ClusBeamSizeConstraints();

    public ClusFastBeamSearch(Clus clus) throws IOException, ClusException {
        super(clus);
    }

    @Override
    public ClusBeam initializeBeam(ClusRun run) throws Exception {
        ClusBeam beam = super.initializeBeam(run);
        ClusBeamModel model = beam.getBestModel();
        this.initModelRecursive((ClusNode)model.getModel(), (RowData)run.getTrainingSet());
        return beam;
    }

    public void initModelRecursive(ClusNode node, RowData data) {
        if (node.atBottomLevel()) {
            ClusBeamAttrSelector attrsel = new ClusBeamAttrSelector();
            attrsel.setData(data);
            node.setVisitor(attrsel);
        } else {
            NodeTest test = node.getTest();
            for (int j = 0; j < node.getNbChildren(); ++j) {
                ClusNode child = (ClusNode)node.getChild(j);
                RowData subset = data.applyWeighted(test, j);
                this.initModelRecursive(child, subset);
            }
        }
    }

    public void computeGlobalHeuristic(NodeTest test, RowData data, CurrentBestTestAndHeuristic sel) throws ClusException {
        sel.reset(2);
        data.calcPosAndMissStat(test, 0, sel.getPosStat(), sel.getMissStat());
        double global_heur = this.m_Heuristic.calcHeuristic(sel.getTotStat(), sel.getPosStat(), sel.getMissStat());
        test.setHeuristicValue(global_heur);
    }

    @Override
    public void refineGivenLeaf(ClusNode leaf, ClusBeamModel root, ClusBeam beam, ClusAttrType[] attrs) throws Exception {
        NodeTest test;
        ClusBeamAttrSelector attrsel = (ClusBeamAttrSelector)leaf.getVisitor();
        if (attrsel.isStopCrit()) {
            if (this.m_Verbose) {
                System.out.print("[S:" + leaf.getClusteringStat() + "]");
            }
            return;
        }
        RowData data = attrsel.getData();
        if (!attrsel.hasEvaluations()) {
            if (this.m_Induce.initSelectorAndStopCrit(leaf, data)) {
                attrsel.setStopCrit(true);
                return;
            }
            CurrentBestTestAndHeuristic sel = this.m_Induce.getBestTest();
            FindBestTest find = this.m_Induce.getFindBestTest();
            this.m_Heuristic.setTreeOffset(0.0);
            attrsel.newEvaluations(attrs.length);
            for (int i = 0; i < attrs.length; ++i) {
                sel.resetBestTest();
                ClusAttrType at = attrs[i];
                if (at instanceof NominalAttrType) {
                    find.findNominal((NominalAttrType)at, data, null);
                } else {
                    find.findNumeric((NumericAttrType)at, data, null);
                }
                if (!sel.hasBestTest()) continue;
                test = sel.updateTest();
                if (this.hasAttrHeuristic()) {
                    this.computeGlobalHeuristic(test, data, sel);
                }
                attrsel.setBestTest(i, test);
            }
        }
        double offset = root.getValue() - this.m_Heuristic.computeLeafAdd(leaf);
        NodeTest[] besttests = attrsel.getBestTests();
        if (this.m_Verbose) {
            ClusLogger.info("[M:" + beam.getMinValue() + "]");
        }
        for (int i = 0; i < besttests.length; ++i) {
            test = besttests[i];
            if (test == null) continue;
            double beam_min_value = beam.getMinValue();
            double heuristic = test.getHeuristicValue() + offset;
            if (heuristic >= beam_min_value) {
                if (this.m_Verbose) {
                    System.out.print("[+]");
                }
                ClusNode ref_leaf = (ClusNode)leaf.cloneNode();
                ref_leaf.setTest(test);
                ref_leaf.setVisitor(leaf.getVisitor());
                if (this.getSettings().getGeneral().getVerbose() > 0) {
                    ClusLogger.info("Test: " + ref_leaf.getTestString() + " -> " + ref_leaf.getTest().getHeuristicValue() + " (" + ref_leaf.getTest().getPosFreq() + ")");
                }
                int arity = ref_leaf.updateArity();
                for (int j = 0; j < arity; ++j) {
                    ClusNode child = new ClusNode();
                    ref_leaf.setChild(child, j);
                }
                ClusNode root_model = (ClusNode)root.getModel();
                ClusNode ref_tree = root_model.cloneTreeWithVisitors(leaf, ref_leaf);
                ClusBeamModel new_model = new ClusBeamModel(heuristic, ref_tree);
                new_model.setRefinement(ref_leaf);
                new_model.setParentModelIndex(this.getCurrentModel());
                beam.addModel(new_model);
                this.setBeamChanged(true);
                continue;
            }
            if (!this.m_Verbose) continue;
            System.out.print("[-:" + heuristic + "]");
        }
    }

    @Override
    public void refineModel(ClusBeamModel model, ClusBeam beam, ClusRun run) throws Exception {
        int size;
        ClusNode tree = (ClusNode)model.getModel();
        ClusBeamModel new_model = model.cloneModel();
        new_model.setValue(this.sanityCheck(model.getValue(), tree));
        if (this.isBeamPostPrune()) {
            ClusNode clone = tree.cloneTreeWithVisitors();
            this.m_Constr.enforce(clone, this.m_MaxTreeSize);
            if (this.m_Constr.isFinished()) {
                model.setFinished(true);
                return;
            }
            if (this.m_Constr.isModified()) {
                new_model.setModel(clone);
                new_model.setValue(this.estimateBeamMeasure(clone));
            }
        } else if (this.m_MaxTreeSize >= 0 && (size = tree.getNbNodes()) + 2 > this.m_MaxTreeSize) {
            model.setFinished(true);
            return;
        }
        RowData train = (RowData)run.getTrainingSet();
        ClusAttrType[] attrs = train.getSchema().getDescriptiveAttributes();
        this.refineEachLeaf((ClusNode)new_model.getModel(), new_model, beam, attrs);
    }

    public void updateModelRefinement(ClusBeamModel model) throws ClusException {
        ClusNode leaf = (ClusNode)model.getRefinement();
        if (leaf == null) {
            return;
        }
        ClusBeamAttrSelector attrsel = (ClusBeamAttrSelector)leaf.getVisitor();
        RowData data = attrsel.getData();
        ClusStatManager mgr = this.m_Induce.getStatManager();
        for (int j = 0; j < leaf.getNbChildren(); ++j) {
            ClusNode child = (ClusNode)leaf.getChild(j);
            ClusBeamAttrSelector casel = new ClusBeamAttrSelector();
            RowData subset = data.applyWeighted(leaf.getTest(), j);
            child.initTargetStat(mgr, subset);
            child.initClusteringStat(mgr, subset);
            casel.setData(subset);
            child.setVisitor(casel);
        }
        leaf.setVisitor(null);
        model.setRefinement(null);
    }

    @Override
    public void refineBeam(ClusBeam beam, ClusRun run) throws Exception {
        super.refineBeam(beam, run);
        ArrayList models = beam.toArray();
        for (int i = 0; i < models.size(); ++i) {
            ClusBeamModel model = (ClusBeamModel)models.get(i);
            this.updateModelRefinement(model);
        }
    }
}

