/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.ext.beamsearch;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamModelDistance;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsExperimental;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class ClusBeamSimilarityOutput {
    static boolean m_WriteHeader;
    static ArrayList<Double> m_BeamSimTrain;
    static ArrayList<Double> m_BeamSimTest;

    public ClusBeamSimilarityOutput(Settings sett) throws IOException {
        if (!m_WriteHeader) {
            this.writeHeader(sett);
            m_WriteHeader = true;
            m_BeamSimTest = new ArrayList();
            m_BeamSimTrain = new ArrayList();
        }
    }

    public boolean isHeaderWritten() {
        return m_WriteHeader;
    }

    public void appendToFile(ArrayList models, ClusRun run) throws IOException, ClusException, InterruptedException {
        Settings set = run.getStatManager().getSettings();
        double[] sim = new double[2];
        ClusNumberFormat outF = ClusFormat.FOUR_AFTER_DOT;
        if (run.getStatManager().getTargetMode() != ClusStatManager.Mode.REGRESSION && run.getStatManager().getTargetMode() != ClusStatManager.Mode.CLASSIFY) {
            System.err.println(this.getClass().getName() + ".appendToFile(): Unhandled Type of Target Attribute");
            throw new ClusException("Unhandled Type of Target Attribute");
        }
        boolean isNum = run.getStatManager().getTargetMode() == ClusStatManager.Mode.CLASSIFY;
        sim[0] = ClusBeamModelDistance.calcBeamSimilarity(models, (RowData)run.getTrainingSet(), isNum);
        m_BeamSimTrain.add(sim[0]);
        try (FileWriter wrtr = new FileWriter(new File(set.getGeneric().getAppName() + ".bsim"), true);){
            block11: {
                try {
                    sim[1] = ClusBeamModelDistance.calcBeamSimilarity(models, run.getTestSet(), isNum);
                    m_BeamSimTest.add(sim[1]);
                    set.getExperimental();
                    if (SettingsExperimental.IS_XVAL) {
                        wrtr.write("Fold " + run.getIndexString() + ":\t" + outF.format(sim[0]) + "\t\t" + outF.format(sim[1]) + "\n");
                        if (run.getIndex() == set.getData().getXValFolds()) {
                            wrtr.write("---------------------------------------\n");
                            wrtr.write("Summary:\t" + outF.format(ClusBeamSimilarityOutput.getAverage(m_BeamSimTrain)) + "\t\t" + outF.format(ClusBeamSimilarityOutput.getAverage(m_BeamSimTest)) + "\n");
                        }
                    } else {
                        wrtr.append("\t\t" + outF.format(sim[0]) + "\t\t" + outF.format(sim[1]) + "\n");
                    }
                }
                catch (NullPointerException e) {
                    set.getExperimental();
                    if (SettingsExperimental.IS_XVAL) break block11;
                    wrtr.append("Summary:\t" + outF.format(sim[0]) + "\t\tN/A\n");
                }
            }
            wrtr.flush();
        }
    }

    public void writeHeader(Settings sett) throws IOException {
        File output = new File(sett.getGeneric().getAppName() + ".bsim");
        try (FileWriter wrtr = new FileWriter(output);){
            wrtr.write("Clus Beam-Search run\n");
            wrtr.write("----------------------\n");
            wrtr.write("Date:\t" + DateFormat.getInstance().format(sett.getGeneric().getDate()) + "\n");
            wrtr.write("File:\t" + output + "\n");
            wrtr.write("\n");
            wrtr.write("Beam Similarity Output\n");
            wrtr.write("----------------------\n");
            wrtr.write("\t\tTraining\tTesting\n");
            wrtr.write("---------------------------------------\n");
        }
    }

    public static double getAverage(ArrayList<Double> arr) {
        double result = 0.0;
        for (int i = 0; i < arr.size(); ++i) {
            result += arr.get(i).doubleValue();
        }
        return result / (double)arr.size();
    }
}

